/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util.naming;

import com.runqian.base.util.naming.FlatNameParser;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

class FlatCtx
implements Context {
    Hashtable myEnv;
    private Hashtable bindings = new Hashtable(11);
    static NameParser myParser = new FlatNameParser();

    FlatCtx(Hashtable environment) {
        this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
    }

    public Object lookup(String name) throws NamingException {
        if (name.equals("")) {
            return new FlatCtx(this.myEnv);
        }
        Object answer = this.bindings.get(name);
        if (answer == null) {
            throw new NameNotFoundException(String.valueOf(name) + " \u672a\u53d1\u73b0");
        }
        return answer;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("\u4e0d\u80fd\u6346\u7ed1\u7a7a\u540d\u79f0");
        }
        if (this.bindings.get(name) != null) {
            throw new NameAlreadyBoundException("\u540d\u79f0\u5df2\u7ecf\u6346\u7ed1\uff0c\u8bf7\u4f7f\u7528rebind\u91cd\u8f7d");
        }
        this.bindings.put(name, obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("\u4e0d\u80fd\u6346\u7ed1\u7a7a\u540d\u79f0");
        }
        this.bindings.put(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("\u4e0d\u80fd\u89e3\u5f00\u7a7a\u540d\u79f0");
        }
        this.bindings.remove(name);
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        if (oldname.equals("") || newname.equals("")) {
            throw new InvalidNameException("\u4e0d\u80fd\u89e3\u5f00\u7a7a\u540d\u79f0");
        }
        if (this.bindings.get(newname) != null) {
            throw new NameAlreadyBoundException(String.valueOf(newname) + " \u5df2\u7ecf\u6346\u7ed1");
        }
        Object oldBinding = this.bindings.remove(oldname);
        if (oldBinding == null) {
            throw new NameNotFoundException(String.valueOf(oldname) + " \u672a\u6346\u7ed1");
        }
        this.bindings.put(newname, oldBinding);
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            return new FlatNames(this.bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(String.valueOf(name) + " \u4e0d\u80fd\u88ab\u5217\u8868");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            return new FlatBindings(this.bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(String.valueOf(name) + " \u4e0d\u80fd\u88ab\u5217\u8868");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("\u4e0d\u652f\u6301subcontext");
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("\u4e0d\u652f\u6301subcontext");
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable(3, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public void close() throws NamingException {
        this.myEnv = null;
        this.bindings = null;
    }

    class FlatNames
    implements NamingEnumeration {
        Enumeration names;

        FlatNames(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = (String)this.names.nextElement();
            String className = FlatCtx.this.bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() {
        }
    }

    class FlatBindings
    implements NamingEnumeration {
        Enumeration names;

        FlatBindings(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = (String)this.names.nextElement();
            return new Binding(name, FlatCtx.this.bindings.get(name));
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() {
        }
    }
}

