/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.action;

import com.runqian.base.util.LimitedStack;
import com.runqian.query.action.Action;
import com.runqian.query.dataset.XDataSet;

public class ActionStack
implements Action {
    private LimitedStack stack;
    private LimitedStack backupStack = null;
    private LimitedStack stepStack = null;
    private boolean canUndo = false;
    private static String ACTION_PUSH = "push";
    private static String ACTION_POP = "pop";
    private XDataSet ds = null;

    public void setXDataSet(XDataSet ds) {
        this.ds = ds;
    }

    public XDataSet run() {
        while (!this.stack.empty()) {
            Action action = (Action)this.stack.pop();
            action.setXDataSet(this.ds);
            this.ds = action.run();
        }
        return this.ds;
    }

    public ActionStack(int stepCapacity, boolean canUndo) {
        this.stack = new LimitedStack(stepCapacity);
        if (canUndo) {
            this.backupStack = new LimitedStack();
            this.stepStack = new LimitedStack();
        }
        this.canUndo = canUndo;
    }

    public ActionStack(int stepCapacity) {
        this(stepCapacity, false);
    }

    public ActionStack() {
        this(10, false);
    }

    public boolean empty() {
        return this.stack.empty();
    }

    public boolean canUndo() {
        if (!this.canUndo) {
            return false;
        }
        return !this.stepStack.empty();
    }

    public boolean isFull() {
        return this.stack.isFull();
    }

    public boolean push(Action action) {
        if (this.stack.isFull()) {
            return false;
        }
        this.stack.push(action);
        if (this.canUndo) {
            this.stepStack.push(ACTION_PUSH);
        }
        return true;
    }

    public Action pop() {
        Action action = (Action)this.stack.pop();
        if (this.canUndo) {
            this.stepStack.push(ACTION_POP);
            this.backupStack.push(action);
        }
        return action;
    }

    public void undo() {
        if (!this.canUndo) {
            return;
        }
        if (this.stepStack.empty()) {
            return;
        }
        String action = (String)this.stepStack.pop();
        if (action.equals(ACTION_POP)) {
            this.stack.push(this.backupStack.pop());
        } else if (action.equals(ACTION_PUSH)) {
            this.stack.pop();
        }
    }

    public Action peek() {
        if (this.stack.empty()) {
            return null;
        }
        return (Action)this.stack.peek();
    }
}

