/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.dataset;

import com.runqian.base.tool.Tools;
import com.runqian.base.util.ArgumentDataType;
import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.ConnectionConfig;
import com.runqian.base.util.DBTypes;
import com.runqian.base.util.ReportError;
import com.runqian.base.util.SegmentSet;
import com.runqian.base.util.Sentence;
import com.runqian.query.dataset.XRow;
import com.runqian.query.dimension.Dimensions;
import com.runqian.query.dimension.DivideMethod;
import com.runqian.query.dimension.Element;
import com.runqian.query.dimension.ElementSet;
import com.runqian.query.dimension.Hierarchy;
import com.runqian.query.exp.Env;
import com.runqian.query.exp.Expression;
import com.runqian.query.exp.Variant2;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class XDataSet
implements Cloneable {
    protected ArrayList colNameList;
    protected ArrayList rows;
    protected HashMap dimensions;
    protected XRow curRow;
    protected ArrayList groups;
    protected Env env;
    private String dsName;
    public static final int TYPE_NORMAL = 1;
    public static final int TYPE_PROC = 3;

    public XDataSet(int XRowCapacity, int colCapacity) {
        this.colNameList = new ArrayList(colCapacity);
        this.colNameList.add("row");
        this.rows = new ArrayList(XRowCapacity);
        this.dimensions = new HashMap();
        this.groups = new ArrayList();
        this.curRow = null;
        this.env = null;
    }

    public void setName(String dsName) {
        this.dsName = dsName;
    }

    public String getName() {
        return this.dsName;
    }

    public void setEnv(Env env) {
        this.env = env;
    }

    public Env getEnv() {
        return this.env;
    }

    public void insertCol(int colIndex, String colName) {
        int i = 1;
        while (i <= this.rows.size()) {
            this.getRow(i).insertCol(colIndex);
            ++i;
        }
        this.colNameList.add(colIndex, colName);
    }

    public void addCol(String colName) {
        int i = 1;
        while (i <= this.rows.size()) {
            this.getRow(i).addCol();
            ++i;
        }
        this.colNameList.add(colName);
    }

    public void insertCalcCol(int col, String colName, String exp) {
        int i = 1;
        while (i <= this.rows.size()) {
            this.getRow(i).insertCalcCol(col, exp);
            ++i;
        }
        this.colNameList.add(col, colName);
    }

    public void addCalcCol(String colName, String exp) {
        int i = 1;
        while (i <= this.rows.size()) {
            this.getRow(i).addCalcCol(exp);
            ++i;
        }
        this.colNameList.add(colName);
    }

    public void deleteCol(int col) {
        int i = 1;
        while (i <= this.rows.size()) {
            this.getRow(i).deleteCol(col);
            ++i;
        }
        this.colNameList.remove(col);
    }

    public void deleteCol(String colName) {
        int i = 1;
        while (i <= this.rows.size()) {
            this.getRow(i).deleteCol(this.getColumnIndex(colName));
            ++i;
        }
        this.colNameList.remove(colName);
    }

    public void setCurrentRow(XRow xrow) {
        this.curRow = xrow;
    }

    public boolean isColumnName(String id) {
        return this.getColumnIndex(id) >= 0;
    }

    public void insertXRow(int rowIndex, XRow xrow) {
        this.rows.add(rowIndex - 1, xrow);
        int i = rowIndex;
        while (i <= this.rows.size()) {
            this.getRow(i).setIndex(i);
            ++i;
        }
        xrow.setXDataSet(this);
    }

    public void addXRow(XRow xrow) {
        this.rows.add(xrow);
        xrow.setIndex(this.rows.size());
        xrow.setXDataSet(this);
    }

    public void deleteXRow(int rowIndex) {
        this.rows.remove(rowIndex - 1);
        int i = rowIndex;
        while (i <= this.rows.size()) {
            this.getRow(i).setIndex(i);
            ++i;
        }
    }

    public void set(int rowNum, int col, Object value) {
        this.getRow(rowNum).setData(col, value);
    }

    public void set(int rowNum, String colName, Object value) {
        this.set(rowNum, this.getColumnIndex(colName), value);
    }

    public Object getData(int colIndex) {
        return this.curRow.getData(colIndex);
    }

    public Object getData(int rowIndex, int colIndex) {
        return this.getRow(rowIndex).getData(colIndex);
    }

    public XRow getRow(int rowIndex) {
        if (rowIndex < 1 || rowIndex > this.getRowCount()) {
            return null;
        }
        return (XRow)this.rows.get(rowIndex - 1);
    }

    public XRow getRow() {
        return this.curRow;
    }

    public ArrayList getColumnNames() {
        int colNum = this.colNameList.size();
        ArrayList cols = new ArrayList(colNum - 1);
        int i = 1;
        while (i < colNum) {
            cols.add(this.colNameList.get(i));
            ++i;
        }
        return cols;
    }

    public String getColumnName(int colIndex) {
        return (String)this.colNameList.get(colIndex);
    }

    public void clear() {
        this.colNameList.clear();
        this.rows.clear();
        this.dimensions.clear();
        this.groups.clear();
        this.curRow = null;
    }

    public void bind(int col, Dimensions dim) {
        this.dimensions.put(this.colNameList.get(col), dim);
    }

    public void bind(String colName, Dimensions dim) {
        this.dimensions.put(colName, dim);
    }

    public Dimensions getDimensions(String colName) {
        return (Dimensions)this.dimensions.get(colName);
    }

    public Dimensions getDimensions(int colIndex) {
        return (Dimensions)this.dimensions.get(this.colNameList.get(colIndex));
    }

    public int findGroupChange() {
        int index = this.curRow.index();
        int i = 0;
        while (i < this.groups.size()) {
            int row = (Integer)this.groups.get(i);
            if (index < row) {
                return row;
            }
            ++i;
        }
        return this.getRowCount() + 1;
    }

    public XDataSet sort(String sortExp, String newDSName) {
        ArgumentTokenizer at = new ArgumentTokenizer(sortExp, ',');
        int n = at.countTokens();
        ArrayList<String> exp = new ArrayList<String>(n);
        ArrayList<String> order = new ArrayList<String>(n);
        while (at.hasMoreTokens()) {
            String sortExp1 = at.nextToken();
            if (sortExp1 == null || sortExp1.trim().length() == 0) continue;
            if ((sortExp1 = sortExp1.trim()).length() < 3) {
                exp.add(sortExp1);
                order.add("A");
                continue;
            }
            char a = sortExp1.charAt(sortExp1.length() - 2);
            char b = sortExp1.charAt(sortExp1.length() - 1);
            if (a == ' ' && (b == 'A' || b == 'D')) {
                exp.add(sortExp1.substring(0, sortExp1.length() - 2));
                order.add(sortExp1.substring(sortExp1.length() - 1));
                continue;
            }
            exp.add(sortExp1);
            order.add("A");
        }
        int l = 1;
        int r = this.getRowCount();
        XDataSet xds = null;
        if (newDSName != null) {
            xds = (XDataSet)this.clone();
            xds.setName(newDSName);
        } else {
            xds = this;
        }
        XDataSet.sort(l, r, exp, order, xds);
        return xds;
    }

    private static void sort(int l, int r, ArrayList exp, ArrayList order, XDataSet xds) {
        boolean b2;
        boolean b1;
        if (l >= r) {
            return;
        }
        int i = l + 1;
        int j = r;
        while (true) {
            int n = 0;
            Object mo = xds.getRow(l).calculate((String)exp.get(n));
            Object lo = xds.getRow(i).calculate((String)exp.get(n));
            b1 = ((String)order.get(0)).equalsIgnoreCase("A") ? Variant2.compare(lo, mo) <= 0 : Variant2.compare(lo, mo) >= 0;
            while (b1) {
                if (Variant2.compare(lo, mo) == 0 && n < exp.size() - 1) {
                    mo = xds.getRow(l).calculate((String)exp.get(++n));
                    lo = xds.getRow(i).calculate((String)exp.get(n));
                } else {
                    if (i >= r) break;
                    n = 0;
                    mo = xds.getRow(l).calculate((String)exp.get(n));
                    lo = xds.getRow(++i).calculate((String)exp.get(n));
                }
                if (((String)order.get(0)).equalsIgnoreCase("A")) {
                    b1 = Variant2.compare(lo, mo) <= 0;
                    continue;
                }
                boolean bl = b1 = Variant2.compare(lo, mo) >= 0;
            }
            n = 0;
            mo = xds.getRow(l).calculate((String)exp.get(n));
            Object ro = xds.getRow(j).calculate((String)exp.get(n));
            b2 = ((String)order.get(0)).equalsIgnoreCase("A") ? Variant2.compare(mo, ro) <= 0 : Variant2.compare(mo, ro) >= 0;
            while (b2) {
                if (Variant2.compare(mo, ro) == 0 && n < exp.size() - 1) {
                    mo = xds.getRow(l).calculate((String)exp.get(++n));
                    ro = xds.getRow(j).calculate((String)exp.get(n));
                } else {
                    if (j <= l + 1) break;
                    n = 0;
                    mo = xds.getRow(l).calculate((String)exp.get(n));
                    ro = xds.getRow(--j).calculate((String)exp.get(n));
                }
                if (((String)order.get(0)).equalsIgnoreCase("A")) {
                    b2 = Variant2.compare(mo, ro) <= 0;
                    continue;
                }
                boolean bl = b2 = Variant2.compare(mo, ro) >= 0;
            }
            if (i >= j) break;
            xds.exchange(i, j);
        }
        if (b1) {
            xds.exchange(l, i);
            XDataSet.sort(l, i - 1, exp, order, xds);
        } else if (b2) {
            XDataSet.sort(j, r, exp, order, xds);
        } else {
            xds.exchange(l, j);
            XDataSet.sort(l, j - 1, exp, order, xds);
            XDataSet.sort(j + 1, r, exp, order, xds);
        }
    }

    private void exchange(int i, int j) {
        XRow irow = this.getRow(i);
        this.setXRow(i, this.getRow(j));
        this.setXRow(j, irow);
    }

    public void setXRow(int index, XRow xrow) {
        this.rows.set(index - 1, xrow);
        xrow.setIndex(index);
        xrow.setXDataSet(this);
    }

    public XDataSet filter(String exp) {
        return this.filter(exp, null);
    }

    public XDataSet filter(String exp, String newDSName) {
        XDataSet xds = null;
        if (newDSName != null) {
            xds = (XDataSet)this.clone();
            xds.setName(newDSName);
        } else {
            xds = this;
        }
        int i = this.getRowCount();
        while (i >= 1) {
            boolean b = (Boolean)xds.getRow(i).calculate(exp);
            if (!b) {
                xds.deleteXRow(i);
            }
            --i;
        }
        return xds;
    }

    public void addCols(List colNameList) {
        int i = 0;
        while (i < colNameList.size()) {
            this.addCol((String)colNameList.get(i));
            ++i;
        }
    }

    public XDataSet fullJoin(XDataSet ds, String exp, String[] sourceCol, String[] desCol, String newDSName) {
        XDataSet xds = new XDataSet(this.getRowCount() * ds.getRowCount(), this.getColumnCount() + ds.getColumnCount());
        xds.setEnv(this.env);
        xds.addCols(Tools.getVector(sourceCol));
        xds.addCols(Tools.getVector(desCol));
        xds.setName(newDSName);
        this.env.setCurrentXDS(this);
        int dsRowNum = ds.getRowCount();
        boolean[] rfind = new boolean[dsRowNum];
        int row = 1;
        while (row <= dsRowNum) {
            rfind[row - 1] = false;
            ++row;
        }
        int i = 1;
        while (i <= this.getRowCount()) {
            boolean find = false;
            XRow xrow1 = this.getRow(i);
            this.setCurrentRow(xrow1);
            int j = 1;
            while (j <= dsRowNum) {
                ds.setCurrentRow(ds.getRow(j));
                Expression expression = new Expression(this.env, exp);
                boolean b = (Boolean)expression.calculate();
                if (b) {
                    if (!find) {
                        find = true;
                    }
                    if (!rfind[j - 1]) {
                        rfind[j - 1] = true;
                    }
                    XRow xrow = new XRow(xds, xds.getRowCount() + 1);
                    XRow xrow2 = ds.getRow(j);
                    int k = 0;
                    while (k < sourceCol.length) {
                        xrow.setData(k + 1, xrow1.getData(sourceCol[k]));
                        ++k;
                    }
                    k = 0;
                    while (k < desCol.length) {
                        xrow.setData(sourceCol.length + k + 1, xrow2.getData(desCol[k]));
                        ++k;
                    }
                    xds.addXRow(xrow);
                }
                ++j;
            }
            if (!find) {
                XRow xrow = new XRow(xds, xds.getRowCount() + 1);
                int k = 0;
                while (k < sourceCol.length) {
                    xrow.setData(k + 1, xrow1.getData(sourceCol[k]));
                    ++k;
                }
                xds.addXRow(xrow);
            }
            ++i;
        }
        int j = 1;
        while (j <= dsRowNum) {
            if (!rfind[j - 1]) {
                XRow xrow = new XRow(xds, xds.getRowCount() + 1);
                XRow xrow2 = ds.getRow(j);
                int k = 0;
                while (k < desCol.length) {
                    xrow.setData(sourceCol.length + k + 1, xrow2.getData(desCol[k]));
                    ++k;
                }
                xds.addXRow(xrow);
            }
            ++j;
        }
        return xds;
    }

    public XDataSet join(XDataSet ds, String exp, String[] sourceCol, String[] desCol, String newDSName) {
        XDataSet xds = new XDataSet(this.getRowCount() * ds.getRowCount(), this.getColumnCount() + ds.getColumnCount());
        xds.setEnv(this.env);
        xds.addCols(Tools.getVector(sourceCol));
        xds.addCols(Tools.getVector(desCol));
        xds.setName(newDSName);
        this.env.setCurrentXDS(this);
        int i = 1;
        while (i <= this.getRowCount()) {
            XRow xrow1 = this.getRow(i);
            int j = 1;
            while (j <= ds.getRowCount()) {
                this.setCurrentRow(this.getRow(i));
                ds.setCurrentRow(ds.getRow(j));
                Expression expression = new Expression(this.env, exp);
                boolean b = (Boolean)expression.calculate();
                if (b) {
                    XRow xrow2 = ds.getRow(j);
                    XRow xrow = new XRow(xds, xds.getRowCount() + 1);
                    int k = 0;
                    while (k < sourceCol.length) {
                        xrow.setData(k + 1, xrow1.getData(sourceCol[k]));
                        ++k;
                    }
                    k = 0;
                    while (k < desCol.length) {
                        xrow.setData(sourceCol.length + k + 1, xrow2.getData(desCol[k]));
                        ++k;
                    }
                    xds.addXRow(xrow);
                }
                ++j;
            }
            ++i;
        }
        return xds;
    }

    public XDataSet leftJoin(XDataSet ds, String exp, String[] sourceCol, String[] desCol, String newDSName) {
        XDataSet xds = new XDataSet(this.getRowCount() * ds.getRowCount(), this.getColumnCount() + ds.getColumnCount());
        xds.setEnv(this.env);
        xds.addCols(Tools.getVector(sourceCol));
        xds.addCols(Tools.getVector(desCol));
        xds.setName(newDSName);
        this.env.setCurrentXDS(this);
        int i = 1;
        while (i <= this.getRowCount()) {
            boolean find = false;
            XRow xrow1 = this.getRow(i);
            this.setCurrentRow(this.getRow(i));
            int j = 1;
            while (j <= ds.getRowCount()) {
                ds.setCurrentRow(ds.getRow(j));
                Expression expression = new Expression(this.env, exp);
                boolean b = (Boolean)expression.calculate();
                if (b) {
                    if (!find) {
                        find = true;
                    }
                    XRow xrow2 = ds.getRow(j);
                    XRow xrow = new XRow(xds, xds.getRowCount() + 1);
                    int k = 0;
                    while (k < sourceCol.length) {
                        xrow.setData(k + 1, xrow1.getData(sourceCol[k]));
                        ++k;
                    }
                    k = 0;
                    while (k < desCol.length) {
                        xrow.setData(sourceCol.length + k + 1, xrow2.getData(desCol[k]));
                        ++k;
                    }
                    xds.addXRow(xrow);
                }
                ++j;
            }
            if (!find) {
                XRow xrow = new XRow(xds, xds.getRowCount() + 1);
                int k = 0;
                while (k < sourceCol.length) {
                    xrow.setData(k + 1, xrow1.getData(sourceCol[k]));
                    ++k;
                }
                xds.addXRow(xrow);
            }
            ++i;
        }
        return xds;
    }

    public XDataSet rightJoin(XDataSet ds, String exp, String[] sourceCol, String[] desCol, String newDSName) {
        XDataSet xds = new XDataSet(this.getRowCount() * ds.getRowCount(), this.getColumnCount() + ds.getColumnCount());
        xds.setEnv(this.env);
        xds.addCols(Tools.getVector(sourceCol));
        xds.addCols(Tools.getVector(desCol));
        xds.setName(newDSName);
        this.env.setCurrentXDS(this);
        int j = 1;
        while (j <= ds.getRowCount()) {
            boolean find = false;
            XRow xrow2 = ds.getRow(j);
            ds.setCurrentRow(xrow2);
            int i = 1;
            while (i <= this.getRowCount()) {
                this.setCurrentRow(this.getRow(i));
                Expression expression = new Expression(this.env, exp);
                boolean b = (Boolean)expression.calculate();
                if (b) {
                    if (!find) {
                        find = true;
                    }
                    XRow xrow = new XRow(xds, xds.getRowCount() + 1);
                    XRow xrow1 = this.getRow(i);
                    int k = 0;
                    while (k < sourceCol.length) {
                        xrow.setData(k + 1, xrow1.getData(sourceCol[k]));
                        ++k;
                    }
                    k = 0;
                    while (k < desCol.length) {
                        xrow.setData(sourceCol.length + k + 1, xrow2.getData(desCol[k]));
                        ++k;
                    }
                    xds.addXRow(xrow);
                }
                ++i;
            }
            if (!find) {
                XRow xrow = new XRow(xds, xds.getRowCount() + 1);
                int k = 0;
                while (k < desCol.length) {
                    xrow.setData(sourceCol.length + k + 1, xrow2.getData(desCol[k]));
                    ++k;
                }
                xds.addXRow(xrow);
            }
            ++j;
        }
        return xds;
    }

    public XDataSet integral(String[] selectCol, String[] integralCol, String[] integralColName, String newDSName) {
        XDataSet newDS = new XDataSet(this.getRowCount(), selectCol.length + integralCol.length);
        newDS.setName(newDSName);
        newDS.setEnv(this.getEnv());
        int i = 0;
        while (i < selectCol.length) {
            newDS.addCol(selectCol[i]);
            ++i;
        }
        i = 0;
        while (i < integralColName.length) {
            newDS.addCol(integralColName[i]);
            ++i;
        }
        i = 1;
        while (i <= this.getRowCount()) {
            XRow current = this.getRow(i);
            XRow prior = this.getRow(i - 1);
            XRow newRow = new XRow(newDS, i);
            int j = 0;
            while (j < selectCol.length) {
                newRow.setData(j + 1, this.getData(i, this.getColumnIndex(selectCol[j])));
                ++j;
            }
            j = 0;
            while (j < integralCol.length) {
                Object o = null;
                if (prior != null) {
                    o = prior.getData(integralCol[j]);
                }
                Object o1 = current.getData(integralCol[j]);
                newRow.setData(j + 1 + selectCol.length, Variant2.add(o, o1));
                ++j;
            }
            newDS.addXRow(newRow);
            ++i;
        }
        return newDS;
    }

    public XDataSet diff(String[] selectCol, String[] diffCol, String[] diffColName, String newDSName) {
        XDataSet newDS = new XDataSet(this.getRowCount(), selectCol.length + diffCol.length);
        newDS.setName(newDSName);
        newDS.setEnv(this.getEnv());
        int i = 0;
        while (i < selectCol.length) {
            newDS.addCol(selectCol[i]);
            ++i;
        }
        i = 0;
        while (i < diffColName.length) {
            newDS.addCol(diffColName[i]);
            ++i;
        }
        i = 1;
        while (i <= this.getRowCount()) {
            XRow current = this.getRow(i);
            XRow prior = this.getRow(i - 1);
            XRow newRow = new XRow(newDS, i);
            int j = 0;
            while (j < selectCol.length) {
                newRow.setData(j + 1, this.getData(i, this.getColumnIndex(selectCol[j])));
                ++j;
            }
            j = 0;
            while (j < diffCol.length) {
                Object o = null;
                if (prior != null) {
                    o = prior.getData(diffCol[j]);
                }
                Object o1 = current.getData(diffCol[j]);
                newRow.setData(j + 1 + selectCol.length, Variant2.subtract(o1, o));
                ++j;
            }
            newDS.addXRow(newRow);
            ++i;
        }
        return newDS;
    }

    public XDataSet group(String[] groupbyList, String[] groupbyColName, String[] collectExp, String[] collectColName, String newDSName) {
        int i;
        XRow row;
        XDataSet xds = new XDataSet(100, groupbyList.length + collectExp.length);
        xds.setName(newDSName);
        xds.setEnv(this.getEnv());
        this.getEnv().putXDataSet(newDSName, xds);
        StringBuffer sb = new StringBuffer(groupbyColName.length * 10);
        int col = this.getColumnCount();
        String[] groupName = new String[groupbyColName.length];
        int i2 = 0;
        while (i2 < groupbyColName.length) {
            xds.addCol(groupbyColName[i2]);
            this.addCol(String.valueOf(col + i2 + 1));
            sb.append(String.valueOf(col + i2 + 1)).append(",");
            groupName[i2] = String.valueOf(col + i2 + 1);
            ++i2;
        }
        i2 = 0;
        while (i2 < collectColName.length) {
            xds.addCol(collectColName[i2]);
            ++i2;
        }
        int n = this.getRowCount();
        int r = 1;
        while (r <= n) {
            row = this.getRow(r);
            row.setXDataSet(this);
            i = 0;
            while (i < groupbyList.length) {
                row.setData(groupName[i], this.calc(row, groupbyList[i]));
                ++i;
            }
            ++r;
        }
        this.sort(sb.toString(), null);
        this.group(groupName);
        this.setCurrentRow(this.getRow(1));
        int rowNum = 0;
        this.env.setCurrentXDS(this);
        while (this.getRow() != null) {
            row = new XRow(xds, ++rowNum);
            i = 0;
            while (i < groupbyColName.length) {
                row.setData(groupbyColName[i], this.getRow().getData(groupName[i]));
                ++i;
            }
            i = 0;
            while (i < collectExp.length) {
                Expression expression = new Expression(this.env, collectExp[i]);
                row.setData(collectColName[i], expression.calculate());
                ++i;
            }
            this.setCurrentRow(this.getRow(this.findGroupChange()));
            xds.addXRow(row);
        }
        return xds;
    }

    private void group(String[] groupName) {
        Object[] value = new Object[groupName.length];
        int i = 1;
        while (i <= this.getRowCount()) {
            int j;
            boolean b = true;
            if (i == 1) {
                j = 0;
                while (j < value.length) {
                    value[j] = this.getRow(i).getData(groupName[j]);
                    ++j;
                }
            } else {
                j = 0;
                while (j < value.length) {
                    if (!b) {
                        value[j] = this.getRow(i).getData(groupName[j]);
                    } else {
                        Object o = this.getRow(i).getData(groupName[j]);
                        if (Variant2.compare(value[j], o) != 0) {
                            b = false;
                            value[j] = o;
                        }
                    }
                    ++j;
                }
                if (!b) {
                    this.groups.add(new Integer(i));
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object calc(XRow row, String exp) {
        int index = Sentence.indexOf(exp, ",", 0, 4);
        if (index < 0 || index >= exp.length()) {
            this.env.setCurrentXDS(this);
            this.setCurrentRow(row);
            Expression expression = new Expression(this.env, exp);
            return expression.calculate();
        }
        String colName = exp.substring(0, index);
        String hierarchy = exp.substring(index + 1);
        int pos = Sentence.indexOf(hierarchy, ".", 0, 4);
        if (pos < 0) return this.calc(row, colName);
        if (pos >= hierarchy.length()) {
            return this.calc(row, colName);
        }
        String divide = hierarchy.substring(0, pos);
        hierarchy = hierarchy.substring(pos + 1);
        Dimensions dim = this.getDimensions(colName);
        DivideMethod divideMethod = dim.getDivideMethod(divide);
        if (divideMethod == null) {
            return this.calc(row, colName);
        }
        Hierarchy hie = divideMethod.getHierarchy(hierarchy);
        if (hie == null) {
            return this.calc(row, colName);
        }
        String setType = hie.getSetType();
        Object o = row.getData(colName);
        if ("SQL".equalsIgnoreCase(setType)) {
            Connection con;
            block16: {
                Object object;
                block17: {
                    Object object2;
                    block15: {
                        con = null;
                        try {
                            try {
                                con = dim.getConnectionConfig().getConnection();
                                String sql = hie.getSql();
                                if (sql == null || sql.trim().length() == 0) {
                                    object2 = this.calc(row, colName);
                                    Object var22_21 = null;
                                    break block15;
                                }
                                SegmentSet segment = new SegmentSet(sql, ';');
                                String value = segment.get("value");
                                String disp = segment.get("disp");
                                String tbl = segment.get("tbl");
                                String where = String.valueOf(value) + "=" + DBTypes.getDBConst(dim.getConnectionConfig().getIntDBType(), o, hie.getDataType());
                                sql = "select " + disp + " from " + tbl + " where " + where;
                                Statement stmt = null;
                                try {
                                    stmt = con.createStatement();
                                    stmt.execute(sql);
                                    ResultSet rs = stmt.getResultSet();
                                    if (!rs.next()) break block16;
                                    object = rs.getObject(1);
                                    break block17;
                                }
                                catch (Exception e) {
                                    throw new ReportError(e.getMessage(), e);
                                }
                            }
                            catch (Exception e) {
                                throw new ReportError(e.getMessage(), e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var22_23 = null;
                            ConnectionConfig.close(con);
                            throw throwable;
                        }
                    }
                    ConnectionConfig.close(con);
                    return object2;
                }
                Object var22_22 = null;
                ConnectionConfig.close(con);
                return object;
            }
            Object var22_24 = null;
            ConnectionConfig.close(con);
            return this.calc(row, colName);
        }
        ElementSet[] elementSets = hie.listElementSets();
        int i = 0;
        while (i < elementSets.length) {
            Object oo = XDataSet.getDispValue(o, elementSets[i], hie.getDataType());
            if (oo != null) return oo;
            ++i;
        }
        return this.calc(row, colName);
    }

    private static Object getDispValue(Object value, ElementSet elementSet, int dataType) {
        Element[] elements = elementSet.listElements();
        int j = 0;
        while (j < elements.length) {
            int defineType = elements[j].getDefineType();
            String svalue = elements[j].getValue();
            switch (defineType) {
                case 0: {
                    Object o = ArgumentDataType.getProperData(dataType, svalue);
                    if (!value.equals(o)) break;
                    return elementSet.getElementSetName();
                }
                case 1: {
                    ArgumentTokenizer at = new ArgumentTokenizer(svalue, ',');
                    Object start = ArgumentDataType.getProperData(dataType, at.nextToken());
                    Object end = ArgumentDataType.getProperData(dataType, at.nextToken());
                    if (Variant2.compare(start, value) > 0 || Variant2.compare(value, end) > 0) break;
                    return elementSet.getElementSetName();
                }
                case 2: {
                    ArgumentTokenizer at = new ArgumentTokenizer(svalue, '.');
                    String hieName = at.nextToken();
                    String setName = at.nextToken();
                    ElementSet set = elementSet.getHierarchy().getDivideMethod().getHierarchy(hieName).getElementSet(setName);
                    return XDataSet.getDispValue(value, set, dataType);
                }
            }
            ++j;
        }
        return null;
    }

    public XDataSet union(XDataSet ds, String newDSName) {
        XDataSet xds = (XDataSet)this.clone();
        xds.setName(newDSName);
        int i = 1;
        while (i <= ds.getRowCount()) {
            XRow xrow = ds.getRow(i);
            xds.addXRow(xrow);
            ++i;
        }
        return xds;
    }

    public Object clone() {
        try {
            XDataSet xds = (XDataSet)super.clone();
            if (this.colNameList != null) {
                xds.colNameList = (ArrayList)this.colNameList.clone();
            }
            if (this.dimensions != null) {
                xds.dimensions = (HashMap)this.dimensions.clone();
            }
            if (this.groups != null) {
                xds.groups = (ArrayList)this.groups.clone();
            }
            if (this.rows != null) {
                xds.rows = (ArrayList)this.rows.clone();
            }
            if (this.env != null) {
                xds.env = this.env;
            }
            return xds;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public int getColumnIndex(String colName) {
        int i = 0;
        while (i < this.colNameList.size()) {
            if (colName.equalsIgnoreCase((String)this.colNameList.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getColumnCount() {
        return this.colNameList.size() - 1;
    }

    public int getRowNum() {
        if (this.curRow == null) {
            return 0;
        }
        return this.curRow.index();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void absolute(int rowIndex) {
        this.curRow = this.getRow(rowIndex);
    }
}

