/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.dataset;

import com.runqian.query.dataset.XDataSet;
import com.runqian.query.exp.Env;
import com.runqian.query.exp.Expression;
import java.util.ArrayList;

public class XRow
implements Cloneable {
    protected XDataSet ds;
    protected ArrayList dataList;
    private int index;

    public XRow(XDataSet ds, int index) {
        this.ds = ds;
        this.index = index;
        int colCount = ds.getColumnCount() + 1;
        this.dataList = new ArrayList(colCount);
        int i = 0;
        while (i < colCount) {
            this.dataList.add(i, null);
            ++i;
        }
        this.dataList.set(0, new Integer(index));
    }

    public XDataSet getXDataSet() {
        return this.ds;
    }

    public void setXDataSet(XDataSet xds) {
        this.ds = xds;
    }

    public int index() {
        return this.index;
    }

    public void setData(int col, Object data) {
        this.dataList.set(col, data);
    }

    public void setData(String colName, Object data) {
        this.ds.getColumnNames().size();
        this.setData(this.ds.getColumnIndex(colName), data);
    }

    public Object getData(int col) {
        return this.dataList.get(col);
    }

    public Object getData(String colName) {
        return this.getData(this.ds.getColumnIndex(colName));
    }

    public void addCalcCol(String exp) {
        this.dataList.add(this.calculate(exp));
    }

    public void insertCalcCol(int col, String exp) {
        this.dataList.add(col, this.calculate(exp));
    }

    public Object calculate(String exp) {
        Env env = this.ds.getEnv();
        env.setCurrentXDS(this.ds);
        this.ds.setCurrentRow(this);
        Expression expression = new Expression(env, exp);
        return expression.calculate();
    }

    public void insertCol(int col) {
        this.dataList.add(col, null);
    }

    public void insertCol(int col, Object value) {
        this.dataList.add(col, value);
    }

    public void addCol() {
        this.dataList.add(null);
    }

    public void addCol(Object value) {
        this.dataList.add(value);
    }

    public void deleteCol(int col) {
        this.dataList.remove(col);
    }

    public void setIndex(int index) {
        this.index = index;
        this.dataList.set(0, new Integer(index));
    }

    public Object clone() {
        try {
            XRow xrow = (XRow)super.clone();
            xrow.dataList = (ArrayList)this.dataList.clone();
            return xrow;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

