/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.dimension;

import com.runqian.base.tool.Section;
import com.runqian.base.tool.XMLFile;
import com.runqian.base.util.ConnectionConfig;
import com.runqian.query.dimension.DivideMethod;
import java.util.ArrayList;

public class Dimensions {
    private String name;
    private ArrayList divideMethodNames;
    private ArrayList divideMethods;
    private ConnectionConfig config;

    public Dimensions(String dimName, XMLFile xmlFile) throws Exception {
        this.name = dimName;
        this.read(xmlFile, "DIM/" + dimName);
    }

    public Dimensions(String dimName) {
        this.name = dimName;
        this.divideMethods = new ArrayList(10);
        this.divideMethodNames = new ArrayList(10);
    }

    public Dimensions(String dimName, String dimFileName) throws Throwable {
        XMLFile xmlFile = new XMLFile(dimFileName);
        this.name = dimName;
        this.read(xmlFile, "DIM/" + dimName);
    }

    private void read(XMLFile xmlFile, String path) throws Exception {
        Section section = xmlFile.listElement(path);
        int n = section.countSection();
        this.divideMethods = new ArrayList(n);
        this.divideMethodNames = new ArrayList(n);
        int i = 0;
        while (i < n) {
            String divideName = section.getSection(i);
            DivideMethod divide = new DivideMethod(xmlFile, path, this, divideName);
            this.divideMethods.add(divide);
            this.divideMethodNames.add(divideName);
            ++i;
        }
    }

    public String getDimensionsName() {
        return this.name.toUpperCase().trim();
    }

    public boolean setDimensionsName(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        this.name = name.toUpperCase().trim();
        return true;
    }

    public void add(DivideMethod divideMethod) {
        this.divideMethods.add(divideMethod);
        this.divideMethodNames.add(divideMethod.getDivideMethodName().toUpperCase().trim());
    }

    public void add(int index, DivideMethod divideMethod) {
        this.divideMethods.add(index, divideMethod);
        this.divideMethodNames.add(index, divideMethod.getDivideMethodName().toUpperCase().trim());
    }

    public int deleteDivideMethod(DivideMethod divideMethod) {
        this.divideMethodNames.remove(divideMethod.getDivideMethodName().toUpperCase().trim());
        this.divideMethods.remove(divideMethod);
        return this.divideMethods.size();
    }

    public DivideMethod[] listDivideMethods() {
        Object[] o = this.divideMethods.toArray();
        DivideMethod[] s = new DivideMethod[o.length];
        int i = 0;
        while (i < o.length) {
            s[i] = (DivideMethod)o[i];
            ++i;
        }
        return s;
    }

    public String[] listDivideMethodsName() {
        Object[] o = this.divideMethodNames.toArray();
        String[] s = new String[o.length];
        int i = 0;
        while (i < o.length) {
            s[i] = (String)o[i];
            ++i;
        }
        return s;
    }

    public int indexOf(String divideName) {
        return this.divideMethodNames.indexOf(divideName.toUpperCase().trim());
    }

    public int indexOf(DivideMethod divide) {
        return this.divideMethods.indexOf(divide);
    }

    public int countDivideMethods() {
        return this.divideMethods.size();
    }

    public boolean renameDivideMethod(String oldName, String newName) {
        if (newName == null || newName.trim().length() == 0) {
            return false;
        }
        int index = this.divideMethodNames.indexOf(oldName.toUpperCase().trim());
        if (index < 0 || index >= this.divideMethodNames.size()) {
            return false;
        }
        DivideMethod dm = (DivideMethod)this.divideMethods.get(index);
        this.divideMethodNames.set(index, newName.toUpperCase().trim());
        dm.setDivideMethodName(newName.toUpperCase().trim());
        return true;
    }

    public DivideMethod getDivideMethod(String divideMethodName) {
        int index = this.divideMethodNames.indexOf(divideMethodName.toUpperCase().trim());
        if (index < 0 || index >= this.divideMethodNames.size()) {
            return null;
        }
        return (DivideMethod)this.divideMethods.get(index);
    }

    public ConnectionConfig getConnectionConfig() {
        return this.config;
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.config = connectionConfig;
    }

    public void saveToXMLFile(XMLFile xmlFile) throws Exception {
        xmlFile.newElement("DIM", this.name);
        DivideMethod[] divideEM = this.listDivideMethods();
        int i = 0;
        while (i < divideEM.length) {
            divideEM[i].saveToXMLFile(xmlFile, "DIM/" + this.name);
            ++i;
        }
    }
}

