/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.dimension;

import com.runqian.base.tool.Section;
import com.runqian.base.tool.XMLFile;
import com.runqian.base.util.ConnectionConfig;
import com.runqian.query.dimension.Dimensions;
import java.util.ArrayList;

public class DimensionsManager {
    private ArrayList dimNames;
    private ArrayList dims;

    public DimensionsManager(String xmlFileName) throws Throwable {
        XMLFile xmlFile = new XMLFile(xmlFileName);
        this.read(xmlFile);
    }

    public DimensionsManager(XMLFile xmlFile) throws Throwable {
        this.read(xmlFile);
    }

    public DimensionsManager(int initCapacity) {
        this.dimNames = new ArrayList(initCapacity);
        this.dims = new ArrayList(initCapacity);
    }

    private void read(XMLFile xmlFile) throws Exception {
        String drivername = xmlFile.getAttribute("DATASOURCES/DSO/drivername");
        String dbtype = xmlFile.getAttribute("DATASOURCES/DSO/dbtype");
        String dbencoding = xmlFile.getAttribute("DATASOURCES/DSO/dbencoding");
        String extend = xmlFile.getAttribute("DATASOURCES/DSO/extendproperties");
        String pswd = xmlFile.getAttribute("DATASOURCES/DSO/password");
        String url = xmlFile.getAttribute("DATASOURCES/DSO/urlpath");
        String userid = xmlFile.getAttribute("DATASOURCES/DSO/userid");
        ConnectionConfig config = new ConnectionConfig("", drivername, url, userid, pswd, dbtype, dbencoding, extend);
        Section section = xmlFile.listElement("DIM");
        int n = section.countSection();
        this.dimNames = new ArrayList(n);
        this.dims = new ArrayList(n);
        int i = 0;
        while (i < n) {
            String dimName = section.getSection(i);
            Dimensions dim = new Dimensions(dimName, xmlFile);
            dim.setConnectionConfig(config);
            this.dimNames.add(dimName);
            this.dims.add(dim);
            ++i;
        }
    }

    public void add(Dimensions dim) {
        this.dimNames.add(dim.getDimensionsName().toUpperCase().trim());
        this.dims.add(dim);
    }

    public void remove(String dimName) {
        int index = this.dimNames.indexOf(dimName.toUpperCase().trim());
        this.dimNames.remove(index);
        this.dims.remove(index);
    }

    public String[] getDimNames() {
        Object[] o = this.dimNames.toArray();
        String[] s = new String[o.length];
        int i = 0;
        while (i < o.length) {
            s[i] = (String)o[i];
            ++i;
        }
        return s;
    }

    public Dimensions[] getDimensions() {
        Object[] o = this.dims.toArray();
        Dimensions[] s = new Dimensions[o.length];
        int i = 0;
        while (i < o.length) {
            s[i] = (Dimensions)o[i];
            ++i;
        }
        return s;
    }

    public Dimensions getDimensions(String dimName) {
        int index = this.dimNames.indexOf(dimName.toUpperCase().trim());
        if (index < 0 || index >= this.dimNames.size()) {
            return null;
        }
        return (Dimensions)this.dims.get(index);
    }

    public void add(int index, Dimensions dim) {
        this.dims.add(index, dim);
        this.dimNames.add(index, dim.getDimensionsName().toUpperCase().trim());
    }

    public boolean contains(String dimName) {
        return this.dimNames.contains(dimName.toUpperCase().trim());
    }

    public int indexOf(String name) {
        return this.dimNames.indexOf(name.toUpperCase().trim());
    }

    public int indexOf(Dimensions dim) {
        return this.dims.indexOf(dim);
    }

    public boolean contains(Dimensions dim) {
        return this.dims.contains(dim);
    }

    public void save(String fileName) throws Throwable {
        XMLFile xmlFile = XMLFile.newXML(fileName, "DIM");
        this.save(xmlFile);
    }

    private void save(XMLFile xmlFile) throws Exception {
        Object[] o = this.dims.toArray();
        Dimensions[] dim = new Dimensions[o.length];
        int i = 0;
        while (i < dim.length) {
            dim[i] = (Dimensions)o[i];
            dim[i].saveToXMLFile(xmlFile);
            ++i;
        }
        xmlFile.save();
    }
}

