/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.dimension;

import com.runqian.base.tool.Section;
import com.runqian.base.tool.XMLFile;
import com.runqian.query.dimension.Dimensions;
import com.runqian.query.dimension.Hierarchy;
import java.util.ArrayList;

public class DivideMethod {
    private String name;
    private ArrayList hierarchysName;
    private ArrayList hierarchys;
    private Dimensions dms;

    public DivideMethod(XMLFile xmlFile, String path, Dimensions dim, String divideName) throws Exception {
        this.dms = dim;
        this.name = divideName;
        path = String.valueOf(path) + "/" + divideName;
        this.read(xmlFile, path);
    }

    private void read(XMLFile xmlFile, String path) throws Exception {
        Section section = xmlFile.listElement(path);
        int n = section.countSection();
        this.hierarchysName = new ArrayList(n);
        this.hierarchys = new ArrayList(n);
        int i = 0;
        while (i < n) {
            String hierarchyName = section.getSection(i);
            Hierarchy hierarchy = new Hierarchy(xmlFile, path, this, hierarchyName);
            this.hierarchys.add(i, hierarchy);
            this.hierarchysName.add(i, hierarchyName);
            hierarchy.setHierarchyNumber(i + 1);
            ++i;
        }
    }

    public DivideMethod(String xmlFileName, String path, Dimensions dim, String divideName) throws Throwable {
        this.dms = dim;
        this.name = divideName;
        path = String.valueOf(path) + "/" + divideName;
        XMLFile xmlFile = new XMLFile(xmlFileName);
        this.read(xmlFile, path);
    }

    public DivideMethod(String name, Dimensions dms) {
        this.name = name.toUpperCase().trim();
        this.dms = dms;
        this.hierarchysName = new ArrayList(10);
        this.hierarchys = new ArrayList(10);
    }

    public Dimensions getDimensions() {
        return this.dms;
    }

    public String getDivideMethodName() {
        return this.name.toUpperCase().trim();
    }

    public boolean setDivideMethodName(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        this.name = name.toUpperCase().trim();
        return true;
    }

    public void add(Hierarchy hierarchy) {
        this.hierarchys.add(hierarchy);
        this.hierarchysName.add(hierarchy.getHierarchyName().toUpperCase().trim());
        hierarchy.setHierarchyNumber(this.hierarchys.size());
    }

    public void add(int index, Hierarchy hierarchy) {
        this.hierarchys.add(index, hierarchy);
        this.hierarchysName.add(index, hierarchy.getHierarchyName().toUpperCase().trim());
        int i = index;
        while (i < this.hierarchys.size()) {
            ((Hierarchy)this.hierarchys.get(i)).setHierarchyNumber(i + 1);
            ++i;
        }
    }

    public int deleteHierarchy(Hierarchy hierarchy) {
        int n = hierarchy.getHierarchyNumber();
        this.hierarchys.remove(n - 1);
        this.hierarchysName.remove(n - 1);
        int i = n - 1;
        while (i < this.hierarchys.size()) {
            ((Hierarchy)this.hierarchys.get(i)).setHierarchyNumber(i + 1);
            ++i;
        }
        return this.hierarchys.size();
    }

    public Hierarchy[] listHierarchys() {
        Object[] o = this.hierarchys.toArray();
        Hierarchy[] s = new Hierarchy[o.length];
        int i = 0;
        while (i < o.length) {
            s[i] = (Hierarchy)o[i];
            ++i;
        }
        return s;
    }

    public String[] listHierarchysName() {
        Object[] o = this.hierarchysName.toArray();
        String[] s = new String[o.length];
        int i = 0;
        while (i < o.length) {
            s[i] = (String)o[i];
            ++i;
        }
        return s;
    }

    public Hierarchy getHierarchy(String hierarchyName) {
        if (hierarchyName == null) {
            return null;
        }
        int n = this.hierarchysName.indexOf(hierarchyName.toUpperCase().trim());
        if (n < 0 || n >= this.hierarchysName.size()) {
            return null;
        }
        return (Hierarchy)this.hierarchys.get(n);
    }

    public Hierarchy getHierarchy(int number) {
        return (Hierarchy)this.hierarchys.get(number - 1);
    }

    public int indexOf(String name) {
        return this.hierarchysName.indexOf(name.toUpperCase().trim());
    }

    public int indexOf(Hierarchy hie) {
        return this.hierarchys.indexOf(hie);
    }

    public int countHierarchys() {
        return this.hierarchys.size();
    }

    public boolean renameHierarchy(String oldName, String newName) {
        if (newName == null || newName.trim().length() == 0) {
            return false;
        }
        int i = this.hierarchysName.indexOf(oldName.toUpperCase().trim());
        Hierarchy hc = (Hierarchy)this.hierarchys.get(i);
        if (hc == null) {
            return false;
        }
        hc.setHierarchyName(newName.toUpperCase().trim());
        this.hierarchys.set(i, newName.toUpperCase().trim());
        return true;
    }

    public void saveToXMLFile(XMLFile xmlFile, String path) throws Exception {
        xmlFile.newElement(path, this.name);
        Hierarchy[] hierarchyEM = this.listHierarchys();
        int i = 0;
        while (i < hierarchyEM.length) {
            Hierarchy hierarchy = hierarchyEM[i];
            hierarchy.saveToXMLFile(xmlFile, String.valueOf(path) + "/" + this.name);
            ++i;
        }
    }
}

