/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.dimension;

import com.runqian.base.tool.XMLFile;
import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.ReportError;
import com.runqian.base.util.SegmentSet;
import com.runqian.query.dimension.ElementSet;

public class Element {
    private String name;
    private int defineType;
    private ElementSet set;
    private String value;
    public static final int CONSTANT = 0;
    public static final int SECTION = 1;
    public static final int SET = 2;

    public Element(XMLFile xmlFile, String path, ElementSet set, String elementName) {
        this.name = elementName;
        this.set = set;
        path = String.valueOf(path) + "/" + elementName;
        String define = xmlFile.getAttribute(path);
        if (define == null || define.trim().length() == 0) {
            return;
        }
        this.init(define);
    }

    public Element(String name, String define, ElementSet set) {
        this.name = name.toUpperCase().trim();
        this.set = set;
        if (define == null || define.trim().length() == 0) {
            return;
        }
        this.init(define);
    }

    public ElementSet getElementSet() {
        return this.set;
    }

    public String getDefineString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("type=").append(this.defineType).append(";");
        switch (this.defineType) {
            case 0: {
                sb.append("constant=").append(this.value).append(";");
                break;
            }
            case 1: {
                ArgumentTokenizer at = new ArgumentTokenizer(this.value, ',');
                sb.append("range1=").append(at.nextToken()).append(";");
                sb.append("range2=").append(at.nextToken()).append(";");
                break;
            }
            case 2: {
                sb.append("elementset=").append(this.value).append(";");
                break;
            }
            default: {
                throw new ReportError("\u5143\u7d20 '" + this.name + "' \u5b9a\u4e49\u7c7b\u578b\u4e0d\u5408\u6cd5");
            }
        }
        return sb.toString();
    }

    public String getElementName() {
        return this.name.toUpperCase().trim();
    }

    public void setElementName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new ReportError("\u5143\u7d20\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.name = name.toUpperCase().trim();
    }

    public int getDefineType() {
        return this.defineType;
    }

    public void setDefineType(int defineType) {
        if (defineType < 0 || defineType > 2) {
            throw new ReportError("\u5143\u7d20\u5b9a\u4e49\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        this.defineType = defineType;
    }

    private void init(String define) {
        SegmentSet segs = new SegmentSet(define);
        String type = segs.get("type");
        try {
            this.defineType = Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            throw new ReportError("\u5143\u7d20 '" + this.name + "' \u5b9a\u4e49\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        switch (this.defineType) {
            case 0: {
                this.value = segs.get("constant");
                break;
            }
            case 1: {
                this.value = String.valueOf(segs.get("range1")) + "," + segs.get("range2");
                break;
            }
            case 2: {
                this.value = segs.get("elementset");
                break;
            }
            default: {
                throw new ReportError("\u5143\u7d20 '" + this.name + "' \u5b9a\u4e49\u7c7b\u578b\u4e0d\u5408\u6cd5");
            }
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void saveToXMLFile(XMLFile xmlFile, String path) throws Exception {
        xmlFile.newAttribute(path, this.name);
        xmlFile.setAttribute(String.valueOf(path) + "/" + this.name, this.getDefineString());
    }
}

