/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.dimension;

import com.runqian.base.tool.Section;
import com.runqian.base.tool.XMLFile;
import com.runqian.query.dimension.Element;
import com.runqian.query.dimension.Hierarchy;
import java.util.ArrayList;

public class ElementSet {
    private String name;
    private ArrayList elements;
    private ArrayList elementNames;
    private Hierarchy hc;

    public ElementSet(XMLFile xmlFile, String path, Hierarchy hiy, String setName) throws Exception {
        this.name = setName;
        this.hc = hiy;
        path = String.valueOf(path) + "/" + setName;
        this.read(xmlFile, path);
    }

    public ElementSet(String xmlFileName, String path, Hierarchy hiy, String setName) throws Throwable {
        this.name = setName;
        this.hc = hiy;
        path = String.valueOf(path) + "/" + setName;
        XMLFile xmlFile = new XMLFile(xmlFileName);
        this.read(xmlFile, path);
    }

    private void read(XMLFile xmlFile, String path) throws Exception {
        Section section = xmlFile.listAttribute(path);
        int n = section.countSection();
        this.elements = new ArrayList(n);
        this.elementNames = new ArrayList(n);
        int i = 0;
        while (i < n) {
            String elementName = section.getSection(i);
            Element element = new Element(xmlFile, path, this, elementName);
            this.elements.add(element);
            this.elementNames.add(elementName.toUpperCase().trim());
            ++i;
        }
    }

    public ElementSet(String name, Hierarchy hc) {
        this.name = name.toUpperCase().trim();
        this.hc = hc;
        this.elements = new ArrayList(10);
        this.elementNames = new ArrayList(10);
    }

    public Hierarchy getHierarchy() {
        return this.hc;
    }

    public String getElementSetName() {
        return this.name.toUpperCase().trim();
    }

    public boolean setElementSetName(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        this.name = name.toUpperCase().trim();
        return true;
    }

    public void add(Element element) {
        this.elements.add(element);
        this.elementNames.add(element.getElementName().toUpperCase().trim());
    }

    public void add(int index, Element element) {
        this.elements.add(index, element);
        this.elementNames.add(index, element.getElementName().toUpperCase().trim());
    }

    public int deleteElement(Element element) {
        this.elements.remove(element.getElementName());
        return this.elements.size();
    }

    public boolean renameElement(String oldName, String newName) throws Exception {
        if (newName == null || newName.trim().length() == 0) {
            return false;
        }
        int index = this.elementNames.indexOf(oldName.toUpperCase().trim());
        Element em = (Element)this.elements.get(index);
        em.setElementName(newName.toUpperCase().trim());
        this.elementNames.set(index, newName.toUpperCase().trim());
        return true;
    }

    public Element[] listElements() {
        Object[] o = this.elements.toArray();
        Element[] s = new Element[o.length];
        int i = 0;
        while (i < o.length) {
            s[i] = (Element)o[i];
            ++i;
        }
        return s;
    }

    public String[] listElementsName() {
        Object[] o = this.elementNames.toArray();
        String[] s = new String[o.length];
        int i = 0;
        while (i < o.length) {
            s[i] = (String)o[i];
            ++i;
        }
        return s;
    }

    public Element getElement(String elementName) {
        int index = this.elementNames.indexOf(elementName.toUpperCase().trim());
        if (index < 0 || index >= this.elements.size()) {
            return null;
        }
        return (Element)this.elements.get(index);
    }

    public int indexOf(String name) {
        return this.elementNames.indexOf(name.toUpperCase().trim());
    }

    public int indexOf(Element element) {
        return this.elements.indexOf(element);
    }

    public int countElements() {
        return this.elements.size();
    }

    public void saveToXMLFile(XMLFile xmlFile, String path) throws Exception {
        xmlFile.newElement(path, this.name);
        Element[] em = this.listElements();
        int i = 0;
        while (i < em.length) {
            em[i].saveToXMLFile(xmlFile, String.valueOf(path) + "/" + this.name);
            ++i;
        }
    }
}

