/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.dimension;

import com.runqian.base.tool.Section;
import com.runqian.base.tool.XMLFile;
import com.runqian.base.util.SegmentSet;
import com.runqian.query.dimension.DivideMethod;
import com.runqian.query.dimension.ElementSet;
import java.util.ArrayList;

public class Hierarchy {
    private String name;
    private int number;
    private String setType;
    private String sql;
    private ArrayList elementSets;
    private ArrayList elementSetNames;
    private int dataType;
    private DivideMethod dm;
    public static final String TYPE_SQL = "SQL";
    public static final String TYPE_SET = "SET";

    public Hierarchy(XMLFile xmlFile, String path, DivideMethod divide, String hierarchyName) throws Exception {
        this.dm = divide;
        this.name = hierarchyName;
        path = String.valueOf(path) + "/" + hierarchyName;
        this.read(xmlFile, path);
    }

    public Hierarchy(String xmlFileName, String path, DivideMethod divide, String hierarchyName) throws Throwable {
        this.dm = divide;
        this.name = hierarchyName;
        path = String.valueOf(path) + "/" + hierarchyName;
        XMLFile xmlFile = new XMLFile(xmlFileName);
        this.read(xmlFile, path);
    }

    private void read(XMLFile xmlFile, String path) throws Exception {
        String num = xmlFile.getAttribute(String.valueOf(path) + "/NUMBER");
        try {
            this.number = Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            this.number = 1;
        }
        String sdataType = xmlFile.getAttribute(String.valueOf(path) + "/DATATYPE");
        try {
            this.dataType = Integer.parseInt(sdataType);
        }
        catch (NumberFormatException e) {
            this.dataType = 12;
        }
        this.setType = xmlFile.getAttribute(String.valueOf(path) + "/SETTYPE");
        if (TYPE_SQL.equalsIgnoreCase(this.setType)) {
            this.sql = xmlFile.getAttribute(String.valueOf(path) + "/SQL");
        } else {
            Section section = xmlFile.listElement(path);
            int n = section.countSection();
            this.elementSets = new ArrayList(n);
            this.elementSetNames = new ArrayList(n);
            int i = 0;
            while (i < n) {
                String setName = section.getSection(i);
                ElementSet set = new ElementSet(xmlFile, path, this, setName);
                this.elementSets.add(set);
                this.elementSetNames.add(setName);
                ++i;
            }
        }
    }

    public Hierarchy(String name, DivideMethod dm) {
        this.name = name.toUpperCase().trim();
        this.dm = dm;
        this.elementSets = new ArrayList();
        this.elementSetNames = new ArrayList();
    }

    public DivideMethod getDivideMethod() {
        return this.dm;
    }

    public String getHierarchyName() {
        return this.name.toUpperCase().trim();
    }

    public boolean setHierarchyName(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        this.name = name.toUpperCase().trim();
        return true;
    }

    public int getHierarchyNumber() {
        return this.number;
    }

    public boolean setHierarchyNumber(int number) {
        if (number < 0) {
            return false;
        }
        this.number = number;
        return true;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public String getSetType() {
        return this.setType;
    }

    public boolean setSetType(String setType) {
        if (setType == null || setType.trim().length() == 0) {
            return false;
        }
        this.setType = setType.toUpperCase().trim();
        return true;
    }

    public String getSql() {
        if (!TYPE_SQL.equals(this.setType)) {
            return null;
        }
        return this.sql;
    }

    public String getExecutableSql() {
        if (TYPE_SQL.equalsIgnoreCase(this.setType) && this.sql != null) {
            SegmentSet segment = new SegmentSet(this.sql, ';');
            String value = segment.get("value");
            String disp = segment.get("disp");
            String tbl = segment.get("tbl");
            String where = segment.get("where");
            StringBuffer sb = new StringBuffer(100);
            sb.append("select ").append(value).append(",").append(disp).append(" from ").append(tbl);
            sb.append(" where ").append(where);
            return sb.toString();
        }
        return null;
    }

    public boolean setSql(String sql) {
        if (sql == null || sql.trim().length() == 0 || !TYPE_SQL.equals(this.setType)) {
            return false;
        }
        this.sql = sql.trim();
        return true;
    }

    public void add(ElementSet elementSet) {
        this.elementSets.add(elementSet);
        this.elementSetNames.add(elementSet.getElementSetName().toUpperCase().trim());
    }

    public void add(int index, ElementSet elementSet) {
        this.elementSets.add(index, elementSet);
        this.elementSetNames.add(index, elementSet.getElementSetName().toUpperCase().trim());
    }

    public int deleteElementSet(ElementSet elementSet) {
        this.elementSets.remove(elementSet);
        this.elementSetNames.remove(elementSet.getElementSetName().toUpperCase().trim());
        return this.elementSets.size();
    }

    public ElementSet[] listElementSets() {
        if (TYPE_SQL.equals(this.setType)) {
            return null;
        }
        Object[] o = this.elementSets.toArray();
        ElementSet[] s = new ElementSet[o.length];
        int i = 0;
        while (i < o.length) {
            s[i] = (ElementSet)o[i];
            ++i;
        }
        return s;
    }

    public String[] listElementSetsName() {
        if (TYPE_SQL.equals(this.setType)) {
            return null;
        }
        Object[] o = this.elementSetNames.toArray();
        String[] s = new String[o.length];
        int i = 0;
        while (i < o.length) {
            s[i] = (String)o[i];
            ++i;
        }
        return s;
    }

    public ElementSet getElementSet(String elementSetName) {
        int index = this.elementSetNames.indexOf(elementSetName.toUpperCase().trim());
        if (index < 0 || index >= this.elementSets.size()) {
            return null;
        }
        return (ElementSet)this.elementSets.get(index);
    }

    public int indexOf(String name) {
        return this.elementSetNames.indexOf(name.toUpperCase().trim());
    }

    public int indexOf(ElementSet set) {
        return this.elementSets.indexOf(set);
    }

    public int countElementSets() {
        if (TYPE_SQL.equals(this.setType)) {
            return 0;
        }
        return this.elementSets.size();
    }

    public boolean renameElementSet(String oldName, String newName) {
        if (newName == null || newName.trim().length() == 0 || oldName == null || oldName.trim().length() == 0 || !this.elementSetNames.contains(oldName.toUpperCase().trim())) {
            return false;
        }
        int index = this.elementSetNames.indexOf(oldName.toUpperCase().trim());
        ElementSet es = (ElementSet)this.elementSets.get(index);
        es.setElementSetName(newName.toUpperCase().trim());
        this.elementSetNames.set(index, newName.toUpperCase().trim());
        return true;
    }

    public void saveToXMLFile(XMLFile xmlFile, String path) throws Exception {
        xmlFile.newElement(path, this.name);
        path = String.valueOf(path) + "/" + this.name;
        xmlFile.newAttribute(path, "NUMBER");
        xmlFile.setAttribute(String.valueOf(path) + "/NUMBER", String.valueOf(this.number));
        xmlFile.newAttribute(path, "DATATYPE");
        xmlFile.setAttribute(String.valueOf(path) + "/DATATYPE", String.valueOf(this.dataType));
        xmlFile.newAttribute(path, "SETTYPE");
        xmlFile.setAttribute(String.valueOf(path) + "/SETTYPE", this.setType);
        if (TYPE_SQL.equalsIgnoreCase(this.setType)) {
            xmlFile.newAttribute(path, TYPE_SQL);
            xmlFile.setAttribute(String.valueOf(path) + "/SQL", this.sql);
        } else {
            ElementSet[] em = this.listElementSets();
            int i = 0;
            while (i < em.length) {
                em[i].saveToXMLFile(xmlFile, path);
                ++i;
            }
        }
    }
}

