/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.exp;

import com.runqian.base.util.ReportError;
import com.runqian.base.util.Sentence;
import com.runqian.query.dataset.XDataSet;
import com.runqian.query.exp.Constant;
import com.runqian.query.exp.Env;
import com.runqian.query.exp.Function;
import com.runqian.query.exp.FunctionLib;
import com.runqian.query.exp.Node;
import com.runqian.query.exp.Variant2;
import com.runqian.query.exp.XDSVariable;
import com.runqian.query.exp.operator.Add;
import com.runqian.query.exp.operator.And;
import com.runqian.query.exp.operator.Divide;
import com.runqian.query.exp.operator.Equals;
import com.runqian.query.exp.operator.Greater;
import com.runqian.query.exp.operator.In;
import com.runqian.query.exp.operator.Like;
import com.runqian.query.exp.operator.Mod;
import com.runqian.query.exp.operator.Multiply;
import com.runqian.query.exp.operator.Not;
import com.runqian.query.exp.operator.NotEquals;
import com.runqian.query.exp.operator.NotGreater;
import com.runqian.query.exp.operator.NotSmaller;
import com.runqian.query.exp.operator.Or;
import com.runqian.query.exp.operator.Smaller;
import com.runqian.query.exp.operator.Subtract;
import com.runqian.query.exp.operator.To;

public class Expression {
    protected Env env;
    protected String expStr;
    protected int location;
    protected Node home;
    protected Node preNode;

    public void setRootNode(Node home) {
        this.home = home;
    }

    public Node getRootNode() {
        return this.home;
    }

    protected String scanId() {
        int len = this.expStr.length();
        int begin = this.location;
        while (this.location < len) {
            char c = this.expStr.charAt(this.location);
            if (Character.isWhitespace(c) || c == '+' || c == '-' || c == '*' || c == '/' || c == '=' || c == '&' || c == '|' || c == '!' || c == '>' || c == '<' || c == '(' || c == ')' || c == '[' || c == ']') break;
            ++this.location;
        }
        return this.expStr.substring(begin, this.location);
    }

    protected String scanParameter() {
        char c;
        int len = this.expStr.length();
        while (this.location < len) {
            c = this.expStr.charAt(this.location);
            if (!Character.isWhitespace(c)) break;
            ++this.location;
        }
        if (this.location == len) {
            throw new ReportError("\u51fd\u6570\u7f3a\u5c11\u53c2\u6570");
        }
        c = this.expStr.charAt(this.location);
        if (c != '(') {
            throw new ReportError("\u51fd\u6570\u7f3a\u5c11\u53c2\u6570");
        }
        int match = Sentence.scanParenthesis(this.expStr, this.location);
        if (match == -1) {
            throw new ReportError("\u51fd\u6570\u62ec\u53f7\u4e0d\u5339\u914d");
        }
        String param = this.expStr.substring(this.location + 1, match);
        this.location = match + 1;
        return param;
    }

    protected Node createNode() {
        char c = this.expStr.charAt(this.location);
        int match = -1;
        if (c == '\"' || c == '\'') {
            match = Sentence.scanQuotation(this.expStr, this.location);
            if (match == -1) {
                throw new ReportError("\u5f15\u53f7\u4e0d\u5339\u914d");
            }
            String str = this.expStr.substring(this.location + 1, match);
            this.location = match + 1;
            return new Constant(str);
        }
        if (c == '[') {
            Function fun;
            match = Sentence.scanBracket(this.expStr, this.location);
            if (match == -1) {
                throw new ReportError("\u4e2d\u62ec\u53f7\u4e0d\u5339\u914d");
            }
            if (this.preNode == null || this.preNode.isOperator()) {
                fun = FunctionLib.newFunction("list", this.env);
                fun.setParameter(this.expStr.substring(this.location + 1, match));
            } else if (this.preNode instanceof XDSVariable) {
                fun = FunctionLib.newFunction("move", this.env);
                fun.setParameter(this.expStr.substring(this.location + 1, match));
            } else {
                fun = FunctionLib.newFunction("offset", this.env);
                fun.setParameter(this.expStr.substring(this.location + 1, match));
            }
            this.location = match + 1;
            return fun;
        }
        String id = this.scanId();
        if (id.equalsIgnoreCase("and")) {
            return new And();
        }
        if (id.equalsIgnoreCase("or")) {
            return new Or();
        }
        if (id.equalsIgnoreCase("not")) {
            return new Not();
        }
        if (id.equalsIgnoreCase("in")) {
            return new In();
        }
        if (id.equalsIgnoreCase("to")) {
            return new To();
        }
        if (id.equalsIgnoreCase("like")) {
            return new Like();
        }
        XDataSet tmpDS = null;
        int index = id.indexOf(46);
        if (index > 0 && !Character.isDigit(id.charAt(0))) {
            String dsName = id.substring(0, index);
            if (this.env != null && this.env.isXDataSetName(dsName)) {
                tmpDS = this.env.getXDataSet(dsName);
                id = id.substring(index + 1);
            }
            if (tmpDS == null) {
                throw new ReportError("\u4e0d\u53ef\u8bc6\u522b\u7684\u6570\u636e\u96c6" + id);
            }
            Node node = this.createDSNode(tmpDS, id);
            if (node != null) {
                return node;
            }
            throw new ReportError("\u4e0d\u53ef\u8bc6\u522b\u7684\u6570\u636e\u96c6\u51fd\u6570" + id);
        }
        if (this.env != null && this.env.isParamName(id)) {
            return new Constant(this.env.getParamValue(id));
        }
        Node node = this.createDSNode(null, id);
        if (node != null) {
            return node;
        }
        if (this.isNextBracket() && FunctionLib.isFunName(id)) {
            Function fun = FunctionLib.newFunction(id, this.env);
            fun.setParameter(this.scanParameter());
            return fun;
        }
        Object value = Variant2.parse(id);
        if (value == null) {
            throw new ReportError("\u4e0d\u8ba4\u8bc6\u7684\u53d8\u91cf\u540d: " + id);
        }
        return new Constant(value);
    }

    private boolean isNextBracket() {
        int i = this.location;
        int len = this.expStr.length();
        while (i < len && Character.isWhitespace(this.expStr.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return false;
        }
        return this.expStr.charAt(i) == '(';
    }

    protected Node createDSNode(XDataSet xds, String id) {
        if (xds == null) {
            xds = this.env.getCurrentXDS();
        }
        if (id.charAt(0) == '#') {
            int colIndex = 0;
            try {
                colIndex = Integer.parseInt(id.substring(1));
            }
            catch (NumberFormatException e) {
                throw new ReportError("\u6570\u636e\u96c6\u5217\u7d22\u5f15\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (xds == null) {
                throw new ReportError("\u6570\u636e\u96c6\u672a\u4ea7\u751f");
            }
            if (colIndex >= xds.getColumnCount()) {
                throw new ReportError("\u6570\u636e\u96c6\u5217\u7d22\u5f15\u8d85\u51fa\u8303\u56f4");
            }
            return new XDSVariable(xds, colIndex);
        }
        if (this.isNextBracket() && FunctionLib.isDSFunName(id)) {
            Function fun = FunctionLib.newDSFunction(id, this.env, xds);
            fun.setParameter(this.scanParameter());
            return fun;
        }
        if (xds != null && xds.isColumnName(id)) {
            return new XDSVariable(xds, xds.getColumnIndex(id));
        }
        return null;
    }

    protected void create() {
        int len = this.expStr.length();
        Node node = null;
        int inBrackets = 0;
        block15: while (this.location < len) {
            char c = this.expStr.charAt(this.location);
            if (Character.isWhitespace(c)) {
                ++this.location;
                continue;
            }
            node = null;
            switch (c) {
                case '(': {
                    ++inBrackets;
                    ++this.location;
                    continue block15;
                }
                case ')': {
                    if (--inBrackets < 0) {
                        throw new ReportError("\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u53f3\u62ec\u53f7\u592a\u591a\uff01");
                    }
                    ++this.location;
                    continue block15;
                }
                case '+': {
                    node = new Add();
                    ++this.location;
                    break;
                }
                case '-': {
                    node = new Subtract();
                    ++this.location;
                    break;
                }
                case '*': {
                    node = new Multiply();
                    ++this.location;
                    break;
                }
                case '/': {
                    node = new Divide();
                    ++this.location;
                    break;
                }
                case '=': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        ++this.location;
                    }
                    node = new Equals();
                    break;
                }
                case '!': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new NotEquals();
                        ++this.location;
                    }
                    if (node != null) break;
                    node = new Not();
                    break;
                }
                case '>': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new NotSmaller();
                        ++this.location;
                    }
                    if (node != null) break;
                    node = new Greater();
                    break;
                }
                case '<': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new NotGreater();
                        ++this.location;
                    }
                    if (node != null) break;
                    node = new Smaller();
                    break;
                }
                case '&': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '&') {
                        node = new And();
                        ++this.location;
                        break;
                    }
                    throw new ReportError("\u4e0d\u80fd\u8bc6\u522b\u6807\u8bc6\u7b26&");
                }
                case '|': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '|') {
                        node = new Or();
                        ++this.location;
                        break;
                    }
                    throw new ReportError("\u4e0d\u80fd\u8bc6\u522b\u6807\u8bc6\u7b26|");
                }
                case '%': {
                    node = new Mod();
                    ++this.location;
                    break;
                }
                default: {
                    node = this.createNode();
                }
            }
            node.setInBrackets(inBrackets);
            this.preNode = node;
            if (this.home == null) {
                this.home = node;
                continue;
            }
            Node right = this.home;
            Node parent = null;
            while (right != null && right.getPriority() < node.getPriority()) {
                parent = right;
                right = right.getRight();
            }
            node.setLeft(right);
            if (parent != null) {
                parent.setRight(node);
                continue;
            }
            this.home = node;
        }
        if (inBrackets > 0) {
            throw new ReportError("\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u5de6\u62ec\u53f7\u592a\u591a\uff01");
        }
    }

    public Expression(Env env, String expStr) {
        this.env = env;
        this.expStr = expStr;
        this.location = 0;
        try {
            this.create();
            this.optimize();
        }
        catch (ReportError re) {
            re.setErrorMsg("\u8868\u8fbe\u5f0f" + expStr + "\u4e2d" + re.getMessage());
            throw re;
        }
        catch (Throwable e) {
            throw new ReportError("\u8868\u8fbe\u5f0f" + expStr + "\u4e2d" + e.getMessage(), e);
        }
    }

    public Expression(String expStr) {
        this(null, expStr);
    }

    public Object calculate() {
        try {
            if (this.home == null) {
                return null;
            }
            return this.home.calculate();
        }
        catch (ReportError re) {
            re.setErrorMsg("\u8868\u8fbe\u5f0f" + this.expStr + "\u4e2d" + re.getMessage());
            throw re;
        }
        catch (Throwable e) {
            throw new ReportError("\u8868\u8fbe\u5f0f" + this.expStr + "\u4e2d" + e.getMessage(), e);
        }
    }

    public String getExp() {
        try {
            if (this.home == null) {
                return null;
            }
            return this.home.getExp();
        }
        catch (ReportError re) {
            re.setErrorMsg("\u8868\u8fbe\u5f0f" + this.expStr + "\u4e2d" + re.getMessage());
            throw re;
        }
        catch (Throwable e) {
            throw new ReportError("\u8868\u8fbe\u5f0f" + this.expStr + "\u4e2d" + e.getMessage(), e);
        }
    }

    public String toString() {
        return this.expStr;
    }

    public boolean canOptimized() {
        return this.home == null ? false : this.home.canOptimized();
    }

    public void optimize() {
        if (this.home != null) {
            this.home = this.home.optimize();
        }
    }
}

