/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.exp;

import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.ReportError;
import com.runqian.query.dataset.XDataSet;
import com.runqian.query.exp.Constant;
import com.runqian.query.exp.Env;
import com.runqian.query.exp.Expression;
import com.runqian.query.exp.FunctionLib;
import com.runqian.query.exp.Node;
import java.util.ArrayList;

public abstract class Function
extends Node {
    protected Env env = null;
    protected XDataSet xds = null;
    protected ArrayList paramList = new ArrayList(5);

    protected void setParameter(String paramStr) {
        ArgumentTokenizer arg = new ArgumentTokenizer(paramStr == null ? null : paramStr.trim(), ',');
        while (arg.hasMoreElements()) {
            String token = arg.nextToken().trim();
            Expression exp = null;
            if (token.length() > 0) {
                exp = new Expression(this.env, token);
            }
            this.paramList.add(exp);
        }
    }

    public abstract Object calculate();

    public String getExp() {
        Class<?> c = this.getClass();
        String funName = (String)FunctionLib.tFunMap.get(c);
        if (funName == null) {
            funName = (String)FunctionLib.tDSFunMap.get(c);
        }
        throw new ReportError(String.valueOf(funName) + "\u51fd\u6570\u672a\u5b9e\u73b0\u5230javascript\u51fd\u6570\u7684\u8f6c\u6362");
    }

    protected boolean canOptimized() {
        if (this.left == null) {
            if (this.right != null && !this.right.canOptimized()) {
                return false;
            }
        } else {
            if (!this.left.canOptimized()) {
                return false;
            }
            if (this.right != null && !this.right.canOptimized()) {
                return false;
            }
        }
        if (this.paramList != null) {
            int i = 0;
            int size = this.paramList.size();
            while (i < size) {
                Expression exp = (Expression)this.paramList.get(i);
                if (!exp.canOptimized()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected Node optimize() {
        if (this.canOptimized()) {
            return new Constant(this.calculate());
        }
        if (this.left != null) {
            this.left = this.left.optimize();
        }
        if (this.right != null) {
            this.right = this.right.optimize();
        }
        if (this.paramList != null) {
            int i = 0;
            while (i < this.paramList.size()) {
                Expression exp = (Expression)this.paramList.get(i);
                exp.optimize();
                ++i;
            }
        }
        return this;
    }
}

