/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.exp;

import com.runqian.query.dataset.XDataSet;
import com.runqian.query.exp.Env;
import com.runqian.query.exp.Function;
import java.util.HashMap;

public class FunctionLib {
    private static HashMap funMap = new HashMap(20);
    private static HashMap dsFunMap = new HashMap(20);
    static HashMap tFunMap = new HashMap(20);
    static HashMap tDSFunMap = new HashMap(20);

    static {
        FunctionLib.loadSystemFunctions();
    }

    public static void addFunction(String funName, String className) {
        try {
            funName = funName.toLowerCase();
            Class<?> funClass = Class.forName(className);
            if (funMap.containsKey(funName)) {
                throw new RuntimeException("\u7cfb\u7edf\u4e2d\u6709\u4e24\u4e2a\u53eb" + funName + "\u7684\u51fd\u6570\uff01");
            }
            funMap.put(funName, funClass);
            tFunMap.put(funClass, funName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected static void addFunction(String funName, Class funClass) {
        funMap.put(funName.toLowerCase(), funClass);
    }

    public static void addDSFunction(String funName, String className) {
        try {
            funName = funName.toLowerCase();
            Class<?> funClass = Class.forName(className);
            if (dsFunMap.containsKey(funName)) {
                throw new RuntimeException("\u7cfb\u7edf\u4e2d\u6709\u4e24\u4e2a\u53eb" + funName + "\u7684\u6570\u636e\u96c6\u51fd\u6570\uff01");
            }
            dsFunMap.put(funName, funClass);
            tDSFunMap.put(funClass, funName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean isFunName(String id) {
        return funMap.containsKey(id.toLowerCase());
    }

    public static boolean isDSFunName(String id) {
        return dsFunMap.containsKey(id.toLowerCase());
    }

    public static Function newFunction(String funName, Env env) {
        try {
            Class funClass = (Class)funMap.get(funName.toLowerCase());
            Function fun = (Function)funClass.newInstance();
            fun.env = env;
            return fun;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Function newDSFunction(String funName, Env env, XDataSet xds) {
        try {
            Class funClass = (Class)dsFunMap.get(funName.toLowerCase());
            Function fun = (Function)funClass.newInstance();
            fun.env = env;
            fun.xds = xds;
            return fun;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void loadSystemFunction() {
        FunctionLib.loadSystemFunctions();
    }

    public static void loadSystemFunctions() {
        FunctionLib.addDSFunction("sum", "com.runqian.query.exp.function.DSSum");
        FunctionLib.addDSFunction("count", "com.runqian.query.exp.function.DSCount");
        FunctionLib.addDSFunction("avg", "com.runqian.query.exp.function.DSAverage");
        FunctionLib.addDSFunction("average", "com.runqian.query.exp.function.DSAverage");
        FunctionLib.addDSFunction("max", "com.runqian.query.exp.function.DSMax");
        FunctionLib.addDSFunction("min", "com.runqian.query.exp.function.DSMin");
        FunctionLib.addFunction("sum", "com.runqian.query.exp.function.Sum");
        FunctionLib.addFunction("count", "com.runqian.query.exp.function.Count");
        FunctionLib.addFunction("avg", "com.runqian.query.exp.function.Average");
        FunctionLib.addFunction("average", "com.runqian.query.exp.function.Average");
        FunctionLib.addFunction("max", "com.runqian.query.exp.function.Max");
        FunctionLib.addFunction("min", "com.runqian.query.exp.function.Min");
        FunctionLib.addFunction("list", "com.runqian.query.exp.function.ValueList");
        FunctionLib.addFunction("str", "com.runqian.query.exp.function.ToString");
        FunctionLib.addFunction("string", "com.runqian.query.exp.function.ToString");
        FunctionLib.addFunction("nvl", "com.runqian.query.exp.function.Nvl");
        FunctionLib.addFunction("if", "com.runqian.query.exp.function.IfFun");
        FunctionLib.addFunction("case", "com.runqian.query.exp.function.Case");
        FunctionLib.addFunction("move", "com.runqian.query.exp.function.Move");
        FunctionLib.addFunction("offset", "com.runqian.query.exp.function.Offset");
        FunctionLib.addFunction("datetime", "com.runqian.query.exp.function.datetime.DateTime");
        FunctionLib.addFunction("date_time", "com.runqian.query.exp.function.datetime.DateTime");
        FunctionLib.addFunction("datetime2", "com.runqian.query.exp.function.datetime.DateTime2");
        FunctionLib.addFunction("day", "com.runqian.query.exp.function.datetime.Day");
        FunctionLib.addFunction("dayname", "com.runqian.query.exp.function.datetime.DayName");
        FunctionLib.addFunction("day_name", "com.runqian.query.exp.function.datetime.DayName");
        FunctionLib.addFunction("daynumber", "com.runqian.query.exp.function.datetime.DayNumber");
        FunctionLib.addFunction("day_number", "com.runqian.query.exp.function.datetime.DayNumber");
        FunctionLib.addFunction("daysafter", "com.runqian.query.exp.function.datetime.DaysAfter");
        FunctionLib.addFunction("days_after", "com.runqian.query.exp.function.datetime.DaysAfter");
        FunctionLib.addFunction("hour", "com.runqian.query.exp.function.datetime.Hour");
        FunctionLib.addFunction("minute", "com.runqian.query.exp.function.datetime.Minute");
        FunctionLib.addFunction("month", "com.runqian.query.exp.function.datetime.Month");
        FunctionLib.addFunction("reldate", "com.runqian.query.exp.function.datetime.RelativeDate");
        FunctionLib.addFunction("relative_date", "com.runqian.query.exp.function.datetime.RelativeDate");
        FunctionLib.addFunction("reltime", "com.runqian.query.exp.function.datetime.RelativeTime");
        FunctionLib.addFunction("relative_time", "com.runqian.query.exp.function.datetime.RelativeTime");
        FunctionLib.addFunction("second", "com.runqian.query.exp.function.datetime.Second");
        FunctionLib.addFunction("seconds_after", "com.runqian.query.exp.function.datetime.SecondsAfter");
        FunctionLib.addFunction("date", "com.runqian.query.exp.function.datetime.ToDate");
        FunctionLib.addFunction("time", "com.runqian.query.exp.function.datetime.ToTime");
        FunctionLib.addFunction("year", "com.runqian.query.exp.function.datetime.Year");
        FunctionLib.addFunction("now", "com.runqian.query.exp.function.datetime.Now");
        FunctionLib.addFunction("abs", "com.runqian.query.exp.function.math.Abs");
        FunctionLib.addFunction("ceil", "com.runqian.query.exp.function.math.Ceiling");
        FunctionLib.addFunction("cos", "com.runqian.query.exp.function.math.Cos");
        FunctionLib.addFunction("exp", "com.runqian.query.exp.function.math.Exp");
        FunctionLib.addFunction("fact", "com.runqian.query.exp.function.math.Fact");
        FunctionLib.addFunction("int", "com.runqian.query.exp.function.math.Int");
        FunctionLib.addFunction("log", "com.runqian.query.exp.function.math.Log");
        FunctionLib.addFunction("log10", "com.runqian.query.exp.function.math.LogTen");
        FunctionLib.addFunction("pi", "com.runqian.query.exp.function.math.Pi");
        FunctionLib.addFunction("pow", "com.runqian.query.exp.function.math.Pow");
        FunctionLib.addFunction("rand", "com.runqian.query.exp.function.math.Rand");
        FunctionLib.addFunction("round", "com.runqian.query.exp.function.math.Round");
        FunctionLib.addFunction("sign", "com.runqian.query.exp.function.math.Sign");
        FunctionLib.addFunction("sin", "com.runqian.query.exp.function.math.Sin");
        FunctionLib.addFunction("sqrt", "com.runqian.query.exp.function.math.Sqrt");
        FunctionLib.addFunction("tan", "com.runqian.query.exp.function.math.Tan");
        FunctionLib.addFunction("floor", "com.runqian.query.exp.function.math.Floor");
        FunctionLib.addFunction("fill", "com.runqian.query.exp.function.string.Fill");
        FunctionLib.addFunction("left", "com.runqian.query.exp.function.string.Left");
        FunctionLib.addFunction("ltrim", "com.runqian.query.exp.function.string.LeftTrim");
        FunctionLib.addFunction("left_trim", "com.runqian.query.exp.function.string.LeftTrim");
        FunctionLib.addFunction("len", "com.runqian.query.exp.function.string.Len");
        FunctionLib.addFunction("lower", "com.runqian.query.exp.function.string.Lower");
        FunctionLib.addFunction("mid", "com.runqian.query.exp.function.string.Mid");
        FunctionLib.addFunction("pos", "com.runqian.query.exp.function.string.Pos");
        FunctionLib.addFunction("right", "com.runqian.query.exp.function.string.Right");
        FunctionLib.addFunction("rtrim", "com.runqian.query.exp.function.string.LeftTrim");
        FunctionLib.addFunction("right_trim", "com.runqian.query.exp.function.string.RightTrim");
        FunctionLib.addFunction("space", "com.runqian.query.exp.function.string.Space");
        FunctionLib.addFunction("trim", "com.runqian.query.exp.function.string.Trim");
        FunctionLib.addFunction("upper", "com.runqian.query.exp.function.string.Upper");
        FunctionLib.addFunction("word_cap", "com.runqian.query.exp.function.string.WordCap");
        FunctionLib.addFunction("like2", "com.runqian.query.exp.function.string.Like2");
        FunctionLib.addFunction("match", "com.runqian.query.exp.function.string.Match");
        FunctionLib.addFunction("integer", "com.runqian.query.exp.function.convert.ToInteger");
        FunctionLib.addFunction("toint", "com.runqian.query.exp.function.convert.ToInteger");
        FunctionLib.addFunction("long", "com.runqian.query.exp.function.convert.ToLong");
        FunctionLib.addFunction("double", "com.runqian.query.exp.function.convert.ToDouble");
        FunctionLib.addFunction("number", "com.runqian.query.exp.function.convert.ToNumber");
        FunctionLib.addFunction("asc", "com.runqian.query.exp.function.convert.Asc");
        FunctionLib.addFunction("char", "com.runqian.query.exp.function.convert.Char");
        FunctionLib.addFunction("isdate", "com.runqian.query.exp.function.convert.IsDate");
        FunctionLib.addFunction("isnumber", "com.runqian.query.exp.function.convert.IsNumber");
        FunctionLib.addFunction("istime", "com.runqian.query.exp.function.convert.IsTime");
    }
}

