/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.exp;

import com.runqian.base.util.ChineseComparator;
import com.runqian.base.util.DateTool;
import com.runqian.base.util.Escape;
import com.runqian.base.util.ObjectCache;
import com.runqian.base.util.ReportError;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class Variant2 {
    protected static final int INTEGER = 1;
    protected static final int LONG = 2;
    protected static final int DOUBLE = 3;
    protected static final int BIGDECIMAL = 4;
    public static int divideScale = 20;
    public static int divideRound = 4;

    private Variant2() {
    }

    public static String getDataType(Object o) {
        if (o == null) {
            return "\u7a7a\u5bf9\u8c61";
        }
        if (o instanceof String) {
            return "\u5b57\u7b26\u4e32";
        }
        if (o instanceof Double) {
            return "\u53cc\u7cbe\u5ea6\u6d6e\u70b9\u6570";
        }
        if (o instanceof Integer) {
            return "\u6574\u6570";
        }
        if (o instanceof Long) {
            return "\u957f\u6574\u6570";
        }
        if (o instanceof Boolean) {
            return "\u5e03\u5c14\u578b";
        }
        if (o instanceof BigDecimal) {
            return "\u957f\u5c0f\u6570";
        }
        if (o instanceof Short) {
            return "\u77ed\u6574\u6570";
        }
        if (o instanceof Date) {
            return "\u65e5\u671f";
        }
        if (o instanceof Byte) {
            return "\u5b57\u8282";
        }
        return o.getClass().getName();
    }

    public static boolean isNumber(Object o) {
        return o instanceof Number;
    }

    public static final Object getValue(Object o) {
        return o;
    }

    public static Object getSingleValue(Object obj) {
        if (obj instanceof List) {
            List list = (List)obj;
            obj = list.size() == 0 ? null : list.get(0);
        }
        return obj;
    }

    public static String toString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof List) {
            List list = (List)o;
            int size = list.size();
            StringBuffer sb = new StringBuffer(10 * size);
            int i = 0;
            while (i < size) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(Variant2.toString(list.get(i)));
                ++i;
            }
            return sb.toString();
        }
        if (o instanceof Date) {
            return DateTool.formatTimestamp((Date)o);
        }
        return o.toString();
    }

    public static String format(Object o, String format) {
        if (o instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(o);
        }
        if (Variant2.isNumber(o)) {
            DecimalFormat df = new DecimalFormat(format);
            return df.format(o);
        }
        return Variant2.toString(o);
    }

    public static int intValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        throw new RuntimeException(String.valueOf(Variant2.getDataType(o)) + "\u4e0d\u80fd\u53d6\u6574\u6570");
    }

    public static long longValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new RuntimeException(String.valueOf(Variant2.getDataType(o)) + "\u4e0d\u80fd\u53d6\u957f\u6574\u6570");
    }

    public static double doubleValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        throw new RuntimeException(String.valueOf(Variant2.getDataType(o)) + "\u4e0d\u80fd\u53d6\u53cc\u7cbe\u5ea6\u6d6e\u70b9\u6570");
    }

    public static BigDecimal toBigDecimal(Object o) {
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof BigInteger) {
            return new BigDecimal((BigInteger)o);
        }
        return new BigDecimal(Variant2.doubleValue(o));
    }

    protected static int compare(int num1, int num2) {
        if (num1 > num2) {
            return 1;
        }
        if (num1 < num2) {
            return -1;
        }
        return 0;
    }

    protected static int compare(long num1, long num2) {
        if (num1 > num2) {
            return 1;
        }
        if (num1 < num2) {
            return -1;
        }
        return 0;
    }

    protected static int compare(double num1, double num2) {
        if (num1 > num2) {
            return 1;
        }
        if (num1 < num2) {
            return -1;
        }
        return 0;
    }

    protected static int compare(boolean num1, boolean num2) {
        if (num1) {
            if (num2) {
                return 0;
            }
            return 1;
        }
        if (num2) {
            return -1;
        }
        return 0;
    }

    public static int compare(Object o1, Object o2) {
        o1 = Variant2.getSingleValue(o1);
        o2 = Variant2.getSingleValue(o2);
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (Variant2.isNumber(o1) && Variant2.isNumber(o2)) {
            int type = Variant2.getMaxNumberType(o1, o2);
            switch (type) {
                case 1: {
                    return Variant2.compare(Variant2.intValue(o1), Variant2.intValue(o2));
                }
                case 2: {
                    return Variant2.compare(Variant2.longValue(o1), Variant2.longValue(o2));
                }
                case 3: {
                    return Variant2.compare(Variant2.doubleValue(o1), Variant2.doubleValue(o2));
                }
                case 4: {
                    return Variant2.toBigDecimal(o1).compareTo(Variant2.toBigDecimal(o2));
                }
            }
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return Variant2.compare((Boolean)o1, (Boolean)o2);
        }
        if (o1 instanceof Date && o2 instanceof Date) {
            return ((Date)o1).compareTo((Date)o2);
        }
        if (o1 instanceof String && o2 instanceof String) {
            return ChineseComparator.getInstance().compare((String)o1, (String)o2);
        }
        throw new ReportError(String.valueOf(Variant2.getDataType(o1)) + "\u4e0e" + Variant2.getDataType(o2) + "\u4e0d\u80fd\u6bd4\u8f83");
    }

    public static boolean equals(Object o1, Object o2) {
        o1 = Variant2.getSingleValue(o1);
        o2 = Variant2.getSingleValue(o2);
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.getClass().equals(o2.getClass())) {
            return o1.equals(o2);
        }
        return Variant2.compare(o1, o2) == 0;
    }

    protected static int getNumberType(Object o) {
        if (o instanceof Integer) {
            return 1;
        }
        if (o instanceof Long) {
            return 2;
        }
        if (o instanceof Double) {
            return 3;
        }
        if (o instanceof BigDecimal) {
            return 4;
        }
        if (o instanceof Byte) {
            return 1;
        }
        if (o instanceof Short) {
            return 1;
        }
        if (o instanceof Float) {
            return 3;
        }
        throw new RuntimeException();
    }

    protected static int getMaxNumberType(Object o1, Object o2) {
        int type2;
        int type1 = Variant2.getNumberType(o1);
        return type1 >= (type2 = Variant2.getNumberType(o2)) ? type1 : type2;
    }

    public static Object add(Object o1, Object o2) {
        o1 = Variant2.getSingleValue(o1);
        o2 = Variant2.getSingleValue(o2);
        if (o1 == null) {
            return o2;
        }
        if (o2 == null) {
            return o1;
        }
        if (Variant2.isNumber(o1) && Variant2.isNumber(o2)) {
            int type = Variant2.getMaxNumberType(o1, o2);
            switch (type) {
                case 1: {
                    return new Integer(Variant2.intValue(o1) + Variant2.intValue(o2));
                }
                case 2: {
                    return new Long(Variant2.longValue(o1) + Variant2.longValue(o2));
                }
                case 3: {
                    return new Double(Variant2.doubleValue(o1) + Variant2.doubleValue(o2));
                }
                case 4: {
                    return Variant2.toBigDecimal(o1).add(Variant2.toBigDecimal(o2));
                }
            }
        }
        if (o1 instanceof String && o2 instanceof String) {
            return String.valueOf((String)o1) + (String)o2;
        }
        if (o1 instanceof String && Variant2.isNumber(o2) || Variant2.isNumber(o1) && o2 instanceof String) {
            return String.valueOf(o1.toString()) + o2;
        }
        throw new ReportError(String.valueOf(Variant2.getDataType(o1)) + "\u4e0e" + Variant2.getDataType(o2) + "\u4e0d\u80fd\u76f8\u52a0");
    }

    public static Object subtract(Object o1, Object o2) {
        o1 = Variant2.getSingleValue(o1);
        o2 = Variant2.getSingleValue(o2);
        if (o1 == null) {
            return Variant2.negate(o2);
        }
        if (o2 == null) {
            return o1;
        }
        if (Variant2.isNumber(o1) && Variant2.isNumber(o2)) {
            int type = Variant2.getMaxNumberType(o1, o2);
            switch (type) {
                case 1: {
                    return new Integer(Variant2.intValue(o1) - Variant2.intValue(o2));
                }
                case 2: {
                    return new Long(Variant2.longValue(o1) - Variant2.longValue(o2));
                }
                case 3: {
                    return new Double(Variant2.doubleValue(o1) - Variant2.doubleValue(o2));
                }
                case 4: {
                    return Variant2.toBigDecimal(o1).subtract(Variant2.toBigDecimal(o2));
                }
            }
        }
        throw new ReportError(String.valueOf(Variant2.getDataType(o1)) + "\u4e0e" + Variant2.getDataType(o2) + "\u4e0d\u80fd\u76f8\u51cf");
    }

    public static Object multiply(Object o1, Object o2) {
        o1 = Variant2.getSingleValue(o1);
        o2 = Variant2.getSingleValue(o2);
        if (o1 == null || o2 == null) {
            return null;
        }
        if (Variant2.isNumber(o1) && Variant2.isNumber(o2)) {
            int type = Variant2.getMaxNumberType(o1, o2);
            switch (type) {
                case 1: {
                    return new Integer(Variant2.intValue(o1) * Variant2.intValue(o2));
                }
                case 2: {
                    return new Long(Variant2.longValue(o1) * Variant2.longValue(o2));
                }
                case 3: {
                    return new Double(Variant2.doubleValue(o1) * Variant2.doubleValue(o2));
                }
                case 4: {
                    return Variant2.toBigDecimal(o1).multiply(Variant2.toBigDecimal(o2));
                }
            }
        }
        throw new ReportError(String.valueOf(Variant2.getDataType(o1)) + "\u4e0e" + Variant2.getDataType(o2) + "\u4e0d\u80fd\u76f8\u4e58");
    }

    public static Object divide(Object o1, Object o2) {
        o1 = Variant2.getSingleValue(o1);
        o2 = Variant2.getSingleValue(o2);
        if (o1 == null || o2 == null) {
            return null;
        }
        if (Variant2.isNumber(o1) && Variant2.isNumber(o2)) {
            int type = Variant2.getMaxNumberType(o1, o2);
            try {
                switch (type) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return new Double(Variant2.doubleValue(o1) / Variant2.doubleValue(o2));
                    }
                    case 4: {
                        return Variant2.toBigDecimal(o1).divide(Variant2.toBigDecimal(o2), divideScale, divideRound);
                    }
                }
            }
            catch (ArithmeticException e) {
                throw new ReportError(e.getMessage());
            }
        }
        throw new ReportError(String.valueOf(Variant2.getDataType(o1)) + "\u4e0e" + Variant2.getDataType(o2) + "\u4e0d\u80fd\u76f8\u9664");
    }

    public static Object negate(Object o) {
        if ((o = Variant2.getSingleValue(o)) == null) {
            return o;
        }
        if (Variant2.isNumber(o)) {
            int type = Variant2.getNumberType(o);
            switch (type) {
                case 1: {
                    return new Integer(-Variant2.intValue(o));
                }
                case 2: {
                    return new Long(-Variant2.longValue(o));
                }
                case 3: {
                    return new Double(-Variant2.doubleValue(o));
                }
                case 4: {
                    return Variant2.toBigDecimal(o).negate();
                }
            }
        }
        throw new ReportError(String.valueOf(Variant2.getDataType(o)) + "\u4e0d\u80fd\u6c42\u8d1f");
    }

    public static Object mod(Object o1, Object o2) {
        o1 = Variant2.getSingleValue(o1);
        o2 = Variant2.getSingleValue(o2);
        if (o1 == null || o2 == null) {
            return null;
        }
        if (Variant2.isNumber(o1) && Variant2.isNumber(o2)) {
            int type = Variant2.getMaxNumberType(o1, o2);
            switch (type) {
                case 1: {
                    return new Integer(Variant2.intValue(o1) % Variant2.intValue(o2));
                }
                case 2: {
                    return new Long(Variant2.longValue(o1) % Variant2.longValue(o2));
                }
                case 3: 
                case 4: {
                    return new Double(Variant2.doubleValue(o1) % Variant2.doubleValue(o2));
                }
            }
        }
        throw new ReportError(String.valueOf(Variant2.getDataType(o1)) + "\u4e0e" + Variant2.getDataType(o2) + "\u4e0d\u80fd\u6c42\u4f59");
    }

    public static Object abs(Object o) {
        if ((o = Variant2.getSingleValue(o)) == null) {
            return null;
        }
        if (Variant2.isNumber(o)) {
            int type = Variant2.getNumberType(o);
            switch (type) {
                case 1: {
                    return new Integer(Math.abs(Variant2.intValue(o)));
                }
                case 2: {
                    return new Long(Math.abs(Variant2.longValue(o)));
                }
                case 3: {
                    return new Double(Math.abs(Variant2.doubleValue(o)));
                }
                case 4: {
                    return Variant2.toBigDecimal(o).abs();
                }
            }
        }
        throw new ReportError(String.valueOf(Variant2.getDataType(o)) + "\u4e0d\u80fd\u6c42\u7edd\u5bf9\u503c");
    }

    public static Object parse(String text) {
        if ((text = text.trim()).length() == 0) {
            return null;
        }
        if (text.length() > 0 && text.charAt(0) == '\"') {
            return Escape.removeEscAndQuote(text);
        }
        if (text.equalsIgnoreCase("null")) {
            return null;
        }
        if (text.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (text.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (text.length() > 2 && text.charAt(0) == '0' && (text.charAt(1) == 'X' || text.charAt(1) == 'x')) {
            try {
                return ObjectCache.getLong(Long.parseLong(text.substring(2), 16));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return ObjectCache.getInteger(Integer.parseInt(text));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new Long(Long.parseLong(text));
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return new Double(text);
                }
                catch (NumberFormatException numberFormatException3) {
                    return null;
                }
            }
        }
    }

    public static Object parseDate(String text) {
        try {
            return DateTool.parseDate(text);
        }
        catch (ParseException parseException) {
            try {
                return DateTool.parseTime(text);
            }
            catch (ParseException parseException2) {
                try {
                    return DateTool.parseTimestamp(text);
                }
                catch (ParseException parseException3) {
                    return null;
                }
            }
        }
    }

    public static String getExp(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return Escape.addEscAndQuote((String)o);
        }
        return o.toString();
    }
}

