/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.ide;

import com.runqian.base.swing.JTableEx;
import com.runqian.base.tool.Section;
import com.runqian.base.tool.Segment;
import com.runqian.base.tool.Tools;
import com.runqian.base.util.IntHashtable;
import com.runqian.query.action.Action;
import com.runqian.query.action.ActionStack;
import com.runqian.query.action.BindDimensionAction;
import com.runqian.query.action.DeleteColAction;
import com.runqian.query.action.DiffAction;
import com.runqian.query.action.FilterAction;
import com.runqian.query.action.FullJoinAction;
import com.runqian.query.action.GroupAction;
import com.runqian.query.action.InsertCalcColAction;
import com.runqian.query.action.IntegralAction;
import com.runqian.query.action.JoinAction;
import com.runqian.query.action.LeftJoinAction;
import com.runqian.query.action.RightJoinAction;
import com.runqian.query.action.SortAction;
import com.runqian.query.action.UnionAction;
import com.runqian.query.dataset.XDataSet;
import com.runqian.query.dimension.Dimensions;
import com.runqian.query.ide.Message;
import com.runqian.query.ide.MessageAcceptor;
import com.runqian.query.ide.MessageDispatcher;
import com.runqian.query.ide.QueryMain;
import com.runqian.query.ide.QueryStatusBar;
import com.runqian.query.ide.XDataSetManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;

public class QueryBrowser
extends JInternalFrame
implements MessageAcceptor {
    public static String TYPE_DATASET = "DataSet";
    public static String TYPE_MAINDATASET = "MainDataSet";
    public static String TYPE_ACTION = "Action";
    public static String TYPE_ARGUMENTS = "Arguments";
    public static String TYPE_MACRO = "Macro";
    public String fileName;
    public QueryMain queryMain;
    public boolean need2Save = false;
    private static int reportCount = 0;
    private Segment wholeSeg = null;
    private String dc = "A,B,C,D,E,F,G,H";
    public JTableEx dataViewer = new JTableEx(this.dc);

    public Object receive(Message command) throws Throwable {
        return null;
    }

    public void load() {
        this.wholeSeg = new Segment();
        if (this.fileName.startsWith("\u6da6\u4e7e\u67e5\u8be2")) {
            return;
        }
        try {
            File f = new File(this.fileName);
            FileReader fr = new FileReader(this.fileName);
            char[] buf = new char[(int)f.length()];
            fr.read(buf);
            this.wholeSeg = new Segment(new String(buf));
        }
        catch (Exception e) {
            Tools.showException(e);
        }
    }

    public boolean save() {
        try {
            if (this.fileName.startsWith("\u6da6\u4e7e\u67e5\u8be2")) {
                return this.saveAs();
            }
            FileWriter fw = new FileWriter(this.fileName);
            fw.write(this.wholeSeg.toString());
            fw.close();
            this.need2Save = false;
            final QueryStatusBar label = QueryMain.statusBar;
            final String sTmp = label.getText();
            label.setText("\u6570\u636e\u5df2\u4fdd\u5b58\u3002");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        Thread.currentThread();
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    label.setText(sTmp);
                }
            });
        }
        catch (Exception e) {
            Tools.showException(e);
        }
        return true;
    }

    public boolean export() throws Exception {
        if (this.dataViewer.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this.queryMain, "\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002");
            return false;
        }
        File txtFile = Tools.getFile("txt");
        if (txtFile == null) {
            return false;
        }
        String sfile = txtFile.getAbsolutePath();
        if (!sfile.toLowerCase().endsWith("txt")) {
            txtFile = new File(txtFile.getParent(), String.valueOf(txtFile.getName()) + ".txt");
            sfile = txtFile.getAbsolutePath();
        }
        FileWriter fw = new FileWriter(txtFile);
        this.dataViewer.exportData(true, fw, true);
        fw.flush();
        fw.close();
        return true;
    }

    public boolean saveAs() {
        try {
            File saveFile = Tools.getFile("rqy");
            if (saveFile == null) {
                return false;
            }
            String sfile = saveFile.getAbsolutePath();
            if (!sfile.toLowerCase().endsWith("rqy")) {
                saveFile = new File(saveFile.getParent(), String.valueOf(saveFile.getName()) + "." + "rqy");
                sfile = saveFile.getAbsolutePath();
            }
            this.fileName = sfile;
            this.setTitle(this.fileName);
            this.save();
        }
        catch (Exception e) {
            Tools.showException(e);
        }
        return true;
    }

    public Action getAction(int index, XDataSetManager xdsm) {
        Segment atom = this.getByIndex(TYPE_ACTION, index);
        if (atom == null) {
            return null;
        }
        String name = atom.get("name");
        Action atomAction = null;
        if (name.equalsIgnoreCase("InsertColumn")) {
            String arg1 = atom.get("Col");
            String arg2 = atom.get("ColName");
            String arg3 = atom.get("Exp");
            atomAction = new InsertCalcColAction(Integer.parseInt(arg1), arg2, arg3);
        } else if (name.equalsIgnoreCase("DeleteColumn")) {
            String arg1 = atom.get("ColName");
            atomAction = new DeleteColAction(arg1);
        } else if (name.equalsIgnoreCase("Filter")) {
            String arg1 = atom.get("Exp");
            String arg2 = atom.get("DSName");
            atomAction = new FilterAction(arg1, arg2);
        } else if (name.equalsIgnoreCase("Sort")) {
            String arg1 = atom.get("SortExp");
            String arg2 = atom.get("DSName");
            atomAction = new SortAction(arg1, arg2);
        } else if (name.equalsIgnoreCase("Group")) {
            String arg1 = atom.get("GroupByExp");
            String arg2 = atom.get("GroupBy");
            String arg3 = atom.get("CollectExp");
            String arg4 = atom.get("Collect");
            String arg5 = atom.get("DSName");
            Section k1 = new Section(arg1);
            Section k2 = new Section(arg2);
            Section k3 = new Section(arg3);
            Section k4 = new Section(arg4);
            atomAction = new GroupAction(k1.toStringArray(), k2.toStringArray(), k3.toStringArray(), k4.toStringArray(), arg5);
        } else if (name.equalsIgnoreCase("Union")) {
            String arg1 = atom.get("DataSet");
            String arg2 = atom.get("DSName");
            atomAction = new UnionAction(xdsm.getXDS(arg1), arg2);
        } else if (name.equalsIgnoreCase("Bind")) {
            String arg1 = atom.get("ColName");
            String arg2 = atom.get("DimFile");
            String arg3 = atom.get("DimName");
            try {
                Dimensions dd = new Dimensions(arg3, arg2);
                atomAction = new BindDimensionAction(arg1, dd);
            }
            catch (Throwable e) {
                Tools.showException(e);
            }
        } else if (name.equalsIgnoreCase("Diff") || name.equalsIgnoreCase("Integral")) {
            String arg1 = atom.get("SelectCol");
            String arg2 = atom.get("DiffCol");
            String arg3 = atom.get("DiffColName");
            String arg4 = atom.get("DSName");
            String[] s1 = new Section(arg1).toStringArray();
            String[] s2 = new Section(arg2).toStringArray();
            String[] s3 = new Section(arg3).toStringArray();
            atomAction = name.equalsIgnoreCase(QueryMain.ACTION_DIFF) ? new DiffAction(s1, s2, s3, arg4) : new IntegralAction(s1, s2, s3, arg4);
        } else if (name.endsWith("Join")) {
            String arg1 = atom.get("DataSet");
            String arg2 = atom.get("Exp");
            String arg3 = atom.get("SCol");
            String arg4 = atom.get("TCol");
            String arg5 = atom.get("DSName");
            XDataSet xds = xdsm.getXDS(arg1);
            String[] s3 = new Section(arg3).toStringArray();
            String[] s4 = new Section(arg4).toStringArray();
            atomAction = name.equalsIgnoreCase(QueryMain.ACTION_FULLJOIN) ? new FullJoinAction(xds, arg2, s3, s4, arg5) : (name.equalsIgnoreCase(QueryMain.ACTION_LEFTJOIN) ? new LeftJoinAction(xds, arg2, s3, s4, arg5) : (name.equalsIgnoreCase(QueryMain.ACTION_RIGHTJOIN) ? new RightJoinAction(xds, arg2, s3, s4, arg5) : new JoinAction(xds, arg2, s3, s4, arg5)));
        }
        return atomAction;
    }

    public XDataSetManager getXDSM() {
        try {
            XDataSetManager xxds = new XDataSetManager(this.get(TYPE_DATASET), this.get(TYPE_MAINDATASET));
            return xxds;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.queryMain, "\u6253\u5f00\u6570\u636e\u8868\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8fde\u63a5\u3002");
            return null;
        }
    }

    public XDataSet runAction(int level) throws Exception {
        XDataSetManager xdsm = this.getXDSM();
        if (xdsm == null) {
            return null;
        }
        ActionStack as = new ActionStack();
        XDataSet xds = xdsm.getMainXDS();
        if (xds == null) {
            throw new Exception("\u6ca1\u6709\u8bbe\u7f6e\u4e3b\u6570\u636e\u96c6\uff01");
        }
        as.setXDataSet(xdsm.getMainXDS());
        int i = level;
        while (i >= 0) {
            Action tmpAction;
            Action atomAction = this.getAction(i, xdsm);
            if (atomAction != null && (tmpAction = this.getAction(i, xdsm)) != null) {
                as.push(tmpAction);
            }
            --i;
        }
        xds = as.run();
        this.display(xds);
        return xds;
    }

    void display(XDataSet xds) {
        if (xds == null) {
            return;
        }
        Vector colNames = new Vector(xds.getColumnNames());
        int rowCount = xds.getRowCount();
        int colCount = xds.getColumnCount();
        DefaultTableModel dtm = new DefaultTableModel(colNames, rowCount);
        dtm.setRowCount(0);
        int i = 0;
        while (i < rowCount) {
            Vector<Object> rowData = new Vector<Object>();
            int j = 0;
            while (j < colCount) {
                rowData.add(xds.getData(i + 1, j + 1));
                ++j;
            }
            dtm.addRow(rowData);
            ++i;
        }
        this.dataViewer.setModel(dtm);
    }

    public String[] getDataSetNames() {
        String sTmp = this.get(TYPE_DATASET);
        Section ss = new Section(sTmp);
        return ss.toStringArray();
    }

    public String get(String type) {
        if (this.wholeSeg == null) {
            return null;
        }
        return this.wholeSeg.get(type);
    }

    public void set(String type, String value) {
        this.need2Save = true;
        this.wholeSeg.put(type, value);
    }

    public Segment getByIndex(String type, int index) {
        String sTmp = this.get(type);
        if (!Tools.isValidString(sTmp)) {
            return null;
        }
        Segment ss = new Segment(sTmp);
        Segment s2 = new Segment(ss.get(Integer.toString(index)));
        return s2;
    }

    public QueryBrowser(String fileName, boolean resizable, boolean closable, boolean maxmizable, boolean iconifiable) {
        super(fileName, resizable, closable, maxmizable, iconifiable);
        if (fileName.equals("")) {
            fileName = "\u6da6\u4e7e\u67e5\u8be2" + reportCount++;
        }
        this.setTitle(fileName);
        this.getContentPane().setLayout(new BorderLayout());
        JScrollPane dataViewerSp = new JScrollPane(this.dataViewer);
        this.getContentPane().add((Component)dataViewerSp, "Center");
        this.addInternalFrameListener(new Listener(this));
        this.fileName = fileName;
        this.load();
        this.setDefaultCloseOperation(0);
    }

    public void setCurrentFile(String file) {
        this.fileName = file;
    }

    class Listener
    extends InternalFrameAdapter {
        private Message ss;
        private IntHashtable argument;
        QueryBrowser qb;

        public Listener(QueryBrowser parent) {
            this.qb = parent;
            this.ss = new Message();
            this.argument = new IntHashtable();
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            QueryMain cfr_ignored_0 = QueryBrowser.this.queryMain;
            QueryMain.resetMenu(Boolean.TRUE);
            QueryBrowser.this.queryMain.loadAction(QueryBrowser.this.get(TYPE_ACTION));
            MessageDispatcher.addRelativeObject((short)5, this.qb);
            try {
                this.ss.setConsumer((short)2);
                this.ss.setName(1500);
                this.ss.setArgument(QueryBrowser.this.fileName);
                MessageDispatcher.send(this.ss);
            }
            catch (Throwable t) {
                Tools.showException(t);
            }
        }

        public void dispose() {
            if (QueryBrowser.this.dataViewer != null) {
                QueryBrowser.this.dataViewer = null;
                this.qb.dispose();
            }
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            this.ss.setConsumer((short)1);
            this.ss.setName(135);
            this.ss.setArgument(QueryBrowser.this.fileName);
            try {
                MessageDispatcher.send(this.ss);
            }
            catch (Throwable t) {
                Tools.showException(t);
            }
        }
    }
}

