/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.query.ide;

import com.runqian.base.tool.Tools;
import com.runqian.base.tool.XMLFile;
import com.runqian.base.util.IntHashtable;
import com.runqian.query.ide.AppConstants;
import com.runqian.query.ide.Message;
import com.runqian.query.ide.MessageAcceptor;
import com.runqian.query.ide.MessageDispatcher;
import com.runqian.query.ide.QueryMain;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class QueryMenuBar
extends JMenuBar
implements MessageAcceptor {
    public JFrame mainFrame;
    private ActionListener menuAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int cmd;
            JMenuItem mi = (JMenuItem)e.getSource();
            QueryMenuBar.this.argument.clear();
            QueryMenuBar.this.message.setConsumer((short)1);
            try {
                cmd = Integer.parseInt(mi.getName());
            }
            catch (NumberFormatException nfe) {
                Object o = e.getSource();
                if (o == null) {
                    return;
                }
                JCheckBoxMenuItem rmi = (JCheckBoxMenuItem)o;
                cmd = 430;
                QueryMenuBar.this.message.setArgument(mi.getName());
                rmi.setSelected(true);
            }
            try {
                QueryMenuBar.this.message.setName(cmd);
                MessageDispatcher.send(QueryMenuBar.this.message);
            }
            catch (Throwable t) {
                Tools.showException(t);
            }
        }
    };
    private IntHashtable menuItems;
    private IntHashtable argument;
    private Message message;
    private String currentTitle;
    public String firstFileToOpen = null;
    public String firstConnect = null;
    private JMenuItem[] fileItem = new JMenuItem[5];
    private JMenuItem[] connItem = new JMenuItem[5];
    private JMenu liveMenu;
    private HashSet liveMenuItems = new HashSet();

    public QueryMenuBar(JFrame f) {
        MessageDispatcher.addRelativeObject((short)2, this);
        this.message = new Message();
        this.message.setProducer((short)2);
        this.argument = new IntHashtable();
        this.menuItems = new IntHashtable(100);
        this.mainFrame = f;
        JMenu menu = this.getMenu("\u6587\u4ef6(F)", 'F');
        menu.add(this.newMenuItem(110, "\u65b0\u5efa\u67e5\u8be2(N)...", 'N', Boolean.TRUE, "/com/runqian/query/ide/resources/M_NEW.gif"));
        menu.add(this.newMenuItem(120, "\u6253\u5f00(O)...", 'O', Boolean.TRUE, "/com/runqian/query/ide/resources/M_OPEN.gif"));
        menu.add(this.newMenuItem(135, "\u5173\u95ed", 's', Boolean.TRUE));
        menu.add(this.newMenuItem(125, "\u4fdd\u5b58(S)", 'S', Boolean.TRUE, "/com/runqian/query/ide/resources/M_SAVE.gif"));
        menu.add(this.newMenuItem(130, "\u53e6\u5b58\u4e3a(A)...", 'A', Boolean.FALSE, "/com/runqian/query/ide/resources/M_SAVE.gif"));
        menu.add(this.newMenuItem(145, "\u5bfc\u51fa\u6587\u672c\u6570\u636e(T)", 'T', Boolean.FALSE));
        JMenu subMenu = this.getMenu("\u6700\u8fd1\u6587\u4ef6(F)", 'F');
        this.getRecentFile(subMenu);
        menu.add(subMenu);
        subMenu = this.getMenu("\u6700\u8fd1\u8fde\u63a5(J)", 'J');
        this.getRecentConn(subMenu);
        menu.add(subMenu);
        menu.add(this.newMenuItem(165, "\u9000\u51fa(X)", 'X', Boolean.FALSE));
        this.add(menu);
        menu = this.getMenu("\u64cd\u4f5c(I)", 'I');
        menu.add(this.newMenuItem(220, "\u589e\u52a0(I)", 'I', Boolean.TRUE, "/com/runqian/query/ide/resources/M_ADD.gif"));
        menu.add(this.newMenuItem(230, "\u63d2\u5165(A)", 'A', Boolean.FALSE, "/com/runqian/query/ide/resources/M_INSERT.gif"));
        menu.add(this.newMenuItem(225, "\u5220\u9664(D)", 'D', Boolean.TRUE, "/com/runqian/query/ide/resources/M_DELETE.gif"));
        menu.add(this.newMenuItem(231, "\u4fee\u6539(M)", 'M', Boolean.TRUE, "/com/runqian/query/ide/resources/M_MODIFY.gif"));
        menu.addSeparator();
        menu.add(this.newMenuItem(155, "\u9884\u89c8", 'x', null, "/com/runqian/query/ide/resources/M_PREVIEW.gif"));
        this.add(menu);
        menu = this.getMenu("\u7cfb\u7edf(S)", 'S');
        menu.add(this.newMenuItem(305, "\u6570\u636e\u5e93\u8fde\u63a5(S)...", 'S', Boolean.FALSE));
        menu.add(this.newMenuItem(325, "\u767b\u8bb0\u8868(R)...", 'R', Boolean.FALSE));
        menu.add(this.newMenuItem(330, "\u5bfc\u5165\u8868(I)...", 'I', Boolean.FALSE));
        menu.add(this.newMenuItem(335, "\u8868\u5b57\u5178(D)...", 'D', Boolean.FALSE));
        menu.add(this.newMenuItem(338, "\u7ef4\u7f16\u8f91(W)...", 'W', Boolean.FALSE));
        menu.add(this.newMenuItem(308, "\u6570\u636e\u96c6\u5b9a\u4e49(T)...", 'T', Boolean.FALSE));
        menu.addSeparator();
        menu.add(this.newMenuItem(310, "\u8bbe\u7f6e\u67e5\u8be2\u8868(C)...", 'C', Boolean.FALSE));
        menu.add(this.newMenuItem(315, "\u62a5\u8868\u53c2\u6570(A)...", 'A', Boolean.FALSE));
        menu.add(this.newMenuItem(320, "\u5b8f\u5b9a\u4e49(M)...", 'M', Boolean.FALSE));
        this.add(menu);
        this.liveMenu = menu = this.getMenu("\u7a97\u53e3(W)", 'W');
        menu.add(this.newMenuItem(20001, "\u5c42\u53e0(C)", 'C', Boolean.FALSE));
        menu.add(this.newMenuItem(20002, "\u6c34\u5e73\u5e73\u94fa(H)", 'H', Boolean.FALSE));
        menu.add(this.newMenuItem(20003, "\u5782\u76f4\u5e73\u94fa(V)", 'V', Boolean.FALSE));
        menu.add(this.newMenuItem(20004, "\u586b\u5145(L)", 'L', Boolean.FALSE));
        this.add(menu);
        menu = this.getMenu("\u5e2e\u52a9(H)", 'H');
        menu.add(this.newMenuItem(410, "\u4e3b\u9898(T)...", 'T', Boolean.FALSE));
        menu.add(this.newMenuItem(420, "\u5173\u4e8e(A)...", 'A', Boolean.FALSE));
        this.add(menu);
    }

    private JMenuItem newMenuItem(int id, String text, char mneKey, Boolean accelerator, String iconURL) {
        KeyStroke ks;
        JMenuItem mItem = new JMenuItem(text, mneKey);
        mItem.setName(Integer.toString(id));
        if (iconURL != null) {
            try {
                ImageIcon iconNew = Tools.getImageIcon(iconURL);
                mItem.setIcon(iconNew);
            }
            catch (Exception e) {
                Tools.showException(e);
            }
        }
        if (accelerator == null) {
            ks = KeyStroke.getKeyStroke((int)mneKey, 0);
            mItem.setAccelerator(ks);
        } else if (accelerator.booleanValue()) {
            ks = KeyStroke.getKeyStroke((int)mneKey, 2);
            mItem.setAccelerator(ks);
        }
        mItem.addActionListener(this.menuAction);
        this.menuItems.put(id, mItem);
        return mItem;
    }

    private JMenuItem newMenuItem(int id, String text, char mneKey, Boolean accelerator) {
        JMenuItem mItem = new JMenuItem(text, mneKey);
        mItem.setName(Integer.toString(id));
        if (accelerator == null) {
            KeyStroke ks = KeyStroke.getKeyStroke((int)mneKey, 0);
            mItem.setAccelerator(ks);
        } else if (accelerator.booleanValue()) {
            KeyStroke ks = KeyStroke.getKeyStroke((int)mneKey, 2);
            mItem.setAccelerator(ks);
        }
        mItem.addActionListener(this.menuAction);
        this.menuItems.put(id, mItem);
        return mItem;
    }

    private void resetLiveMenuItems() {
        Iterator it = this.liveMenuItems.iterator();
        while (it.hasNext()) {
            JCheckBoxMenuItem rmi = (JCheckBoxMenuItem)it.next();
            rmi.setSelected(false);
        }
    }

    public void addLiveMenu(String winName) {
        JMenuItem mi = Tools.findMenuItemByName(this, winName);
        this.resetLiveMenuItems();
        this.currentTitle = winName;
        if (mi == null) {
            if (this.liveMenu.getItemCount() == 4) {
                this.liveMenu.addSeparator();
            }
            JCheckBoxMenuItem rmi = new JCheckBoxMenuItem(winName);
            rmi.setName(winName);
            rmi.addActionListener(this.menuAction);
            this.liveMenu.add(rmi);
            this.liveMenuItems.add(rmi);
            rmi.setSelected(true);
        } else {
            JCheckBoxMenuItem rmi = (JCheckBoxMenuItem)mi;
            rmi.setSelected(true);
        }
    }

    public void removeLiveMenu(String winName, boolean removeControl) {
        JCheckBoxMenuItem mi = (JCheckBoxMenuItem)Tools.findMenuItemByName(this, winName);
        if (mi != null) {
            this.liveMenu.remove(mi);
            this.liveMenuItems.remove(mi);
            if (winName.startsWith("\u6d4f\u89c8\u62a5\u8868[  ")) {
                MessageDispatcher.removeRelativeObject((short)5);
            } else if (removeControl && mi.isSelected()) {
                MessageDispatcher.removeRelativeObject((short)5);
            }
        }
    }

    public void renameLiveMenu(String srcName, String tarName) {
        JMenuItem mi = Tools.findMenuItemByName(this, srcName);
        if (mi != null) {
            mi.setName(tarName);
            mi.setText(tarName);
        }
    }

    private JMenu getMenu(String text, char mneKey) {
        JMenu mItem = new JMenu(text);
        mItem.setMnemonic(mneKey);
        return mItem;
    }

    public void setMenuAll(boolean lb) {
        IntHashtable.Enumerator eu = this.menuItems.keys();
        while (eu.hasMoreElements()) {
            int key = eu.nextElement();
            Object o = this.menuItems.get(key);
            JMenuItem mi = (JMenuItem)o;
            mi.setEnabled(lb);
        }
    }

    public JMenuItem getMenuItem(int menuId) {
        JMenuItem mItem = new JMenuItem();
        JMenuItem jmi = (JMenuItem)this.menuItems.get(menuId);
        String text = jmi.getText();
        int pos = text.indexOf("(");
        if (pos > 0) {
            text = text.substring(0, pos);
        }
        mItem.setText(text);
        mItem.setName(Integer.toString(menuId));
        mItem.setIcon(jmi.getIcon());
        mItem.setAccelerator(jmi.getAccelerator());
        mItem.addActionListener(this.menuAction);
        return mItem;
    }

    public void setMenuEnable(int[] items, boolean lb) {
        int i = 0;
        while (i < items.length) {
            JMenuItem mi = (JMenuItem)this.menuItems.get(items[i]);
            if (mi != null) {
                mi.setEnabled(lb);
            }
            ++i;
        }
    }

    private void getRecentFile(JMenu menu) {
        AbstractAction actionNew = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem tt = (JMenuItem)e.getSource();
                try {
                    QueryMenuBar.this.message.setConsumer((short)1);
                    QueryMenuBar.this.message.setName(120);
                    QueryMenuBar.this.message.setArgument(tt.getText());
                    MessageDispatcher.send(QueryMenuBar.this.message);
                }
                catch (Throwable t) {
                    Tools.showException(t);
                }
            }
        };
        try {
            XMLFile file = new XMLFile(AppConstants.CONFIG_FILE);
            int i = 0;
            while (i < 5) {
                String sTmp = "rq" + Integer.toString(i);
                String tempFileName = file.getAttribute("RUNQIAN/RECENTFILE_QUERY/" + sTmp + "/filename");
                this.fileItem[i] = new JMenuItem(tempFileName);
                if (tempFileName.equals("")) {
                    this.fileItem[i].setVisible(false);
                }
                this.fileItem[i].addActionListener(actionNew);
                menu.add(this.fileItem[i]);
                if (i == 0 && Tools.isValidString(tempFileName)) {
                    this.firstFileToOpen = tempFileName;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Tools.showException(e);
        }
    }

    private void getRecentConn(JMenu menu) {
        AbstractAction actionNew = new AbstractAction(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent e) {
                try {
                    try {
                        JMenuItem tt = (JMenuItem)e.getSource();
                        QueryMenuBar.this.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                        QueryMain cfr_ignored_0 = (QueryMain)QueryMenuBar.this.mainFrame;
                        QueryMain.connect(tt.getText());
                    }
                    catch (Throwable e2) {
                        Tools.showException(e2);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    QueryMenuBar.this.mainFrame.setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                QueryMenuBar.this.mainFrame.setCursor(Cursor.getDefaultCursor());
            }
        };
        try {
            XMLFile file = new XMLFile(AppConstants.CONFIG_FILE);
            int i = 0;
            while (i < 5) {
                String sTmp = "rq" + Integer.toString(i);
                String tempConnName = file.getAttribute("RUNQIAN/RECENTCONN_QUERY/" + sTmp + "/sourcename");
                this.connItem[i] = new JMenuItem(tempConnName);
                if (tempConnName.equals("")) {
                    this.connItem[i].setVisible(false);
                }
                this.connItem[i].addActionListener(actionNew);
                menu.add(this.connItem[i]);
                if (i == 0 && Tools.isValidString(tempConnName)) {
                    this.firstConnect = tempConnName;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Tools.showException(e);
        }
    }

    public void refreshRecentFile(String fileName) {
        String tempFileName;
        int point = 4;
        int i = 0;
        while (i < this.fileItem.length) {
            tempFileName = this.fileItem[i].getText();
            if (fileName.equals(tempFileName)) {
                point = i;
                break;
            }
            ++i;
        }
        i = point;
        while (i > 0) {
            tempFileName = this.fileItem[i - 1].getText();
            this.fileItem[i].setText(tempFileName);
            this.fileItem[i].setVisible(!tempFileName.equals(""));
            --i;
        }
        this.fileItem[0].setText(fileName);
        this.fileItem[0].setVisible(true);
        this.saveRecentMenu();
    }

    public void refreshRecentConn(String sourceName) {
        String tempConnName;
        int point = 4;
        int i = 0;
        while (i < 5) {
            tempConnName = this.connItem[i].getText();
            if (sourceName.equals(tempConnName)) {
                point = i;
                break;
            }
            ++i;
        }
        i = point;
        while (i > 0) {
            tempConnName = this.connItem[i - 1].getText();
            this.connItem[i].setText(tempConnName);
            this.connItem[i].setVisible(!tempConnName.equals(""));
            --i;
        }
        this.connItem[0].setText(sourceName);
        this.connItem[0].setVisible(true);
        this.saveRecentMenu();
    }

    public void setMenuEnable(IntHashtable setting) {
        IntHashtable.Enumerator items = setting.keys();
        int menuIndex = 0;
        while (items.hasMoreElements()) {
            menuIndex = items.nextElement();
            JMenuItem item = (JMenuItem)this.menuItems.get(menuIndex);
            if (item == null) continue;
            Boolean enable = (Boolean)setting.get(menuIndex);
            item.setEnabled(enable);
        }
    }

    public Object receive(Message command) throws Throwable {
        Object retVal = null;
        if (command.getArgument() == null) {
            return null;
        }
        int cmd = command.getName();
        try {
            switch (cmd) {
                case 1400: {
                    this.argument = (IntHashtable)command.getArgument();
                    IntHashtable.Enumerator items = this.argument.keys();
                    int menuIndex = 0;
                    while (items.hasMoreElements()) {
                        menuIndex = items.nextElement();
                        JMenuItem item = (JMenuItem)this.menuItems.get(menuIndex);
                        if (item == null) continue;
                        Boolean enable = (Boolean)this.argument.get(menuIndex);
                        item.setEnabled(enable);
                    }
                    break;
                }
                case 1500: {
                    String strName = (String)command.getArgument();
                    this.addLiveMenu(strName);
                    break;
                }
            }
        }
        catch (Exception e) {
            Tools.showException(e);
        }
        return retVal;
    }

    private void saveRecentMenu() {
        try {
            XMLFile file = new XMLFile(AppConstants.CONFIG_FILE);
            int i = 0;
            while (i < 5) {
                String sTmp = "rq" + Integer.toString(i);
                file.setAttribute("RUNQIAN/RECENTFILE_QUERY/" + sTmp + "/filename", this.fileItem[i].getText());
                file.setAttribute("RUNQIAN/RECENTCONN_QUERY/" + sTmp + "/sourcename", this.connItem[i].getText());
                ++i;
            }
            file.save();
        }
        catch (Throwable t) {
            Tools.showException(t);
        }
    }
}

