/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.cellset;

import com.runqian.report.cellset.CellPosition;
import java.io.Serializable;

public class CellRegion
implements Serializable {
    public int right = 0;
    public int bottom = 0;
    public int left = 0;
    public int top = 0;

    public CellRegion() {
    }

    public CellRegion(String merge) {
        char ch;
        int i = 0;
        int len = merge.length();
        int row1 = 0;
        int col1 = 0;
        int row2 = 0;
        int col2 = 0;
        while (i < len && (ch = merge.charAt(i)) <= '9' && ch >= '0') {
            row1 = row1 * 10 + ch - 48;
            ++i;
        }
        if (merge.charAt(i) != ',') {
            throw new RuntimeException("\u975e\u6cd5\u5408\u5e76\u4e32\u8868\u793a");
        }
        ++i;
        while (i < len && (ch = merge.charAt(i)) <= '9' && ch >= '0') {
            col1 = col1 * 10 + ch - 48;
            ++i;
        }
        if (i == len) {
            this.set(row1, col1);
            return;
        }
        if (merge.charAt(i) != '-') {
            throw new RuntimeException("\u975e\u6cd5\u5408\u5e76\u4e32\u8868\u793a");
        }
        ++i;
        while (i < len && (ch = merge.charAt(i)) <= '9' && ch >= '0') {
            row2 = row2 * 10 + ch - 48;
            ++i;
        }
        if (merge.charAt(i) != ',') {
            throw new RuntimeException("\u975e\u6cd5\u5408\u5e76\u4e32\u8868\u793a");
        }
        ++i;
        while (i < len && (ch = merge.charAt(i)) <= '9' && ch >= '0') {
            col2 = col2 * 10 + ch - 48;
            ++i;
        }
        if (i != len) {
            throw new RuntimeException("\u975e\u6cd5\u5408\u5e76\u4e32\u8868\u793a");
        }
        this.set(row1, col1, row2, col2);
    }

    public CellRegion(CellPosition cp1) {
        this.set(cp1.row, cp1.col);
    }

    public CellRegion(int row, int col) {
        this.set(row, col);
    }

    private void set(int row, int col) {
        this.top = row;
        this.bottom = row;
        this.left = col;
        this.right = col;
    }

    public CellRegion(CellPosition cp1, CellPosition cp2) {
        this.set(cp1.row, cp1.col, cp2.row, cp2.col);
    }

    public CellRegion(int row1, int col1, int row2, int col2) {
        this.set(row1, col1, row2, col2);
    }

    public boolean equals(Object o) {
        if (o instanceof CellRegion) {
            CellRegion cr = (CellRegion)o;
            return this.top == cr.top && this.bottom == cr.bottom && this.left == cr.left && this.right == cr.right;
        }
        return false;
    }

    public boolean contains(CellRegion cr) {
        return this.top <= cr.top && this.bottom >= cr.bottom && this.left <= cr.left && this.right >= cr.right;
    }

    public boolean contains(int row1, int col1, int row2, int col2) {
        int t;
        if (row1 > row2) {
            t = row2;
            row2 = row1;
            row1 = t;
        }
        if (col1 > col2) {
            t = col2;
            col2 = col1;
            col1 = t;
        }
        return this.top <= row1 && this.bottom >= row2 && this.left <= col1 && this.right >= col2;
    }

    public boolean contains(CellPosition cp) {
        return this.top <= cp.row && this.bottom >= cp.row && this.left <= cp.col && this.right >= cp.col;
    }

    public boolean contains(int row, int col) {
        return this.top <= row && this.bottom >= row && this.left <= col && this.right >= col;
    }

    public boolean containsInRow(CellRegion cr) {
        return this.top <= cr.top && this.bottom >= cr.bottom;
    }

    public boolean containsInCol(CellRegion cr) {
        return this.left <= cr.left && this.right >= cr.right;
    }

    public boolean intersects(CellRegion cr) {
        int minRight;
        int maxTop = this.top <= cr.top ? cr.top : this.top;
        int minBottom = this.bottom <= cr.bottom ? this.bottom : cr.bottom;
        int maxLeft = this.left <= cr.left ? cr.left : this.left;
        int n = minRight = this.right <= cr.right ? this.right : cr.right;
        return maxTop <= minBottom && maxLeft <= minRight;
    }

    public boolean intersects(int row1, int col1, int row2, int col2) {
        int minRight;
        int t;
        if (row1 > row2) {
            t = row2;
            row2 = row1;
            row1 = t;
        }
        if (col1 > col2) {
            t = col2;
            col2 = col1;
            col1 = t;
        }
        int maxTop = this.top < row1 ? row1 : this.top;
        int minBottom = this.bottom < row2 ? this.bottom : row2;
        int maxLeft = this.left < col1 ? col1 : this.left;
        int n = minRight = this.right < col2 ? this.right : col2;
        return maxTop <= minBottom && maxLeft <= minRight;
    }

    public CellRegion intersection(CellRegion cr) {
        int minRight;
        int maxTop = this.top <= cr.top ? cr.top : this.top;
        int minBottom = this.bottom <= cr.bottom ? this.bottom : cr.bottom;
        int maxLeft = this.left <= cr.left ? cr.left : this.left;
        int n = minRight = this.right <= cr.right ? this.right : cr.right;
        if (maxTop > minBottom || maxLeft > minRight) {
            return null;
        }
        return new CellRegion(maxTop, maxLeft, minBottom, minRight);
    }

    public boolean intersection(CellRegion cr, CellRegion toCr) {
        int minRight;
        int maxTop = this.top <= cr.top ? cr.top : this.top;
        int minBottom = this.bottom <= cr.bottom ? this.bottom : cr.bottom;
        int maxLeft = this.left <= cr.left ? cr.left : this.left;
        int n = minRight = this.right <= cr.right ? this.right : cr.right;
        if (maxTop > minBottom || maxLeft > minRight) {
            return false;
        }
        toCr.set(maxTop, maxLeft, minBottom, minRight);
        return true;
    }

    public CellRegion intersection(int row1, int col1, int row2, int col2) {
        int minRight;
        int t;
        if (row1 > row2) {
            t = row2;
            row2 = row1;
            row1 = t;
        }
        if (col1 > col2) {
            t = col2;
            col2 = col1;
            col1 = t;
        }
        int maxTop = this.top < row1 ? row1 : this.top;
        int minBottom = this.bottom < row2 ? this.bottom : row2;
        int maxLeft = this.left < col1 ? col1 : this.left;
        int n = minRight = this.right < col2 ? this.right : col2;
        if (maxTop > minBottom || maxLeft > minRight) {
            return null;
        }
        return new CellRegion(maxTop, maxLeft, minBottom, minRight);
    }

    public boolean intersection(int row1, int col1, int row2, int col2, CellRegion toCr) {
        int minRight;
        int t;
        if (row1 > row2) {
            t = row2;
            row2 = row1;
            row1 = t;
        }
        if (col1 > col2) {
            t = col2;
            col2 = col1;
            col1 = t;
        }
        int maxTop = this.top < row1 ? row1 : this.top;
        int minBottom = this.bottom < row2 ? this.bottom : row2;
        int maxLeft = this.left < col1 ? col1 : this.left;
        int n = minRight = this.right < col2 ? this.right : col2;
        if (maxTop > minBottom || maxLeft > minRight) {
            return false;
        }
        toCr.set(maxTop, maxLeft, minBottom, minRight);
        return true;
    }

    public int getWidth() {
        return this.right - this.left + 1;
    }

    public int getHeight() {
        return this.bottom - this.top + 1;
    }

    public void addRow(int rowCount) {
        this.bottom += rowCount;
    }

    public void addCol(int colCount) {
        this.right += colCount;
    }

    public void set(int row1, int col1, int row2, int col2) {
        this.top = row1 <= row2 ? row1 : row2;
        this.bottom = row1 <= row2 ? row2 : row1;
        this.left = col1 <= col2 ? col1 : col2;
        this.right = col1 <= col2 ? col2 : col1;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public String toMergeString() {
        return "" + this.top + ',' + this.left + '-' + this.bottom + ',' + this.right;
    }

    public String toString() {
        return new StringBuffer(50).append("CellRegion[top=").append(this.top).append(", left=").append(this.left).append(", bottom=").append(this.bottom).append(", right=").append(this.right).toString();
    }

    public static void main(String[] args) {
        System.out.println(new CellRegion("3,3"));
        System.out.println(new CellRegion("3,3-6,6"));
    }
}

