/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.cellset;

import com.runqian.base.util.IntHashtable;
import com.runqian.base.util.Matrix;
import com.runqian.base.util.Sentence;
import com.runqian.report.cellset.CellPosition;
import com.runqian.report.cellset.CellProperty;
import com.runqian.report.cellset.CellSet1;
import com.runqian.report.cellset.CellSetOperator;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.RelativeFreeze;
import java.util.Vector;

public class CellSet
extends CellSet1
implements Cloneable {
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int TOP = 3;
    private static final int BOTTOM = 4;
    private static int count = 0;
    private static int[] changeValueKeys = new int[]{4503, 4502, 4801, 4803, 4807, 4802, 4808, 4809};
    private boolean needAdjust = true;
    private Vector vectFreeze;

    public void setNeedAdjust(boolean b) {
        this.needAdjust = b;
    }

    public static int getInstanceCount() {
        return count;
    }

    public void finalize() {
        --count;
    }

    public CellSet(int nRow, int nColumn) {
        this.matrix = new Matrix(nRow, nColumn);
        ++count;
    }

    public void insertRow(int row) {
        int col;
        if (this.matrix == null) {
            this.matrix = new Matrix();
        }
        if (row > this.getRow() || row < 0) {
            this.insertRow(this.getRow());
            return;
        }
        this.matrix.insertRow(row);
        CellSetParser parser = new CellSetParser(this);
        int rows = this.getRow();
        int cols = this.getColumn();
        int nOriginalRow = row - 1;
        if (row != rows - 1) {
            nOriginalRow = row + 1;
            col = 1;
            while (col < cols) {
                if (parser.isMerged(nOriginalRow, col)) {
                    int startRow = parser.getMergedStartRow(nOriginalRow, col);
                    int endRow = parser.getMergedEndRow(nOriginalRow, col);
                    int startCol = parser.getMergedStartCol(nOriginalRow, col);
                    int endCol = parser.getMergedEndCol(nOriginalRow, col);
                    if (startRow < row) {
                        this.mergeRegion(startRow, endRow + 1, startCol, endCol);
                    }
                    col = endCol;
                }
                ++col;
            }
            int iRow = nOriginalRow;
            while (iRow < rows) {
                int col2 = 1;
                while (col2 < cols) {
                    if (parser.isMergedFirstCell(iRow, col2)) {
                        int startRow = parser.getMergedStartRow(iRow, col2);
                        int endRow = parser.getMergedEndRow(iRow, col2);
                        int startCol = parser.getMergedStartCol(iRow, col2);
                        int endCol = parser.getMergedEndCol(iRow, col2);
                        this.mergeRegion(startRow + 1, endRow + 1, startCol, endCol);
                    }
                    ++col2;
                }
                ++iRow;
            }
        }
        if (row > 1) {
            col = 1;
            while (col < cols) {
                this.resetBorderProperty(row - 1, col, 4);
                ++col;
            }
        }
        if (row < rows - 1) {
            col = 1;
            while (col < cols) {
                this.resetBorderProperty(row + 1, col, 3);
                ++col;
            }
        }
        if (this.needAdjust) {
            int typeRow = row + 1;
            if (row == rows - 1) {
                typeRow = row - 1;
            }
            this.setPropertyValue(row, 0, 3103, this.getPropertyValue(typeRow, 0, 3103));
            this.insertRowRegulate(row);
        }
    }

    public void removeRow(int row) {
        int col;
        if (row < 1 || row > this.getRow() - 1) {
            this.removeRow(this.getRow() - 1);
            return;
        }
        this.removeRowRegulate(row);
        this.matrix.removeRow(row);
        int rows = this.getRow();
        int cols = this.getColumn();
        CellSetParser parser = new CellSetParser(this);
        if (row > 1) {
            col = 1;
            while (col < cols) {
                if (parser.isMerged(row - 1, col)) {
                    int startRow = parser.getMergedStartRow(row - 1, col);
                    int endRow = parser.getMergedEndRow(row - 1, col);
                    int startCol = parser.getMergedStartCol(row - 1, col);
                    int endCol = parser.getMergedEndCol(row - 1, col);
                    if (endRow >= row) {
                        this.mergeRegion(startRow, endRow - 1, startCol, endCol);
                    }
                    col = endCol;
                }
                ++col;
            }
        }
        if (row < rows) {
            int iRow = row;
            while (iRow < rows) {
                int col2 = 1;
                while (col2 < cols) {
                    if (parser.isMergedFirstCell(iRow, col2)) {
                        int startRow = parser.getMergedStartRow(iRow, col2);
                        int endRow = parser.getMergedEndRow(iRow, col2);
                        int startCol = parser.getMergedStartCol(iRow, col2);
                        int endCol = parser.getMergedEndCol(iRow, col2);
                        if (row == startRow) {
                            this.mergeRegion(startRow, endRow - 1, startCol, endCol);
                        } else {
                            this.mergeRegion(startRow - 1, endRow - 1, startCol, endCol);
                        }
                    }
                    ++col2;
                }
                ++iRow;
            }
        }
        if (row > 1) {
            col = 1;
            while (col < cols) {
                this.resetBorderProperty(row - 1, col, 4);
                ++col;
            }
        }
    }

    public void insertColumn(int column) {
        int row;
        if (this.matrix == null) {
            this.matrix = new Matrix();
        }
        if (column > this.getColumn() || column < 0) {
            this.insertColumn(this.getColumn());
            return;
        }
        this.matrix.insertColumn(column);
        CellSetParser parser = new CellSetParser(this);
        int rows = this.getRow();
        int cols = this.getColumn();
        int nOriginalCol = column - 1;
        if (column != cols - 1) {
            nOriginalCol = column + 1;
            row = 1;
            while (row < rows) {
                if (parser.isMerged(row, nOriginalCol)) {
                    int startRow = parser.getMergedStartRow(row, nOriginalCol);
                    int endRow = parser.getMergedEndRow(row, nOriginalCol);
                    int startCol = parser.getMergedStartCol(row, nOriginalCol);
                    int endCol = parser.getMergedEndCol(row, nOriginalCol);
                    if (startCol < column) {
                        this.mergeRegion(startRow, endRow, startCol, endCol + 1);
                    }
                    row = endRow;
                }
                ++row;
            }
            int col = nOriginalCol;
            while (col < cols) {
                int row2 = 1;
                while (row2 < rows) {
                    if (parser.isMergedFirstCell(row2, col)) {
                        int startRow = parser.getMergedStartRow(row2, col);
                        int endRow = parser.getMergedEndRow(row2, col);
                        int startCol = parser.getMergedStartCol(row2, col);
                        int endCol = parser.getMergedEndCol(row2, col);
                        this.mergeRegion(startRow, endRow, startCol + 1, endCol + 1);
                    }
                    ++row2;
                }
                ++col;
            }
        }
        if (column > 1) {
            row = 1;
            while (row < rows) {
                this.resetBorderProperty(row, column - 1, 2);
                ++row;
            }
        }
        if (column < cols - 1) {
            row = 1;
            while (row < rows) {
                this.resetBorderProperty(row, column + 1, 1);
                ++row;
            }
        }
        if (this.needAdjust) {
            int typeCol = column + 1;
            if (column == cols - 1) {
                typeCol = column - 1;
            }
            this.setPropertyValue(0, column, 2102, this.getPropertyValue(0, typeCol, 2102));
            this.insertColumnRegulate(column);
        }
    }

    public void removeColumn(int column) {
        int row;
        if (column < 1 || column > this.getColumn() - 1) {
            this.removeColumn(this.getColumn() - 1);
            return;
        }
        this.removeColumnRegulate(column);
        this.matrix.removeColumn(column);
        int rows = this.getRow();
        int cols = this.getColumn();
        CellSetParser parser = new CellSetParser(this);
        if (column > 1) {
            row = 1;
            while (row < rows) {
                if (parser.isMerged(row, column - 1)) {
                    int startRow = parser.getMergedStartRow(row, column - 1);
                    int endRow = parser.getMergedEndRow(row, column - 1);
                    int startCol = parser.getMergedStartCol(row, column - 1);
                    int endCol = parser.getMergedEndCol(row, column - 1);
                    if (endCol >= column) {
                        this.mergeRegion(startRow, endRow, startCol, endCol - 1);
                    }
                    row = endRow;
                }
                ++row;
            }
        }
        if (column < cols) {
            int col = column;
            while (col < cols) {
                int row2 = 1;
                while (row2 < rows) {
                    if (parser.isMergedFirstCell(row2, col)) {
                        int startRow = parser.getMergedStartRow(row2, col);
                        int endRow = parser.getMergedEndRow(row2, col);
                        int startCol = parser.getMergedStartCol(row2, col);
                        int endCol = parser.getMergedEndCol(row2, col);
                        if (col == startCol) {
                            this.mergeRegion(startRow, endRow, startCol, endCol - 1);
                        } else {
                            this.mergeRegion(startRow, endRow, startCol - 1, endCol - 1);
                        }
                    }
                    ++row2;
                }
                ++col;
            }
        }
        if (column > 1) {
            row = 1;
            while (row < rows) {
                this.resetBorderProperty(row, column - 1, 2);
                ++row;
            }
        }
    }

    private void insertRowRegulate(int nRow) {
        int nRowIncrement = 1;
        int nColumnIncrement = 0;
        this.relativeRegulate(nRow, -1, nRowIncrement, nColumnIncrement);
    }

    private void removeRowRegulate(int nRow) {
        int nRowIncrement = -1;
        int nColumnIncrement = 0;
        this.relativeRegulate(nRow, -1, nRowIncrement, nColumnIncrement);
    }

    private void insertColumnRegulate(int nColumn) {
        int nRowIncrement = 0;
        int nColumnIncrement = 1;
        this.relativeRegulate(-1, nColumn, nRowIncrement, nColumnIncrement);
    }

    private void removeColumnRegulate(int nColumn) {
        int nRowIncrement = 0;
        int nColumnIncrement = -1;
        this.relativeRegulate(-1, nColumn, nRowIncrement, nColumnIncrement);
    }

    private void relativeRegulate(int nRowBase, int nColumnBase, int nRowIncrement, int nColumnIncrement) {
        this.vectFreeze = null;
        int iRow = 0;
        while (iRow < this.matrix.getRow()) {
            int iColumn = 0;
            iColumn = 0;
            while (iColumn < this.matrix.getColumn()) {
                this.relativeRegulateCell(iRow, iColumn, nRowBase, nColumnBase, nRowIncrement, nColumnIncrement);
                ++iColumn;
            }
            ++iRow;
        }
    }

    private final boolean isValidExcelNotation(String s, int i, int j) {
        int k = i;
        int col = 0;
        while (k < j) {
            char ch = s.charAt(k);
            if (ch >= 'A' && ch <= 'Z') {
                col = col * 26 + ch - 65 + 1;
                ++k;
            } else {
                if (ch < 'a' || ch > 'z') break;
                col = col * 26 + ch - 97 + 1;
                ++k;
            }
            if (col < this.getColumn()) continue;
            return false;
        }
        if (k == i || k == j || col >= this.getColumn()) {
            return false;
        }
        int row = 0;
        while (k < j) {
            char ch = s.charAt(k);
            if (!Character.isDigit(ch)) break;
            if ((row = row * 10 + ch - 48) >= this.getRow()) {
                return false;
            }
            ++k;
        }
        return k == j && row < this.getRow();
    }

    private boolean isSymbol(char c) {
        return Character.isWhitespace(c) || c == '+' || c == '-' || c == '*' || c == '/' || c == '=' || c == '&' || c == '|' || c == '!' || c == ':' || c == '>' || c == '<' || c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}' || c == ',' || c == ';';
    }

    private int scanId(String expStr, int start) {
        int len = expStr.length();
        while (start < len) {
            char c = expStr.charAt(start);
            if (this.isSymbol(c)) break;
            ++start;
        }
        return start;
    }

    private void relativeRegulateCell(int nRow, int nColumn, int nRowBase, int nColumnBase, int nRowIncrement, int nColumnIncrement) {
        IntHashtable map = (IntHashtable)this.matrix.get(nRow, nColumn);
        if (map != null) {
            IntHashtable.Enumerator enumCell = map.keys();
            while (enumCell.hasMoreElements()) {
                String str;
                int nPropertyId;
                block26: {
                    nPropertyId = enumCell.nextElement();
                    if (nPropertyId == 4802 || nPropertyId == 4808 || nPropertyId == 4809) {
                        String exp = (String)this.getPropertyValue(nRow, nColumn, nPropertyId);
                        if (exp == null || exp.trim().length() == 0 || (exp = exp.trim()).startsWith("#REF!")) continue;
                        boolean bFreeze = false;
                        try {
                            int refRow = Integer.parseInt(exp);
                            if (nRowBase < 0) continue;
                            if (nRowBase < refRow) {
                                refRow += nRowIncrement;
                            } else if (nRowBase == refRow) {
                                if (nRowIncrement > 0) {
                                    refRow += nRowIncrement;
                                } else {
                                    bFreeze = true;
                                }
                            }
                            if (bFreeze) {
                                if (this.vectFreeze == null) {
                                    this.vectFreeze = new Vector();
                                }
                                this.vectFreeze.add(new RelativeFreeze(nRow, nColumn, nPropertyId));
                                this.resetRefExp(nRow, nColumn, nPropertyId, "#REF!" + exp);
                                continue;
                            }
                            this.resetRefExp(nRow, nColumn, nPropertyId, String.valueOf(refRow));
                            continue;
                        }
                        catch (Exception e) {
                            if (!this.isAllLetter(exp)) break block26;
                            if (nColumnBase < 0) continue;
                            this.setPropertyValue(nRow, nColumn, nPropertyId, String.valueOf(exp) + "0");
                        }
                    }
                }
                if ((str = this.getRefExp(nRow, nColumn, nPropertyId)) == null || str.trim().length() == 0 || str.startsWith("#REF!") || str.startsWith("#ERR!")) continue;
                StringBuffer strNew = null;
                int len = str.length();
                boolean bFreeze = false;
                int idx = 0;
                while (idx < len) {
                    int tmp;
                    char ch = str.charAt(idx);
                    if (ch == '\'' || ch == '\"') {
                        tmp = Sentence.scanQuotation(str, idx, '\\');
                        if (tmp < 0) {
                            this.resetRefExp(nRow, nColumn, nPropertyId, "#ERR!" + str);
                            bFreeze = true;
                            break;
                        }
                        if (strNew != null) {
                            strNew.append(str.substring(idx, tmp + 1));
                        }
                        idx = tmp + 1;
                        continue;
                    }
                    if (this.isSymbol(ch)) {
                        if (strNew != null) {
                            strNew.append(ch);
                        }
                        ++idx;
                        continue;
                    }
                    tmp = this.scanId(str, idx);
                    int pos = idx;
                    while (pos < tmp && str.charAt(pos) != '.') {
                        ++pos;
                    }
                    if (this.isValidExcelNotation(str, idx, pos)) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        if (!this.changeCellExpRef(str, idx, pos, nRowBase, nColumnBase, nColumnIncrement, nRowIncrement, strNew)) {
                            if (this.vectFreeze == null) {
                                this.vectFreeze = new Vector();
                            }
                            this.vectFreeze.add(new RelativeFreeze(nRow, nColumn, nPropertyId));
                            this.resetRefExp(nRow, nColumn, nPropertyId, "#REF!" + str);
                            bFreeze = true;
                            break;
                        }
                    } else if (strNew != null) {
                        strNew.append(str.substring(idx, pos));
                    }
                    if (pos < tmp && strNew != null) {
                        strNew.append(str.substring(pos, tmp));
                    }
                    idx = tmp;
                }
                if (bFreeze || strNew == null) continue;
                this.resetRefExp(nRow, nColumn, nPropertyId, strNew.toString());
            }
        }
    }

    private boolean changeCellExpRef(String strExpression, int nStart, int nEnd, int nRowBase, int nColumnBase, int nColumnIncrement, int nRowIncrement, StringBuffer strNewExpression) {
        String strRelative = strExpression.substring(nStart, nEnd);
        CellPosition cellPos = new CellPosition(strRelative);
        if (nColumnBase != -1) {
            if (nColumnIncrement == -1 && cellPos.getColumn() == nColumnBase) {
                return false;
            }
            if (cellPos.getColumn() >= nColumnBase) {
                cellPos.addColumn(nColumnIncrement);
            }
        }
        if (nRowBase != -1) {
            if (nRowIncrement == -1 && cellPos.getRow() == nRowBase) {
                return false;
            }
            if (cellPos.getRow() >= nRowBase) {
                cellPos.addRow(nRowIncrement);
            }
        }
        if (nRowBase == -1 && nColumnBase == -1) {
            cellPos.addCol(nColumnIncrement);
            cellPos.addRow(nRowIncrement);
        }
        if (cellPos.getRow() < this.getRow() && cellPos.getColumn() < this.getColumn()) {
            String strNewRelative = cellPos.toExcelNotation();
            strNewExpression.append(strNewRelative);
        } else {
            strNewExpression.append(strRelative);
        }
        return true;
    }

    public Vector getRelativeFreeze() {
        return this.vectFreeze;
    }

    public void relativeRelease(int nRow, int nColumn, int nPropertyId) {
        String strExpression = this.getRefExp(nRow, nColumn, nPropertyId);
        if (strExpression != null && strExpression.startsWith("#REF!")) {
            strExpression = strExpression.substring(5);
            this.resetRefExp(nRow, nColumn, nPropertyId, strExpression);
        }
    }

    public Object clone() {
        try {
            CellSet cellSetNew = (CellSet)super.clone();
            int nRow = this.matrix.getRow();
            int nColumn = this.matrix.getColumn();
            cellSetNew.matrix = new Matrix(nRow, nColumn);
            int iRow = 0;
            while (iRow < nRow) {
                int iColumn = 0;
                while (iColumn < nColumn) {
                    IntHashtable hashSource = this.getPropertyMap(iRow, iColumn);
                    if (hashSource != null) {
                        IntHashtable hashTarget = new IntHashtable();
                        IntHashtable.Enumerator enumerator = hashSource.keys();
                        while (enumerator.hasMoreElements()) {
                            int nKey = enumerator.nextElement();
                            CellProperty cellPropertySource = (CellProperty)hashSource.get(nKey);
                            CellProperty cellPropertyClone = (CellProperty)cellPropertySource.clone();
                            hashTarget.put(nKey, cellPropertyClone);
                        }
                        cellSetNew.setPropertyMap(iRow, iColumn, hashTarget);
                    }
                    ++iColumn;
                }
                ++iRow;
            }
            return cellSetNew;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void mergeRegion(int startRow, int endRow, int startCol, int endCol) {
        String mergeStr = String.valueOf(startRow) + "," + startCol + "-" + endRow + "," + endCol;
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                this.setPropertyValue(row, col, 4103, mergeStr);
                ++col;
            }
            ++row;
        }
    }

    private String getRefExp(int nRow, int nColumn, int nPropertyId) {
        if (this.isChangeValueKey(nPropertyId)) {
            return (String)this.getPropertyValue(nRow, nColumn, nPropertyId);
        }
        return this.getPropertyExpression(nRow, nColumn, nPropertyId);
    }

    private void resetRefExp(int nRow, int nColumn, int nPropertyId, String strNewExpression) {
        if (this.isChangeValueKey(nPropertyId)) {
            this.setPropertyValue(nRow, nColumn, nPropertyId, strNewExpression);
        } else {
            this.setPropertyExpression(nRow, nColumn, nPropertyId, strNewExpression);
        }
    }

    public void reCalcMergedExp() {
        CellSetParser csp = new CellSetParser(this);
        CellSetOperator cso = new CellSetOperator(this);
        int row = 1;
        while (row < csp.getRowCount()) {
            int col = 1;
            while (col < csp.getColCount()) {
                if (csp.isMergedFirstCell(row, col)) {
                    int colSpan = csp.getColSpan(row, col, true);
                    int rowSpan = csp.getRowSpan(row, col, true);
                    String newMerge = String.valueOf(row) + "," + col + "-" + (row + rowSpan - 1) + "," + (col + colSpan - 1);
                    int i = row;
                    while (i < row + rowSpan) {
                        int j = col;
                        while (j < col + colSpan) {
                            cso.setMergedExp(i, j, newMerge);
                            ++j;
                        }
                        ++i;
                    }
                }
                ++col;
            }
            ++row;
        }
    }

    public IntHashtable clonePropertyMap(int row, int col) {
        IntHashtable props = this.getPropertyMap(row, col);
        IntHashtable newProps = null;
        if (props != null) {
            newProps = new IntHashtable();
            IntHashtable.Enumerator em = props.keys();
            while (em.hasMoreElements()) {
                int key = em.nextElement();
                CellProperty cp = (CellProperty)props.get(key);
                if (cp == null) continue;
                CellProperty prop = new CellProperty();
                prop.setPropertyValue(cp.getPropertyValue());
                prop.setPropertyExpression(cp.getPropertyExpression());
                newProps.put(key, prop);
            }
        }
        return newProps;
    }

    public static IntHashtable createDefaultPropertyMap() {
        return null;
    }

    private void resetBorderProperty(int row, int col, int location) {
        switch (location) {
            case 1: {
                int key = 4401;
                Object value = this.getPropertyValue(row, col, key);
                this.setPropertyValue(row, col, key, value);
                key = 4402;
                value = this.getPropertyValue(row, col, key);
                this.setPropertyValue(row, col, key, value);
                key = 4403;
                value = this.getPropertyValue(row, col, key);
                this.setPropertyValue(row, col, key, value);
                break;
            }
            case 2: {
                int key = 4404;
                Object value = this.getPropertyValue(row, col, key);
                this.setPropertyValue(row, col, key, value);
                key = 4405;
                value = this.getPropertyValue(row, col, key);
                this.setPropertyValue(row, col, key, value);
                key = 4406;
                value = this.getPropertyValue(row, col, key);
                this.setPropertyValue(row, col, key, value);
                break;
            }
            case 3: {
                int key = 4407;
                Object value = this.getPropertyValue(row, col, key);
                this.setPropertyValue(row, col, key, value);
                key = 4408;
                value = this.getPropertyValue(row, col, key);
                this.setPropertyValue(row, col, key, value);
                key = 4409;
                value = this.getPropertyValue(row, col, key);
                this.setPropertyValue(row, col, key, value);
                break;
            }
            case 4: {
                int key = 4410;
                Object value = this.getPropertyValue(row, col, key);
                this.setPropertyValue(row, col, key, value);
                key = 4411;
                value = this.getPropertyValue(row, col, key);
                this.setPropertyValue(row, col, key, value);
                key = 4412;
                value = this.getPropertyValue(row, col, key);
                this.setPropertyValue(row, col, key, value);
            }
        }
    }

    private boolean isChangeValueKey(int propertyId) {
        int i = 0;
        while (i < changeValueKeys.length) {
            if (propertyId == changeValueKeys[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isAllLetter(String s) {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (!Character.isLetter(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isNewInputVersion() {
        Boolean bool = (Boolean)this.getPropertyValue(0, 0, 1216);
        if (bool == null) {
            return false;
        }
        return bool;
    }
}

