/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.cellset;

import com.runqian.base.util.IntHashtable;
import com.runqian.base.util.Matrix;
import com.runqian.report.cellset.CellProperty;
import com.runqian.report.cellset.CellPropertyDefine;

class CellSet1 {
    protected Matrix matrix = null;

    CellSet1() {
    }

    public int getRow() {
        return this.matrix.getRow();
    }

    public int getColumn() {
        return this.matrix.getColumn();
    }

    public Object getPropertyValue(int row, int column, int nPropertyId) {
        return this.getPropertyValue(row, column, nPropertyId, false);
    }

    public Object getPropertyValue(int row, int column, int nPropertyId, boolean forEditorDisplay) {
        CellProperty cellProperty;
        Object value = null;
        IntHashtable map = (IntHashtable)this.matrix.get(row, column);
        if (map != null && (cellProperty = (CellProperty)map.get(nPropertyId)) != null) {
            value = cellProperty.getPropertyValue();
        }
        if (value == null) {
            value = this.getDefaultPropertyValue(row, column, nPropertyId);
        }
        if (!(forEditorDisplay || value == null || nPropertyId != 2101 && nPropertyId != 3101)) {
            value = new Integer(((Number)value).intValue());
        }
        return value;
    }

    private Object getDefaultPropertyValue(int row, int column, int nPropertyId) {
        switch (nPropertyId) {
            case 1101: {
                return CellPropertyDefine.CRT_GRID;
            }
            case 4201: {
                return CellPropertyDefine.CA_LEFT;
            }
            case 1201: {
                return CellPropertyDefine.CPS_A4;
            }
            case 1202: {
                return CellPropertyDefine.CPO_PORTRAIT;
            }
            case 1205: 
            case 1206: 
            case 1207: 
            case 1208: {
                return new Integer(19);
            }
            case 1109: 
            case 1218: 
            case 2103: 
            case 3102: 
            case 3104: 
            case 4107: 
            case 4108: 
            case 4111: 
            case 4304: 
            case 4305: 
            case 4306: {
                return Boolean.FALSE;
            }
            case 4413: {
                return CellPropertyDefine.COLOR_WHITE;
            }
            case 4303: 
            case 4403: 
            case 4406: 
            case 4409: 
            case 4412: 
            case 4415: {
                return CellPropertyDefine.COLOR_BLACK;
            }
            case 4401: 
            case 4404: 
            case 4407: 
            case 4410: {
                return CellPropertyDefine.CBS_NONE;
            }
            case 4402: 
            case 4405: 
            case 4408: 
            case 4411: {
                return CellPropertyDefine.DEFAULT_BORDER_WIDTH;
            }
            case 4101: {
                return CellPropertyDefine.CDT_TEXT;
            }
            case 4501: {
                return CellPropertyDefine.CEX_DEFAULT;
            }
            case 4203: {
                return CellPropertyDefine.DEFAULT_INDENT;
            }
            case 3103: {
                return CellPropertyDefine.CRT_NORMAL;
            }
            case 2102: {
                return CellPropertyDefine.CCT_NORMAL;
            }
            case 4301: {
                return "\u5b8b\u4f53";
            }
            case 4302: {
                return CellPropertyDefine.DEFAULT_FONT_SIZE;
            }
            case 4202: {
                return CellPropertyDefine.CVA_MIDDLE;
            }
            case 4414: {
                return CellPropertyDefine.CLL_NONE;
            }
            case 4106: 
            case 4601: 
            case 4602: 
            case 4804: {
                return Boolean.TRUE;
            }
            case 1209: {
                return CellPropertyDefine.CSU_PIXEL;
            }
            case 1210: {
                return CellPropertyDefine.CPS_PAPER;
            }
            case 1211: {
                return new Integer(10);
            }
            case 1212: {
                return new Integer(1);
            }
            case 1213: {
                return new Integer(1);
            }
            case 1214: {
                return CellPropertyDefine.CPLI_ROW;
            }
            case 1215: {
                return CellPropertyDefine.CHS_ALL;
            }
            case 1217: {
                return CellPropertyDefine.SP_NONE;
            }
            case 4109: {
                return CellPropertyDefine.CAS_SHRINK;
            }
            case 4805: {
                return CellPropertyDefine.CES_EDITBOX;
            }
            case 4810: {
                return CellPropertyDefine.CIDT_TEXT;
            }
            case 2101: {
                if (row != 0) break;
                return CellPropertyDefine.DEFAULT_COL_WIDTH;
            }
            case 3101: {
                if (column != 0) break;
                return CellPropertyDefine.DEFAULT_ROW_HEIGHT;
            }
        }
        return null;
    }

    public String getPropertyExpression(int nRow, int nColumn, int nPropertyId) {
        IntHashtable map = (IntHashtable)this.matrix.get(nRow, nColumn);
        if (map == null) {
            return null;
        }
        CellProperty cellProperty = (CellProperty)map.get(nPropertyId);
        if (cellProperty == null) {
            return null;
        }
        return cellProperty.getPropertyExpression();
    }

    public Object setPropertyValue(int row, int column, int nPropertyId, Object value) {
        return this.setPropertyValue(row, column, nPropertyId, value, true);
    }

    public Object setPropertyValue(int row, int column, int nPropertyId, Object value, boolean setRelatedBorder) {
        if (row >= this.getRow()) {
            this.matrix.setSize(row + 1, this.getColumn());
        }
        if (column >= this.getColumn()) {
            this.matrix.setSize(this.getRow(), column + 1);
        }
        if (setRelatedBorder) {
            RelatedCellProperty rcp = this.getRelatedBorderPropId(row, column, nPropertyId);
            this.setRelatedBorderProp(rcp, value);
        }
        if (value == null || value instanceof String && value.toString().trim().length() == 0) {
            return this.cleanPropertyValue(row, column, nPropertyId);
        }
        this.getProperty(row, column, nPropertyId).setPropertyExpression(null);
        if (row == 0 && column > 0) {
            int i = 1;
            while (i < this.getRow()) {
                this.cleanPropertyValue(i, column, nPropertyId);
                ++i;
            }
            return this.getProperty(row, column, nPropertyId).setPropertyValue(value);
        }
        if (row > 0 && column > 0) {
            int mm;
            String s;
            Object value0 = this.getPropertyValue(0, column, nPropertyId);
            boolean equal = false;
            if (value0 != null) {
                if (value instanceof String) {
                    equal = value.toString().equals(value0.toString());
                } else if (value instanceof Integer) {
                    equal = ((Integer)value).intValue() == ((Integer)value0).intValue();
                } else if (value instanceof Float) {
                    equal = ((Float)value).floatValue() == ((Float)value0).floatValue();
                } else if (value instanceof Boolean) {
                    boolean bl = equal = ((Boolean)value).booleanValue() == ((Boolean)value0).booleanValue();
                }
            }
            if (equal) {
                return this.cleanPropertyValue(row, column, nPropertyId);
            }
            if (nPropertyId == 4103 && (s = value.toString()).substring(0, mm = s.indexOf("-")).equals(s.substring(mm + 1))) {
                value = null;
            }
            return this.getProperty(row, column, nPropertyId).setPropertyValue(value);
        }
        return this.getProperty(row, column, nPropertyId).setPropertyValue(value);
    }

    private void setRelatedBorderProp(RelatedCellProperty rcp, Object value) {
        if (rcp == null) {
            return;
        }
        int row = rcp.row;
        int column = rcp.col;
        this.setPropertyValue(row, column, rcp.propertyId, value, false);
    }

    private Object cleanPropertyValue(int row, int column, int nPropertyId) {
        Object rtn = this.getProperty(row, column, nPropertyId).getPropertyValue();
        this.removeProperty(row, column, nPropertyId);
        return rtn;
    }

    public String setPropertyExpression(int row, int column, int nPropertyId, String strNewExpression) {
        RelatedCellProperty rcp = this.getRelatedBorderPropId(row, column, nPropertyId);
        this.setPropertyExpression(rcp, strNewExpression);
        if (strNewExpression != null && strNewExpression.trim().length() > 0) {
            if (nPropertyId != 2101 && nPropertyId != 3101) {
                this.getProperty(row, column, nPropertyId).setPropertyValue(null);
            }
        } else {
            strNewExpression = null;
        }
        return this.getProperty(row, column, nPropertyId).setPropertyExpression(strNewExpression);
    }

    private void setPropertyExpression(RelatedCellProperty rcp, String exp) {
        if (rcp == null) {
            return;
        }
        int row = rcp.row;
        int column = rcp.col;
        this.getProperty(row, column, rcp.propertyId).setPropertyExpression(exp);
    }

    protected CellProperty getProperty(int row, int column, int nPropertyId) {
        CellProperty cellProperty;
        IntHashtable map = (IntHashtable)this.matrix.get(row, column);
        if (map == null) {
            map = new IntHashtable(15, 0.9f);
            this.matrix.set(row, column, map);
        }
        if ((cellProperty = (CellProperty)map.get(nPropertyId)) == null) {
            cellProperty = new CellProperty();
            map.put(nPropertyId, cellProperty);
        }
        return cellProperty;
    }

    public Object removeProperty(int row, int column, int nPropertyId) {
        IntHashtable map = (IntHashtable)this.matrix.get(row, column);
        if (map == null) {
            return null;
        }
        return map.remove(nPropertyId);
    }

    public IntHashtable removePropertyMap(int nRow, int nColumn) {
        return this.setPropertyMap(nRow, nColumn, null);
    }

    public IntHashtable getPropertyMap(int nRow, int nColumn) {
        IntHashtable map = (IntHashtable)this.matrix.get(nRow, nColumn);
        return map;
    }

    public IntHashtable setPropertyMap(int nRow, int nColumn, IntHashtable mapProperty) {
        if (nRow >= this.getRow()) {
            this.matrix.setSize(nRow + 1, this.getColumn());
        }
        if (nColumn >= this.getColumn()) {
            this.matrix.setSize(this.getRow(), nColumn + 1);
        }
        IntHashtable mapOld = (IntHashtable)this.matrix.set(nRow, nColumn, mapProperty);
        this.setRelatedBorderProperty(nRow, nColumn, 4401);
        this.setRelatedBorderProperty(nRow, nColumn, 4402);
        this.setRelatedBorderProperty(nRow, nColumn, 4403);
        this.setRelatedBorderProperty(nRow, nColumn, 4404);
        this.setRelatedBorderProperty(nRow, nColumn, 4405);
        this.setRelatedBorderProperty(nRow, nColumn, 4406);
        this.setRelatedBorderProperty(nRow, nColumn, 4407);
        this.setRelatedBorderProperty(nRow, nColumn, 4408);
        this.setRelatedBorderProperty(nRow, nColumn, 4409);
        this.setRelatedBorderProperty(nRow, nColumn, 4410);
        this.setRelatedBorderProperty(nRow, nColumn, 4411);
        this.setRelatedBorderProperty(nRow, nColumn, 4412);
        return mapOld;
    }

    private void setRelatedBorderProperty(int nRow, int nColumn, int propId) {
        RelatedCellProperty rcp = this.getRelatedBorderPropId(nRow, nColumn, propId);
        String exp = this.getPropertyExpression(nRow, nColumn, propId);
        if (exp != null && exp.trim().length() > 0) {
            this.setPropertyExpression(rcp, exp);
        } else {
            Object value = this.getPropertyValue(nRow, nColumn, propId);
            this.setRelatedBorderProp(rcp, value);
        }
    }

    public IntHashtable duplicateCell(int nRowSource, int nColumnSource, int nRowTarget, int nColumnTarget) {
        IntHashtable mapOld = (IntHashtable)this.matrix.get(nRowTarget, nColumnTarget);
        IntHashtable mapSource = (IntHashtable)this.matrix.get(nRowSource, nColumnSource);
        if (mapSource != null) {
            IntHashtable mapNew = (IntHashtable)mapSource.clone();
            this.matrix.set(nRowTarget, nColumnTarget, mapNew);
        } else {
            this.matrix.set(nRowTarget, nColumnTarget, null);
        }
        return mapOld;
    }

    protected RelatedCellProperty getRelatedBorderPropId(int row, int col, int propId) {
        switch (propId) {
            case 4401: {
                return col > 1 ? new RelatedCellProperty(row, col - 1, 4404) : null;
            }
            case 4402: {
                return col > 1 ? new RelatedCellProperty(row, col - 1, 4405) : null;
            }
            case 4403: {
                return col > 1 ? new RelatedCellProperty(row, col - 1, 4406) : null;
            }
            case 4404: {
                return col < this.getColumn() - 1 ? new RelatedCellProperty(row, col + 1, 4401) : null;
            }
            case 4405: {
                return col < this.getColumn() - 1 ? new RelatedCellProperty(row, col + 1, 4402) : null;
            }
            case 4406: {
                return col < this.getColumn() - 1 ? new RelatedCellProperty(row, col + 1, 4403) : null;
            }
            case 4407: {
                return row > 1 ? new RelatedCellProperty(row - 1, col, 4410) : null;
            }
            case 4408: {
                return row > 1 ? new RelatedCellProperty(row - 1, col, 4411) : null;
            }
            case 4409: {
                return row > 1 ? new RelatedCellProperty(row - 1, col, 4412) : null;
            }
            case 4410: {
                return row < this.getRow() - 1 ? new RelatedCellProperty(row + 1, col, 4407) : null;
            }
            case 4411: {
                return row < this.getRow() - 1 ? new RelatedCellProperty(row + 1, col, 4408) : null;
            }
            case 4412: {
                return row < this.getRow() - 1 ? new RelatedCellProperty(row + 1, col, 4409) : null;
            }
        }
        return null;
    }

    public boolean isMerge(int row, int column) {
        int key = 4103;
        Object merge = this.getPropertyValue(row, column, key);
        return merge != null && merge.toString().trim().length() > 0;
    }

    public int getMergeRow1(String value) {
        int pos = value.indexOf(44, 0);
        return Integer.parseInt(value.substring(0, pos));
    }

    public int getMergeColumn1(String value) {
        int pos1 = value.indexOf(44, 0) + 1;
        int pos2 = value.indexOf(45, pos1);
        return Integer.parseInt(value.substring(pos1, pos2));
    }

    public int getMergeRow2(String value) {
        int pos1 = value.indexOf(45, 0) + 1;
        int pos2 = value.indexOf(44, pos1);
        return Integer.parseInt(value.substring(pos1, pos2));
    }

    public int getMergeColumn2(String value) {
        int pos = value.lastIndexOf(44) + 1;
        return Integer.parseInt(value.substring(pos));
    }

    public boolean isBorderProperty(int propertyId) {
        switch (propertyId) {
            case 4401: 
            case 4402: 
            case 4403: 
            case 4404: 
            case 4405: 
            case 4406: 
            case 4407: 
            case 4408: 
            case 4409: 
            case 4410: 
            case 4411: 
            case 4412: {
                return true;
            }
        }
        return false;
    }

    protected class RelatedCellProperty {
        public int row;
        public int col;
        public int propertyId;

        public RelatedCellProperty(int row, int col, int propId) {
            this.row = row;
            this.col = col;
            this.propertyId = propId;
        }
    }
}

