/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.cellset;

import com.runqian.base.util.IntHashtable;
import com.runqian.report.cellset.CellProperty;
import com.runqian.report.cellset.CellSet;

public class CellSetOperator {
    private CellSet cellset;

    public CellSetOperator(CellSet cellset) {
        this.cellset = cellset;
    }

    public void copyCellTo(int srcRow, int srcCol, CellSet target, int targetRow, int targetCol) {
        if (target.getColumn() <= targetCol) {
            int col = target.getColumn();
            while (col <= targetCol) {
                target.insertColumn(col);
                ++col;
            }
        }
        if (target.getRow() <= targetRow) {
            int row = target.getRow();
            while (row <= targetRow) {
                target.insertRow(row);
                ++row;
            }
        }
        IntHashtable props = this.cellset.getPropertyMap(srcRow, srcCol);
        IntHashtable newProps = null;
        if (props != null && props.size() > 0) {
            newProps = new IntHashtable(props.size());
            IntHashtable.Enumerator em = props.keys();
            while (em.hasMoreElements()) {
                int key = em.nextElement();
                CellProperty cp = (CellProperty)props.get(key);
                if (cp == null) continue;
                CellProperty prop = new CellProperty();
                prop.setPropertyValue(cp.getPropertyValue());
                prop.setPropertyExpression(cp.getPropertyExpression());
                newProps.put(key, prop);
            }
        }
        target.setPropertyMap(targetRow, targetCol, newProps);
    }

    public void copyRowTo(int srcRow, CellSet target, int targetRow) {
        int col = 0;
        while (col < this.cellset.getColumn()) {
            this.copyCellTo(srcRow, col, target, targetRow, col);
            ++col;
        }
    }

    public void copyColumnTo(int srcCol, CellSet target, int targetCol) {
        int row = 0;
        while (row < this.cellset.getRow()) {
            this.copyCellTo(row, srcCol, target, row, targetCol);
            ++row;
        }
    }

    public void setMergedExp(int row, int col, String exp) {
        this.cellset.setPropertyValue(row, col, 4103, exp);
    }

    public void setPropertyValue(int row, int col, int key, Object value) {
        this.cellset.setPropertyValue(row, col, key, value);
    }
}

