/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.cellset;

import com.runqian.base.util.IntHashtable;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.Field;
import java.awt.print.PageFormat;
import java.awt.print.Paper;

public class CellSetParser {
    private CellSet cellset;

    public CellSetParser(CellSet cellset) {
        this.cellset = cellset;
    }

    public int getRowCount() {
        return this.cellset.getRow();
    }

    public int getColCount() {
        return this.cellset.getColumn();
    }

    public int getRowHeight(int row) {
        return this.getRowHeight(row, 1.0f);
    }

    public int getRowHeight(int row, float scale) {
        Object obj = this.cellset.getPropertyValue(row, 0, 3101);
        if (obj == null) {
            return 0;
        }
        int h = (int)Math.ceil(((Number)obj).floatValue() * scale);
        if ((double)scale != 1.0) {
            ++h;
        }
        return h;
    }

    public int getColWidth(int col) {
        return this.getColWidth(col, 1.0f);
    }

    public int getColWidth(int col, float scale) {
        Object obj = this.cellset.getPropertyValue(0, col, 2101);
        if (obj == null) {
            return 0;
        }
        int w = (int)Math.ceil(((Number)obj).floatValue() * scale);
        if ((double)scale != 1.0) {
            w += 2;
        }
        return w;
    }

    public boolean isMerged(int row, int col) {
        return this.cellset.isMerge(row, col);
    }

    public String getMergedExp(int row, int col) {
        Object obj = null;
        try {
            obj = this.cellset.getPropertyValue(row, col, 4103);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public boolean isMergedFirstCell(int row, int col) {
        String leftMerge;
        if (!this.isMerged(row, col)) {
            return false;
        }
        String selfMerge = this.getMergedExp(row, col);
        if (selfMerge.equalsIgnoreCase(leftMerge = this.getMergedExp(row, col - 1)) && this.getMergedEndCol(row, col - 1) != col - 1) {
            return false;
        }
        String topMerge = this.getMergedExp(row - 1, col);
        return !selfMerge.equalsIgnoreCase(topMerge) || this.getMergedEndRow(row - 1, col) == row - 1;
    }

    public boolean isMergedLeftCell(int row, int col) {
        String leftMerge;
        if (!this.isMerged(row, col)) {
            return false;
        }
        String selfMerge = this.getMergedExp(row, col);
        return !selfMerge.equalsIgnoreCase(leftMerge = this.getMergedExp(row, col - 1));
    }

    public boolean isMergedTopCell(int row, int col) {
        String topMerge;
        if (!this.isMerged(row, col)) {
            return false;
        }
        String selfMerge = this.getMergedExp(row, col);
        return !selfMerge.equalsIgnoreCase(topMerge = this.getMergedExp(row - 1, col));
    }

    public boolean isMergedRightCell(int row, int col) {
        String rightMerge;
        if (!this.isMerged(row, col)) {
            return false;
        }
        String selfMerge = this.getMergedExp(row, col);
        return !selfMerge.equalsIgnoreCase(rightMerge = this.getMergedExp(row, col + 1));
    }

    public boolean isMergedBottomCell(int row, int col) {
        String bottomMerge;
        if (!this.isMerged(row, col)) {
            return false;
        }
        String selfMerge = this.getMergedExp(row, col);
        return !selfMerge.equalsIgnoreCase(bottomMerge = this.getMergedExp(row + 1, col));
    }

    public int getMergedStartRow(int row, int col) {
        String mergeExp = this.cellset.getPropertyValue(row, col, 4103).toString();
        return this.cellset.getMergeRow1(mergeExp);
    }

    public int getMergedEndRow(int row, int col) {
        String mergeExp = this.cellset.getPropertyValue(row, col, 4103).toString();
        return this.cellset.getMergeRow2(mergeExp);
    }

    public int getMergedStartCol(int row, int col) {
        String mergeExp = this.cellset.getPropertyValue(row, col, 4103).toString();
        return this.cellset.getMergeColumn1(mergeExp);
    }

    public int getMergedEndCol(int row, int col) {
        String mergeExp = this.cellset.getPropertyValue(row, col, 4103).toString();
        return this.cellset.getMergeColumn2(mergeExp);
    }

    public int getColSpan(int row, int col, boolean includeHideCol) {
        if (!this.isMerged(row, col)) {
            return 1;
        }
        int startCol = this.getMergedStartCol(row, col);
        int endCol = this.getMergedEndCol(row, col);
        int colspan = endCol - startCol + 1;
        if (includeHideCol) {
            return colspan;
        }
        int i = startCol;
        while (i <= endCol) {
            if (!this.isColVisible(i)) {
                --colspan;
            }
            ++i;
        }
        return colspan;
    }

    public int getRowSpan(int row, int col, boolean includeHideRow) {
        if (!this.isMerged(row, col)) {
            return 1;
        }
        int startRow = this.getMergedStartRow(row, col);
        int endRow = this.getMergedEndRow(row, col);
        int rowspan = endRow - startRow + 1;
        if (includeHideRow) {
            return rowspan;
        }
        int i = startRow;
        while (i <= endRow) {
            if (!this.isRowVisible(i)) {
                --rowspan;
            }
            ++i;
        }
        return rowspan;
    }

    public int getMergedWidth(int row, int col, boolean includeHideCol) {
        return this.getMergedWidth(row, col, includeHideCol, 1.0f);
    }

    public int getMergedWidth(int row, int col, boolean includeHideCol, float scale) {
        int width = 0;
        int colspan = this.getColSpan(row, col, true);
        int i = col;
        while (i < col + colspan) {
            int w = this.getColWidth(i, scale);
            if (includeHideCol) {
                width += w;
            } else if (this.isColVisible(i)) {
                width += w;
            }
            ++i;
        }
        return width;
    }

    public int getMergedHeight(int row, int col, boolean includeHideRow) {
        return this.getMergedHeight(row, col, includeHideRow, 1.0f);
    }

    public int getMergedHeight(int row, int col, boolean includeHideRow, float scale) {
        int height = 0;
        int rowspan = this.getRowSpan(row, col, true);
        int i = row;
        while (i < row + rowspan) {
            int h = this.getRowHeight(i, scale);
            if (includeHideRow) {
                height += h;
            } else if (this.isRowVisible(i)) {
                height += h;
            }
            ++i;
        }
        return height;
    }

    private Field getRowField(int fieldType) {
        Field field = new Field();
        boolean startRowFound = false;
        int startRow = -1;
        int endRow = -2;
        int row = 1;
        while (row < this.cellset.getRow()) {
            Integer rowType = (Integer)this.cellset.getPropertyValue(row, 0, 3103);
            if (rowType != null && rowType == fieldType) {
                if (!startRowFound) {
                    startRow = row;
                    startRowFound = true;
                }
                endRow = row;
            } else if (startRowFound) break;
            ++row;
        }
        if (!startRowFound) {
            return null;
        }
        field.setStartRow(startRow);
        field.setEndRow(endRow);
        field.setStartColumn(1);
        field.setEndColumn(this.cellset.getColumn() - 1);
        return field;
    }

    public Field getTitleField() {
        return this.getRowField(CellPropertyDefine.CRT_TITLE);
    }

    public Field getTopHeader() {
        return this.getRowField(CellPropertyDefine.CRT_TABLE_HEADER);
    }

    public Field getFooterField() {
        return this.getRowField(CellPropertyDefine.CRT_TABLE_FOOTER);
    }

    public Field getPageHeader() {
        return this.getRowField(CellPropertyDefine.CRT_PAGE_HEADER);
    }

    public Field getPageFooter() {
        return this.getRowField(CellPropertyDefine.CRT_PAGE_FOOTER);
    }

    public Field getLeftHeader() {
        Field field = new Field();
        boolean startColFound = false;
        int startCol = -1;
        int endCol = -2;
        int startRow = -1;
        int endRow = -2;
        int col = 1;
        while (col < this.cellset.getColumn()) {
            Integer colType = (Integer)this.cellset.getPropertyValue(0, col, 2102);
            if (colType != null && colType.intValue() == CellPropertyDefine.CCT_TABLE_HEADER.intValue()) {
                if (!startColFound) {
                    startCol = col;
                    startColFound = true;
                }
                endCol = col;
            } else if (startColFound) break;
            ++col;
        }
        if (!startColFound) {
            return null;
        }
        Field tmpField = this.getTopHeader();
        if (tmpField == null) {
            tmpField = this.getTitleField();
        }
        startRow = tmpField == null ? 1 : tmpField.getEndRow() + 1;
        field.setStartRow(startRow);
        field.setEndRow(this.cellset.getRow() - 1);
        field.setStartColumn(startCol);
        field.setEndColumn(endCol);
        return field;
    }

    public Field getDataField() {
        Field tmpField = this.getTopHeader();
        if (tmpField == null) {
            tmpField = this.getTitleField();
        }
        int startRow = tmpField == null ? 1 : tmpField.getEndRow() + 1;
        tmpField = this.getFooterField();
        int endRow = tmpField == null ? ((tmpField = this.getPageFooter()) == null ? this.cellset.getRow() - 1 : tmpField.getStartRow() - 1) : tmpField.getStartRow() - 1;
        Field field = new Field();
        field.setStartRow(startRow);
        field.setEndRow(endRow);
        field.setStartColumn(1);
        field.setEndColumn(this.cellset.getColumn() - 1);
        return field;
    }

    public Object getPropertyValue(int row, int col, int key) {
        return this.cellset.getPropertyValue(row, col, key);
    }

    public IntHashtable getPropertyMap(int row, int col) {
        return this.cellset.getPropertyMap(row, col);
    }

    public int getCellSetWidth() {
        int width = 0;
        int col = 1;
        while (col < this.getColCount()) {
            if (this.isColVisible(col)) {
                width += this.getColWidth(col);
            }
            ++col;
        }
        return width;
    }

    public int getCellSetHeight() {
        int height = 0;
        int row = 1;
        while (row < this.getRowCount()) {
            if (this.isRowVisible(row)) {
                height += this.getRowHeight(row);
            }
            ++row;
        }
        return height;
    }

    public int getCellSetEditWidth() {
        int width = 0;
        int col = 1;
        while (col < this.getColCount()) {
            width += this.getColWidth(col);
            ++col;
        }
        return width;
    }

    public int getCellSetEditHeight() {
        int height = 0;
        int row = 1;
        while (row < this.getRowCount()) {
            height += this.getRowHeight(row);
            ++row;
        }
        return height;
    }

    public boolean isCellVisible(int row, int col) {
        Boolean visible = (Boolean)this.cellset.getPropertyValue(row, col, 4106);
        if (visible == null) {
            return true;
        }
        return visible;
    }

    public boolean isRowVisible(int row) {
        return this.isCellVisible(row, 0);
    }

    public boolean isColVisible(int col) {
        return this.isCellVisible(0, col);
    }

    public int getFieldScanHeight(Field field) {
        int startRow = field.getStartRow();
        int endRow = field.getEndRow();
        int height = 0;
        int i = startRow;
        while (i <= endRow) {
            if (this.isRowVisible(i)) {
                height += this.getRowHeight(i);
            }
            ++i;
        }
        return height;
    }

    public int getColumns() {
        Object propObj = this.cellset.getPropertyValue(0, 0, 1106);
        if (propObj != null) {
            int columns = ((Number)propObj).intValue();
            return columns < 1 ? 1 : columns;
        }
        return 1;
    }

    public PageFormat getPageFormat() {
        Object propObj = this.cellset.getPropertyValue(0, 0, 1201);
        int pageSize = CellPropertyDefine.CPS_A4;
        if (propObj != null) {
            pageSize = ((Number)propObj).intValue();
        }
        int pageWidth = 210;
        int pageHeight = 297;
        if (pageSize == CellPropertyDefine.CPS_A0) {
            pageWidth = 841;
            pageHeight = 1189;
        } else if (pageSize == CellPropertyDefine.CPS_A1) {
            pageWidth = 594;
            pageHeight = 841;
        } else if (pageSize == CellPropertyDefine.CPS_A2) {
            pageWidth = 420;
            pageHeight = 594;
        } else if (pageSize == CellPropertyDefine.CPS_A3) {
            pageWidth = 297;
            pageHeight = 420;
        } else if (pageSize == CellPropertyDefine.CPS_A4) {
            pageWidth = 210;
            pageHeight = 297;
        } else if (pageSize == CellPropertyDefine.CPS_A5) {
            pageWidth = 148;
            pageHeight = 210;
        } else if (pageSize == CellPropertyDefine.CPS_B0) {
            pageWidth = 1000;
            pageHeight = 1414;
        } else if (pageSize == CellPropertyDefine.CPS_B1) {
            pageWidth = 707;
            pageHeight = 1000;
        } else if (pageSize == CellPropertyDefine.CPS_B2) {
            pageWidth = 500;
            pageHeight = 707;
        } else if (pageSize == CellPropertyDefine.CPS_B3) {
            pageWidth = 353;
            pageHeight = 500;
        } else if (pageSize == CellPropertyDefine.CPS_B4) {
            pageWidth = 250;
            pageHeight = 353;
        } else if (pageSize == CellPropertyDefine.CPS_B5) {
            pageWidth = 176;
            pageHeight = 250;
        } else if (pageSize == CellPropertyDefine.CPS_USERDEFINED) {
            propObj = this.cellset.getPropertyValue(0, 0, 1203);
            if (propObj != null) {
                pageWidth = ((Number)propObj).intValue();
            }
            if ((propObj = this.cellset.getPropertyValue(0, 0, 1204)) != null) {
                pageHeight = ((Number)propObj).intValue();
            }
        }
        int orientation = 1;
        propObj = this.cellset.getPropertyValue(0, 0, 1202);
        if (propObj != null && ((Number)propObj).intValue() == CellPropertyDefine.CPO_LANDSCAPE.intValue()) {
            orientation = 0;
        }
        double paperWidth = (double)(pageWidth * 72) / 25.4;
        double paperHeight = (double)(pageHeight * 72) / 25.4;
        int leftMargin = 25;
        int rightMargin = 25;
        int topMargin = 25;
        int bottomMargin = 25;
        propObj = this.cellset.getPropertyValue(0, 0, 1205);
        if (propObj != null) {
            leftMargin = ((Number)propObj).intValue();
        }
        if ((propObj = this.cellset.getPropertyValue(0, 0, 1206)) != null) {
            rightMargin = ((Number)propObj).intValue();
        }
        if ((propObj = this.cellset.getPropertyValue(0, 0, 1207)) != null) {
            topMargin = ((Number)propObj).intValue();
        }
        if ((propObj = this.cellset.getPropertyValue(0, 0, 1208)) != null) {
            bottomMargin = ((Number)propObj).intValue();
        }
        double x = (double)(leftMargin * 72) / 25.4;
        double y = (double)(topMargin * 72) / 25.4;
        double width = (double)((pageWidth - leftMargin - rightMargin) * 72) / 25.4;
        double height = (double)((pageHeight - topMargin - bottomMargin) * 72) / 25.4;
        Paper paper = new Paper();
        paper.setSize(paperWidth, paperHeight);
        paper.setImageableArea(x, y, width, height);
        PageFormat pf = new PageFormat();
        pf.setOrientation(orientation);
        pf.setPaper(paper);
        return pf;
    }

    public String getPropertyExpression(int row, int col, int propertyId) {
        return this.cellset.getPropertyExpression(row, col, propertyId);
    }

    public int getLayoutRows() {
        int rows = 1;
        Object obj = this.cellset.getPropertyValue(0, 0, 1212);
        try {
            rows = ((Number)obj).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rows;
    }

    public int getLayoutCols() {
        int cols = 1;
        Object obj = this.cellset.getPropertyValue(0, 0, 1213);
        try {
            cols = ((Number)obj).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cols;
    }

    public int getLayoutIndex() {
        int index = 1;
        Object obj = this.cellset.getPropertyValue(0, 0, 1214);
        try {
            index = ((Number)obj).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return index;
    }

    public int getPagerStyle() {
        int style = 1;
        Object obj = this.cellset.getPropertyValue(0, 0, 1210);
        try {
            style = ((Number)obj).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return style;
    }

    public CellSet getCellSet() {
        return this.cellset;
    }
}

