/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.cellset;

import com.runqian.base.util.Base64;
import com.runqian.base.util.Escape;
import com.runqian.base.util.SegmentSet;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetReader1;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;

public class CellSetReader {
    private BufferedReader in;

    public CellSetReader(InputStream in) {
        try {
            this.in = new BufferedReader(new InputStreamReader(in, "GBK"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CellSetReader(String fileName) {
        try {
            this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "GBK"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CellSetReader(Reader in) {
        this.in = new BufferedReader(in);
    }

    public CellSet read() throws Exception {
        String line = this.in.readLine();
        if (line.equals("error")) {
            String error = "";
            String tmp = null;
            while ((tmp = this.in.readLine()) != null) {
                error = String.valueOf(error) + tmp + "\n";
            }
            throw new Exception(error);
        }
        line = line.substring(line.indexOf("=") + 1);
        if ((line = line.trim()).equals("1.0")) {
            return new CellSetReader1(this.in).read();
        }
        throw new Exception("\u6587\u4ef6\u6ca1\u6709\u6307\u5b9a\u7248\u672c\u53f7\u6216\u7248\u672c\u53f7\u9519\u8bef!");
    }

    public static Object cloneValue(Object value) {
        if (value instanceof Boolean) {
            return new Boolean(value.toString());
        }
        if (value instanceof Integer) {
            return new Integer(value.toString());
        }
        if (value instanceof Float) {
            return new Float(value.toString());
        }
        if (value instanceof byte[]) {
            byte[] b = (byte[])value;
            byte[] newBytes = new byte[b.length];
            int i = 0;
            while (i < b.length) {
                newBytes[i] = b[i];
                ++i;
            }
            return newBytes;
        }
        return value.toString();
    }

    public static boolean canRef(int key, String cannotRef) {
        if (key == 4102) {
            return false;
        }
        if (cannotRef == null) {
            return true;
        }
        cannotRef = cannotRef.substring(2);
        StringTokenizer st = new StringTokenizer(cannotRef, ",");
        while (st.hasMoreTokens()) {
            String stmp = st.nextToken();
            try {
                int tmp = Integer.parseInt(stmp);
                if (tmp != key) continue;
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static Object transValue(int key, String value, SegmentSet seg, Object refDataType) {
        switch (key) {
            case 1102: 
            case 1103: 
            case 1104: 
            case 1105: 
            case 1107: 
            case 1108: 
            case 4103: 
            case 4104: 
            case 4105: 
            case 4110: 
            case 4301: 
            case 4502: 
            case 4503: 
            case 4701: 
            case 4702: 
            case 4703: 
            case 4704: 
            case 4801: 
            case 4802: 
            case 4803: 
            case 4806: 
            case 4807: 
            case 4808: 
            case 4809: {
                return value;
            }
            case 1109: 
            case 1216: 
            case 1218: 
            case 2103: 
            case 3102: 
            case 3104: 
            case 4106: 
            case 4107: 
            case 4108: 
            case 4111: 
            case 4304: 
            case 4305: 
            case 4306: 
            case 4601: 
            case 4602: 
            case 4804: {
                return value.equals("1") ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1106: 
            case 1201: 
            case 1202: 
            case 1203: 
            case 1204: 
            case 1205: 
            case 1206: 
            case 1207: 
            case 1208: 
            case 1211: 
            case 1212: 
            case 1213: 
            case 4203: 
            case 4302: 
            case 4303: 
            case 4403: 
            case 4406: 
            case 4409: 
            case 4412: 
            case 4413: 
            case 4415: {
                try {
                    return new Integer(value);
                }
                catch (Throwable e) {
                    return new Integer(0);
                }
            }
            case 1101: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CRT_CROSS;
                    }
                    case 2: {
                        return CellPropertyDefine.CRT_GRID;
                    }
                    case 3: {
                        return CellPropertyDefine.CRT_COMPLEX;
                    }
                    case 4: {
                        return CellPropertyDefine.CRT_INPUT;
                    }
                }
                return CellPropertyDefine.CRT_GRID;
            }
            case 1209: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CSU_PIXEL;
                    }
                    case 2: {
                        return CellPropertyDefine.CSU_MM;
                    }
                    case 3: {
                        return CellPropertyDefine.CSU_INCH;
                    }
                }
                return CellPropertyDefine.CSU_PIXEL;
            }
            case 1210: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CPS_PAPER;
                    }
                    case 2: {
                        return CellPropertyDefine.CPS_ROWS;
                    }
                }
                return CellPropertyDefine.CPS_PAPER;
            }
            case 1214: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CPLI_ROW;
                    }
                    case 2: {
                        return CellPropertyDefine.CPLI_COL;
                    }
                }
                return CellPropertyDefine.CPLI_ROW;
            }
            case 1215: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CHS_ALL;
                    }
                    case 2: {
                        return CellPropertyDefine.CHS_ONE;
                    }
                }
                return CellPropertyDefine.CHS_ALL;
            }
            case 1217: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.SP_NONE;
                    }
                    case 2: {
                        return CellPropertyDefine.SP_WIDTH;
                    }
                    case 3: {
                        return CellPropertyDefine.SP_HEIGHT;
                    }
                }
                return CellPropertyDefine.SP_NONE;
            }
            case 4501: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 0: {
                        return CellPropertyDefine.CEX_NONE;
                    }
                    case 1: {
                        return CellPropertyDefine.CEX_VERTICAL;
                    }
                    case 2: {
                        return CellPropertyDefine.CEX_HORIZONTAL;
                    }
                    case 3: {
                        return CellPropertyDefine.CEX_DEFAULT;
                    }
                    case 4: {
                        return CellPropertyDefine.CEX_COL_HORIZONTAL;
                    }
                }
                return CellPropertyDefine.CEX_DEFAULT;
            }
            case 3103: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 0: {
                        return CellPropertyDefine.CRT_TITLE;
                    }
                    case 1: {
                        return CellPropertyDefine.CRT_TABLE_HEADER;
                    }
                    case 2: {
                        return CellPropertyDefine.CRT_TABLE_FOOTER;
                    }
                    case 3: {
                        return CellPropertyDefine.CRT_PAGE_HEADER;
                    }
                    case 4: {
                        return CellPropertyDefine.CRT_PAGE_FOOTER;
                    }
                }
                return CellPropertyDefine.CRT_NORMAL;
            }
            case 2102: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 0: {
                        return CellPropertyDefine.CCT_TABLE_HEADER;
                    }
                }
                return CellPropertyDefine.CCT_NORMAL;
            }
            case 4101: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CDT_TEXT;
                    }
                    case 2: {
                        return CellPropertyDefine.CDT_PIC_FILE;
                    }
                    case 3: {
                        return CellPropertyDefine.CDT_PIC_DB;
                    }
                    case 4: {
                        return CellPropertyDefine.CDT_GRAPH;
                    }
                    case 5: {
                        return CellPropertyDefine.CDT_SUBREPORT;
                    }
                    case 6: {
                        return CellPropertyDefine.CDT_BLANK;
                    }
                    case 7: {
                        return CellPropertyDefine.CDT_HTML;
                    }
                }
                return CellPropertyDefine.CDT_TEXT;
            }
            case 4109: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CAS_EXTEND;
                    }
                    case 2: {
                        return CellPropertyDefine.CAS_SHRINK;
                    }
                }
                return CellPropertyDefine.CAS_EXTEND;
            }
            case 4201: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CA_LEFT;
                    }
                    case 2: {
                        return CellPropertyDefine.CA_CENTER;
                    }
                    case 3: {
                        return CellPropertyDefine.CA_RIGHT;
                    }
                }
                return CellPropertyDefine.CA_LEFT;
            }
            case 4202: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CVA_TOP;
                    }
                    case 2: {
                        return CellPropertyDefine.CVA_MIDDLE;
                    }
                    case 3: {
                        return CellPropertyDefine.CVA_BOTTOM;
                    }
                }
                return CellPropertyDefine.CVA_MIDDLE;
            }
            case 4401: 
            case 4404: 
            case 4407: 
            case 4410: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CBS_NONE;
                    }
                    case 2: {
                        return CellPropertyDefine.CBS_DOTTED;
                    }
                    case 3: {
                        return CellPropertyDefine.CBS_DASHED;
                    }
                    case 4: {
                        return CellPropertyDefine.CBS_SOLID;
                    }
                    case 5: {
                        return CellPropertyDefine.CBS_DOUBLE;
                    }
                }
                return CellPropertyDefine.CBS_NONE;
            }
            case 2101: 
            case 3101: 
            case 4402: 
            case 4405: 
            case 4408: 
            case 4411: {
                try {
                    return new Float(value);
                }
                catch (Throwable e) {
                    return new Float(0.75);
                }
            }
            case 4414: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CLL_NONE;
                    }
                    case 2: {
                        return CellPropertyDefine.CLL_075_LINE;
                    }
                    case 3: {
                        return CellPropertyDefine.CLL_100_LINE;
                    }
                    case 4: {
                        return CellPropertyDefine.CLL_150_LINE;
                    }
                    case 5: {
                        return CellPropertyDefine.CLL_200_LINE;
                    }
                    case 6: {
                        return CellPropertyDefine.CLL_300_LINE;
                    }
                }
                return CellPropertyDefine.CLL_NONE;
            }
            case 4805: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CES_EDITBOX;
                    }
                    case 2: {
                        return CellPropertyDefine.CES_LISTBOX;
                    }
                    case 3: {
                        return CellPropertyDefine.CES_DATAWIN;
                    }
                    case 4: {
                        return CellPropertyDefine.CES_CHECKBOX;
                    }
                    case 5: {
                        return CellPropertyDefine.CES_RADIO;
                    }
                    case 6: {
                        return CellPropertyDefine.CES_CALENDAR;
                    }
                    case 7: {
                        return CellPropertyDefine.CES_UPLOAD;
                    }
                    case 8: {
                        return CellPropertyDefine.CES_TREE;
                    }
                }
                return CellPropertyDefine.CES_EDITBOX;
            }
            case 4810: {
                int intValue = CellSetReader.toInt(value);
                switch (intValue) {
                    case 1: {
                        return CellPropertyDefine.CIDT_TEXT;
                    }
                    case 2: {
                        return CellPropertyDefine.CIDT_NUMERIC;
                    }
                    case 3: {
                        return CellPropertyDefine.CIDT_DATE;
                    }
                    case 4: {
                        return CellPropertyDefine.CIDT_DIGITAL;
                    }
                    case 5: {
                        return CellPropertyDefine.CIDT_EMAIL;
                    }
                    case 6: {
                        return CellPropertyDefine.CIDT_INT;
                    }
                }
                return CellPropertyDefine.CIDT_TEXT;
            }
            case 4102: {
                int dataType;
                String stype = seg.get(String.valueOf(4101));
                if (stype == null) {
                    if (refDataType == null) {
                        return value;
                    }
                    stype = refDataType.toString();
                }
                if ((dataType = Integer.parseInt(CellSetReader.removeTilde(stype))) == CellPropertyDefine.CDT_TEXT || dataType == CellPropertyDefine.CDT_HTML) {
                    if (value.startsWith("__64__")) {
                        return Base64.base64ToByteArray(value.substring(6));
                    }
                    return value;
                }
                try {
                    if (value.startsWith("__64__")) {
                        return Base64.base64ToByteArray(value.substring(6));
                    }
                    return Base64.base64ToByteArray(value);
                }
                catch (Exception e) {
                    return value;
                }
            }
        }
        return value;
    }

    private static int toInt(String value) {
        int rtn = -1;
        try {
            rtn = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }

    static String removeTilde(String src) {
        if (src == null || src.trim().length() == 0) {
            return src;
        }
        src = Escape.removeEscAndQuote(src);
        return src;
    }
}

