/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.cellset;

import com.runqian.base.util.IntHashtable;
import com.runqian.base.util.Logger;
import com.runqian.base.util.SegmentSet;
import com.runqian.report.cellset.CellProperty;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetReader;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.StringTokenizer;

public class CellSetReader1 {
    private BufferedReader in;

    public CellSetReader1(BufferedReader in) {
        this.in = in;
    }

    public CellSet read() {
        CellSet cs = null;
        try {
            String line = this.in.readLine();
            StringTokenizer st = new StringTokenizer(line.trim(), ",");
            int rows = Integer.parseInt(st.nextToken());
            int cols = Integer.parseInt(st.nextToken());
            cs = new CellSet(rows, cols);
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    String[] data = new String[4];
                    line = this.in.readLine();
                    if (line == null) {
                        Logger.info("\u62a5\u8868\u884c\u5217\u6570\u4e0e\u6587\u4ef6\u7b2c\u4e8c\u884c\u6307\u5b9a\u7684\u884c\u5217\u6570\u4e0d\u7b26\uff01");
                    } else {
                        String sub = "";
                        block6: while (true) {
                            if ((line = this.in.readLine()) == null) {
                                Logger.info("\u6587\u4ef6\u5c3e\u90e8\u88ab\u7834\u574f\uff0c\u6570\u636e\u4e0d\u5168\uff01");
                                break;
                            }
                            if ((line = this.trimSpace(line)).equals("</>")) break;
                            if (line.equalsIgnoreCase("<sub>")) {
                                int subCounts = 0;
                                while (true) {
                                    line = this.in.readLine();
                                    if ((line = this.trimSpace(line)).equalsIgnoreCase("<sub>")) {
                                        ++subCounts;
                                    }
                                    if (line.equalsIgnoreCase("</sub>")) {
                                        if (subCounts == 0) continue block6;
                                        --subCounts;
                                    }
                                    sub = String.valueOf(sub) + line + "\n";
                                }
                            }
                            boolean validLine = false;
                            int j = 1;
                            while (j < 5) {
                                if (line.startsWith(String.valueOf(j) + ":")) {
                                    data[j - 1] = line;
                                    validLine = true;
                                    break;
                                }
                                ++j;
                            }
                            if (validLine) continue;
                            Logger.info(String.valueOf(row) + "\u884c" + col + "\u5217(<" + row + "-" + col + ">)\u6807\u7b7e\u4e2d\u67d0\u884c\u6570\u636e\u5f00\u5934\u6709\u9519\uff01");
                        }
                        if (data[0] != null) {
                            int refSource = Integer.parseInt(data[0].substring(2));
                            if (refSource == 0) {
                                this.setRefProperty(cs, row - 1, col, row, col, data[1]);
                            } else {
                                this.setRefProperty(cs, row, col - 1, row, col, data[1]);
                            }
                        }
                        if (data[2] != null) {
                            line = data[2].substring(2);
                            SegmentSet seg = new SegmentSet(line, ';');
                            Iterator it = seg.keySet().iterator();
                            Object dataValue = null;
                            while (it.hasNext()) {
                                String key = (String)it.next();
                                String value = seg.get(key);
                                if (value == null) continue;
                                value = CellSetReader.removeTilde(value);
                                int prop = Integer.parseInt(key);
                                try {
                                    Object refDataType = cs.getPropertyValue(row, col, 4101);
                                    Object propValue = CellSetReader.transValue(prop, value, seg, refDataType);
                                    if (prop == 4102) {
                                        dataValue = propValue;
                                        continue;
                                    }
                                    cs.setPropertyValue(row, col, prop, propValue);
                                }
                                catch (Exception e) {
                                    Logger.info(String.valueOf(row) + "\u884c" + col + "\u5217" + prop + "\u5c5e\u6027\u503c\"" + value + "\"\u9519\u8bef!", e);
                                }
                            }
                            if (dataValue != null) {
                                cs.setPropertyValue(row, col, 4102, dataValue);
                            }
                        }
                        if (data[3] != null) {
                            line = data[3].substring(2);
                            SegmentSet seg = new SegmentSet(line, ';');
                            Iterator it = seg.keySet().iterator();
                            while (it.hasNext()) {
                                String key = (String)it.next();
                                String value = seg.get(key);
                                if (value == null) continue;
                                value = CellSetReader.removeTilde(value);
                                int prop = Integer.parseInt(key);
                                cs.setPropertyExpression(row, col, prop, value);
                            }
                        }
                        if (sub.length() > 0) {
                            StringReader sr = new StringReader(sub);
                            CellSet subReport = new CellSetReader(sr).read();
                            cs.setPropertyValue(row, col, 4102, subReport);
                        }
                    }
                    ++col;
                }
                ++row;
            }
            this.in.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
        }
        return cs;
    }

    private String trimSpace(String src) {
        src = src.trim();
        while (src.startsWith("\t")) {
            src = src.substring(1);
        }
        return src;
    }

    private void setRefProperty(CellSet cs, int refRow, int refCol, int row, int col, String cannotRef) {
        IntHashtable props = cs.getPropertyMap(refRow, refCol);
        if (props == null) {
            return;
        }
        IntHashtable.Enumerator em = props.keys();
        while (em.hasMoreElements()) {
            Object value;
            int key = em.nextElement();
            if (!CellSetReader.canRef(key, cannotRef) || (value = ((CellProperty)props.get(key)).getPropertyValue()) == null) continue;
            cs.setPropertyValue(row, col, key, value, false);
        }
    }
}

