/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.cellset;

import com.runqian.base.util.Base64;
import com.runqian.base.util.IntHashtable;
import com.runqian.report.cellset.CellProperty;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetWriter;
import java.io.PrintWriter;
import java.io.StringWriter;

public class CellSetWriter1 {
    private CellSet cs;
    private String prefix;
    private StringBuffer sb_sub;

    public CellSetWriter1(CellSet cs) {
        this.cs = cs;
        this.prefix = "";
    }

    public CellSetWriter1(CellSet cs, String prefix) {
        this.cs = cs;
        this.prefix = prefix;
    }

    public void write(PrintWriter pw) {
        pw.println(String.valueOf(this.prefix) + "version=1.0");
        int rows = this.cs.getRow();
        int cols = this.cs.getColumn();
        pw.println(String.valueOf(this.prefix) + rows + "," + cols);
        int col = 0;
        while (col < cols) {
            pw.println(String.valueOf(this.prefix) + "<0-" + col + ">");
            this.writeCell(0, col, false, pw);
            this.writeCell(0, col, true, pw);
            pw.println(String.valueOf(this.prefix) + "</>");
            ++col;
        }
        int row = 1;
        while (row < rows) {
            pw.println(String.valueOf(this.prefix) + "<" + row + "-0>");
            this.writeCell(row, 0, false, pw);
            this.writeCell(row, 0, true, pw);
            pw.println(String.valueOf(this.prefix) + "</>");
            int col2 = 1;
            while (col2 < cols) {
                RefResult refResult;
                this.sb_sub = null;
                pw.println(String.valueOf(this.prefix) + "<" + row + "-" + col2 + ">");
                if (row == 1 && col2 == 1) {
                    this.writeCell(row, col2, false, pw);
                } else if (row == 1) {
                    refResult = this.getRefResult(row, col2 - 1, row, col2);
                    if (refResult == null) {
                        this.writeCell(row, col2, false, pw);
                    } else {
                        this.writeRefResult(refResult, 1, pw);
                    }
                } else if (col2 == 1) {
                    refResult = this.getRefResult(row - 1, col2, row, col2);
                    if (refResult == null) {
                        this.writeCell(row, col2, false, pw);
                    } else {
                        this.writeRefResult(refResult, 0, pw);
                    }
                } else {
                    RefResult leftRefResult = this.getRefResult(row, col2 - 1, row, col2);
                    RefResult topRefResult = this.getRefResult(row - 1, col2, row, col2);
                    if (leftRefResult == null && topRefResult == null) {
                        this.writeCell(row, col2, false, pw);
                    } else if (topRefResult == null) {
                        this.writeRefResult(leftRefResult, 1, pw);
                    } else if (leftRefResult == null) {
                        this.writeRefResult(topRefResult, 0, pw);
                    } else if (leftRefResult.refCount > topRefResult.refCount) {
                        this.writeRefResult(leftRefResult, 1, pw);
                    } else {
                        this.writeRefResult(topRefResult, 0, pw);
                    }
                }
                this.writeCell(row, col2, true, pw);
                if (this.sb_sub != null) {
                    pw.println(String.valueOf(this.prefix) + "\t<sub>");
                    pw.print(this.sb_sub.toString());
                    pw.println(String.valueOf(this.prefix) + "\t</sub>");
                }
                pw.println(String.valueOf(this.prefix) + "</>");
                ++col2;
            }
            ++row;
        }
        pw.flush();
    }

    private void writeSubReport(CellSet sub) {
        StringWriter sw = new StringWriter();
        new CellSetWriter(sub).write(new PrintWriter(sw), String.valueOf(this.prefix) + "\t\t");
        this.sb_sub = sw.getBuffer();
    }

    private void writeCell(int row, int col, boolean isPropertyExpress, PrintWriter pw) {
        StringBuffer pvalues = new StringBuffer();
        IntHashtable props = this.cs.getPropertyMap(row, col);
        if (props == null) {
            return;
        }
        IntHashtable.Enumerator em = props.keys();
        while (em.hasMoreElements()) {
            String propValue;
            int key = em.nextElement();
            CellProperty prop = (CellProperty)props.get(key);
            Object value = null;
            value = isPropertyExpress ? prop.getPropertyExpression() : prop.getPropertyValue();
            if (value == null) continue;
            if (value instanceof CellSet) {
                this.writeSubReport((CellSet)value);
                continue;
            }
            if (pvalues.length() > 0) {
                pvalues.append(";");
            }
            if ((propValue = this.transPropertyValue(value)) == null || propValue.trim().length() <= 0) continue;
            pvalues.append(String.valueOf(key)).append("=").append(propValue);
        }
        if (pvalues.length() > 0) {
            String flag = "3";
            if (isPropertyExpress) {
                flag = "4";
            }
            pw.println(String.valueOf(this.prefix) + "\t" + flag + ":" + pvalues.toString());
        }
    }

    private String transPropertyValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "1" : "0";
        }
        if (value instanceof byte[]) {
            return "__64__" + Base64.byteArrayToBase64((byte[])value);
        }
        return CellSetWriter.addTilde(value.toString());
    }

    private RefResult getRefResult(int refRow, int refCol, int row, int col) {
        IntHashtable props = this.cs.getPropertyMap(row, col);
        IntHashtable refp = this.cs.getPropertyMap(refRow, refCol);
        if (props == null || refp == null) {
            return null;
        }
        IntHashtable refProps = (IntHashtable)refp.clone();
        int refCount = 0;
        StringBuffer kept = new StringBuffer();
        StringBuffer cannotRef = new StringBuffer();
        IntHashtable.Enumerator em = props.keys();
        while (em.hasMoreElements()) {
            int key = em.nextElement();
            Object value = ((CellProperty)props.get(key)).getPropertyValue();
            CellProperty cp = (CellProperty)refProps.get(key);
            if (value == null) {
                if (cp == null) continue;
                this.add2Buffer(cannotRef, String.valueOf(key), ",");
                refProps.remove(key);
                continue;
            }
            if (cp == null) {
                this.add2Buffer(kept, String.valueOf(key) + "=" + this.transPropertyValue(value), ";");
                continue;
            }
            Object refValue = cp.getPropertyValue();
            if (key != 4102 && this.isPropertyValueEqual(value, refValue)) {
                ++refCount;
            } else if (value instanceof CellSet) {
                this.writeSubReport((CellSet)value);
            } else {
                this.add2Buffer(kept, String.valueOf(key) + "=" + this.transPropertyValue(value), ";");
            }
            refProps.remove(key);
        }
        em = refProps.keys();
        while (em.hasMoreElements()) {
            this.add2Buffer(cannotRef, String.valueOf(em.nextElement()), ",");
        }
        RefResult result = new RefResult();
        result.refCount = refCount;
        result.selfKept = kept.toString();
        result.cannotRef = cannotRef.toString();
        return result;
    }

    private void add2Buffer(StringBuffer sb, String value, String delim) {
        if (sb.length() > 0) {
            sb.append(delim);
        }
        sb.append(value);
    }

    private boolean isPropertyValueEqual(Object value, Object refValue) {
        if (refValue == null) {
            return false;
        }
        return this.transPropertyValue(value).equals(this.transPropertyValue(refValue));
    }

    private void writeRefResult(RefResult result, int refSource, PrintWriter pw) {
        if (result.refCount > 0) {
            pw.println(String.valueOf(this.prefix) + "\t1:" + refSource);
            if (result.cannotRef.length() > 0) {
                pw.println(String.valueOf(this.prefix) + "\t2:" + result.cannotRef);
            }
        }
        if (result.selfKept.length() > 0) {
            pw.println(String.valueOf(this.prefix) + "\t3:" + result.selfKept);
        }
    }

    private class RefResult {
        public int refCount;
        public String selfKept;
        public String cannotRef;

        RefResult() {
        }
    }
}

