/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.Field;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class CellBorder {
    private CellSetParser parser;
    private int row;
    private int col;
    private static final int TOP = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;
    private static final int RIGHT = 4;
    private static final int MERGE_NOT = 0;
    private static final int MERGE_LEFTTOP = 1;
    private static final int MERGE_RIGHTTOP = 2;
    private static final int MERGE_LEFTBOTTOM = 4;
    private static final int MERGE_RIGHTBOTTOM = 8;
    private static final int MERGE_MIDDLE = 16;
    private boolean isEditing;
    private int reportStartRow;
    private int reportEndRow;
    private Graphics g;

    public CellBorder(Graphics g, CellSetParser parser, int row, int col, boolean isEditing) {
        this.g = g;
        this.parser = parser;
        this.row = row;
        this.col = col;
        this.isEditing = isEditing;
        this.reportStartRow = 1;
        this.reportEndRow = parser.getRowCount() - 1;
    }

    public void setPageHeaderAndFooter(Field pageHeader, Field pageFooter) {
        if (!this.isEditing) {
            if (pageHeader != null) {
                this.reportStartRow = pageHeader.getEndRow() + 1;
            }
            if (pageFooter != null) {
                this.reportEndRow = pageFooter.getStartRow() - 1;
            }
        }
    }

    public void drawBorder(int x, int y, int width, int height) {
        if (this.parser.isMerged(this.row, this.col)) {
            int y2;
            int startRow = this.parser.getMergedStartRow(this.row, this.col);
            int endRow = this.parser.getMergedEndRow(this.row, this.col);
            int startCol = this.parser.getMergedStartCol(this.row, this.col);
            int endCol = this.parser.getMergedEndCol(this.row, this.col);
            int mergeLocation = 16;
            int x1 = x;
            int y1 = y;
            int x2 = x;
            int nRow = startRow;
            while (nRow <= endRow) {
                if (this.isEditing || this.parser.isRowVisible(nRow)) {
                    y2 = y1 + this.parser.getRowHeight(nRow);
                    if (nRow == startRow) {
                        ++mergeLocation;
                    }
                    if (nRow == endRow) {
                        mergeLocation += 4;
                    }
                    this.drawBorder(this.g, x1, y1, x2, y2, 3, mergeLocation, nRow, startCol);
                    y1 = y2;
                }
                ++nRow;
            }
            mergeLocation = 16;
            x1 = x + width;
            y1 = y;
            x2 = x + width;
            nRow = startRow;
            while (nRow <= endRow) {
                if (this.isEditing || this.parser.isRowVisible(nRow)) {
                    y2 = y1 + this.parser.getRowHeight(nRow);
                    if (nRow == startRow) {
                        mergeLocation += 2;
                    }
                    if (nRow == endRow) {
                        mergeLocation += 8;
                    }
                    this.drawBorder(this.g, x1, y1, x2, y2, 4, mergeLocation, nRow, endCol);
                    y1 = y2;
                }
                ++nRow;
            }
            mergeLocation = 16;
            x1 = x;
            y1 = y;
            y2 = y;
            int nCol = startCol;
            while (nCol <= endCol) {
                if (this.isEditing || this.parser.isColVisible(nCol)) {
                    x2 = x1 + this.parser.getColWidth(nCol);
                    if (nCol == startCol) {
                        ++mergeLocation;
                    }
                    if (nCol == endCol) {
                        mergeLocation += 2;
                    }
                    this.drawBorder(this.g, x1, y1, x2, y2, 1, mergeLocation, startRow, nCol);
                    x1 = x2;
                }
                ++nCol;
            }
            mergeLocation = 16;
            x1 = x;
            y1 = y + height;
            y2 = y + height;
            nCol = startCol;
            while (nCol <= endCol) {
                if (this.isEditing || this.parser.isColVisible(nCol)) {
                    x2 = x1 + this.parser.getColWidth(nCol);
                    if (nCol == startCol) {
                        mergeLocation += 4;
                    }
                    if (nCol == endCol) {
                        mergeLocation += 8;
                    }
                    this.drawBorder(this.g, x1, y1, x2, y2, 2, mergeLocation, endRow, nCol);
                    x1 = x2;
                }
                ++nCol;
            }
        } else {
            int x1 = x;
            int y1 = y;
            int x2 = x + width;
            int y2 = y;
            this.drawBorder(this.g, x1, y1, x2, y2, 1, 0, this.row, this.col);
            x1 = x;
            y1 = y + height;
            x2 = x + width;
            y2 = y + height;
            this.drawBorder(this.g, x1, y1, x2, y2, 2, 0, this.row, this.col);
            x1 = x;
            y1 = y;
            x2 = x;
            y2 = y + height;
            this.drawBorder(this.g, x1, y1, x2, y2, 3, 0, this.row, this.col);
            x1 = x + width;
            y1 = y;
            x2 = x + width;
            y2 = y + height;
            this.drawBorder(this.g, x1, y1, x2, y2, 4, 0, this.row, this.col);
        }
    }

    private void drawBorder(Graphics g, int x1, int y1, int x2, int y2, int location, int mergeLocation, int drawRow, int drawCol) {
        int widthKey = 0;
        int styleKey = 0;
        int colorKey = 0;
        switch (location) {
            case 3: {
                widthKey = 4402;
                styleKey = 4401;
                colorKey = 4403;
                break;
            }
            case 4: {
                widthKey = 4405;
                styleKey = 4404;
                colorKey = 4406;
                break;
            }
            case 1: {
                widthKey = 4408;
                styleKey = 4407;
                colorKey = 4409;
                break;
            }
            case 2: {
                widthKey = 4411;
                styleKey = 4410;
                colorKey = 4412;
            }
        }
        Object weight = this.parser.getPropertyValue(drawRow, drawCol, widthKey);
        Object style = this.parser.getPropertyValue(drawRow, drawCol, styleKey);
        Object color = this.parser.getPropertyValue(drawRow, drawCol, colorKey);
        Graphics2D g2d = (Graphics2D)g;
        if (color == null) {
            g2d.setColor(Color.lightGray);
        } else {
            g2d.setColor(new Color(Integer.parseInt(color.toString()), true));
        }
        float lineWidth = 0.5f;
        if (weight != null) {
            lineWidth = Float.parseFloat(weight.toString());
        }
        BasicStroke bs = new BasicStroke(lineWidth);
        int lineStyle = -1;
        if (style != null) {
            float[] dash;
            lineStyle = Integer.parseInt(style.toString());
            if (lineStyle == CellPropertyDefine.CBS_NONE) {
                if (!this.isEditing) {
                    return;
                }
                bs = new BasicStroke(0.5f);
                g2d.setColor(Color.lightGray);
            }
            if (lineStyle == CellPropertyDefine.CBS_DASHED) {
                dash = new float[]{5.0f, 3.0f};
                bs = new BasicStroke(lineWidth, 0, 0, 1.0f, dash, 0.0f);
            }
            if (lineStyle == CellPropertyDefine.CBS_DOTTED) {
                dash = new float[]{10.0f, 3.0f, 2.0f, 3.0f};
                bs = new BasicStroke(lineWidth, 0, 0, 1.0f, dash, 0.0f);
            }
            if (lineStyle == CellPropertyDefine.CBS_NOTMODIFIED) {
                g2d.setColor(Color.lightGray);
                lineWidth = 2.0f;
                dash = new float[]{1.0f, 1.0f};
                bs = new BasicStroke(lineWidth, 0, 0, 1.0f, dash, 0.0f);
            }
        } else if (!this.isEditing) {
            return;
        }
        Stroke bsOld = g2d.getStroke();
        g2d.setStroke(bs);
        if (lineStyle == CellPropertyDefine.CBS_DOUBLE) {
            switch (location) {
                case 3: {
                    if (this.isFirstCol()) {
                        g2d.drawLine(x1, y1, x2, y2);
                        ++x1;
                        ++x2;
                    }
                    ++x1;
                    ++x2;
                    if (this.isBorderDouble(drawRow, drawCol, 1) && (mergeLocation == 0 || (1 & mergeLocation) != 0)) {
                        ++y1;
                        if (this.isFirstRow()) {
                            ++y1;
                        }
                    }
                    if (!this.isBorderDouble(drawRow, drawCol, 2) || mergeLocation != 0 && (4 & mergeLocation) == 0) break;
                    --y2;
                    if (!this.isLastRow()) break;
                    --y2;
                    break;
                }
                case 1: {
                    if (this.isFirstRow()) {
                        g2d.drawLine(x1, y1, x2, y2);
                        ++y1;
                        ++y2;
                    }
                    ++y1;
                    ++y2;
                    if (this.isBorderDouble(drawRow, drawCol, 3) && (mergeLocation == 0 || (1 & mergeLocation) != 0)) {
                        ++x1;
                        if (this.isFirstCol()) {
                            ++x1;
                        }
                    }
                    if (!this.isBorderDouble(drawRow, drawCol, 4) || mergeLocation != 0 && (2 & mergeLocation) == 0) break;
                    --x2;
                    if (!this.isLastCol()) break;
                    --x2;
                    break;
                }
                case 2: {
                    if (this.isLastRow()) {
                        g2d.drawLine(x1, y1, x2, y2);
                        --y1;
                        --y2;
                    }
                    --y1;
                    --y2;
                    if (this.isBorderDouble(drawRow, drawCol, 3) && (mergeLocation == 0 || (4 & mergeLocation) != 0)) {
                        ++x1;
                        if (this.isFirstCol()) {
                            ++x1;
                        }
                    }
                    if (!this.isBorderDouble(drawRow, drawCol, 4) || mergeLocation != 0 && (8 & mergeLocation) == 0) break;
                    --x2;
                    if (!this.isLastCol()) break;
                    --x2;
                    break;
                }
                case 4: {
                    if (this.isLastCol()) {
                        g2d.drawLine(x1, y1, x2, y2);
                        --x1;
                        --x2;
                    }
                    --x1;
                    --x2;
                    if (this.isBorderDouble(drawRow, drawCol, 1) && (mergeLocation == 0 || (2 & mergeLocation) != 0)) {
                        ++y1;
                        if (this.isFirstRow()) {
                            ++y1;
                        }
                    }
                    if (!this.isBorderDouble(drawRow, drawCol, 2) || mergeLocation != 0 && (8 & mergeLocation) == 0) break;
                    --y2;
                    if (!this.isLastRow()) break;
                    --y2;
                }
            }
        }
        g2d.drawLine(x1, y1, x2, y2);
        g2d.setStroke(bsOld);
    }

    private boolean isBorderDouble(int nRow, int nCol, int location) {
        Object obj = null;
        switch (location) {
            case 3: {
                obj = this.parser.getPropertyValue(nRow, nCol, 4401);
                break;
            }
            case 4: {
                obj = this.parser.getPropertyValue(nRow, nCol, 4404);
                break;
            }
            case 1: {
                obj = this.parser.getPropertyValue(nRow, nCol, 4407);
                break;
            }
            case 2: {
                obj = this.parser.getPropertyValue(nRow, nCol, 4410);
            }
        }
        if (obj == null) {
            return false;
        }
        return ((Integer)obj).intValue() == CellPropertyDefine.CBS_DOUBLE.intValue();
    }

    private boolean isLastRow() {
        if (this.parser.isMerged(this.row, this.col)) {
            int endRow = this.parser.getMergedEndRow(this.row, this.col);
            return endRow == this.reportEndRow;
        }
        return this.row == this.reportEndRow;
    }

    private boolean isLastCol() {
        if (this.parser.isMerged(this.row, this.col)) {
            int endCol = this.parser.getMergedEndCol(this.row, this.col);
            return endCol == this.parser.getColCount() - 1;
        }
        return this.col == this.parser.getColCount() - 1;
    }

    private boolean isFirstRow() {
        if (this.parser.isMerged(this.row, this.col)) {
            int startRow = this.parser.getMergedStartRow(this.row, this.col);
            return startRow == this.reportStartRow;
        }
        return this.row == this.reportStartRow;
    }

    private boolean isFirstCol() {
        if (this.parser.isMerged(this.row, this.col)) {
            int startCol = this.parser.getMergedStartCol(this.row, this.col);
            return startCol == 1;
        }
        return this.col == 1;
    }
}

