/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.report.control.ContentPanel;
import com.runqian.report.control.ReportControl;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class CellEditingListener
implements KeyListener {
    private ReportControl control;
    private ContentPanel cp;

    public CellEditingListener(ReportControl control, ContentPanel panel) {
        this.control = control;
        this.cp = panel;
    }

    public void keyReleased(KeyEvent e) {
        if (!Character.isDefined(e.getKeyChar())) {
            return;
        }
        if (e.isControlDown()) {
            return;
        }
        if (e.isAltDown()) {
            return;
        }
        int key = e.getKeyCode();
        if (key == 27 || key == 10) {
            return;
        }
        String text = ((JTextComponent)e.getSource()).getText();
        this.control.fireEditorInputing(text);
    }

    public void keyPressed(KeyEvent e) {
        JComponent source = (JComponent)e.getSource();
        int key = e.getKeyCode();
        switch (key) {
            case 40: {
                if (source instanceof JTextArea && !e.isControlDown()) {
                    return;
                }
                this.cp.toDownCell();
                break;
            }
            case 38: {
                if (source instanceof JTextArea && !e.isControlDown()) {
                    return;
                }
                this.cp.toUpCell();
                break;
            }
            case 39: {
                if (!e.isControlDown()) {
                    return;
                }
                this.cp.toRightCell();
                break;
            }
            case 10: {
                if (source instanceof JTextArea) {
                    return;
                }
                this.cp.toRightCell();
                break;
            }
            case 37: {
                if (!e.isControlDown()) {
                    return;
                }
                this.cp.toLeftCell();
                break;
            }
            default: {
                return;
            }
        }
        e.consume();
    }

    public void keyTyped(KeyEvent e) {
    }
}

