/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.report.cellset.CellPosition;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellRegion;
import com.runqian.report.control.ContentPanel;
import com.runqian.report.control.ControlUtils;
import com.runqian.report.control.ReportControl;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.text.JTextComponent;

public class CellSelectListener
implements MouseMotionListener,
MouseListener,
KeyListener {
    private ReportControl control;
    private ContentPanel cp;

    public CellSelectListener(ReportControl control, ContentPanel panel) {
        this.control = control;
        this.cp = panel;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int endCol;
        int startCol;
        int endRow;
        int startRow;
        CellPosition pos = ControlUtils.lookupCellPosition(e.getX(), e.getY(), this.cp);
        if (pos == null) {
            return;
        }
        boolean isCellSelected = false;
        if (this.control.m_selectedRegion != null) {
            startRow = this.control.m_selectedRegion.getTop();
            endRow = this.control.m_selectedRegion.getBottom();
            startCol = this.control.m_selectedRegion.getLeft();
            endCol = this.control.m_selectedRegion.getRight();
            if (pos.getRow() >= startRow && pos.getRow() <= endRow && pos.getColumn() >= startCol && pos.getColumn() <= endCol) {
                isCellSelected = true;
            }
        }
        if (e.getButton() == 1 || !isCellSelected) {
            if (e.isShiftDown() && this.control.m_selectedRegion != null) {
                startRow = this.control.m_selectedRegion.getTop();
                endRow = this.control.m_selectedRegion.getBottom();
                startCol = this.control.m_selectedRegion.getLeft();
                endCol = this.control.m_selectedRegion.getRight();
                if (pos.getRow() <= startRow) {
                    startRow = pos.getRow();
                } else {
                    endRow = pos.getRow();
                }
                if (pos.getCol() <= startCol) {
                    startCol = pos.getCol();
                } else {
                    endCol = pos.getCol();
                }
                this.control.m_selectedRegion = new CellRegion(startRow, startCol, endRow, endCol);
                this.control.m_selectedRegion = ControlUtils.adjustCellRegion(this.control, this.control.m_selectedRegion);
                this.control.fireRegionSelect();
                ControlUtils.scrollToVisible(this.control.getViewport(), this.control, pos.getRow(), pos.getCol());
                this.control.repaint();
            } else {
                this.cp.rememberedRow = pos.getRow();
                this.cp.rememberedCol = pos.getColumn();
                this.cp.setActiveCell(pos);
                this.cp.requestFocus();
            }
        }
        this.showPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.control.status == 1 && this.control.m_selectedRegion != null) {
            this.control.fireRegionSelect();
        }
        this.control.status = 0;
        this.showPopup(e);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        CellPosition pos = ControlUtils.lookupCellPosition(e.getX(), e.getY(), this.cp);
        if (pos == null) {
            return;
        }
        Object dataType = this.control.m_cellSet.getPropertyValue(pos.getRow(), pos.getColumn(), 4101);
        int dtype = (Integer)dataType;
        if (dtype == CellPropertyDefine.CDT_GRAPH) {
            this.control.fireGraphEdit(pos.getRow(), pos.getColumn());
        } else if (dtype == CellPropertyDefine.CDT_SUBREPORT) {
            this.control.fireSubReportEdit(pos.getRow(), pos.getColumn());
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.control.status = 1;
        CellPosition pos = ControlUtils.lookupCellPosition(e.getX(), e.getY(), this.cp);
        if (pos == null) {
            return;
        }
        CellRegion region = new CellRegion(this.cp.m_activeCell.getRow(), this.cp.m_activeCell.getColumn(), pos.getRow(), pos.getColumn());
        region = ControlUtils.adjustCellRegion(this.control, region);
        ControlUtils.scrollToVisible(this.control.getViewport(), this.control, pos.getRow(), pos.getColumn());
        if (!region.equals(this.control.m_selectedRegion)) {
            this.control.m_selectedRegion = region;
            this.control.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        switch (key) {
            case 40: {
                this.cp.toDownCell();
                e.consume();
                break;
            }
            case 38: {
                this.cp.toUpCell();
                e.consume();
                break;
            }
            case 10: 
            case 39: {
                this.cp.toRightCell();
                e.consume();
                break;
            }
            case 37: {
                this.cp.toLeftCell();
                e.consume();
                break;
            }
            default: {
                return;
            }
        }
    }

    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        if (!Character.isDefined(c)) {
            return;
        }
        if (e.isControlDown()) {
            return;
        }
        if (e.isAltDown()) {
            return;
        }
        if (c == '\u001b' || c == '\n' || c == '\b') {
            return;
        }
        if (this.cp.editor == null) {
            return;
        }
        if (this.cp.editor instanceof JTextComponent) {
            this.cp.editor.requestFocus();
            String text = String.valueOf(e.getKeyChar());
            ((JTextComponent)this.cp.editor).setText(text);
        }
    }

    void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.control.fireRightClicked(e, 4);
        }
    }
}

