/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.report.cellset.CellRegion;
import com.runqian.report.control.ControlUtils;
import com.runqian.report.control.ReportControl;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class ColHeaderListener
implements MouseMotionListener,
MouseListener {
    private ReportControl control;
    private int startSelectedCol;
    private int resizeStartX;
    private int resizeStartCol;
    private int tableHeight;
    private int oldCellWidth;

    public ColHeaderListener(ReportControl control) {
        this.control = control;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int col = ControlUtils.lookupHeaderIndex(e.getX(), this.control.cellX, this.control.cellW);
        if (col < 0) {
            return;
        }
        boolean colIsSelected = false;
        if (this.control.m_selectedCols != null) {
            int i = 0;
            while (i < this.control.m_selectedCols.size()) {
                Integer c = (Integer)this.control.m_selectedCols.get(i);
                if (c == col) {
                    colIsSelected = true;
                    break;
                }
                ++i;
            }
        }
        if (e.getButton() == 1 || !colIsSelected) {
            if (this.control.status != 4 || e.getButton() != 1) {
                this.control.m_selectedRows = null;
                this.control.m_cornerSelected = false;
                this.startSelectedCol = col;
                this.control.m_selectedCols = new Vector();
                this.control.m_selectedCols.add(new Integer(col));
                this.control.m_selectedRegion = new CellRegion(1, col, this.control.m_parser.getRowCount() - 1, col);
                this.control.repaint();
            } else if (e.getButton() == 1) {
                this.resizeStartX = e.getX();
                this.resizeStartCol = ControlUtils.lookupHeaderIndex(this.resizeStartX, this.control.cellX, this.control.cellW);
                this.oldCellWidth = this.control.cellW[col];
            }
        }
        this.showPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int col = ControlUtils.lookupHeaderIndex(x, this.control.cellX, this.control.cellW);
        if (this.control.status == 4) {
            if (e.getButton() == 1) {
                int startCol = ControlUtils.lookupHeaderIndex(this.resizeStartX, this.control.cellX, this.control.cellW);
                if (col != startCol) {
                    col = startCol;
                }
                Vector willResizeCols = new Vector();
                willResizeCols.add(new Integer(col));
                if (this.control.m_selectedCols != null) {
                    int selectedStartCol = (Integer)this.control.m_selectedCols.get(0);
                    int selectedEndCol = (Integer)this.control.m_selectedCols.get(this.control.m_selectedCols.size() - 1);
                    if (col >= selectedStartCol && col <= selectedEndCol) {
                        willResizeCols = this.control.m_selectedCols;
                    }
                }
                this.control.m_cellSet.setPropertyValue(0, col, 2101, new Integer(this.oldCellWidth));
                this.control.fireColHeaderResized(willResizeCols, this.control.cellW[col]);
            }
        } else {
            this.control.fireRegionSelect();
        }
        this.control.status = 0;
        this.showPopup(e);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int col = ControlUtils.lookupHeaderIndex(x, this.control.cellX, this.control.cellW);
        if (this.control.status == 0) {
            if (col < 0) {
                return;
            }
            int start = this.startSelectedCol < col ? this.startSelectedCol : col;
            int end = this.startSelectedCol > col ? this.startSelectedCol : col;
            this.control.m_selectedCols = new Vector();
            int i = start;
            while (i <= end) {
                this.control.m_selectedCols.add(new Integer(i));
                ++i;
            }
            this.control.m_selectedRegion = new CellRegion(1, start, this.control.m_parser.getRowCount() - 1, end);
            if (ControlUtils.scrollToVisible(this.control.getColumnHeader(), this.control, 0, col)) {
                Point p1 = this.control.getColumnHeader().getViewPosition();
                Point p2 = this.control.getViewport().getViewPosition();
                p2.x = p1.x;
                this.control.getViewport().setViewPosition(p2);
            }
            this.control.repaint();
        }
        if (this.control.status == 4) {
            if (col != this.resizeStartCol) {
                col = this.resizeStartCol;
            }
            int newWidth = this.control.cellW[col] + x - this.resizeStartX;
            this.resizeStartX = x;
            if (newWidth > 0) {
                this.control.m_cellSet.setPropertyValue(0, col, 2101, new Integer(newWidth));
                this.control.getColumnHeader().getView().repaint();
                this.control.getViewport().getView().repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int col = ControlUtils.lookupHeaderIndex(x, this.control.cellX, this.control.cellW);
        if (col < 0) {
            this.control.status = 0;
            this.control.getColumnHeader().getView().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (x >= this.control.cellX[col] + this.control.cellW[col] - 2 && x <= this.control.cellX[col] + this.control.cellW[col]) {
            this.control.status = 4;
            this.control.getColumnHeader().getView().setCursor(Cursor.getPredefinedCursor(10));
        } else {
            this.control.status = 0;
            this.control.getColumnHeader().getView().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.control.fireRightClicked(e, 2);
        }
    }
}

