/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.control.ControlUtils;
import com.runqian.report.control.ReportControl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import javax.swing.JPanel;

public class ColHeaderPanel
extends JPanel {
    private ReportControl control;
    private static final String[] colLabels = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public ColHeaderPanel(ReportControl control) {
        this.control = control;
        control.cellX = new int[control.m_cellSet.getColumn()];
        control.cellW = new int[control.m_cellSet.getColumn()];
        this.setPreferredSize(new Dimension(control.m_parser.getCellSetEditWidth(), 21));
    }

    public void paintComponent(Graphics g) {
        int h = 20;
        g.clearRect(0, 0, 999999, h + 1);
        int cols = this.control.m_cellSet.getColumn();
        if (cols != this.control.cellX.length) {
            this.control.cellX = new int[cols];
            this.control.cellW = new int[cols];
        }
        Rectangle r = this.control.getViewport().getViewRect();
        int i = 1;
        while (i < cols) {
            this.control.cellX[i] = i == 1 ? 1 : this.control.cellX[i - 1] + this.control.cellW[i - 1];
            this.control.cellW[i] = this.control.m_parser.getColWidth(i);
            if (this.control.cellX[i] + this.control.cellW[i] > r.x && this.control.cellX[i] < r.x + r.width) {
                int type;
                Color bkColor = Color.lightGray;
                String label = this.getColLabel(i - 1);
                Object colType = this.control.m_parser.getPropertyValue(0, i, 2102);
                if (colType != null && (type = ((Integer)colType).intValue()) == CellPropertyDefine.CCT_TABLE_HEADER) {
                    label = String.valueOf(label) + "(\u5934)";
                    bkColor = new Color(221, 160, 221);
                }
                int flag = 0;
                if (this.control.m_selectedRegion != null) {
                    int col1 = this.control.m_selectedRegion.getLeft();
                    int col2 = this.control.m_selectedRegion.getRight();
                    if (i >= col1 && i <= col2) {
                        flag = 1;
                    }
                }
                if (this.control.m_selectedCols != null) {
                    int k = 0;
                    while (k < this.control.m_selectedCols.size()) {
                        if (i == (Integer)this.control.m_selectedCols.get(k)) {
                            flag = 2;
                            break;
                        }
                        ++k;
                    }
                }
                int x = this.control.cellX[i];
                int w = this.control.cellW[i];
                if (i > 1) {
                    ++x;
                    --w;
                }
                ControlUtils.drawHeader(g, x, 0, w, h, label, bkColor, flag);
            }
            ++i;
        }
        this.setPreferredSize(new Dimension(this.control.m_parser.getCellSetEditWidth(), 21));
        g.dispose();
    }

    private String getColLabel(int index) {
        if (index < 26) {
            return colLabels[index];
        }
        int shang = index / 26;
        int yu = index % 26;
        return String.valueOf(colLabels[shang - 1]) + colLabels[yu];
    }

    public Dimension getPreferredSize() {
        int width = 0;
        CellSetParser parser = this.control.m_parser;
        int col = 1;
        while (col < parser.getColCount()) {
            width += parser.getColWidth(col);
            ++col;
        }
        PageFormat pf = parser.getPageFormat();
        int ww = (int)pf.getImageableWidth();
        if (width < ww) {
            width = ww;
        }
        return new Dimension(width + 2, 21);
    }
}

