/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.base.util.Escape;
import com.runqian.report.cellset.CellPosition;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellRegion;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.Field;
import com.runqian.report.control.CellBorder;
import com.runqian.report.control.CellEditingListener;
import com.runqian.report.control.ControlUtils;
import com.runqian.report.control.EditorRightClicked;
import com.runqian.report.control.HyperLinkListener;
import com.runqian.report.control.LeanLine;
import com.runqian.report.control.ReportControl;
import com.runqian.report.control.ShowEditorListener;
import com.runqian.report.control.UnderLineBorder;
import com.runqian.report.graph.GraphProperty;
import com.runqian.report.graph.GraphUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.awt.print.PageFormat;
import java.io.InputStream;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class ContentPanel
extends JPanel
implements InputMethodListener,
InputMethodRequests {
    CellSet cs;
    CellSetParser parser;
    int startRow;
    int endRow;
    int startCol;
    int endCol;
    boolean isEditing;
    boolean onlyDrawCellInWin;
    boolean editable;
    JScrollPane jsp;
    int[][] cellX;
    int[][] cellY;
    int[][] cellW;
    int[][] cellH;
    public CellPosition m_activeCell;
    private JTextField singleEditor;
    private JTextArea multiEditor;
    private String oldText = "";
    public JComponent editor;
    int editorType;
    int rememberedRow = 0;
    int rememberedCol = 0;
    private ArrayList al_subReport = new ArrayList();
    private int location = 1;
    public static final int SINGLE_EDITOR = 1;
    public static final int MULTI_EDITOR = 2;

    public ContentPanel(CellSet cs, int startRow, int endRow, int startCol, int endCol, boolean isEditing, boolean onlyDrawCellInWin, JScrollPane jsp, boolean editable, JApplet applet, String appmap, Color mouseOnLinkColor, int location) {
        this.cs = cs;
        this.parser = new CellSetParser(cs);
        this.startRow = startRow;
        this.endRow = endRow;
        this.startCol = startCol;
        this.endCol = endCol;
        this.isEditing = isEditing;
        this.onlyDrawCellInWin = onlyDrawCellInWin;
        this.jsp = jsp;
        this.editable = editable;
        this.location = location;
        int rows = this.parser.getRowCount();
        int cols = this.parser.getColCount();
        this.cellX = new int[rows][cols];
        this.cellW = new int[rows][cols];
        this.cellY = new int[rows][cols];
        this.cellH = new int[rows][cols];
        this.setLayout(null);
        if (editable) {
            this.singleEditor = new JTextField();
            this.singleEditor.setVisible(false);
            this.multiEditor = new JTextArea();
            this.multiEditor.setLineWrap(true);
            this.multiEditor.setWrapStyleWord(true);
            this.multiEditor.setEditable(true);
            this.multiEditor.setVisible(false);
            this.multiEditor.setOpaque(true);
            this.add(this.singleEditor);
            this.add(this.multiEditor);
            if (!isEditing) {
                this.addMouseListener(new ShowEditorListener(this));
            } else {
                this.enableInputMethods(true);
                this.addInputMethodListener(this);
                CellEditingListener listener = new CellEditingListener((ReportControl)jsp, this);
                this.singleEditor.addKeyListener(listener);
                this.multiEditor.addKeyListener(listener);
                EditorRightClicked erc = new EditorRightClicked((ReportControl)jsp);
                this.singleEditor.addMouseListener(erc);
                this.multiEditor.addMouseListener(erc);
            }
        }
        if (applet != null) {
            HyperLinkListener linkListener = new HyperLinkListener(this, appmap, applet, mouseOnLinkColor);
            this.addMouseListener(linkListener);
            this.addMouseMotionListener(linkListener);
        }
    }

    public Dimension getPreferredSize() {
        int width = 0;
        int col = this.startCol;
        while (col <= this.endCol) {
            if (this.isEditing) {
                width += this.parser.getColWidth(col);
            } else if (this.parser.isColVisible(col)) {
                width += this.parser.getColWidth(col);
            }
            ++col;
        }
        int height = 0;
        int row = this.startRow;
        while (row <= this.endRow) {
            if (this.isEditing) {
                height += this.parser.getRowHeight(row);
            } else if (this.parser.isRowVisible(row)) {
                height += this.parser.getRowHeight(row);
            }
            ++row;
        }
        if (this.isEditing) {
            PageFormat pf = this.parser.getPageFormat();
            int ww = (int)pf.getImageableWidth();
            int hh = (int)pf.getImageableHeight();
            if (width < ww) {
                width = ww;
            }
            if (height < hh) {
                height = hh;
            }
        }
        return new Dimension(width + 2, height + 2);
    }

    public void paint(Graphics g) {
        Image backImage;
        int rows = this.parser.getRowCount();
        int cols = this.parser.getColCount();
        if (cols != this.cellX[0].length || rows != this.cellX.length) {
            this.cellX = new int[rows][cols];
            this.cellW = new int[rows][cols];
            this.cellY = new int[rows][cols];
            this.cellH = new int[rows][cols];
        }
        this.clearCoordinate();
        int i = 0;
        while (i < this.al_subReport.size()) {
            JComponent jc = (JComponent)this.al_subReport.get(i);
            this.remove(jc);
            ++i;
        }
        while (this.al_subReport.size() > 0) {
            this.al_subReport.remove(0);
        }
        if (this.isEditing) {
            this.startCol = 1;
            this.startRow = 1;
            this.endRow = rows - 1;
            this.endCol = cols - 1;
        }
        g.clearRect(0, 0, 99999, 999999);
        Rectangle displayWin = null;
        if (this.onlyDrawCellInWin) {
            if (this.location == 1) {
                displayWin = this.jsp.getViewport().getViewRect();
            } else if (this.location == 2) {
                displayWin = this.jsp.getColumnHeader().getViewRect();
            } else if (this.location == 3) {
                displayWin = this.jsp.getRowHeader().getViewRect();
            }
        }
        if (!this.isEditing) {
            g.setColor(Color.white);
            if (this.onlyDrawCellInWin) {
                g.fillRect(displayWin.x, displayWin.y, displayWin.width + 5, displayWin.height + 5);
            } else {
                Dimension d = this.getPreferredSize();
                g.fillRect(0, 0, d.width + 5, d.height + 5);
            }
        }
        boolean hasBackImage = false;
        if (this.jsp != null && this.jsp instanceof ReportControl && (backImage = ((ReportControl)this.jsp).getBackImage()) != null) {
            hasBackImage = true;
            g.drawImage(backImage, 1, 1, null);
        }
        int x = 0;
        int y = 1;
        int drawStartRow = this.startRow;
        if (displayWin != null && displayWin.y > 1) {
            int i2 = this.startRow;
            while (i2 < this.endRow) {
                if (this.isEditing || this.parser.isRowVisible(i2)) {
                    int rh = this.parser.getRowHeight(i2);
                    if (y + rh > displayWin.y) break;
                    y += rh;
                }
                ++i2;
            }
            drawStartRow = i2;
            int backY = 0;
            int col = this.startCol;
            while (col <= this.endCol) {
                int row1;
                if (this.parser.isMerged(i2, col) && this.parser.isMergedLeftCell(i2, col) && (row1 = this.parser.getMergedStartRow(i2, col)) != i2) {
                    int tmpY = 0;
                    int r = row1;
                    while (r < i2) {
                        if (this.isEditing || this.parser.isRowVisible(r)) {
                            tmpY += this.parser.getRowHeight(r);
                        }
                        ++r;
                    }
                    if (tmpY > backY) {
                        drawStartRow = row1;
                        backY = tmpY;
                    }
                }
                ++col;
            }
            y -= backY;
        }
        Field pageHeader = this.parser.getPageHeader();
        Field pageFooter = this.parser.getPageFooter();
        int row = drawStartRow;
        while (row <= this.endRow) {
            if (displayWin != null && y >= displayWin.y + displayWin.height) break;
            if (this.isEditing || this.parser.isRowVisible(row)) {
                x = 1;
                int col = this.startCol;
                while (col <= this.endCol) {
                    if (displayWin != null && x >= displayWin.x + displayWin.width) break;
                    if (this.isEditing || this.parser.isColVisible(col)) {
                        int colWidth = this.parser.getColWidth(col);
                        if (this.parser.isMerged(row, col) && !this.parser.isMergedFirstCell(row, col)) {
                            x += colWidth;
                        } else {
                            int width = this.parser.getMergedWidth(row, col, this.isEditing);
                            int height = this.parser.getMergedHeight(row, col, this.isEditing);
                            if (displayWin != null && x + width <= displayWin.x) {
                                x += colWidth;
                            } else if (displayWin != null && y + height <= displayWin.y) {
                                x += colWidth;
                            } else {
                                ImageIcon icon;
                                Integer dataType;
                                this.cellX[row][col] = x;
                                this.cellW[row][col] = width;
                                this.cellY[row][col] = y;
                                this.cellH[row][col] = height;
                                Object obj = this.parser.getPropertyValue(row, col, 4413);
                                Color bkcolor = Color.white;
                                if (obj != null) {
                                    bkcolor = new Color(Integer.parseInt(obj.toString()), true);
                                }
                                if (this.isEditing && ((Integer)(obj = this.parser.getPropertyValue(row, col, 4101))).intValue() == CellPropertyDefine.CDT_BLANK.intValue()) {
                                    bkcolor = Color.lightGray;
                                }
                                if (!hasBackImage) {
                                    g.setColor(bkcolor);
                                    g.fillRect(x, y, width, height);
                                }
                                if ((dataType = (Integer)this.parser.getPropertyValue(row, col, 4101)) == null) {
                                    dataType = CellPropertyDefine.CDT_TEXT;
                                }
                                if (dataType.intValue() == CellPropertyDefine.CDT_TEXT.intValue()) {
                                    Object lean = this.parser.getPropertyValue(row, col, 4414);
                                    if (lean == null || ((Integer)lean).intValue() == CellPropertyDefine.CLL_NONE.intValue()) {
                                        this.drawText(g, row, col, x, y, width, height);
                                    } else {
                                        new LeanLine(this.parser, row, col).draw(g, x, y, width, height);
                                    }
                                } else if (dataType.intValue() == CellPropertyDefine.CDT_HTML.intValue() && this.isEditing) {
                                    this.drawText(g, row, col, x, y, width, height);
                                } else if (dataType.intValue() == CellPropertyDefine.CDT_SUBREPORT.intValue()) {
                                    Object sub = this.parser.getPropertyValue(row, col, 4102);
                                    if (sub instanceof CellSet) {
                                        if (this.isEditing || this.parser.isCellVisible(row, col)) {
                                            this.drawSubReport((CellSet)sub, row, col, x + 1, y + 1, width - 2, height - 2);
                                        }
                                    } else {
                                        icon = this.getImageIcon("/com/runqian/report/ide/resources/rs_subreport.gif");
                                        if (icon != null) {
                                            g.drawImage(icon.getImage(), x, y, width, height, null);
                                        }
                                    }
                                } else {
                                    Image image = null;
                                    icon = null;
                                    if (this.isEditing) {
                                        if (dataType.intValue() == CellPropertyDefine.CDT_PIC_DB.intValue()) {
                                            this.drawText(g, row, col, x, y, width, height);
                                        } else if (dataType.intValue() == CellPropertyDefine.CDT_PIC_FILE.intValue()) {
                                            icon = this.getImageIcon("/com/runqian/report/ide/resources/app_logo.jpg");
                                        } else if (dataType.intValue() == CellPropertyDefine.CDT_GRAPH.intValue()) {
                                            String imageUrl = "/com/runqian/report/ide/resources/graph_col.gif";
                                            String exp = this.parser.getPropertyExpression(row, col, 4102);
                                            if (exp != null && exp.trim().length() > 0) {
                                                exp = exp.substring(exp.indexOf("(") + 1, exp.length() - 1);
                                                exp = Escape.removeEscAndQuote(exp);
                                            }
                                            String graphType = new GraphProperty(exp).getPropertyValue("type");
                                            try {
                                                imageUrl = GraphUtils.getGraphIcon(Integer.parseInt(graphType));
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            icon = this.getImageIcon(imageUrl);
                                        }
                                        if (icon != null) {
                                            image = icon.getImage();
                                        }
                                    } else if (this.parser.isCellVisible(row, col)) {
                                        obj = this.parser.getPropertyValue(row, col, 4102);
                                        if (obj != null && obj instanceof byte[]) {
                                            icon = new ImageIcon((byte[])obj);
                                            image = icon.getImage();
                                        }
                                    } else {
                                        image = null;
                                    }
                                    if (image != null) {
                                        if (this.isEditing || dataType.intValue() == CellPropertyDefine.CDT_GRAPH.intValue()) {
                                            g.drawImage(image, x, y, width, height, null);
                                        } else {
                                            this.drawImage(g, image, row, col, x, y, width, height);
                                        }
                                    }
                                }
                                CellBorder border = new CellBorder(g, this.parser, row, col, this.isEditing);
                                border.setPageHeaderAndFooter(pageHeader, pageFooter);
                                border.drawBorder(x, y, width, height);
                                x += colWidth;
                            }
                        }
                    }
                    ++col;
                }
                y += this.parser.getRowHeight(row);
            }
            ++row;
        }
        this.drawSelectedBox(g);
        this.submitEditor();
        this.initEditor();
        if (this.isEditing) {
            PageFormat pf = this.parser.getPageFormat();
            Graphics2D g2d = (Graphics2D)g;
            Stroke bsOld = g2d.getStroke();
            float[] dash = new float[]{2.0f, 2.0f};
            BasicStroke bs = new BasicStroke(0.75f, 0, 0, 1.0f, dash, 0.0f);
            g2d.setColor(Color.darkGray);
            g2d.setStroke(bs);
            int ww = (int)pf.getImageableWidth() - 1;
            int hh = (int)pf.getImageableHeight() - 1;
            g2d.drawLine(ww, 0, ww, hh);
            g2d.drawLine(0, hh, ww, hh);
            g2d.setStroke(bsOld);
        }
        g.dispose();
    }

    private void drawText(Graphics g, int row, int col, int x, int y, int w, int h) {
        String text = ControlUtils.getCellText(this.parser, row, col, this.isEditing);
        Font font = this.getFont(row, col);
        boolean wordWrap = false;
        Object value = this.parser.getPropertyValue(row, col, 4107);
        if (value != null && ((Boolean)value).booleanValue()) {
            wordWrap = true;
        }
        int align = CellPropertyDefine.CA_LEFT;
        value = this.parser.getPropertyValue(row, col, 4201);
        if (value != null) {
            align = Integer.parseInt(value.toString());
        }
        int valign = CellPropertyDefine.CVA_MIDDLE;
        value = this.parser.getPropertyValue(row, col, 4202);
        if (value != null) {
            valign = Integer.parseInt(value.toString());
        }
        int indent = CellPropertyDefine.DEFAULT_INDENT;
        value = this.parser.getPropertyValue(row, col, 4203);
        if (value != null) {
            indent = Integer.parseInt(value.toString());
        }
        Color c = Color.black;
        value = this.parser.getPropertyValue(row, col, 4303);
        if (value != null) {
            c = new Color(Integer.parseInt(value.toString()), true);
        }
        boolean underLine = false;
        value = this.parser.getPropertyValue(row, col, 4306);
        if (value != null && ((Boolean)value).booleanValue()) {
            underLine = true;
        }
        ControlUtils.drawText(g, text, x, y, w, h, wordWrap, underLine, align, valign, indent, font, c);
    }

    private void drawSubReport(CellSet sub, int row, int col, int x, int y, int w, int h) {
        ContentPanel subPanel = new ContentPanel(sub, 1, sub.getRow() - 1, 1, sub.getColumn() - 1, false, false, null, this.editable, null, null, null, 1);
        int subw = subPanel.getPreferredSize().width;
        int subh = subPanel.getPreferredSize().height;
        subw = subw > w ? w : subw;
        subh = subh > h ? h : subh;
        int x1 = x;
        int y1 = y;
        int align = (Integer)this.parser.getPropertyValue(row, col, 4201);
        if (align == CellPropertyDefine.CA_CENTER) {
            x1 = x + (w - subw) / 2;
        } else if (align == CellPropertyDefine.CA_RIGHT) {
            x1 = x + w - subw;
        }
        int valign = (Integer)this.parser.getPropertyValue(row, col, 4202);
        if (valign == CellPropertyDefine.CVA_MIDDLE) {
            y1 = y + (h - subh) / 2;
        } else if (valign == CellPropertyDefine.CVA_BOTTOM) {
            y1 = y + h - subh;
        }
        JScrollPane jsp = new JScrollPane(21, 31);
        jsp.setViewportView(subPanel);
        jsp.setBounds(x1, y1, subw, subh);
        this.add(jsp);
        jsp.setBorder(null);
        this.al_subReport.add(jsp);
    }

    private void drawImage(Graphics g, Image image, int row, int col, int x, int y, int w, int h) {
        int iw = image.getWidth(null);
        int ih = image.getHeight(null);
        int x1 = x;
        int y1 = y;
        int align = (Integer)this.parser.getPropertyValue(row, col, 4201);
        if (align == CellPropertyDefine.CA_CENTER) {
            x1 = x + (w - iw) / 2;
        } else if (align == CellPropertyDefine.CA_RIGHT) {
            x1 = x + w - iw;
        }
        int valign = (Integer)this.parser.getPropertyValue(row, col, 4202);
        if (valign == CellPropertyDefine.CVA_MIDDLE) {
            y1 = y + (h - ih) / 2;
        } else if (valign == CellPropertyDefine.CVA_BOTTOM) {
            y1 = y + h - ih;
        }
        g.drawImage(image, x1, y1, iw, ih, null);
    }

    private void drawSelectedBox(Graphics g) {
        int i;
        if (!this.isEditing) {
            return;
        }
        ReportControl control = (ReportControl)this.jsp;
        if (control.m_selectedRegion == null) {
            return;
        }
        if (this.m_activeCell != null && (this.m_activeCell.getRow() >= this.parser.getRowCount() || this.m_activeCell.getColumn() >= this.parser.getColCount())) {
            this.m_activeCell = new CellPosition(1, 1);
        }
        int startRow = control.m_selectedRegion.getTop();
        int endRow = control.m_selectedRegion.getBottom();
        int startCol = control.m_selectedRegion.getLeft();
        int endCol = control.m_selectedRegion.getRight();
        int rows = control.m_parser.getRowCount();
        int cols = control.m_parser.getColCount();
        if (startRow >= rows || startCol >= cols) {
            control.m_selectedCols = null;
            control.m_selectedRows = null;
            if (this.m_activeCell != null) {
                control.m_selectedRegion = new CellRegion(this.m_activeCell, this.m_activeCell);
                startRow = control.m_selectedRegion.getTop();
                endRow = control.m_selectedRegion.getBottom();
                startCol = control.m_selectedRegion.getLeft();
                endCol = control.m_selectedRegion.getRight();
                control.fireRegionSelect();
            } else {
                control.m_selectedRegion = null;
                control.fireRegionSelect();
                return;
            }
        }
        boolean refireRegion = false;
        if (endRow >= rows) {
            refireRegion = true;
            endRow = rows - 1;
            if (control.m_selectedRows != null) {
                control.m_selectedRows = new Vector();
                i = startRow;
                while (i <= endRow) {
                    control.m_selectedRows.add(new Integer(i));
                    ++i;
                }
            }
        }
        if (endCol >= cols) {
            refireRegion = true;
            endCol = cols - 1;
            if (control.m_selectedCols != null) {
                control.m_selectedCols = new Vector();
                i = startCol;
                while (i <= endCol) {
                    control.m_selectedCols.add(new Integer(i));
                    ++i;
                }
            }
        }
        if (refireRegion) {
            control.m_selectedRegion = new CellRegion(startRow, startCol, endRow, endCol);
            control.fireRegionSelect();
        }
        int width = 0;
        int height = 0;
        int row = startRow;
        while (row <= endRow) {
            height += control.m_parser.getRowHeight(row);
            ++row;
        }
        int col = startCol;
        while (col <= endCol) {
            width += control.m_parser.getColWidth(col);
            ++col;
        }
        int x = control.cellX[startCol];
        int y = control.cellY[startRow];
        g.setColor(Color.black);
        g.setXORMode(new Color(51, 0, 51));
        g.fillRect(x, y, width, height);
        if (this.m_activeCell != null) {
            int activeRow = this.m_activeCell.getRow();
            int activeCol = this.m_activeCell.getColumn();
            if (activeRow >= startRow && activeRow <= endRow && activeCol >= startCol && activeCol <= endCol) {
                g.fillRect(this.cellX[activeRow][activeCol], this.cellY[activeRow][activeCol], this.cellW[activeRow][activeCol], this.cellH[activeRow][activeCol]);
            }
        }
        BasicStroke bs = new BasicStroke(3.0f, 0, 0);
        Stroke bsOld = ((Graphics2D)g).getStroke();
        ((Graphics2D)g).setStroke(bs);
        g.setXORMode(new Color(204, 255, 0));
        g.setColor(Color.black);
        g.drawRect(x, y, width, height);
        g.setPaintMode();
        ((Graphics2D)g).setStroke(bsOld);
    }

    private void clearCoordinate() {
        int i = 0;
        while (i < this.cellX.length) {
            int j = 0;
            while (j < this.cellX[i].length) {
                this.cellX[i][j] = 0;
                this.cellY[i][j] = 0;
                this.cellW[i][j] = 0;
                this.cellH[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    private void initEditor() {
        String text;
        int col;
        if (!this.editable) {
            return;
        }
        if (this.m_activeCell == null) {
            return;
        }
        int row = this.m_activeCell.getRow();
        Object obj = this.parser.getPropertyValue(row, col = this.m_activeCell.getColumn(), 4101);
        if (obj == null) {
            obj = CellPropertyDefine.CDT_TEXT;
        }
        if (((Integer)obj).intValue() == CellPropertyDefine.CDT_GRAPH.intValue() || ((Integer)obj).intValue() == CellPropertyDefine.CDT_PIC_FILE.intValue() || !this.isEditing && ((Integer)obj).intValue() == CellPropertyDefine.CDT_PIC_DB.intValue() || ((Integer)obj).intValue() == CellPropertyDefine.CDT_SUBREPORT.intValue()) {
            if (this.editor != null) {
                this.editor.setVisible(false);
            }
            this.editor = null;
            return;
        }
        obj = this.parser.getPropertyValue(row, col, 4107);
        if (obj != null && ((Boolean)obj).booleanValue()) {
            if (this.editorType != 2 && this.editor != null) {
                this.editor.setVisible(false);
            }
            this.editorType = 2;
            this.editor = this.multiEditor;
        } else {
            if (this.editorType != 1 && this.editor != null) {
                this.editor.setVisible(false);
            }
            this.editorType = 1;
            this.editor = this.singleEditor;
        }
        this.editor.setVisible(true);
        this.editor.setBounds(this.cellX[row][col] + 2, this.cellY[row][col] + 2, this.cellW[row][col] - 3, this.cellH[row][col] - 3);
        if (!this.isEditing) {
            this.editor.requestFocus();
        }
        this.oldText = text = ControlUtils.getCellText(this.parser, row, col, this.isEditing);
        if (this.editor instanceof JTextField || this.editor instanceof JTextArea) {
            ((JTextComponent)this.editor).setText(text);
        }
        obj = this.parser.getPropertyValue(row, col, 4201);
        int align = CellPropertyDefine.CA_LEFT;
        if (obj != null && this.editor instanceof JTextField) {
            JTextField alignText = (JTextField)this.editor;
            align = (Integer)obj;
            if (align == CellPropertyDefine.CA_LEFT) {
                alignText.setHorizontalAlignment(2);
            }
            if (align == CellPropertyDefine.CA_CENTER) {
                alignText.setHorizontalAlignment(0);
            }
            if (align == CellPropertyDefine.CA_RIGHT) {
                alignText.setHorizontalAlignment(4);
            }
        }
        obj = this.parser.getPropertyValue(row, col, 4202);
        int valign = CellPropertyDefine.CVA_MIDDLE;
        if (obj != null) {
            valign = (Integer)obj;
            if (valign == CellPropertyDefine.CVA_TOP) {
                this.editor.setAlignmentY(0.0f);
            }
            if (valign == CellPropertyDefine.CVA_MIDDLE) {
                this.editor.setAlignmentY(0.5f);
            }
            if (valign == CellPropertyDefine.CVA_BOTTOM) {
                this.editor.setAlignmentY(1.0f);
            }
        }
        if ((obj = this.parser.getPropertyValue(row, col, 4413)) != null) {
            this.editor.setBackground(new Color(Integer.parseInt(obj.toString())));
        }
        if ((obj = this.parser.getPropertyValue(row, col, 4303)) != null) {
            this.editor.setForeground(new Color(Integer.parseInt(obj.toString()), true));
        }
        this.editor.setFont(this.getFont(row, col));
        obj = this.parser.getPropertyValue(row, col, 4306);
        boolean underLine = false;
        if (obj != null) {
            underLine = (Boolean)obj;
        }
        if (underLine && this.editor instanceof JTextComponent) {
            this.editor.setBorder(new UnderLineBorder());
        } else {
            this.editor.setBorder(null);
        }
        obj = this.parser.getPropertyValue(row, col, 4203);
        if (obj != null && this.editor instanceof JTextComponent) {
            int indent = Integer.parseInt(obj.toString());
            Border border = ((JTextComponent)this.editor).getBorder();
            int left = 0;
            int right = 0;
            if (align == CellPropertyDefine.CA_LEFT) {
                left = indent;
            } else if (align == CellPropertyDefine.CA_CENTER) {
                left = indent;
                right = indent;
            } else if (align == CellPropertyDefine.CA_RIGHT) {
                right = indent;
            }
            if (border instanceof UnderLineBorder) {
                this.editor.setBorder(new UnderLineBorder(left, right));
            } else {
                this.editor.setBorder(BorderFactory.createEmptyBorder(0, left, 0, right));
            }
        }
    }

    public void submitEditor() {
        if (this.editor == null) {
            return;
        }
        if (!this.editor.isVisible()) {
            return;
        }
        String text = ((JTextComponent)this.editor).getText();
        if (!text.equals(this.oldText)) {
            this.oldText = text;
            if (this.isEditing) {
                ((ReportControl)this.jsp).fireCellTextInput(this.m_activeCell, text);
            } else {
                this.cs.setPropertyValue(this.m_activeCell.getRow(), this.m_activeCell.getColumn(), 4105, text);
            }
        }
    }

    private Font getFont(int row, int col) {
        Object value = this.parser.getPropertyValue(row, col, 4301);
        String face = "\u5b8b\u4f53";
        if (value != null) {
            face = value.toString();
        }
        value = this.parser.getPropertyValue(row, col, 4302);
        int size = 12;
        if (value != null) {
            size = Integer.parseInt(value.toString());
        }
        int fontStyle = 0;
        value = this.parser.getPropertyValue(row, col, 4304);
        if (value != null && ((Boolean)value).booleanValue()) {
            ++fontStyle;
        }
        if ((value = this.parser.getPropertyValue(row, col, 4305)) != null && ((Boolean)value).booleanValue()) {
            fontStyle += 2;
        }
        return new Font(face, fontStyle, size);
    }

    void setActiveCell(CellPosition pos) {
        int col;
        if (pos == null) {
            return;
        }
        ReportControl control = (ReportControl)this.jsp;
        int row = pos.getRow();
        if (control.m_parser.isMerged(row, col = pos.getColumn())) {
            control.m_selectedRegion = new CellRegion(row, col, control.m_parser.getMergedEndRow(row, col), control.m_parser.getMergedEndCol(row, col));
            if (!control.m_selectedRegion.contains(new CellPosition(this.rememberedRow, col))) {
                this.rememberedRow = row;
            }
            if (!control.m_selectedRegion.contains(new CellPosition(row, this.rememberedCol))) {
                this.rememberedCol = col;
            }
        } else {
            control.m_selectedRegion = new CellRegion(row, col, row, col);
            this.rememberedRow = row;
            this.rememberedCol = col;
        }
        control.m_selectedCols = null;
        control.m_selectedRows = null;
        control.m_cornerSelected = false;
        control.fireRegionSelect();
        this.submitEditor();
        this.m_activeCell = pos;
        ControlUtils.scrollToVisible(control.getViewport(), control, row, col);
        control.repaint();
        this.requestFocus();
    }

    void toDownCell() {
        int col;
        if (this.m_activeCell == null) {
            return;
        }
        int row = this.m_activeCell.getRow();
        if (this.parser.isMerged(row, col = this.m_activeCell.getColumn())) {
            row = this.parser.getMergedEndRow(row, col) + 1;
            col = this.rememberedCol;
        } else {
            ++row;
        }
        if (row == this.cs.getRow()) {
            row = 1;
        }
        if (this.parser.isMerged(row, col)) {
            col = this.parser.getMergedStartCol(row, col);
        }
        this.setActiveCell(new CellPosition(row, col));
    }

    void toUpCell() {
        int col;
        if (this.m_activeCell == null) {
            return;
        }
        int row = this.m_activeCell.getRow();
        if (this.parser.isMerged(row, col = this.m_activeCell.getColumn())) {
            row = this.parser.getMergedStartRow(row, col) - 1;
            col = this.rememberedCol;
        } else {
            --row;
        }
        if (row == 0) {
            row = this.cs.getRow() - 1;
        }
        if (this.parser.isMerged(row, col)) {
            row = this.parser.getMergedStartRow(row, col);
            col = this.parser.getMergedStartCol(row, col);
        }
        this.setActiveCell(new CellPosition(row, col));
    }

    void toRightCell() {
        int col;
        if (this.m_activeCell == null) {
            return;
        }
        int row = this.m_activeCell.getRow();
        if (this.parser.isMerged(row, col = this.m_activeCell.getColumn())) {
            col = this.parser.getMergedEndCol(row, col) + 1;
            row = this.rememberedRow;
        } else {
            ++col;
        }
        if (col == this.cs.getColumn()) {
            col = 1;
        }
        if (this.parser.isMerged(row, col)) {
            row = this.parser.getMergedStartRow(row, col);
            col = this.parser.getMergedStartCol(row, col);
        }
        this.setActiveCell(new CellPosition(row, col));
    }

    void toLeftCell() {
        int col;
        if (this.m_activeCell == null) {
            return;
        }
        int row = this.m_activeCell.getRow();
        if (this.parser.isMerged(row, col = this.m_activeCell.getColumn())) {
            col = this.parser.getMergedStartCol(row, col) - 1;
            row = this.rememberedRow;
        } else {
            --col;
        }
        if (col == 0) {
            col = this.cs.getColumn() - 1;
        }
        if (this.parser.isMerged(row, col)) {
            row = this.parser.getMergedStartRow(row, col);
            col = this.parser.getMergedStartCol(row, col);
        }
        this.setActiveCell(new CellPosition(row, col));
    }

    public InputMethodRequests getInputMethodRequests() {
        return this;
    }

    public void inputMethodTextChanged(InputMethodEvent event) {
        int count = event.getCommittedCharacterCount();
        AttributedCharacterIterator text = event.getText();
        String composedText = "";
        if (text != null) {
            char c = text.first();
            while (count-- > 0) {
                composedText = String.valueOf(composedText) + String.valueOf(c);
                c = text.next();
            }
            if (this.editor != null && this.editor instanceof JTextComponent) {
                ((JTextComponent)this.editor).setText(composedText);
                this.editor.requestFocus();
            }
        }
        event.consume();
    }

    public void caretPositionChanged(InputMethodEvent event) {
    }

    public Rectangle getTextLocation(TextHitInfo offset) {
        return new Rectangle(0, 0);
    }

    public TextHitInfo getLocationOffset(int x, int y) {
        return null;
    }

    public int getInsertPositionOffset() {
        return 0;
    }

    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    public int getCommittedTextLength() {
        return 0;
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    public void dispose() {
        this.cs = null;
        this.parser = null;
        this.jsp = null;
        this.cellX = null;
        this.cellY = null;
        this.cellW = null;
        this.cellH = null;
        this.singleEditor = null;
        this.multiEditor = null;
        this.editor = null;
    }

    private ImageIcon getImageIcon(String filePath) {
        try {
            InputStream is = this.getClass().getResourceAsStream(filePath.toLowerCase());
            byte[] bt = ControlUtils.getStreamBytes(is);
            is.close();
            ImageIcon ii = new ImageIcon(bt);
            return ii;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

