/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.IntHashtable;
import com.runqian.base.util.StringUtils;
import com.runqian.report.cellset.CellPosition;
import com.runqian.report.cellset.CellProperty;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellRegion;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.control.ContentPanel;
import com.runqian.report.control.ReportControl;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JViewport;

public class ControlUtils {
    public static CellRegion adjustCellRegion(ReportControl control, CellRegion region) {
        int startRow = region.getTop();
        int endRow = region.getBottom();
        int startCol = region.getLeft();
        int endCol = region.getRight();
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                if (control.m_parser.isMerged(row, col)) {
                    int top = control.m_parser.getMergedStartRow(row, col);
                    if (top < startRow) {
                        region = new CellRegion(top, startCol, endRow, endCol);
                        return ControlUtils.adjustCellRegion(control, region);
                    }
                    int left = control.m_parser.getMergedStartCol(row, col);
                    if (left < startCol) {
                        region = new CellRegion(startRow, left, endRow, endCol);
                        return ControlUtils.adjustCellRegion(control, region);
                    }
                    int right = control.m_parser.getMergedEndCol(row, col);
                    if (right > endCol) {
                        region = new CellRegion(startRow, startCol, endRow, right);
                        return ControlUtils.adjustCellRegion(control, region);
                    }
                    int bottom = control.m_parser.getMergedEndRow(row, col);
                    if (bottom > endRow) {
                        region = new CellRegion(startRow, startCol, bottom, endCol);
                        return ControlUtils.adjustCellRegion(control, region);
                    }
                }
                ++col;
            }
            ++row;
        }
        return region;
    }

    public static boolean scrollToVisible(JViewport viewport, ReportControl control, int row, int col) {
        Rectangle viewArea = viewport.getViewRect();
        Rectangle fieldArea = new Rectangle();
        fieldArea.x = control.cellX[col];
        fieldArea.y = control.cellY[row];
        if (row == 0) {
            fieldArea.width = control.cellW[col];
            fieldArea.height = 20;
        } else if (col == 0) {
            fieldArea.width = 40;
            fieldArea.height = control.cellH[row];
        } else {
            fieldArea.width = control.m_parser.getMergedWidth(row, col, true);
            fieldArea.height = control.m_parser.getMergedHeight(row, col, true);
        }
        if (viewArea.contains(fieldArea)) {
            return false;
        }
        Point pos = new Point();
        pos.x = viewArea.x;
        if (fieldArea.x + fieldArea.width > viewArea.x + viewArea.width) {
            pos.x = fieldArea.x + fieldArea.width - viewArea.width + 5;
        }
        int n = pos.x = pos.x > fieldArea.x ? fieldArea.x - 5 : pos.x;
        if (pos.x + viewArea.width > viewport.getView().getWidth()) {
            pos.x = viewport.getView().getWidth() - viewArea.width;
        }
        pos.y = viewArea.y;
        if (fieldArea.y + fieldArea.height > viewArea.y + viewArea.height) {
            pos.y = fieldArea.y + fieldArea.height - viewArea.height + 5;
        }
        int n2 = pos.y = pos.y > fieldArea.y ? fieldArea.y - 5 : pos.y;
        if (pos.y + viewArea.height > viewport.getView().getHeight()) {
            pos.y = viewport.getView().getHeight() - viewArea.height;
        }
        viewport.setViewPosition(pos);
        return true;
    }

    public static void drawHeader(Graphics g, int x, int y, int w, int h, String label, Color backColor, int flag) {
        Font font = new Font("\u5b8b\u4f53", 0, 12);
        Color fontColor = Color.black;
        switch (flag) {
            case 1: {
                font = new Font("\u5b8b\u4f53", 1, 12);
                backColor = new Color(128, 160, 192);
                break;
            }
            case 2: {
                font = new Font("\u5b8b\u4f53", 1, 12);
                fontColor = Color.white;
                backColor = new Color(153, 153, 102);
            }
        }
        g.setFont(font);
        g.setColor(backColor);
        g.fillRect(x, y, w, h);
        g.setColor(new Color(236, 236, 236));
        g.drawLine(x, y, x + w, y);
        g.drawLine(x, y, x, y + h);
        g.setColor(Color.darkGray);
        g.drawLine(x + w, y + h, x, y + h);
        g.drawLine(x + w, y + h, x + w, y);
        g.setColor(fontColor);
        int fontW = g.getFontMetrics(font).stringWidth(label);
        g.drawString(label, x + (w - fontW) / 2, y + h / 2 + 5);
    }

    public static String getCellText(CellSetParser parser, int row, int col, boolean isEditing) {
        CellProperty cp;
        String textValue = null;
        IntHashtable props = parser.getPropertyMap(row, col);
        if (props == null) {
            return "";
        }
        Object visible = parser.getPropertyValue(row, col, 4106);
        if (!isEditing) {
            if (visible != null && !((Boolean)visible).booleanValue()) {
                return "";
            }
            textValue = (String)parser.getPropertyValue(row, col, 4105);
            if (textValue != null && textValue.trim().length() > 0) {
                return textValue;
            }
        }
        if ((cp = (CellProperty)props.get(4102)) != null) {
            String exp = cp.getPropertyExpression();
            if (exp != null && exp.trim().length() > 0) {
                textValue = "=" + exp;
            } else {
                Object value = parser.getPropertyValue(row, col, 4102);
                if (value != null) {
                    if (value instanceof byte[]) {
                        try {
                            textValue = new String((byte[])value, "GBK");
                        }
                        catch (Exception exception) {}
                    } else {
                        textValue = value.toString();
                    }
                }
            }
            if (textValue != null && textValue.length() > 0) {
                return textValue;
            }
        }
        return "";
    }

    public static void drawText(Graphics g, String text, int x, int y, int w, int h, boolean wordWrap, boolean underLine, int align, int valign, int indent, Font font, Color c) {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        g.setColor(c);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
        if (align == CellPropertyDefine.CA_CENTER) {
            x += indent;
            w -= indent * 2;
        } else if (align == CellPropertyDefine.CA_LEFT) {
            x += indent;
            w -= indent;
        } else if (align == CellPropertyDefine.CA_RIGHT) {
            w -= indent;
        }
        y += 3;
        h -= 6;
        int fw = fm.stringWidth(text);
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        if (!wordWrap) {
            if (fw > w) {
                text = ControlUtils.getCanDisplayText(text, fm, w);
                fw = fm.stringWidth(text);
            }
            int x1 = x;
            if (align == CellPropertyDefine.CA_CENTER) {
                x1 = x + (w - fw) / 2;
            } else if (align == CellPropertyDefine.CA_RIGHT) {
                x1 = x + w - fw;
            }
            int y1 = y + ascent;
            if (valign == CellPropertyDefine.CVA_MIDDLE) {
                y1 = y + (h - ascent - descent) / 2 + ascent;
            } else if (valign == CellPropertyDefine.CVA_BOTTOM) {
                y1 = y + h - descent;
            }
            ControlUtils.drawText(g, text, x1, y1, fw, descent, underLine);
        } else {
            ArrayList al = ControlUtils.wrapString(text, fm, w);
            int leading = fm.getLeading();
            int lineH = ascent + descent + leading;
            int yy = y;
            if (valign == CellPropertyDefine.CVA_MIDDLE) {
                yy = y + (h - lineH * al.size()) / 2;
            } else if (valign == CellPropertyDefine.CVA_BOTTOM) {
                yy = y + h - lineH * al.size();
            }
            if (yy < y) {
                yy = y;
            }
            int i = 0;
            while (i < al.size()) {
                if (yy > y + h) break;
                String wrapedText = (String)al.get(i);
                fw = fm.stringWidth(wrapedText);
                int x1 = x;
                if (align == CellPropertyDefine.CA_CENTER) {
                    x1 = x + (w - fw) / 2;
                } else if (align == CellPropertyDefine.CA_RIGHT) {
                    x1 = x + w - fw;
                }
                int y1 = yy + ascent;
                ControlUtils.drawText(g, wrapedText, x1, y1, fw, descent, underLine);
                yy += lineH;
                ++i;
            }
        }
    }

    private static void drawText(Graphics g, String text, int x, int y, int w, int descent, boolean underLine) {
        if (text == null || text.length() == 0) {
            return;
        }
        g.drawString(text, x, y);
        if (underLine) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke bsOld = g2d.getStroke();
            g2d.setStroke(new BasicStroke(0.75f));
            g2d.setPaintMode();
            g2d.drawLine(x, y + descent, x + w, y + descent);
            g2d.setStroke(bsOld);
        }
    }

    private static String getCanDisplayText(String text, FontMetrics fm, int w) {
        String newText = text;
        while (fm.stringWidth(newText) > w) {
            if (newText.trim().length() == 0) {
                return "";
            }
            newText = newText.substring(0, newText.length() - 1);
        }
        return newText;
    }

    public static ArrayList wrapString(String text, FontMetrics fm, int w) {
        ArrayList<String> al = new ArrayList<String>();
        text = StringUtils.replace(text, "\\n", "\n");
        ArgumentTokenizer at = new ArgumentTokenizer(text, '\n', true, true, true);
        while (at.hasNext()) {
            String line = at.next();
            int len = line.length();
            String tmp = "";
            int i = 0;
            while (i < len) {
                char c = line.charAt(i);
                if (fm.stringWidth(tmp = String.valueOf(tmp) + String.valueOf(c)) > w) {
                    al.add(tmp.substring(0, tmp.length() - 1));
                    tmp = String.valueOf(c);
                }
                ++i;
            }
            al.add(tmp);
        }
        return al;
    }

    public static int lookupHeaderIndex(int curr, int[] start, int[] len) {
        int i = 1;
        while (i < start.length) {
            if (curr > start[i] && curr <= start[i] + len[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static CellPosition lookupCellPosition(int x, int y, ContentPanel panel) {
        int i = 1;
        while (i < panel.cellX.length) {
            int j = 1;
            while (j < panel.cellX[i].length) {
                if (y > panel.cellY[i][j] && y <= panel.cellY[i][j] + panel.cellH[i][j] && x > panel.cellX[i][j] && x <= panel.cellX[i][j] + panel.cellW[i][j]) {
                    return new CellPosition(i, j);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static byte[] getStreamBytes(InputStream is) throws Exception {
        ArrayList<byte[]> al = new ArrayList<byte[]>();
        int totalBytes = 0;
        byte[] b = new byte[102400];
        int readBytes = 0;
        while ((readBytes = is.read(b)) > 0) {
            byte[] bb = new byte[readBytes];
            System.arraycopy(b, 0, bb, 0, readBytes);
            al.add(bb);
            totalBytes += readBytes;
        }
        b = new byte[totalBytes];
        int pos = 0;
        int i = 0;
        while (i < al.size()) {
            byte[] bb = (byte[])al.get(i);
            System.arraycopy(bb, 0, b, pos, bb.length);
            pos += bb.length;
            ++i;
        }
        return b;
    }
}

