/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.base.util.Sentence;
import com.runqian.report.cellset.CellPosition;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellRegion;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.control.CellSelectListener;
import com.runqian.report.control.ColHeaderListener;
import com.runqian.report.control.ColHeaderPanel;
import com.runqian.report.control.ContentPanel;
import com.runqian.report.control.ControlUtils;
import com.runqian.report.control.CornerListener;
import com.runqian.report.control.CornerPanel;
import com.runqian.report.control.ReportControl;
import com.runqian.report.control.RowHeaderListener;
import com.runqian.report.control.RowHeaderPanel;
import javax.swing.JPanel;

public class EditControl
extends ReportControl {
    private String searchString = "";
    private String replaceString = "";
    private int searchFlag;
    private boolean searchInExp;
    private int valueKeyIndex = 0;
    private int expKeyIndex = 0;
    private int stringIndex = -1;
    private int searchedRow = -1;
    private int searchedCol = -1;
    private boolean searchSelectedCells;
    private int replaceAllStartRow = 0;
    private int replaceAllStartCol = 0;

    public EditControl(int rows, int cols) {
        super(rows, cols);
    }

    JPanel createCorner() {
        CornerPanel panel = new CornerPanel(this);
        CornerListener listener = new CornerListener(this);
        panel.addMouseListener(listener);
        return panel;
    }

    JPanel createColHeaderView() {
        ColHeaderPanel panel = new ColHeaderPanel(this);
        ColHeaderListener listener = new ColHeaderListener(this);
        panel.addMouseListener(listener);
        panel.addMouseMotionListener(listener);
        return panel;
    }

    JPanel createRowHeaderView() {
        RowHeaderPanel panel = new RowHeaderPanel(this);
        RowHeaderListener listener = new RowHeaderListener(this);
        panel.addMouseListener(listener);
        panel.addMouseMotionListener(listener);
        return panel;
    }

    ContentPanel createContentView() {
        ContentPanel panel = new ContentPanel(this.m_cellSet, 1, this.m_parser.getRowCount() - 1, 1, this.m_parser.getColCount() - 1, true, true, this, true, null, null, null, 1);
        CellSelectListener listener = new CellSelectListener(this, panel);
        panel.addMouseListener(listener);
        panel.addMouseMotionListener(listener);
        panel.addKeyListener(listener);
        return panel;
    }

    public void setSearchConfig(String searchString, String replaceString, boolean caseSensitive, boolean onlyWorld, boolean searchInExp) {
        this.searchString = searchString;
        this.replaceString = replaceString;
        this.searchInExp = searchInExp;
        this.searchFlag = 18;
        if (!caseSensitive) {
            ++this.searchFlag;
        }
        if (onlyWorld) {
            this.searchFlag += 8;
        }
    }

    public boolean search() {
        return this.search(false);
    }

    public boolean replace() {
        return this.replace(false);
    }

    public int replaceAll() {
        int count = 0;
        while (this.replace(true)) {
            ++count;
        }
        this.replaceAllStartRow = 0;
        this.replaceAllStartCol = 0;
        return count;
    }

    private boolean replace(boolean replaceAll) {
        if (this.search(replaceAll)) {
            if (this.searchInExp) {
                int propId = CellPropertyDefine.searchExpKeys[this.expKeyIndex];
                String exp = this.getCellPropertyExpression(this.searchedRow, this.searchedCol, propId);
                exp = Sentence.replace(exp, this.stringIndex, this.searchString, this.replaceString, this.searchFlag + 4);
                this.setCellPropertyExpression(this.searchedRow, this.searchedCol, propId, exp);
            } else {
                int propId = CellPropertyDefine.searchValueKeys[this.valueKeyIndex];
                String value = (String)this.getCellPropertyValue(this.searchedRow, this.searchedCol, propId);
                value = Sentence.replace(value, this.stringIndex, this.searchString, this.replaceString, this.searchFlag + 4);
                this.setCellPropertyValue(this.searchedRow, this.searchedCol, propId, value);
            }
            this.stringIndex += this.replaceString.length() - 1;
            return true;
        }
        return false;
    }

    private boolean search(boolean replaceAll) {
        int startRow = 1;
        int startCol = 1;
        int endRow = this.getCellSet().getRow() - 1;
        int endCol = this.getCellSet().getColumn() - 1;
        if (this.m_selectedRegion != null && (this.m_selectedRegion.getWidth() > 1 || this.m_selectedRegion.getHeight() > 1)) {
            startRow = this.m_selectedRegion.getTop();
            startCol = this.m_selectedRegion.getLeft();
            endRow = this.m_selectedRegion.getBottom();
            endCol = this.m_selectedRegion.getRight();
            this.searchSelectedCells = true;
        }
        int activeRow = startRow;
        int activeCol = startCol;
        if (this.contentView.m_activeCell != null) {
            activeRow = this.contentView.m_activeCell.getRow();
            activeCol = this.contentView.m_activeCell.getCol();
        }
        boolean found = false;
        if (!replaceAll) {
            found = this.search(activeRow, activeCol, activeRow, endCol, replaceAll);
            if (found) {
                return true;
            }
            found = this.search(activeRow + 1, startCol, endRow, endCol, replaceAll);
            if (found) {
                return true;
            }
            found = this.search(startRow, startCol, activeRow - 1, endCol, replaceAll);
            if (found) {
                return true;
            }
            found = this.search(activeRow, startCol, activeRow, activeCol - 1, replaceAll);
            if (found) {
                return true;
            }
        } else {
            found = this.search(this.replaceAllStartRow, this.replaceAllStartCol, this.replaceAllStartRow, endCol, replaceAll);
            if (found) {
                return true;
            }
            found = this.search(this.replaceAllStartRow + 1, 0, endRow, endCol, replaceAll);
            if (found) {
                return true;
            }
        }
        return false;
    }

    private boolean search(int startRow, int startCol, int endRow, int endCol, boolean replaceAll) {
        CellSetParser parser = new CellSetParser(this.getCellSet());
        boolean found = false;
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                if (!parser.isMerged(row, col) || parser.isMergedFirstCell(row, col)) {
                    int propId;
                    int i;
                    if (this.searchInExp) {
                        i = this.expKeyIndex;
                        while (i < CellPropertyDefine.searchExpKeys.length) {
                            propId = CellPropertyDefine.searchExpKeys[i];
                            String exp = this.getCellPropertyExpression(row, col, propId);
                            if (exp == null) {
                                this.stringIndex = -1;
                            } else {
                                this.stringIndex = Sentence.indexOf(exp, this.searchString, this.stringIndex + 1, this.searchFlag);
                                if (this.stringIndex >= 0) {
                                    found = true;
                                    this.expKeyIndex = i;
                                    break;
                                }
                            }
                            ++i;
                        }
                    } else {
                        i = this.valueKeyIndex;
                        while (i < CellPropertyDefine.searchValueKeys.length) {
                            propId = CellPropertyDefine.searchValueKeys[i];
                            String value = (String)this.getCellPropertyValue(row, col, propId);
                            if (value == null) {
                                this.stringIndex = -1;
                            } else {
                                this.stringIndex = Sentence.indexOf(value, this.searchString, this.stringIndex + 1, this.searchFlag);
                                if (this.stringIndex >= 0) {
                                    found = true;
                                    this.valueKeyIndex = i;
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                    if (found) {
                        this.searchedRow = row;
                        this.searchedCol = col;
                        this.replaceAllStartRow = row;
                        this.replaceAllStartCol = col;
                        if (!replaceAll) {
                            this.contentView.m_activeCell = new CellPosition(row, col);
                            ControlUtils.scrollToVisible(this.getViewport(), this, row, col);
                            if (!this.searchSelectedCells) {
                                this.m_selectedRegion = new CellRegion(row, col, row, col);
                                this.fireRegionSelect();
                            }
                            this.repaint();
                        }
                        return true;
                    }
                    this.expKeyIndex = 0;
                    this.valueKeyIndex = 0;
                }
                ++col;
            }
            ++row;
        }
        return false;
    }
}

