/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.report.cellset.CellPosition;
import com.runqian.report.control.ContentPanel;
import com.runqian.report.control.ControlUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JOptionPane;

public class HyperLinkListener
implements MouseListener,
MouseMotionListener {
    private ContentPanel cp;
    private String appmap;
    private JApplet applet;
    private Color mouseOnLinkColor;
    private Color oldColor;
    private int mouseInRow = -1;
    private int mouseInCol = -1;
    private boolean isLink = false;
    private String linkUrl = "";
    private String linkTarget = "";

    public HyperLinkListener(ContentPanel cp, String appmap, JApplet applet, Color mouseOnLinkColor) {
        this.cp = cp;
        this.appmap = appmap;
        this.applet = applet;
        this.mouseOnLinkColor = mouseOnLinkColor;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        try {
            if (this.isLink) {
                this.applet.getAppletContext().showDocument(new URL(this.linkUrl), this.linkTarget);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "\u9519\u8bef\uff1a" + ex.getMessage());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        CellPosition pos = ControlUtils.lookupCellPosition(e.getX(), e.getY(), this.cp);
        if (pos == null) {
            this.cp.setCursor(Cursor.getPredefinedCursor(0));
            if (this.isLink) {
                this.cp.cs.setPropertyValue(this.mouseInRow, this.mouseInCol, 4303, new Integer(this.oldColor.getRGB()));
                this.cp.repaint();
                this.mouseInRow = -1;
                this.mouseInCol = -1;
                this.isLink = false;
            }
            return;
        }
        if (pos.getRow() == this.mouseInRow && pos.getColumn() == this.mouseInCol) {
            return;
        }
        boolean needRepaint = false;
        if (this.isLink) {
            this.cp.cs.setPropertyValue(this.mouseInRow, this.mouseInCol, 4303, new Integer(this.oldColor.getRGB()));
            needRepaint = true;
        }
        this.mouseInRow = pos.getRow();
        this.mouseInCol = pos.getColumn();
        Object obj = this.cp.cs.getPropertyValue(this.mouseInRow, this.mouseInCol, 4701);
        if (obj == null || obj.toString().trim().length() == 0) {
            this.isLink = false;
            this.cp.setCursor(Cursor.getPredefinedCursor(0));
            this.linkUrl = "";
        } else {
            this.isLink = true;
            this.cp.setCursor(Cursor.getPredefinedCursor(12));
            this.linkUrl = obj.toString().trim();
            if (this.linkUrl.indexOf(":") < 0 && this.linkUrl.startsWith("/")) {
                this.linkUrl = String.valueOf(this.appmap) + this.linkUrl;
            }
            this.linkTarget = (obj = this.cp.cs.getPropertyValue(this.mouseInRow, this.mouseInCol, 4703)) == null || obj.toString().trim().length() == 0 ? "_self" : obj.toString().trim();
            obj = this.cp.cs.setPropertyValue(this.mouseInRow, this.mouseInCol, 4303, new Integer(this.mouseOnLinkColor.getRGB()));
            this.oldColor = obj == null ? Color.black : new Color(Integer.parseInt(obj.toString()), true);
            needRepaint = true;
        }
        if (needRepaint) {
            this.cp.repaint();
        }
    }
}

