/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSetParser;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.StringTokenizer;

public class LeanLine {
    private CellSetParser parser;
    private int row;
    private int col;
    private Font font;
    private FontMetrics fm;

    public LeanLine(CellSetParser parser, int row, int col) {
        this.parser = parser;
        this.row = row;
        this.col = col;
        this.getFont();
    }

    public void draw(Graphics g, int x, int y, int w, int h) {
        StringTokenizer st;
        Object obj = this.parser.getPropertyValue(this.row, this.col, 4413);
        Color bc = new Color(Integer.parseInt(obj.toString()), true);
        g.setColor(bc);
        g.fillRect(x, y, w, h);
        g.setFont(this.font);
        this.fm = g.getFontMetrics(this.font);
        obj = this.parser.getPropertyValue(this.row, this.col, 4414);
        BasicStroke bs = new BasicStroke(0.75f);
        int leanType = Integer.parseInt(obj.toString());
        if (leanType == CellPropertyDefine.CLL_100_LINE) {
            bs = new BasicStroke(1.0f);
        } else if (leanType == CellPropertyDefine.CLL_150_LINE) {
            bs = new BasicStroke(1.5f);
        } else if (leanType == CellPropertyDefine.CLL_200_LINE) {
            bs = new BasicStroke(2.0f);
        } else if (leanType == CellPropertyDefine.CLL_300_LINE) {
            bs = new BasicStroke(3.0f);
        }
        obj = this.parser.getPropertyValue(this.row, this.col, 4102);
        String text = " , ";
        if (obj != null && obj.toString().trim().length() > 0) {
            text = obj.toString().trim();
        }
        if ((st = new StringTokenizer(text, ",")).countTokens() < 3) {
            this.drawLeanLine(g, x, y, x + w - 1, y + h - 1, bs);
            String t1 = st.nextToken();
            this.drawText1(g, x, y, w, h, t1);
            if (st.hasMoreTokens()) {
                String t2 = st.nextToken();
                this.drawText2(g, x, y, w, h, t2);
            }
        } else {
            this.drawLeanLine(g, x, y, x + w * 2 / 3, y + h - 1, bs);
            this.drawLeanLine(g, x, y, x + w - 1, y + h * 3 / 5, bs);
            String t1 = st.nextToken();
            this.drawText1(g, x, y, w, h, t1);
            String t2 = st.nextToken();
            this.drawText2(g, x, y, w, h, t2);
            String t3 = st.nextToken();
            this.drawText3(g, x, y, w, h, t3);
        }
    }

    private void drawLeanLine(Graphics g, int x1, int y1, int x2, int y2, BasicStroke bs) {
        Object obj = this.parser.getPropertyValue(this.row, this.col, 4415);
        Color c = new Color(Integer.parseInt(obj.toString()), true);
        g.setColor(c);
        Graphics2D g2d = (Graphics2D)g;
        Stroke bsOld = g2d.getStroke();
        g2d.setStroke(bs);
        g2d.drawLine(x1, y1, x2, y2);
        g2d.setStroke(bsOld);
    }

    private void setTextColor(Graphics g) {
        Object obj = this.parser.getPropertyValue(this.row, this.col, 4303);
        Color c = new Color(Integer.parseInt(obj.toString()), true);
        g.setColor(c);
    }

    private void drawText1(Graphics g, int x, int y, int w, int h, String text) {
        int x1 = x + 5;
        int y1 = y + h - 4 - this.fm.getDescent();
        this.setTextColor(g);
        g.drawString(text, x1, y1);
    }

    private void drawText2(Graphics g, int x, int y, int w, int h, String text) {
        int x1 = x + w - 5 - this.fm.stringWidth(text);
        int y1 = y + 4 + this.fm.getAscent();
        this.setTextColor(g);
        g.drawString(text, x1, y1);
    }

    private void drawText3(Graphics g, int x, int y, int w, int h, String text) {
        int descent = this.fm.getDescent();
        int x2 = x + w - 4;
        int y2 = y + h - 2;
        this.setTextColor(g);
        int count = text.length();
        int i = count - 1;
        while (i >= 0) {
            String s = String.valueOf(text.charAt(i));
            int width = this.fm.stringWidth(s);
            int x1 = x2 - width;
            int y1 = y2 - descent;
            g.drawString(s, x1, y1);
            x2 = x2 - width - 2;
            y2 -= (int)((double)((width + 2) * h) * 1.0 / (double)w);
            --i;
        }
    }

    private void getFont() {
        Object value = this.parser.getPropertyValue(this.row, this.col, 4301);
        String face = "\u5b8b\u4f53";
        if (value != null) {
            face = value.toString();
        }
        value = this.parser.getPropertyValue(this.row, this.col, 4302);
        int size = 12;
        if (value != null) {
            size = Integer.parseInt(value.toString());
        }
        int fontStyle = 0;
        value = this.parser.getPropertyValue(this.row, this.col, 4304);
        if (value != null && ((Boolean)value).booleanValue()) {
            ++fontStyle;
        }
        if ((value = this.parser.getPropertyValue(this.row, this.col, 4305)) != null && ((Boolean)value).booleanValue()) {
            fontStyle += 2;
        }
        this.font = new Font(face, fontStyle, size);
    }
}

