/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.base.util.LLObject;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.control.ContentPanel;
import com.runqian.report.control.PrintPage;
import com.runqian.report.pager.PageBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class PrintFrame
extends JDialog
implements ActionListener {
    private CellSet cellSet;
    private int columns = 1;
    private PageBuilder pb;
    private PageFormat pf;
    private JScrollPane dispPane;
    private JPanel dispPanel;
    private JPanel hidePanel;
    private JLabel pageMarkLabel;
    private JComboBox gotoPageBox;
    private JButton firstPageButton = new JButton();
    private JButton prevPageButton = new JButton();
    private JButton nextPageButton = new JButton();
    private JButton lastPageButton = new JButton();
    private JComboBox ratioBox;
    private JComboBox alignBox;
    private JComboBox printedPagesBox;
    private JComboBox shrinkBox;
    private JButton zoomoutButton = new JButton();
    private JButton zoominButton = new JButton();
    private JButton pageSetupButton = new JButton();
    private JButton printButton = new JButton();
    private JButton closeButton = new JButton();
    private JTextField columnsField;
    private Book printBook;
    private int currPageNo = 1;
    private int pageCounts;
    double currScale = 1.0;
    private boolean editable;
    private Dimension oldSize;
    private boolean isMaxized;
    private int align = 0;
    private boolean canSetAlign = true;
    private int printedPages = 0;
    private int shrink = 1;
    private PageFormat truePf;
    private double shrinkScale = 1.0;
    private int frameW = 700;
    private int frameH = 560;

    public PrintFrame(CellSet cs, boolean editable, JFrame owner) throws Exception {
        super(owner);
        this.setModal(true);
        try {
            this.cellSet = cs;
            this.editable = editable;
            String userUnitName = "\u6da6\u4e7e\u62a5\u8868\u8bd5\u7528\u7248";
            try {
                userUnitName = LLObject.get().getCustName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.init(userUnitName);
            CellSetParser parser = new CellSetParser(this.cellSet);
            this.columns = parser.getColumns();
            this.pf = parser.getPageFormat();
            this.addFunctionBar();
            this.createPageBuilder();
            this.initPrintWindow();
            this.initScale();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public PrintFrame(CellSet cs, String userUnitName, boolean editable) throws Exception {
        try {
            this.cellSet = cs;
            this.editable = editable;
            this.init(userUnitName);
            CellSetParser parser = new CellSetParser(this.cellSet);
            this.columns = parser.getColumns();
            this.pf = parser.getPageFormat();
            this.addFunctionBar();
            this.createPageBuilder();
            this.initPrintWindow();
            this.initScale();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void init(String userUnitName) {
        int layoutCol;
        this.setSize(this.frameW, this.frameH);
        if (userUnitName.length() > 0) {
            userUnitName = String.valueOf(userUnitName) + " -- ";
        }
        this.setTitle(String.valueOf(userUnitName) + "\u6253\u5370\u9884\u89c8 (\u53cc\u51fb\u53f3\u8fb9\u529f\u80fd\u9762\u677f\u7a7a\u767d\u5904\uff0c\u5bf9\u8bdd\u6846\u6700\u5927\u5316\u6216\u8fd8\u539f)");
        Dimension size = this.getSize();
        this.oldSize = this.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int newX = (screenSize.width - size.width) / 2;
        int newY = (screenSize.height - size.height) / 2;
        this.setLocation(newX, newY);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PrintFrame f = (PrintFrame)e.getSource();
                Dimension d = f.getSize();
                if (d.width < 500 && d.height < 560) {
                    f.setSize(500, 560);
                } else if (d.width < 500) {
                    f.setSize(500, d.height);
                } else if (d.height < 560) {
                    f.setSize(d.width, 560);
                }
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension size = f.getSize();
                if (size.width != screenSize.width && size.height != screenSize.height) {
                    f.oldSize = size;
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PrintFrame f = (PrintFrame)e.getSource();
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    if (f.isMaxized) {
                        f.setSize(f.oldSize);
                        int newX = (screenSize.width - ((PrintFrame)f).oldSize.width) / 2;
                        int newY = (screenSize.height - ((PrintFrame)f).oldSize.height) / 2;
                        f.setLocation(newX, newY);
                        f.isMaxized = false;
                    } else {
                        f.setLocation(0, 0);
                        f.setSize(screenSize);
                        f.isMaxized = true;
                    }
                }
            }
        });
        Object obj = this.cellSet.getPropertyValue(0, 0, 1210);
        if (((Integer)obj).intValue() == CellPropertyDefine.CPS_ROWS.intValue() && (layoutCol = ((Integer)(obj = this.cellSet.getPropertyValue(0, 0, 1213))).intValue()) > 1) {
            this.canSetAlign = false;
        }
        this.shrink = (Integer)this.cellSet.getPropertyValue(0, 0, 1217);
        this.dispPane = new JScrollPane(20, 30);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.hidePanel = new JPanel();
        pane.add(this.hidePanel);
        pane.add(this.dispPane);
    }

    private void createPageBuilder() throws Exception {
        if (this.shrink == 1) {
            this.truePf = this.pf;
            this.shrinkScale = 1.0;
        } else {
            CellSetParser csp = new CellSetParser(this.cellSet);
            if (this.shrink == 2) {
                int w = csp.getCellSetWidth() + 2;
                this.shrinkScale = this.pf.getImageableWidth() / (double)w;
            } else if (this.shrink == 3) {
                int h = csp.getCellSetHeight() + 2;
                this.shrinkScale = this.pf.getImageableHeight() / (double)h;
            }
            this.truePf = this.getTruePageFormat(1.0 / this.shrinkScale);
        }
        int width = (int)this.truePf.getImageableWidth();
        int height = (int)this.truePf.getImageableHeight();
        CellSet cs = (CellSet)this.cellSet.clone();
        this.pb = new PageBuilder(cs, width, height, this.columns, false);
    }

    private PageFormat getTruePageFormat(double scale) {
        PageFormat pageformat = new PageFormat();
        Paper paper = new Paper();
        Paper p = this.pf.getPaper();
        paper.setSize(p.getWidth() * scale, p.getHeight() * scale);
        double x = p.getImageableX() * scale;
        double y = p.getImageableY() * scale;
        double w = p.getImageableWidth() * scale;
        double h = p.getImageableHeight() * scale;
        paper.setImageableArea(x, y, w, h);
        pageformat.setPaper(paper);
        pageformat.setOrientation(this.pf.getOrientation());
        return pageformat;
    }

    private void initPrintWindow() {
        this.hidePanel.removeAll();
        this.gotoPageBox.removeAllItems();
        this.printBook = new Book();
        this.pageCounts = 0;
        int pageNo = 1;
        while (true) {
            PrintPage page;
            block3: {
                page = new PrintPage(this.pb, this.truePf, pageNo, this.editable);
                try {
                    page.create();
                    if (!this.canSetAlign) break block3;
                    page.setAlign(this.align);
                }
                catch (Exception e) {
                    break;
                }
            }
            this.hidePanel.add(page);
            this.printBook.append(page, this.pf);
            this.gotoPageBox.addItem(String.valueOf(pageNo));
            ++pageNo;
            ++this.pageCounts;
        }
        this.setCurrentPage(1);
        this.ratioBox.setSelectedIndex(0);
    }

    private void addFunctionBar() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        Font font = new Font("\u5b8b\u4f53", 0, 12);
        this.pageMarkLabel = new JLabel();
        this.pageMarkLabel.setFont(font);
        panel.add((Component)this.pageMarkLabel, this.createGBC(row++));
        JPanel gotoPanel = new JPanel();
        JLabel label1 = new JLabel("\u5230\u7b2c");
        label1.setFont(font);
        gotoPanel.add(label1);
        this.gotoPageBox = new JComboBox();
        this.gotoPageBox.setFont(font);
        this.gotoPageBox.setPreferredSize(new Dimension(40, 20));
        this.gotoPageBox.addActionListener(this);
        gotoPanel.add(this.gotoPageBox);
        JLabel label2 = new JLabel("\u9875");
        label2.setFont(font);
        gotoPanel.add(label2);
        panel.add((Component)gotoPanel, this.createGBC(row++, 3));
        this.addButton(panel, this.firstPageButton, "\u6700\u524d\u9875", row++, font);
        this.addButton(panel, this.prevPageButton, "\u4e0a\u4e00\u9875", row++, font);
        this.addButton(panel, this.nextPageButton, "\u4e0b\u4e00\u9875", row++, font);
        this.addButton(panel, this.lastPageButton, "\u6700\u540e\u9875", row++, font);
        this.addButton(panel, this.zoominButton, "\u653e  \u5927", row++, font);
        this.addButton(panel, this.zoomoutButton, "\u7f29  \u5c0f", row++, font);
        JPanel ratioPanel = new JPanel();
        JLabel label3 = new JLabel("\u6bd4\u4f8b");
        label3.setFont(font);
        ratioPanel.add(label3);
        this.ratioBox = new JComboBox<String>(new String[]{"\u6574\u9875", "50%", "75%", "100%", "150%", "200%"});
        this.ratioBox.setFont(font);
        this.ratioBox.setEditable(true);
        this.ratioBox.setPreferredSize(new Dimension(55, 20));
        this.ratioBox.addActionListener(this);
        ratioPanel.add(this.ratioBox);
        panel.add((Component)ratioPanel, this.createGBC(row++, 3));
        if (this.canSetAlign) {
            JPanel alignPanel = new JPanel();
            JLabel labelAlign = new JLabel("\u5bf9\u9f50");
            labelAlign.setFont(font);
            alignPanel.add(labelAlign);
            this.alignBox = new JComboBox<String>(new String[]{"\u5c45\u4e2d", "\u9760\u5de6", "\u9760\u53f3"});
            this.alignBox.setFont(font);
            this.alignBox.setPreferredSize(new Dimension(55, 20));
            this.alignBox.addActionListener(this);
            alignPanel.add(this.alignBox);
            panel.add((Component)alignPanel, this.createGBC(row++, 0));
        }
        JPanel fenlanPanel = new JPanel();
        JLabel label4 = new JLabel("\u5206\u680f");
        label4.setFont(font);
        fenlanPanel.add(label4);
        this.columnsField = new JTextField(String.valueOf(this.columns));
        this.columnsField.setFont(font);
        this.columnsField.setPreferredSize(new Dimension(56, 20));
        this.columnsField.setHorizontalAlignment(0);
        this.columnsField.addActionListener(this);
        fenlanPanel.add(this.columnsField);
        panel.add((Component)fenlanPanel, this.createGBC(row++, 0));
        JPanel printedPagesPanel = new JPanel();
        JLabel labelPages = new JLabel("\u9875\u6570");
        labelPages.setFont(font);
        printedPagesPanel.add(labelPages);
        this.printedPagesBox = new JComboBox<String>(new String[]{"\u5168\u90e8", "\u5947\u6570", "\u5076\u6570"});
        this.printedPagesBox.setFont(font);
        this.printedPagesBox.setPreferredSize(new Dimension(55, 20));
        this.printedPagesBox.addActionListener(this);
        printedPagesPanel.add(this.printedPagesBox);
        panel.add((Component)printedPagesPanel, this.createGBC(row++, 0));
        JPanel shrinkPanel = new JPanel();
        JLabel labelShrink = new JLabel("\u7f29\u653e");
        labelShrink.setFont(font);
        shrinkPanel.add(labelShrink);
        this.shrinkBox = new JComboBox<String>(new String[]{"\u65e0", "\u6309\u5bbd", "\u6309\u9ad8"});
        this.shrinkBox.setFont(font);
        this.shrinkBox.setPreferredSize(new Dimension(55, 20));
        this.shrinkBox.setSelectedIndex(this.shrink - 1);
        this.shrinkBox.addActionListener(this);
        shrinkPanel.add(this.shrinkBox);
        panel.add((Component)shrinkPanel, this.createGBC(row++, 0));
        this.addButton(panel, this.pageSetupButton, "\u9875\u9762\u8bbe\u7f6e", row++, font);
        this.addButton(panel, this.printButton, "\u6253  \u5370", row++, font);
        this.addButton(panel, this.closeButton, "\u5173  \u95ed", row++, font);
        GridBagConstraints gbc = this.createGBC(row);
        gbc.weighty = 1.0;
        panel.add((Component)new JPanel(), gbc);
        this.getContentPane().add((Component)panel, "East");
    }

    private void addButton(JPanel panel, JButton button, String text, int row, Font font) {
        button.setText(text);
        button.setFont(font);
        button.setPreferredSize(new Dimension(85, 25));
        button.setMargin(new Insets(1, 5, 1, 5));
        button.addActionListener(this);
        panel.add((Component)button, this.createGBC(row));
    }

    public void actionPerformed(ActionEvent e) {
        JComponent source = (JComponent)e.getSource();
        if (source.equals(this.gotoPageBox)) {
            try {
                int pageNo = Integer.parseInt(this.gotoPageBox.getSelectedItem().toString());
                this.setCurrentPage(pageNo);
            }
            catch (Exception pageNo) {}
        } else if (source.equals(this.firstPageButton)) {
            this.setCurrentPage(1);
        } else if (source.equals(this.lastPageButton)) {
            this.setCurrentPage(this.pageCounts);
        } else if (source.equals(this.prevPageButton)) {
            int pageNo = this.currPageNo - 1;
            if (pageNo < 1) {
                return;
            }
            this.setCurrentPage(pageNo);
        } else if (source.equals(this.nextPageButton)) {
            int pageNo = this.currPageNo + 1;
            if (pageNo > this.pageCounts) {
                return;
            }
            this.setCurrentPage(pageNo);
        } else if (source.equals(this.zoominButton)) {
            this.hideEditor();
            this.currScale *= 1.5;
            String scale = String.valueOf(String.valueOf((int)(this.currScale * 100.0))) + "%";
            this.ratioBox.setSelectedItem(scale);
        } else if (source.equals(this.zoomoutButton)) {
            this.hideEditor();
            this.currScale *= 0.667;
            String scale = String.valueOf(String.valueOf((int)(this.currScale * 100.0))) + "%";
            this.ratioBox.setSelectedItem(scale);
        } else if (source.equals(this.ratioBox)) {
            this.hideEditor();
            String selectedRatio = this.ratioBox.getSelectedItem().toString();
            if (selectedRatio.equals("\u6574\u9875")) {
                Rectangle r = this.dispPane.getViewport().getViewRect();
                int pfWidth = (int)this.truePf.getWidth();
                int pfHeight = (int)this.truePf.getHeight();
                double hScale = (double)(r.width - 20) * 1.0 / (double)pfWidth;
                double vScale = (double)(r.height - 10) * 1.0 / (double)pfHeight;
                this.currScale = Math.min(hScale, vScale);
                this.changeDisplayScale();
            } else {
                this.currScale = Double.parseDouble(selectedRatio.substring(0, selectedRatio.length() - 1)) / 100.0;
                this.changeDisplayScale();
            }
        } else if (source.equals(this.alignBox)) {
            String selectedAlign = this.alignBox.getSelectedItem().toString();
            if (selectedAlign.equals("\u5c45\u4e2d")) {
                this.align = 0;
            } else if (selectedAlign.equals("\u9760\u5de6")) {
                this.align = 1;
            } else if (selectedAlign.equals("\u9760\u53f3")) {
                this.align = 2;
            }
            int n = this.printBook.getNumberOfPages();
            int i = 0;
            while (i < n) {
                ((PrintPage)this.printBook.getPrintable(i)).setAlign(this.align);
                ++i;
            }
            this.changeDisplayScale();
        } else if (source.equals(this.printedPagesBox)) {
            String s = this.printedPagesBox.getSelectedItem().toString();
            if (s.equals("\u5168\u90e8")) {
                this.printedPages = 0;
            } else if (s.equals("\u5947\u6570")) {
                this.printedPages = 1;
            } else if (s.equals("\u5076\u6570")) {
                this.printedPages = 2;
            }
        } else if (source.equals(this.columnsField)) {
            int newColumns = 1;
            try {
                newColumns = Integer.parseInt(this.columnsField.getText());
            }
            catch (Exception ex) {
                this.columnsField.setText(String.valueOf(this.columns));
                return;
            }
            if (newColumns > 5) {
                newColumns = 5;
                this.columnsField.setText(String.valueOf(newColumns));
            }
            if (newColumns != this.columns) {
                this.columns = newColumns;
                try {
                    this.createPageBuilder();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage());
                }
                this.initPrintWindow();
            }
        } else if (source.equals(this.shrinkBox)) {
            String s = this.shrinkBox.getSelectedItem().toString();
            if (s.equals("\u65e0")) {
                this.shrink = 1;
            } else if (s.equals("\u6309\u5bbd")) {
                this.shrink = 2;
            } else if (s.equals("\u6309\u9ad8")) {
                this.shrink = 3;
            }
            this.columns = Integer.parseInt(this.columnsField.getText());
            try {
                this.createPageBuilder();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage());
            }
            this.initPrintWindow();
        } else if (source.equals(this.pageSetupButton)) {
            int imageWidth = (int)this.pf.getImageableWidth();
            int imageHeight = (int)this.pf.getImageableHeight();
            this.pf = PrinterJob.getPrinterJob().pageDialog(this.pf);
            if (this.pf.getOrientation() == 0) {
                Paper p = this.pf.getPaper();
                double b = p.getImageableX();
                double t = p.getWidth() - p.getImageableWidth() - p.getImageableX();
                double l = p.getImageableY();
                double r = p.getHeight() - p.getImageableHeight() - p.getImageableY();
                double y = p.getHeight() - p.getImageableHeight() - l;
                p.setImageableArea(t, y, p.getImageableWidth(), p.getImageableHeight());
                this.pf.setPaper(p);
            }
            if (imageWidth != (int)this.pf.getImageableWidth() || imageHeight != (int)this.pf.getImageableHeight()) {
                this.columns = Integer.parseInt(this.columnsField.getText());
                try {
                    this.createPageBuilder();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage());
                }
                this.initPrintWindow();
            }
        } else if (source.equals(this.printButton)) {
            this.print();
        } else if (source.equals(this.closeButton)) {
            this.hide();
            this.dispose();
        }
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PrintPage.setScale(this.shrinkScale);
        if (this.printedPages == 0) {
            job.setPageable(this.printBook);
        } else {
            Book book = new Book();
            if (this.printedPages == 1) {
                int i = 0;
                while (i < this.printBook.getNumberOfPages()) {
                    book.append((PrintPage)this.printBook.getPrintable(i), this.pf);
                    i += 2;
                }
            } else if (this.printedPages == 2) {
                int i = 1;
                while (i < this.printBook.getNumberOfPages()) {
                    book.append((PrintPage)this.printBook.getPrintable(i), this.pf);
                    i += 2;
                }
            }
            job.setPageable(book);
        }
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            this.hide();
            this.dispose();
        }
    }

    public void directPrint(boolean needSelectPrinter) {
        PrinterJob job = PrinterJob.getPrinterJob();
        PrintPage.setScale(this.shrinkScale);
        job.setPageable(this.printBook);
        try {
            if (needSelectPrinter) {
                if (job.printDialog()) {
                    job.print();
                }
            } else {
                job.print();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.hide();
        this.dispose();
    }

    void changeDisplayScale() {
        PrintPage.setScale(this.currScale);
        this.dispPanel.setPreferredSize(new Dimension((int)(this.truePf.getWidth() * this.currScale), (int)(this.truePf.getHeight() * this.currScale)));
        this.dispPane.getViewport().setView(this.dispPanel);
    }

    private void setCurrentPage(int pageNo) {
        try {
            PrintPage oldPage = (PrintPage)this.printBook.getPrintable(this.currPageNo - 1);
            if (oldPage != null) {
                this.hidePanel.add(oldPage);
            }
        }
        catch (Exception oldPage) {
            // empty catch block
        }
        PrintPage currPage = (PrintPage)this.printBook.getPrintable(pageNo - 1);
        this.dispPanel = new JPanel();
        this.dispPanel.add(currPage);
        this.dispPane.getViewport().setView(this.dispPanel);
        this.repaint();
        this.currPageNo = pageNo;
        this.pageMarkLabel.setText("\u9875\u7801: " + pageNo + "/" + this.pageCounts);
        if (pageNo == 1) {
            this.firstPageButton.setEnabled(false);
            this.prevPageButton.setEnabled(false);
        } else {
            this.firstPageButton.setEnabled(true);
            this.prevPageButton.setEnabled(true);
        }
        if (pageNo == this.pageCounts) {
            this.lastPageButton.setEnabled(false);
            this.nextPageButton.setEnabled(false);
        } else {
            this.lastPageButton.setEnabled(true);
            this.nextPageButton.setEnabled(true);
        }
    }

    private PrintPage getCurrentPage() {
        JPanel panel = (JPanel)this.dispPane.getViewport().getView();
        return (PrintPage)panel.getComponent(0);
    }

    private GridBagConstraints createGBC(int row, int topMargin) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(topMargin, 5, 0, 5);
        return gbc;
    }

    private GridBagConstraints createGBC(int row) {
        return this.createGBC(row, 6);
    }

    private void hideEditor() {
        if (!this.editable) {
            return;
        }
        PrintPage page = this.getCurrentPage();
        this.hideEditor(page);
    }

    private void hideEditor(Container c) {
        Component[] child = c.getComponents();
        if (child.length == 0) {
            return;
        }
        int i = 0;
        while (i < child.length) {
            if (child[i] instanceof ContentPanel) {
                ContentPanel cp = (ContentPanel)child[i];
                cp.submitEditor();
                if (cp.editor != null) {
                    cp.editor.setVisible(false);
                    cp.m_activeCell = null;
                }
            } else {
                this.hideEditor((Container)child[i]);
            }
            ++i;
        }
    }

    private void initScale() {
        int pfWidth = (int)this.truePf.getWidth();
        int pfHeight = (int)this.truePf.getHeight();
        double hScale = (double)(this.frameW - 130) * 1.0 / (double)pfWidth;
        double vScale = (double)(this.frameH - 40) * 1.0 / (double)pfHeight;
        this.currScale = Math.min(hScale, vScale);
        this.changeDisplayScale();
    }

    public void dispose() {
        super.dispose();
        this.cellSet = null;
        this.pb = null;
        int i = 0;
        while (i < this.printBook.getNumberOfPages()) {
            ((PrintPage)this.printBook.getPrintable(i)).dispose();
            ++i;
        }
    }
}

