/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.Field;
import com.runqian.report.control.ContentPanel;
import com.runqian.report.control.ReportPage;
import com.runqian.report.pager.PageBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;

public class PrintPage
extends JPanel
implements Printable {
    private static double scale = 1.0;
    private PageFormat pf;
    private PageBuilder pb;
    boolean isCreated = false;
    private Field pageHeader;
    private Field pageFooter;
    private boolean editable;
    ContentPanel headerPanel;
    ContentPanel footerPanel;
    JPanel pagesPanel;
    private int pointX;
    private int pointY;
    private int W;
    private int H;
    private int pageNo;

    public PrintPage(PageBuilder pb, PageFormat pf, int pageNo, boolean editable) {
        int hh;
        int hfs;
        this.pf = pf;
        this.pb = pb;
        this.pageNo = pageNo;
        this.editable = editable;
        this.pointX = (int)pf.getImageableX();
        this.pointY = (int)pf.getImageableY();
        this.W = (int)pf.getImageableWidth() + 2;
        this.H = (int)pf.getImageableHeight() + 2;
        CellSet totalCs = pb.getCellSet();
        CellSetParser csp = new CellSetParser(totalCs);
        this.pageHeader = csp.getPageHeader();
        this.pageFooter = csp.getPageFooter();
        boolean hasPageHeader = false;
        boolean hasPageFooter = false;
        int pageStyle = (Integer)csp.getPropertyValue(0, 0, 1210);
        if (this.pageHeader != null) {
            if (pageStyle == CellPropertyDefine.CPS_PAPER) {
                hasPageHeader = true;
            }
            if (pageStyle == CellPropertyDefine.CPS_ROWS) {
                hfs = (Integer)csp.getPropertyValue(0, 0, 1215);
                if (hfs == CellPropertyDefine.CHS_ALL) {
                    hasPageHeader = false;
                }
                if (hfs == CellPropertyDefine.CHS_ONE) {
                    hasPageHeader = true;
                }
            }
        }
        if (this.pageFooter != null) {
            if (pageStyle == CellPropertyDefine.CPS_PAPER) {
                hasPageFooter = true;
            }
            if (pageStyle == CellPropertyDefine.CPS_ROWS) {
                hfs = (Integer)csp.getPropertyValue(0, 0, 1215);
                if (hfs == CellPropertyDefine.CHS_ALL) {
                    hasPageFooter = false;
                }
                if (hfs == CellPropertyDefine.CHS_ONE) {
                    hasPageFooter = true;
                }
            }
        }
        if (hasPageHeader) {
            hh = csp.getFieldScanHeight(this.pageHeader);
            this.pointY += hh;
            this.H -= hh;
        }
        if (hasPageFooter) {
            hh = csp.getFieldScanHeight(this.pageFooter);
            this.H -= hh;
        }
        this.pagesPanel = new JPanel(null);
        this.pagesPanel.setBackground(Color.white);
        this.pagesPanel.setBounds(this.pointX, this.pointY, this.W, this.H);
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension((int)pf.getWidth() + 1, (int)pf.getHeight() + 1));
        this.setLayout(null);
    }

    public void create() throws Exception {
        CellSet totalCs = this.pb.getCellSet();
        Object obj = totalCs.getPropertyValue(0, 0, 1210);
        if (((Integer)obj).intValue() == CellPropertyDefine.CPS_PAPER.intValue()) {
            CellSet cs = null;
            cs = this.pb.getPage(this.pageNo);
            CellSetParser csp = new CellSetParser(cs);
            this.pageHeader = csp.getPageHeader();
            this.createPageHeader(cs);
            this.pageFooter = csp.getPageFooter();
            this.createPageFooter(cs);
            ReportPage rp = new ReportPage(cs, new Dimension(this.W, this.H), false, this.editable);
            rp.setBounds(0, 0, this.W, this.H);
            this.pagesPanel.add(rp);
        } else if (((Integer)obj).intValue() == CellPropertyDefine.CPS_ROWS.intValue()) {
            Object obj1 = totalCs.getPropertyValue(0, 0, 1212);
            int layoutRow = 1;
            try {
                layoutRow = Integer.parseInt(obj1.toString());
                if (layoutRow < 1) {
                    layoutRow = 1;
                }
            }
            catch (Exception rp) {
                // empty catch block
            }
            obj1 = totalCs.getPropertyValue(0, 0, 1213);
            int layoutCol = 1;
            try {
                layoutCol = Integer.parseInt(obj1.toString());
                if (layoutCol < 1) {
                    layoutCol = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            int spaceRow = 10;
            int spaceCol = 10;
            int pageW = (int)((double)(this.W - (layoutCol - 1) * spaceCol) * 1.0 / (double)layoutCol);
            int pageH = (int)((double)(this.H - (layoutRow - 1) * spaceRow) * 1.0 / (double)layoutRow);
            obj1 = totalCs.getPropertyValue(0, 0, 1215);
            boolean printHFAll = ((Integer)obj1).intValue() == CellPropertyDefine.CHS_ALL.intValue();
            ReportPage[] pages = new ReportPage[layoutRow * layoutCol];
            int startPage = (this.pageNo - 1) * layoutRow * layoutCol + 1;
            int i = 0;
            while (i < pages.length) {
                CellSet cs = null;
                try {
                    cs = this.pb.getPage(startPage + i);
                }
                catch (Exception e) {
                    if (i != 0) break;
                    throw e;
                }
                if (i == 0 && !printHFAll) {
                    CellSetParser csp = new CellSetParser(cs);
                    this.pageHeader = csp.getPageHeader();
                    this.pageFooter = csp.getPageFooter();
                    this.createPageHeader(cs);
                    this.createPageFooter(cs);
                }
                pages[i] = new ReportPage(cs, new Dimension(pageW, pageH), printHFAll, this.editable);
                ++i;
            }
            obj1 = totalCs.getPropertyValue(0, 0, 1214);
            int layoutIndex = CellPropertyDefine.CPLI_ROW;
            try {
                layoutIndex = Integer.parseInt(obj1.toString());
            }
            catch (Exception cs) {
                // empty catch block
            }
            int y = 0;
            int i2 = 1;
            while (i2 <= layoutRow) {
                if (i2 > 1) {
                    y += pageH + spaceRow;
                }
                int x = 0;
                int j = 1;
                while (j <= layoutCol) {
                    if (j > 1) {
                        x += pageW + spaceCol;
                    }
                    int index = 0;
                    if (layoutIndex == CellPropertyDefine.CPLI_ROW) {
                        index = (i2 - 1) * layoutCol + (j - 1);
                    } else if (layoutIndex == CellPropertyDefine.CPLI_COL) {
                        index = (j - 1) * layoutRow + (i2 - 1);
                    }
                    if (pages[index] != null) {
                        pages[index].setBounds(x, y, pageW, pageH);
                        this.pagesPanel.add(pages[index]);
                    }
                    ++j;
                }
                ++i2;
            }
        }
        this.isCreated = true;
    }

    private void createPageHeader(CellSet cs) {
        if (this.pageHeader == null) {
            return;
        }
        this.headerPanel = new ContentPanel(cs, this.pageHeader.getStartRow(), this.pageHeader.getEndRow(), 1, this.pageHeader.getEndColumn(), false, false, null, this.editable, null, null, null, 1);
        Dimension d = this.headerPanel.getPreferredSize();
        int y = this.pointY - d.height + 1;
        this.headerPanel.setBounds(this.pointX, y, d.width, d.height - 1);
        this.headerPanel.setBackground(Color.white);
    }

    private void createPageFooter(CellSet cs) {
        if (this.pageFooter == null) {
            return;
        }
        this.footerPanel = new ContentPanel(cs, this.pageFooter.getStartRow(), this.pageFooter.getEndRow(), 1, this.pageFooter.getEndColumn(), false, false, null, this.editable, null, null, null, 1);
        Dimension d = this.footerPanel.getPreferredSize();
        int y = this.pointY + this.H;
        this.footerPanel.setBounds(this.pointX, y, d.width, d.height);
        this.footerPanel.setBackground(Color.white);
    }

    public void paintComponent(Graphics g) {
        g.clearRect(0, 0, 999999, 999999);
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(scale, scale);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, (int)this.pf.getWidth() + 1, (int)this.pf.getHeight() + 1);
        if (scale > 8.0) {
            g2.setColor(Color.red);
            g2.drawString("\u6c88\u5efa\u8363\u5370", 0, 10);
        }
        if (this.headerPanel != null) {
            this.add(this.headerPanel);
        }
        this.add(this.pagesPanel);
        if (this.footerPanel != null) {
            this.add(this.footerPanel);
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        this.printAll(g);
        return 0;
    }

    public static void setScale(double newScale) {
        scale = newScale;
    }

    public static double getScale() {
        return scale;
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)(this.pf.getWidth() * scale) + 1, (int)(this.pf.getHeight() * scale) + 1);
    }

    public void setAlign(int align) {
        Rectangle r;
        int w;
        Component[] child = this.pagesPanel.getComponents();
        int i = 0;
        while (i < child.length) {
            Component c = child[i];
            if (c instanceof ReportPage) {
                ((ReportPage)c).setAlign(align);
            }
            ++i;
        }
        if (this.headerPanel != null) {
            w = this.headerPanel.getWidth();
            int x = 0;
            if (align == 0) {
                x = (this.W - w) / 2;
            } else if (align == 2) {
                x = this.W - w;
            }
            r = this.headerPanel.getBounds();
            r.x = this.pointX + x;
            this.headerPanel.setBounds(r);
        }
        if (this.footerPanel != null) {
            w = this.footerPanel.getWidth();
            int x = 0;
            if (align == 0) {
                x = (this.W - w) / 2;
            } else if (align == 2) {
                x = this.W - w;
            }
            r = this.footerPanel.getBounds();
            r.x = this.pointX + x;
            this.footerPanel.setBounds(r);
        }
    }

    public void dispose() {
        this.pb = null;
        if (this.headerPanel != null) {
            this.headerPanel.dispose();
        }
        if (this.footerPanel != null) {
            this.footerPanel.dispose();
        }
    }
}

