/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.base.util.IntHashtable;
import com.runqian.report.cellset.CellPosition;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellRegion;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.CellSetReader;
import com.runqian.report.cellset.CellSetWriter;
import com.runqian.report.cellset.RelativeFreeze;
import com.runqian.report.control.ContentPanel;
import com.runqian.report.control.EditorListener;
import com.runqian.report.ide.ExcelImporter;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;

public abstract class ReportControl
extends JScrollPane {
    CellSet m_cellSet;
    CellSetParser m_parser;
    CellRegion m_selectedRegion;
    int status;
    Vector m_selectedCols;
    Vector m_selectedRows;
    boolean m_cornerSelected = false;
    boolean m_autoRepaint = true;
    ArrayList m_editorListener = new ArrayList();
    ContentPanel contentView = null;
    Image backImage = null;
    int[] cellX;
    int[] cellY;
    int[] cellW;
    int[] cellH;

    public ReportControl(int rows, int cols) {
        super(20, 30);
        this.getHorizontalScrollBar().setUnitIncrement(10);
        this.getVerticalScrollBar().setUnitIncrement(10);
        this.m_cellSet = new CellSet(rows, cols);
        this.m_parser = new CellSetParser(this.m_cellSet);
        int iRow = 0;
        while (iRow < rows) {
            int iColumn = 0;
            while (iColumn < cols) {
                this.setCellDefaultProperty(iRow, iColumn);
                ++iColumn;
            }
            ++iRow;
        }
    }

    public ReportControl() {
        this(1, 1);
    }

    public void draw() {
        JPanel rowHeaderView;
        JPanel colHeaderView;
        JPanel corner = this.createCorner();
        if (corner != null) {
            this.setCorner("UPPER_LEFT_CORNER", corner);
        }
        if ((colHeaderView = this.createColHeaderView()) != null) {
            JViewport colHeader = new JViewport();
            this.setColumnHeader(colHeader);
            this.setColumnHeaderView(colHeaderView);
        }
        if ((rowHeaderView = this.createRowHeaderView()) != null) {
            JViewport rowHeader = new JViewport();
            this.setRowHeader(rowHeader);
            this.setRowHeaderView(rowHeaderView);
        }
        this.contentView = this.createContentView();
        this.getViewport().setView(this.contentView);
        this.getViewport().setAutoscrolls(true);
    }

    abstract JPanel createCorner();

    abstract JPanel createColHeaderView();

    abstract JPanel createRowHeaderView();

    abstract ContentPanel createContentView();

    public void setCellSet(CellSet cs) {
        this.m_cellSet = cs;
        this.m_parser = new CellSetParser(this.m_cellSet);
        this.draw();
    }

    public CellSet getCellSet() {
        return this.m_cellSet;
    }

    public void loadData(InputStream in) throws Exception {
        this.m_cellSet = new CellSetReader(in).read();
        this.m_parser = new CellSetParser(this.m_cellSet);
    }

    public void loadData(String fileName) throws Exception {
        int pos = fileName.lastIndexOf(".");
        String ext = "";
        if (pos > 0) {
            ext = fileName.substring(pos + 1);
        }
        if (ext.equalsIgnoreCase("xls")) {
            ExcelImporter ei = new ExcelImporter(fileName);
            this.setCellSet(ei.getCellSet(0));
            return;
        }
        FileInputStream in = new FileInputStream(fileName);
        this.loadData(in);
        in.close();
    }

    public void saveData(PrintWriter out) throws Exception {
        new CellSetWriter(this.m_cellSet).write(out);
    }

    public void saveData(String fileName) throws Exception {
        PrintWriter out = new PrintWriter(new FileOutputStream(fileName));
        this.saveData(out);
        out.close();
    }

    private void setCellDefaultProperty(int nRow, int nColumn) {
        if (nRow == 0 && nColumn == 0) {
            this.m_cellSet.setPropertyValue(nRow, nColumn, 1101, CellPropertyDefine.CRT_GRID);
            this.m_cellSet.setPropertyValue(nRow, nColumn, 1201, CellPropertyDefine.CPS_A4);
            this.m_cellSet.setPropertyValue(nRow, nColumn, 1202, CellPropertyDefine.CPO_PORTRAIT);
            this.m_cellSet.setPropertyValue(nRow, nColumn, 1205, new Integer(25));
            this.m_cellSet.setPropertyValue(nRow, nColumn, 1206, new Integer(25));
            this.m_cellSet.setPropertyValue(nRow, nColumn, 1207, new Integer(25));
            this.m_cellSet.setPropertyValue(nRow, nColumn, 1208, new Integer(25));
        }
    }

    public boolean setAutoRepaint(boolean bAutoRepaint) {
        this.m_autoRepaint = bAutoRepaint;
        return bAutoRepaint;
    }

    private void notifyPropertyChanged() {
        if (this.m_autoRepaint) {
            this.repaint();
        }
    }

    public void addEditorListener(EditorListener listener) {
        this.m_editorListener.add(listener);
    }

    void fireRowHeaderResized(Vector vectHeader, int newHeight) {
        double height = (double)newHeight * 1.0;
        Object unit = this.getCellPropertyValue(0, 0, 1209);
        if (unit != null) {
            int csu = (Integer)unit;
            if (csu == CellPropertyDefine.CSU_MM) {
                height = (double)newHeight * 25.4 / 72.0;
            }
            if (csu == CellPropertyDefine.CSU_INCH) {
                height = (double)newHeight * 1.0 / 72.0;
            }
        }
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = (EditorListener)this.m_editorListener.get(i);
            listener.rowHeightChange(vectHeader, height);
            ++i;
        }
        this.resetControlHeight();
    }

    void fireColHeaderResized(Vector vectHeader, int newWidth) {
        double width = (double)newWidth * 1.0;
        Object unit = this.getCellPropertyValue(0, 0, 1209);
        if (unit != null) {
            int csu = (Integer)unit;
            if (csu == CellPropertyDefine.CSU_MM) {
                width = (double)newWidth * 25.4 / 72.0;
            }
            if (csu == CellPropertyDefine.CSU_INCH) {
                width = (double)newWidth * 1.0 / 72.0;
            }
        }
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = (EditorListener)this.m_editorListener.get(i);
            listener.columnWidthChange(vectHeader, width);
            ++i;
        }
        this.resetControlWidth();
    }

    void fireRegionMove() {
    }

    void fireRegionPaste() {
    }

    void fireRegionSelect() {
        Vector<CellRegion> selectedRegion = new Vector<CellRegion>();
        selectedRegion.add(this.m_selectedRegion);
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = (EditorListener)this.m_editorListener.get(i);
            listener.regionsSelect(selectedRegion, this.m_selectedRows, this.m_selectedCols, this.m_cornerSelected);
            ++i;
        }
    }

    void fireCellTextInput(CellPosition pos, String text) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = (EditorListener)this.m_editorListener.get(i);
            listener.cellTextInput(pos, text);
            ++i;
        }
    }

    void fireEditorInputing(String text) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = (EditorListener)this.m_editorListener.get(i);
            listener.editorInputing(text);
            ++i;
        }
    }

    void fireGraphEdit(int row, int col) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = (EditorListener)this.m_editorListener.get(i);
            listener.graphEdit(row, col);
            ++i;
        }
    }

    void fireSubReportEdit(int row, int col) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = (EditorListener)this.m_editorListener.get(i);
            listener.subReportEdit(row, col);
            ++i;
        }
    }

    void fireRightClicked(MouseEvent e, int clickPlace) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = (EditorListener)this.m_editorListener.get(i);
            listener.rightClicked(e, clickPlace);
            ++i;
        }
    }

    public Object getCellPropertyValue(int nRow, int nColumn, int nPropertyId) {
        Object objProperty = null;
        if (nPropertyId == 2101 || nPropertyId == 3101) {
            objProperty = this.m_cellSet.getPropertyValue(nRow, nColumn, nPropertyId, true);
            if (objProperty == null) {
                return new Double(10.0);
            }
            float value = Float.parseFloat(objProperty.toString());
            objProperty = new Double(new DecimalFormat("###########").format(value));
            Object unit = this.getCellPropertyValue(0, 0, 1209);
            if (unit != null) {
                int csu = (Integer)unit;
                if (csu == CellPropertyDefine.CSU_MM) {
                    objProperty = new Double(new DecimalFormat("###########.#").format((double)value * 25.4 / 72.0));
                }
                if (csu == CellPropertyDefine.CSU_INCH) {
                    objProperty = new Double(new DecimalFormat("###########.##").format((double)value / 72.0));
                }
            }
        } else {
            objProperty = this.m_cellSet.getPropertyValue(nRow, nColumn, nPropertyId);
        }
        return objProperty;
    }

    public Object getCellPropertyValue(CellPosition cellPos, int nPropertyId) {
        return this.getCellPropertyValue(cellPos.getRow(), cellPos.getColumn(), nPropertyId);
    }

    public String getCellPropertyExpression(int nRow, int nColumn, int nPropertyId) {
        String strExpression = this.m_cellSet.getPropertyExpression(nRow, nColumn, nPropertyId);
        return strExpression;
    }

    public String getCellPropertyExpression(CellPosition cellPos, int nPropertyId) {
        return this.getCellPropertyExpression(cellPos.getRow(), cellPos.getColumn(), nPropertyId);
    }

    public Object setCellPropertyValue(int nRow, int nColumn, int nPropertyId, Object value) {
        Object objOldProperty = null;
        try {
            objOldProperty = this.m_cellSet.getPropertyValue(nRow, nColumn, nPropertyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nPropertyId == 2101 || nPropertyId == 3101) {
            Object unit = this.m_cellSet.getPropertyValue(0, 0, 1209);
            if (unit != null) {
                int csu = (Integer)unit;
                if (csu == CellPropertyDefine.CSU_PIXEL) {
                    if (value != null) {
                        value = new Float(Math.round(Double.parseDouble(value.toString())));
                    }
                } else if (csu == CellPropertyDefine.CSU_MM) {
                    if (value != null) {
                        value = new Float(Double.parseDouble(value.toString()) * 72.0 / 25.4);
                    }
                    objOldProperty = new Float(Double.parseDouble(objOldProperty.toString()) * 25.4 / 72.0);
                } else if (csu == CellPropertyDefine.CSU_INCH) {
                    if (value != null) {
                        value = new Float(Double.parseDouble(value.toString()) * 72.0);
                    }
                    objOldProperty = new Float(Double.parseDouble(objOldProperty.toString()) / 72.0);
                }
            } else {
                value = new Float(Math.round(Double.parseDouble(value.toString())));
            }
        }
        this.m_cellSet.setPropertyValue(nRow, nColumn, nPropertyId, value);
        if (this.m_autoRepaint) {
            this.repaint();
        }
        return objOldProperty;
    }

    public Object setCellPropertyValue(CellPosition cellPos, int nPropertyId, Object objPropertyValue) {
        return this.setCellPropertyValue(cellPos.getRow(), cellPos.getColumn(), nPropertyId, objPropertyValue);
    }

    public String setCellPropertyExpression(int nRow, int nColumn, int nPropertyId, String strExpression) {
        String strOld = this.m_cellSet.setPropertyExpression(nRow, nColumn, nPropertyId, strExpression);
        if (nPropertyId == 4102) {
            this.repaint();
        }
        return strOld;
    }

    public String setCellPropertyExpression(CellPosition cellPos, int nPropertyId, String strExpression) {
        return this.setCellPropertyExpression(cellPos.getRow(), cellPos.getColumn(), nPropertyId, strExpression);
    }

    public IntHashtable getCellPropertyMap(int nRow, int nColumn) {
        IntHashtable objOldMap = null;
        objOldMap = this.m_cellSet.getPropertyMap(nRow, nColumn);
        return objOldMap;
    }

    public IntHashtable getCellPropertyMap(CellPosition cellPos) {
        return this.getCellPropertyMap(cellPos.getRow(), cellPos.getColumn());
    }

    public IntHashtable setCellPropertyMap(int nRow, int nColumn, IntHashtable objNewMap) {
        IntHashtable objOldMap = null;
        objOldMap = this.m_cellSet.setPropertyMap(nRow, nColumn, objNewMap);
        this.notifyPropertyChanged();
        return objOldMap;
    }

    public IntHashtable setCellPropertyMap(CellPosition cellPos, IntHashtable objNewMap) {
        return this.setCellPropertyMap(cellPos.getRow(), cellPos.getColumn(), objNewMap);
    }

    public int getRowCount() {
        return this.m_cellSet.getRow();
    }

    public int getColumnCount() {
        return this.m_cellSet.getColumn();
    }

    public boolean isMerged(int nRow, int nColumn) {
        return this.m_parser.isMerged(nRow, nColumn);
    }

    public boolean isMerged(CellPosition cellPos) {
        return this.isMerged(cellPos.getRow(), cellPos.getColumn());
    }

    public void insertColumn(int nColumn, Vector vectMap) {
        int activeCellStartCol;
        if (nColumn >= this.m_cellSet.getColumn() || nColumn < 0) {
            nColumn = this.m_cellSet.getColumn();
        }
        this.m_cellSet.insertColumn(nColumn);
        if (vectMap.size() > 0) {
            int nSize = vectMap.size();
            int iRow = 0;
            while (iRow < this.m_cellSet.getRow() && iRow < nSize) {
                IntHashtable propertyMap = (IntHashtable)vectMap.get(iRow);
                this.m_cellSet.setPropertyMap(iRow, nColumn, propertyMap);
                if (this.m_cellSet.isMerge(iRow, nColumn)) {
                    String mergeExp = (String)this.m_cellSet.getPropertyValue(iRow, nColumn, 4103);
                    int r1 = this.m_cellSet.getMergeRow1(mergeExp);
                    int r2 = this.m_cellSet.getMergeRow2(mergeExp);
                    int c1 = this.m_cellSet.getMergeColumn1(mergeExp);
                    int c2 = this.m_cellSet.getMergeColumn2(mergeExp);
                    r2 = r2 >= this.m_cellSet.getRow() ? this.m_cellSet.getRow() - 1 : r2;
                    c2 = c2 >= this.m_cellSet.getColumn() ? this.m_cellSet.getColumn() - 1 : c2;
                    this.m_cellSet.mergeRegion(r1, r2, c1, c2);
                }
                ++iRow;
            }
            iRow = this.m_cellSet.getRow();
            while (iRow < nSize) {
                RelativeFreeze freeze = (RelativeFreeze)vectMap.get(iRow);
                if (freeze != null) {
                    this.m_cellSet.relativeRelease(freeze.m_nRow, freeze.m_nColumn, freeze.m_nPropertyId);
                }
                ++iRow;
            }
        } else {
            int iRow = 0;
            while (iRow < this.m_cellSet.getRow()) {
                this.setCellDefaultProperty(iRow, nColumn);
                ++iRow;
            }
        }
        if (this.contentView.m_activeCell != null && nColumn <= (activeCellStartCol = this.contentView.m_activeCell.getColumn())) {
            this.contentView.m_activeCell.setColumn(++activeCellStartCol);
        }
        this.resetControlWidth();
        this.repaint();
    }

    private void resetControlWidth() {
        Point hp = this.getColumnHeader().getViewPosition();
        Point p = this.getViewport().getViewPosition();
        this.getColumnHeader().setView(this.createColHeaderView());
        this.contentView = this.createContentView();
        this.getViewport().setView(this.contentView);
        this.getColumnHeader().setViewPosition(hp);
        this.getViewport().setViewPosition(p);
    }

    private void resetControlHeight() {
        Point hp = this.getRowHeader().getViewPosition();
        Point p = this.getViewport().getViewPosition();
        this.getRowHeader().setView(this.createRowHeaderView());
        this.contentView = this.createContentView();
        this.getViewport().setView(this.contentView);
        this.getRowHeader().setViewPosition(hp);
        this.getViewport().setViewPosition(p);
    }

    public Vector removeColumn(int nColumn) {
        Vector objMapVector = null;
        if (nColumn < this.m_cellSet.getColumn() && nColumn > 0) {
            int activeCellStartCol;
            CellRegion cellRegion = new CellRegion();
            cellRegion.set(0, nColumn, this.m_cellSet.getRow() - 1, nColumn);
            objMapVector = this.getRegionPropertyMap(cellRegion);
            this.m_cellSet.removeColumn(nColumn);
            Vector vectFreeze = this.m_cellSet.getRelativeFreeze();
            if (vectFreeze != null) {
                objMapVector.addAll(vectFreeze);
            }
            if (this.contentView.m_activeCell != null && nColumn <= (activeCellStartCol = this.contentView.m_activeCell.getColumn()) && nColumn > 1) {
                this.contentView.m_activeCell.setColumn(--activeCellStartCol);
            }
            this.notifyPropertyChanged();
        }
        return objMapVector;
    }

    public void insertRow(int nRow, Vector vectMap) {
        int activeCellStartRow;
        if (nRow >= this.m_cellSet.getRow() || nRow < 0) {
            nRow = this.m_cellSet.getRow();
        }
        this.m_cellSet.insertRow(nRow);
        if (vectMap.size() > 0) {
            int nSize = vectMap.size();
            int iColumn = 0;
            while (iColumn < this.m_cellSet.getColumn() && iColumn < nSize) {
                IntHashtable propertyMap = (IntHashtable)vectMap.get(iColumn);
                this.m_cellSet.setPropertyMap(nRow, iColumn, propertyMap);
                if (this.m_cellSet.isMerge(nRow, iColumn)) {
                    String mergeExp = (String)this.m_cellSet.getPropertyValue(nRow, iColumn, 4103);
                    int r1 = this.m_cellSet.getMergeRow1(mergeExp);
                    int r2 = this.m_cellSet.getMergeRow2(mergeExp);
                    int c1 = this.m_cellSet.getMergeColumn1(mergeExp);
                    int c2 = this.m_cellSet.getMergeColumn2(mergeExp);
                    r2 = r2 >= this.m_cellSet.getRow() ? this.m_cellSet.getRow() - 1 : r2;
                    c2 = c2 >= this.m_cellSet.getColumn() ? this.m_cellSet.getColumn() - 1 : c2;
                    this.m_cellSet.mergeRegion(r1, r2, c1, c2);
                }
                ++iColumn;
            }
            iColumn = this.m_cellSet.getColumn();
            while (iColumn < nSize) {
                RelativeFreeze freeze = (RelativeFreeze)vectMap.get(iColumn);
                if (freeze != null) {
                    this.m_cellSet.relativeRelease(freeze.m_nRow, freeze.m_nColumn, freeze.m_nPropertyId);
                }
                ++iColumn;
            }
        } else {
            int iColumn = 0;
            while (iColumn < this.m_cellSet.getColumn()) {
                this.setCellDefaultProperty(nRow, iColumn);
                ++iColumn;
            }
        }
        if (this.contentView.m_activeCell != null && nRow <= (activeCellStartRow = this.contentView.m_activeCell.getRow())) {
            this.contentView.m_activeCell.setRow(++activeCellStartRow);
        }
        this.resetControlHeight();
        this.repaint();
    }

    public Vector removeRow(int nRow) {
        Vector objMapVector = null;
        if (nRow < this.m_cellSet.getRow() && nRow > 0) {
            int activeCellStartRow;
            CellRegion cellRegion = new CellRegion();
            cellRegion.set(nRow, 0, nRow, this.m_cellSet.getColumn() - 1);
            objMapVector = this.getRegionPropertyMap(cellRegion);
            this.m_cellSet.removeRow(nRow);
            Vector vectFreeze = this.m_cellSet.getRelativeFreeze();
            if (vectFreeze != null) {
                objMapVector.addAll(vectFreeze);
            }
            if (this.contentView.m_activeCell != null && nRow <= (activeCellStartRow = this.contentView.m_activeCell.getRow()) && nRow > 1) {
                this.contentView.m_activeCell.setRow(--activeCellStartRow);
            }
            this.notifyPropertyChanged();
        }
        return objMapVector;
    }

    private Vector getRegionPropertyMap(CellRegion cellRegion) {
        Vector<IntHashtable> vectMap = null;
        if (cellRegion != null) {
            vectMap = new Vector<IntHashtable>();
            int iRow = cellRegion.getTop();
            while (iRow <= cellRegion.getBottom()) {
                int iColumn = cellRegion.getLeft();
                while (iColumn <= cellRegion.getRight()) {
                    IntHashtable obj = this.m_cellSet.getPropertyMap(iRow, iColumn);
                    vectMap.add(obj);
                    ++iColumn;
                }
                ++iRow;
            }
        }
        return vectMap;
    }

    public void setBackImage(String fileName) {
        ImageIcon icon = new ImageIcon(fileName);
        this.backImage = icon.getImage();
        this.repaint();
    }

    public void setBackImage(Image image) {
        this.backImage = image;
        this.repaint();
    }

    public Image getBackImage() {
        return this.backImage;
    }

    public void clearBackImage() {
        if (this.backImage == null) {
            return;
        }
        this.backImage = null;
        this.repaint();
    }

    public JTextComponent getEditor() {
        if (this.contentView == null) {
            return null;
        }
        if (this.contentView.editor == null) {
            return null;
        }
        if (!(this.contentView.editor instanceof JTextComponent)) {
            return null;
        }
        return (JTextComponent)this.contentView.editor;
    }

    public void dispose() {
        this.m_cellSet = null;
        this.m_parser = null;
        this.m_selectedRegion = null;
        this.m_selectedCols = null;
        this.m_selectedRows = null;
        this.m_editorListener = null;
        if (this.contentView != null) {
            this.contentView.dispose();
        }
        this.backImage = null;
        this.cellX = null;
        this.cellY = null;
        this.cellW = null;
        this.cellH = null;
    }
}

