/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.Field;
import com.runqian.report.control.ContentPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ReportPage
extends JPanel {
    public ReportPage(CellSet cellSet, Dimension pageSize, boolean needHF, boolean editable) {
        Dimension d;
        this.setBackground(Color.white);
        this.setPreferredSize(pageSize);
        this.setLayout(null);
        CellSetParser parser = new CellSetParser(cellSet);
        Field pageHeader = parser.getPageHeader();
        Field pageFooter = parser.getPageFooter();
        int y = 0;
        int w = 0;
        int h = pageSize.height;
        if (pageHeader != null && needHF) {
            ContentPanel headerPanel = new ContentPanel(cellSet, pageHeader.getStartRow(), pageHeader.getEndRow(), 1, parser.getColCount() - 1, false, false, null, editable, null, null, null, 1);
            d = ((JComponent)headerPanel).getPreferredSize();
            w = d.width < pageSize.width ? d.width : pageSize.width;
            headerPanel.setBounds(0, 0, w, d.height);
            headerPanel.setBackground(Color.white);
            y += d.height;
            h -= d.height;
            this.add(headerPanel);
        }
        if (pageFooter != null && needHF) {
            ContentPanel footerPanel = new ContentPanel(cellSet, pageFooter.getStartRow(), pageFooter.getEndRow(), 1, parser.getColCount() - 1, false, false, null, editable, null, null, null, 1);
            d = ((JComponent)footerPanel).getPreferredSize();
            w = d.width < pageSize.width ? d.width : pageSize.width;
            footerPanel.setBounds(0, pageSize.height - d.height, w, d.height);
            footerPanel.setBackground(Color.white);
            h -= d.height;
            this.add(footerPanel);
        }
        int startRow = pageHeader == null ? 1 : pageHeader.getEndRow() + 1;
        int endRow = pageFooter == null ? parser.getRowCount() - 1 : pageFooter.getStartRow() - 1;
        ContentPanel tablePanel = new ContentPanel(cellSet, startRow, endRow, 1, parser.getColCount() - 1, false, false, null, editable, null, null, null, 1);
        d = ((JComponent)tablePanel).getPreferredSize();
        w = d.width < pageSize.width ? d.width : pageSize.width;
        h = d.height < h ? d.height : h;
        tablePanel.setBounds(0, y, w, h);
        tablePanel.setBackground(Color.white);
        this.add(tablePanel);
    }

    public void paintComponent(Graphics g) {
        g.clearRect(0, 0, 999999, 999999);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth() + 5, this.getHeight() + 5);
    }

    void setAlign(int align) {
        Component[] child = this.getComponents();
        int i = 0;
        while (i < child.length) {
            Component c = child[i];
            if (c instanceof JPanel) {
                JPanel jp = (JPanel)c;
                int w = jp.getWidth();
                int W = this.getWidth();
                int x = 0;
                if (align == 0) {
                    x = (W - w) / 2;
                } else if (align == 2) {
                    x = W - w;
                }
                Rectangle r = jp.getBounds();
                r.x = x;
                jp.setBounds(r);
            }
            ++i;
        }
    }
}

