/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.report.cellset.CellRegion;
import com.runqian.report.control.ControlUtils;
import com.runqian.report.control.ReportControl;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class RowHeaderListener
implements MouseMotionListener,
MouseListener {
    private ReportControl control;
    private int startSelectedRow;
    private int resizeStartY;
    private int resizeStartRow;
    private int tableWidth;
    private int oldCellHeight;

    public RowHeaderListener(ReportControl control) {
        this.control = control;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int row = ControlUtils.lookupHeaderIndex(e.getY(), this.control.cellY, this.control.cellH);
        if (row < 0) {
            return;
        }
        boolean rowIsSelected = false;
        if (this.control.m_selectedRows != null) {
            int i = 0;
            while (i < this.control.m_selectedRows.size()) {
                Integer r = (Integer)this.control.m_selectedRows.get(i);
                if (r == row) {
                    rowIsSelected = true;
                    break;
                }
                ++i;
            }
        }
        if (e.getButton() == 1 || !rowIsSelected) {
            if (this.control.status != 4 || e.getButton() != 1) {
                this.control.m_selectedCols = null;
                this.control.m_cornerSelected = false;
                this.startSelectedRow = row;
                this.control.m_selectedRows = new Vector();
                this.control.m_selectedRows.add(new Integer(row));
                this.control.m_selectedRegion = new CellRegion(row, 1, row, this.control.m_parser.getColCount() - 1);
                this.control.repaint();
            } else if (e.getButton() == 1) {
                this.resizeStartY = e.getY();
                this.resizeStartRow = ControlUtils.lookupHeaderIndex(this.resizeStartY, this.control.cellY, this.control.cellH);
                this.oldCellHeight = this.control.cellH[row];
            }
        }
        this.showPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        int y = e.getY();
        int row = ControlUtils.lookupHeaderIndex(y, this.control.cellY, this.control.cellH);
        if (this.control.status == 4) {
            if (e.getButton() == 1) {
                int startRow = ControlUtils.lookupHeaderIndex(this.resizeStartY, this.control.cellY, this.control.cellH);
                if (row != startRow) {
                    row = startRow;
                }
                Vector willResizeRows = new Vector();
                willResizeRows.add(new Integer(row));
                if (this.control.m_selectedRows != null) {
                    int selectedStartRow = (Integer)this.control.m_selectedRows.get(0);
                    int selectedEndRow = (Integer)this.control.m_selectedRows.get(this.control.m_selectedRows.size() - 1);
                    if (row >= selectedStartRow && row <= selectedEndRow) {
                        willResizeRows = this.control.m_selectedRows;
                    }
                }
                this.control.m_cellSet.setPropertyValue(row, 0, 3101, new Integer(this.oldCellHeight));
                this.control.fireRowHeaderResized(willResizeRows, this.control.cellH[row]);
            }
        } else {
            this.control.fireRegionSelect();
        }
        this.control.status = 0;
        this.showPopup(e);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        int y = e.getY();
        int row = ControlUtils.lookupHeaderIndex(y, this.control.cellY, this.control.cellH);
        if (this.control.status == 0) {
            if (row < 0) {
                return;
            }
            int start = this.startSelectedRow < row ? this.startSelectedRow : row;
            int end = this.startSelectedRow > row ? this.startSelectedRow : row;
            this.control.m_selectedRows = new Vector();
            int i = start;
            while (i <= end) {
                this.control.m_selectedRows.add(new Integer(i));
                ++i;
            }
            this.control.m_selectedRegion = new CellRegion(start, 1, end, this.control.m_parser.getColCount() - 1);
            if (ControlUtils.scrollToVisible(this.control.getRowHeader(), this.control, row, 0)) {
                Point p1 = this.control.getRowHeader().getViewPosition();
                Point p2 = this.control.getViewport().getViewPosition();
                p2.y = p1.y;
                this.control.getViewport().setViewPosition(p2);
            }
            this.control.repaint();
        }
        if (this.control.status == 4) {
            if (row != this.resizeStartRow) {
                row = this.resizeStartRow;
            }
            int newHeight = this.control.cellH[row] + y - this.resizeStartY;
            this.resizeStartY = y;
            if (newHeight > 0) {
                this.control.m_cellSet.setPropertyValue(row, 0, 3101, new Integer(newHeight));
                this.control.getRowHeader().getView().repaint();
                this.control.getViewport().getView().repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        int y = e.getY();
        int row = ControlUtils.lookupHeaderIndex(y, this.control.cellY, this.control.cellH);
        if (row < 0) {
            this.control.status = 0;
            this.control.getRowHeader().getView().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (y >= this.control.cellY[row] + this.control.cellH[row] - 2 && y <= this.control.cellY[row] + this.control.cellH[row]) {
            this.control.status = 4;
            this.control.getRowHeader().getView().setCursor(Cursor.getPredefinedCursor(8));
        } else {
            this.control.status = 0;
            this.control.getRowHeader().getView().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.control.fireRightClicked(e, 3);
        }
    }
}

