/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.control;

import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.control.ControlUtils;
import com.runqian.report.control.ReportControl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import javax.swing.JPanel;

public class RowHeaderPanel
extends JPanel {
    private ReportControl control;

    public RowHeaderPanel(ReportControl control) {
        this.control = control;
        control.cellY = new int[control.m_cellSet.getRow()];
        control.cellH = new int[control.m_cellSet.getRow()];
        this.setPreferredSize(new Dimension(41, control.m_parser.getCellSetEditHeight()));
    }

    public void paintComponent(Graphics g) {
        int w = 40;
        g.clearRect(0, 0, w + 1, 999999);
        int rows = this.control.m_cellSet.getRow();
        if (rows != this.control.cellY.length) {
            this.control.cellY = new int[rows];
            this.control.cellH = new int[rows];
        }
        Rectangle r = this.control.getViewport().getViewRect();
        int i = 1;
        while (i < rows) {
            this.control.cellY[i] = i == 1 ? 1 : this.control.cellY[i - 1] + this.control.cellH[i - 1];
            this.control.cellH[i] = this.control.m_parser.getRowHeight(i);
            if (this.control.cellY[i] + this.control.cellH[i] > r.y && this.control.cellY[i] < r.y + r.height) {
                Color bkColor = Color.lightGray;
                String label = String.valueOf(i);
                Object rowType = this.control.m_parser.getPropertyValue(i, 0, 3103);
                if (rowType != null) {
                    int type = (Integer)rowType;
                    if (type == CellPropertyDefine.CRT_PAGE_HEADER) {
                        label = String.valueOf(label) + "(\u7709)";
                        bkColor = new Color(210, 180, 140);
                    } else if (type == CellPropertyDefine.CRT_TITLE) {
                        label = String.valueOf(label) + "(\u6807)";
                        bkColor = new Color(144, 238, 144);
                    } else if (type == CellPropertyDefine.CRT_TABLE_HEADER) {
                        label = String.valueOf(label) + "(\u5934)";
                        bkColor = new Color(221, 160, 221);
                    } else if (type == CellPropertyDefine.CRT_TABLE_FOOTER) {
                        label = String.valueOf(label) + "(\u5c3e)";
                        bkColor = new Color(255, 127, 80);
                    } else if (type == CellPropertyDefine.CRT_PAGE_FOOTER) {
                        label = String.valueOf(label) + "(\u811a)";
                        bkColor = new Color(255, 228, 181);
                    }
                }
                int flag = 0;
                if (this.control.m_selectedRegion != null) {
                    int row1 = this.control.m_selectedRegion.getTop();
                    int row2 = this.control.m_selectedRegion.getBottom();
                    if (i >= row1 && i <= row2) {
                        flag = 1;
                    }
                }
                if (this.control.m_selectedRows != null) {
                    int k = 0;
                    while (k < this.control.m_selectedRows.size()) {
                        if (i == (Integer)this.control.m_selectedRows.get(k)) {
                            flag = 2;
                            break;
                        }
                        ++k;
                    }
                }
                int y = this.control.cellY[i];
                int h = this.control.cellH[i];
                if (i > 1) {
                    ++y;
                    --h;
                }
                ControlUtils.drawHeader(g, 0, y, w, h, label, bkColor, flag);
            }
            ++i;
        }
        this.setPreferredSize(new Dimension(41, this.control.m_parser.getCellSetEditHeight()));
        g.dispose();
    }

    public Dimension getPreferredSize() {
        int height = 0;
        CellSetParser parser = this.control.m_parser;
        int row = 1;
        while (row < parser.getRowCount()) {
            height += parser.getRowHeight(row);
            ++row;
        }
        PageFormat pf = parser.getPageFormat();
        int hh = (int)pf.getImageableHeight();
        if (height < hh) {
            height = hh;
        }
        return new Dimension(41, height + 2);
    }
}

