/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.base.util.ReportError;
import com.runqian.report.dataset.AVLNode;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.dataset.Row;
import com.runqian.report.engine.Variant2;
import java.util.NoSuchElementException;

public class AVLIndex {
    static final int MEMORY_INDEX = 0;
    static final int DISK_INDEX = 1;
    private final DataSet ds;
    private final int[] cols;
    private final boolean isUnique;
    private AVLNode root;
    private int depth;

    AVLIndex(DataSet ds, int[] column, boolean unique) {
        this.ds = ds;
        this.cols = column;
        this.isUnique = unique;
    }

    AVLNode getRoot() {
        return this.root;
    }

    void setRoot(AVLNode r) {
        this.root = r;
        this.depth = 0;
    }

    boolean isUnique() {
        return this.isUnique;
    }

    int[] getColumns() {
        return this.cols;
    }

    int size() {
        int count = 0;
        AVLNode n = this.first();
        while (n != null) {
            n = this.next(n);
            ++count;
        }
        return count;
    }

    void clear() {
        this.root = null;
        this.depth = 0;
    }

    private int compareRow(Row row1, Row row2) {
        int i = 0;
        while (i < this.cols.length) {
            int col = this.cols[i];
            int c = Variant2.compare2(row1.getData(col), row2.getData(col));
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return 0;
    }

    void insert(AVLNode i) {
        AVLNode n;
        AVLNode x = n = this.root;
        boolean isleft = true;
        int compare = -1;
        while (true) {
            if (n == null) {
                if (x == null) {
                    this.root = i;
                    return;
                }
                break;
            }
            compare = this.compareRow(i.getRow(), n.getRow());
            if (compare == 0 && this.isUnique) {
                throw new ReportError("\u7d22\u5f15\u8fdd\u53cd\u552f\u4e00\u6027\u539f\u5219");
            }
            isleft = compare < 0;
            x = n;
            n = this.getChild(x, isleft);
        }
        this.setChild(x, isleft, i);
        this.balance(x, isleft);
    }

    private final AVLNode getChild(AVLNode x, boolean isleft) {
        return isleft ? x.getLeft() : x.getRight();
    }

    private void replace(AVLNode x, AVLNode n) {
        if (x == this.root) {
            this.root = n;
            if (n != null) {
                n.setParent(null);
            }
        } else {
            this.setChild(x.getParent(), x.isFromLeft(), n);
        }
    }

    private final void setChild(AVLNode x, boolean isleft, AVLNode n) {
        if (isleft) {
            x.setLeft(n);
        } else {
            x.setRight(n);
        }
        if (n != null) {
            n.setParent(x);
        }
    }

    private void balance(AVLNode x, boolean isleft) {
        while (true) {
            int sign = isleft ? 1 : -1;
            switch (x.getBalance() * sign) {
                case 1: {
                    x.setBalance(0);
                    return;
                }
                case 0: {
                    x.setBalance(-sign);
                    break;
                }
                case -1: {
                    AVLNode l = this.getChild(x, isleft);
                    if (l.getBalance() == -sign) {
                        this.replace(x, l);
                        this.setChild(x, isleft, this.getChild(l, !isleft));
                        this.setChild(l, !isleft, x);
                        x.setBalance(0);
                        l.setBalance(0);
                    } else {
                        AVLNode r = this.getChild(l, !isleft);
                        this.replace(x, r);
                        this.setChild(l, !isleft, this.getChild(r, isleft));
                        this.setChild(r, isleft, l);
                        this.setChild(x, isleft, this.getChild(r, !isleft));
                        this.setChild(r, !isleft, x);
                        int rb = r.getBalance();
                        x.setBalance(rb == -sign ? sign : 0);
                        l.setBalance(rb == sign ? -sign : 0);
                        r.setBalance(0);
                    }
                    return;
                }
            }
            if (x == this.root) {
                return;
            }
            isleft = x.isFromLeft();
            x = x.getParent();
        }
    }

    AVLNode first() {
        AVLNode x;
        this.depth = 0;
        AVLNode l = x = this.root;
        while (l != null) {
            x = l;
            l = x.getLeft();
            ++this.depth;
        }
        return x;
    }

    IndexRowIterator firstRow() {
        return new IndexRowIterator(this);
    }

    AVLNode next(AVLNode x) {
        if (x == null) {
            return null;
        }
        AVLNode r = x.getRight();
        if (r != null) {
            x = r;
            AVLNode l = x.getLeft();
            while (l != null) {
                x = l;
                l = x.getLeft();
            }
            return x;
        }
        AVLNode ch = x;
        x = x.getParent();
        while (x != null && ch.equals(x.getRight())) {
            ch = x;
            x = x.getParent();
        }
        return x;
    }

    void dump() {
        this.dump(0, this.root);
        System.out.println("==================================================");
    }

    private void dump(int depth, AVLNode n) {
        Row row;
        if (n == null) {
            return;
        }
        if (n.getLeft() != null) {
            this.dump(depth + 1, n.getLeft());
        }
        if ((row = n.getRow()) != null) {
            System.out.println(String.valueOf(AVLIndex.space(depth)) + row.getRowNo());
        } else {
            System.out.println(String.valueOf(AVLIndex.space(depth)) + "null");
        }
        if (n.getRight() != null) {
            this.dump(depth + 1, n.getRight());
        }
    }

    private static String space(int count) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < count) {
            sb.append(" ").append(" ");
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        DataSet ds = new DataSet();
        ds.addColumn("id");
        AVLIndex index = new AVLIndex(ds, new int[]{1}, true);
        int i = 1;
        while (i <= 3) {
            Row row = ds.addRow();
            row.setData(1, (Object)new Integer(i));
            AVLNode node = new AVLNode(row);
            index.insert(node);
            ++i;
        }
    }

    public static class IndexRowIterator {
        AVLIndex index;
        AVLNode next;

        private IndexRowIterator(AVLIndex index) {
            this.index = index;
            this.next = index.first();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Row next() {
            if (this.hasNext()) {
                Row row = this.next.getRow();
                this.next = this.index.next(this.next);
                return row;
            }
            throw new NoSuchElementException();
        }
    }
}

