/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.report.dataset.Row;
import com.runqian.report.engine.Expression;
import com.runqian.report.engine.Variable;
import com.runqian.report.engine.Variant2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class BINode
implements Variable {
    private int level;
    private Object value;
    private ArrayList childs;
    private ArrayList rows;
    static Comparator nodeComparator = new BINodeComparator();

    public BINode(int level, Object value) {
        this.level = level;
        this.value = value;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isLeaf() {
        return this.childs == null;
    }

    public Object getValue(boolean dispValue) {
        return this.value;
    }

    public int search(Object key) {
        return Collections.binarySearch(this.childs, key, nodeComparator);
    }

    public void addChild(BINode child) {
        if (this.childs == null) {
            this.childs = new ArrayList();
        }
        this.childs.add(child);
    }

    public int numOfChild() {
        if (this.childs == null) {
            return 0;
        }
        return this.childs.size();
    }

    public BINode getChild(int i) {
        return (BINode)this.childs.get(i);
    }

    public BINode getMaxChild() {
        if (this.childs == null) {
            return null;
        }
        return (BINode)this.childs.get(this.childs.size() - 1);
    }

    public void addRow(Row row) {
        if (this.rows == null) {
            this.rows = new ArrayList();
        }
        this.rows.add(row);
    }

    public void addRowsTo(List rowList) {
        if (this.rows != null) {
            rowList.addAll(this.rows);
            return;
        }
        if (this.childs != null) {
            int i = 0;
            while (i < this.childs.size()) {
                BINode node = (BINode)this.childs.get(i);
                node.addRowsTo(rowList);
                ++i;
            }
        }
    }

    public void addRowsTo(Expression filter, List rowList) {
        int i;
        if (this.rows != null) {
            i = 0;
            while (i < this.rows.size()) {
                Row row = (Row)this.rows.get(i);
                if (row.test(filter)) {
                    rowList.add(row);
                }
                ++i;
            }
        }
        if (this.childs != null) {
            i = 0;
            while (i < this.childs.size()) {
                BINode node = (BINode)this.childs.get(i);
                node.addRowsTo(rowList);
                ++i;
            }
        }
    }

    public List getRows() {
        return this.rows;
    }

    public Row getRow(Expression filter) {
        int i;
        if (this.rows != null) {
            i = 0;
            while (i < this.rows.size()) {
                Row row = (Row)this.rows.get(i);
                if (filter == null || row.test(filter)) {
                    return row;
                }
                ++i;
            }
        }
        if (this.childs != null) {
            i = 0;
            while (i < this.childs.size()) {
                BINode node = (BINode)this.childs.get(i);
                Row row = node.getRow(filter);
                if (row != null) {
                    return row;
                }
                ++i;
            }
        }
        return null;
    }

    public void trimToSize() {
        if (this.rows != null) {
            this.rows.trimToSize();
        }
        if (this.childs != null) {
            this.childs.trimToSize();
            int i = 0;
            while (i < this.childs.size()) {
                BINode node = (BINode)this.childs.get(i);
                node.trimToSize();
                ++i;
            }
        }
    }

    public void dump(String s1, String s2) {
        int i;
        if (this.rows == null) {
            i = 0;
            while (i < this.childs.size()) {
                BINode node = (BINode)this.childs.get(i);
                node.dump(String.valueOf(s1) + this.value + s2, s2);
                ++i;
            }
        }
        if (this.rows != null) {
            System.out.print("index=(" + s1 + this.value + ")");
            System.out.print(String.valueOf(s2) + "row=(");
            i = 0;
            while (i < this.rows.size()) {
                Row row = (Row)this.rows.get(i);
                if (i > 0) {
                    System.out.print(",");
                }
                System.out.print(row.getRowNo());
                ++i;
            }
            System.out.print(")");
        }
        System.out.println();
    }

    static class BINodeComparator
    implements Comparator {
        BINodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            return Variant2.compare(o1, o2);
        }
    }
}

