/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.report.dataset.BINode;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.dataset.Filter;
import com.runqian.report.dataset.Filters;
import com.runqian.report.dataset.Group;
import com.runqian.report.dataset.Row;
import com.runqian.report.engine.Expression;
import com.runqian.report.engine.Variant2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BlockIndex {
    private DataSet ds = null;
    int[] cols = null;
    private BINode root = new BINode(-1, "");
    private boolean sorted;

    public BlockIndex(DataSet ds, String[] colNames) {
        this(ds, colNames, false);
    }

    public BlockIndex(DataSet ds, String[] colNames, boolean sorted) {
        this.ds = ds;
        this.ds.getRootGroup().setIndexNode(this.root);
        this.cols = new int[colNames.length];
        int i = 0;
        while (i < colNames.length) {
            int col = ds.getColumnNo(colNames[i]);
            if (col < 0) {
                throw new RuntimeException("\u672a\u627e\u5230\u5217\u540d" + colNames[i]);
            }
            this.cols[i] = col;
            ++i;
        }
        this.sorted = sorted;
    }

    public BlockIndex(DataSet ds, int[] cols) {
        this(ds, cols, false);
    }

    public BlockIndex(DataSet ds, int[] cols, boolean sorted) {
        this.ds = ds;
        this.ds.getRootGroup().setIndexNode(this.root);
        this.cols = cols;
        int i = 0;
        while (i < cols.length) {
            if (cols[i] < 0 || cols[i] > ds.getColumnCount()) {
                throw new RuntimeException("\u5217\u53f7" + cols[i] + "\u8d85\u51fa\u6570\u636e\u96c6\u5217\u8303\u56f4");
            }
            ++i;
        }
        this.sorted = sorted;
    }

    public int[] getIndexColNos() {
        return this.cols;
    }

    public boolean getSorted() {
        return this.sorted;
    }

    public void create() {
        ArrayList rows = this.ds.getRootGroup().getRows();
        if (!this.sorted) {
            ArrayList tmp = new ArrayList(rows.size());
            tmp.addAll(rows);
            rows = tmp;
            Collections.sort(rows, new IndexComparator(this.cols));
        }
        int i = 0;
        while (i < rows.size()) {
            this.add((Row)rows.get(i));
            ++i;
        }
        this.root.trimToSize();
    }

    private void add(Row row) {
        BINode node = this.root;
        BINode child = null;
        int len = this.cols.length;
        int i = 0;
        while (i < len) {
            Object key = row.getData(this.cols[i]);
            int childNum = node.numOfChild();
            if (childNum == 0) {
                child = new BINode(i, key);
                node.addChild(child);
            } else {
                child = node.getMaxChild();
                Object value = child.getValue(false);
                int c = Variant2.compare2(key, value);
                if (c != 0) {
                    child = new BINode(i, key);
                    node.addChild(child);
                }
            }
            node = child;
            ++i;
        }
        node.addRow(row);
    }

    public void dump() {
        this.root.dump("", "\t");
    }

    public DataSet getDS() {
        return this.ds;
    }

    public BINode getRoot() {
        return this.root;
    }

    public int getNextLevelColNo(BINode node) {
        int nextLevel = node.getLevel() + 1;
        if (nextLevel < this.cols.length) {
            return this.cols[nextLevel];
        }
        return -1;
    }

    public int getLevelFrom(BINode node, int col) {
        return this.getLevelFrom(node.getLevel(), col);
    }

    public int getLevelFrom(int level, int col) {
        int nextLevel = level + 1;
        while (nextLevel < this.cols.length) {
            if (this.cols[nextLevel] == col) {
                return nextLevel;
            }
            ++nextLevel;
        }
        return -1;
    }

    public List getGroups(BINode parent, boolean asc) {
        ArrayList<Group> list = new ArrayList<Group>();
        if (asc) {
            int i = 0;
            while (i < parent.numOfChild()) {
                BINode n = parent.getChild(i);
                Group group = new Group(this.ds, false);
                group.setValue(n.getValue(false));
                group.setIndexNode(n);
                n.addRowsTo(group.getRows());
                list.add(group);
                ++i;
            }
        } else {
            int i = parent.numOfChild() - 1;
            while (i >= 0) {
                BINode n = parent.getChild(i);
                Group group = new Group(this.ds, false);
                group.setValue(n.getValue(false));
                group.setIndexNode(n);
                n.addRowsTo(group.getRows());
                list.add(group);
                ++i;
            }
        }
        return list;
    }

    public ArrayList getRows(BINode parent, Filters fs) {
        ArrayList rows = new ArrayList();
        this.getRows(parent, fs.getFilterExp(), fs, fs.includeAllFilter(), rows);
        return rows;
    }

    private void getRows(BINode parent, Expression filterExp, Filters fs, boolean includeAllFilter, List rows) {
        if (parent.getLevel() + 1 >= fs.getIndexColCount()) {
            if (includeAllFilter) {
                parent.addRowsTo(rows);
            } else {
                parent.addRowsTo(filterExp, rows);
            }
            return;
        }
        Filter[] filter = fs.getFilter(parent.getLevel() + 1);
        if (filter[0] == null) {
            int pos1 = parent.search(filter[1].value);
            if (pos1 < 0) {
                pos1 = -pos1 - 1;
            } else if (filter[1].op == 4) {
                --pos1;
            }
            int i = 0;
            while (i < pos1) {
                this.getRows(parent.getChild(i), filterExp, fs, includeAllFilter, rows);
                ++i;
            }
        } else {
            switch (filter[0].op) {
                case 0: {
                    int pos1 = parent.search(filter[0].value);
                    if (pos1 < 0) break;
                    this.getRows(parent.getChild(pos1), filterExp, fs, includeAllFilter, rows);
                    break;
                }
                case 1: {
                    List values = (List)filter[0].value;
                    int i = 0;
                    while (i < values.size()) {
                        int pos2 = parent.search(filter[0].value);
                        if (pos2 >= 0) {
                            this.getRows(parent.getChild(pos2), filterExp, fs, includeAllFilter, rows);
                        }
                        ++i;
                    }
                    break;
                }
                case 2: 
                case 3: {
                    int i;
                    int pos3 = parent.search(filter[0].value);
                    if (pos3 < 0) {
                        pos3 = -pos3 - 1;
                    } else if (filter[0].op == 2) {
                        ++pos3;
                    }
                    int pos4 = parent.numOfChild() - 1;
                    if (filter[1] != null) {
                        i = parent.search(filter[1].value);
                        if (i < 0) {
                            if ((i = -i - 1) <= pos4) {
                                pos4 = filter[1].op == 4 ? i - 1 : i;
                            }
                        } else if (filter[1].op == 4) {
                            pos4 = i - 1;
                        }
                    }
                    i = pos3;
                    while (i <= pos4) {
                        this.getRows(parent.getChild(i), filterExp, fs, includeAllFilter, rows);
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    public Row getRow(BINode parent, Filters fs) {
        return this.getRow(parent, fs.getFilterExp(), fs, fs.includeAllFilter());
    }

    private Row getRow(BINode parent, Expression filterExp, Filters fs, boolean includeAllFilter) {
        Filter[] filter;
        if (parent.getLevel() + 1 >= fs.getIndexColCount()) {
            Row row = null;
            row = includeAllFilter ? parent.getRow(null) : parent.getRow(filterExp);
            if (row != null) {
                return row;
            }
        }
        if ((filter = fs.getFilter(parent.getLevel() + 1))[0] == null) {
            int pos1 = parent.search(filter[1].value);
            if (pos1 < 0) {
                pos1 = -pos1 - 1;
            } else if (filter[1].op == 4) {
                --pos1;
            }
            int i = 0;
            while (i < pos1) {
                Row row = this.getRow(parent.getChild(i), filterExp, fs, includeAllFilter);
                if (row != null) {
                    return row;
                }
                ++i;
            }
        } else {
            switch (filter[0].op) {
                case 0: {
                    Row row;
                    int pos1 = parent.search(filter[0].value);
                    if (pos1 >= 0 && (row = this.getRow(parent.getChild(pos1), filterExp, fs, includeAllFilter)) != null) {
                        return row;
                    }
                    break;
                }
                case 1: {
                    List values = (List)filter[0].value;
                    int i = 0;
                    while (i < values.size()) {
                        Row row;
                        int pos2 = parent.search(filter[0].value);
                        if (pos2 >= 0 && (row = this.getRow(parent.getChild(pos2), filterExp, fs, includeAllFilter)) != null) {
                            return row;
                        }
                        ++i;
                    }
                    break;
                }
                case 2: 
                case 3: {
                    int i;
                    int pos3 = parent.search(filter[0].value);
                    if (pos3 < 0) {
                        pos3 = -pos3 - 1;
                    } else if (filter[0].op == 2) {
                        ++pos3;
                    }
                    int pos4 = parent.numOfChild() - 1;
                    if (filter[1] != null) {
                        i = parent.search(filter[1].value);
                        if (i < 0) {
                            if ((i = -i - 1) <= pos4) {
                                pos4 = filter[1].op == 4 ? i - 1 : i;
                            }
                        } else if (filter[1].op == 4) {
                            pos4 = i - 1;
                        }
                    }
                    i = pos3;
                    while (i <= pos4) {
                        Row row = this.getRow(parent.getChild(i), filterExp, fs, includeAllFilter);
                        if (row != null) {
                            return row;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return null;
    }

    class IndexComparator
    implements Comparator {
        private int[] cols;

        public IndexComparator(int[] cols) {
            this.cols = cols;
        }

        public int compare(Object o1, Object o2) {
            Row row1 = (Row)o1;
            Row row2 = (Row)o2;
            int i = 0;
            while (i < this.cols.length) {
                int c = Variant2.compare2(row1.getData(this.cols[i]), row2.getData(this.cols[i]));
                if (c != 0) {
                    return c;
                }
                ++i;
            }
            return 0;
        }
    }
}

