/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.base.util.ObjectCache;
import com.runqian.base.util.ReportError;
import com.runqian.report.dataset.CachedDataSet;
import java.io.File;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

class BlockInputStream {
    CachedDataSet ds = null;
    RandomAccessFile raf = null;

    public BlockInputStream(CachedDataSet ds, File f) throws Exception {
        this.ds = ds;
        this.raf = new RandomAccessFile(f, "r");
    }

    public BlockInputStream(CachedDataSet ds, String fileName) throws Exception {
        this.ds = ds;
        this.raf = new RandomAccessFile(fileName, "r");
    }

    public final Object[][] read(long offset) throws Exception {
        int colCount = this.ds.getColumnCount();
        this.raf.seek(offset);
        Object[][] o = new Object[100][colCount];
        int i = 0;
        while (i < 100) {
            int j = 0;
            while (j < colCount) {
                o[i][j] = this.readObject();
                ++j;
            }
            ++i;
        }
        return o;
    }

    private final Object readObject() throws Exception {
        byte type = this.raf.readByte();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                byte[] b1 = new byte[this.raf.readInt()];
                this.raf.read(b1);
                return new String(b1, "gb2312");
            }
            case 2: {
                double d = Double.longBitsToDouble(this.raf.readLong());
                return new Double(d);
            }
            case 3: {
                return ObjectCache.getInteger(this.raf.readInt());
            }
            case 4: {
                return new Long(this.raf.readLong());
            }
            case 5: {
                byte[] bb5 = new byte[this.raf.readInt()];
                this.raf.read(bb5);
                return new BigInteger(bb5);
            }
            case 6: {
                int scale = this.raf.readInt();
                byte[] bb6 = new byte[this.raf.readInt()];
                this.raf.read(bb6);
                return new BigDecimal(new BigInteger(bb6), scale);
            }
            case 7: {
                return new Date(this.raf.readLong());
            }
            case 8: {
                byte[] bb8 = new byte[this.raf.readInt()];
                this.raf.read(bb8);
                return bb8;
            }
            case 9: {
                return new Short(this.raf.readShort());
            }
            case 10: {
                return new Byte(this.raf.readByte());
            }
            case 11: {
                return this.raf.readByte() == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                float f = Float.intBitsToFloat(this.raf.readInt());
                return new Float(f);
            }
        }
        throw new ReportError("\u4e0d\u53ef\u8bc6\u522b\u7684\u7c7b\u578b" + type);
    }

    public void close() throws Exception {
        this.raf.close();
    }
}

