/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.base.util.ReportError;
import com.runqian.report.dataset.CachedDataSet;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

class BlockOutputStream {
    CachedDataSet ds = null;
    DataOutputStream dos = null;
    int colCount = 0;

    public BlockOutputStream(CachedDataSet ds, File f) throws Exception {
        this.ds = ds;
        this.colCount = ds.getColumnCount();
        this.dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f), 51200));
    }

    public final int write(Object[][] block) throws Exception {
        int i = 0;
        while (i < 100) {
            int j = 0;
            while (j < this.colCount) {
                Object o = block[i][j];
                if (o == null) {
                    this.dos.writeByte(0);
                } else if (o instanceof String) {
                    this.dos.writeByte(1);
                    byte[] bb = ((String)o).getBytes("gb2312");
                    this.dos.writeInt(bb.length);
                    this.dos.write(bb);
                } else if (o instanceof Double) {
                    this.dos.writeByte(2);
                    double d = (Double)o;
                    this.dos.writeLong(Double.doubleToLongBits(d));
                } else if (o instanceof Integer) {
                    this.dos.writeByte(3);
                    this.dos.writeInt((Integer)o);
                } else if (o instanceof Long) {
                    this.dos.writeByte(4);
                    this.dos.writeLong((Long)o);
                } else if (o instanceof BigInteger) {
                    this.dos.writeByte(5);
                    byte[] bb = ((BigInteger)o).toByteArray();
                    this.dos.writeInt(bb.length);
                    this.dos.write(bb);
                } else if (o instanceof BigDecimal) {
                    this.dos.writeByte(6);
                    BigDecimal bd = (BigDecimal)o;
                    byte[] bb = bd.unscaledValue().toByteArray();
                    this.dos.writeInt(bd.scale());
                    this.dos.writeInt(bb.length);
                    this.dos.write(bb);
                } else if (o instanceof Date) {
                    this.dos.writeByte(7);
                    this.dos.writeLong(((Date)o).getTime());
                } else if (o instanceof byte[]) {
                    this.dos.writeByte(8);
                    byte[] bb = (byte[])o;
                    this.dos.writeInt(bb.length);
                    this.dos.write(bb);
                } else if (o instanceof Short) {
                    this.dos.writeByte(9);
                    this.dos.writeShort(((Short)o).shortValue());
                } else if (o instanceof Byte) {
                    this.dos.writeByte(10);
                    this.dos.writeByte(((Byte)o).byteValue());
                } else if (o instanceof Boolean) {
                    this.dos.writeByte(11);
                    this.dos.writeByte((Boolean)o != false ? 0 : 1);
                } else if (o instanceof Float) {
                    this.dos.writeByte(12);
                    float f = ((Float)o).floatValue();
                    this.dos.writeByte(Float.floatToIntBits(f));
                } else {
                    throw new ReportError("\u4e0d\u8ba4\u8bc6\u7684\u6570\u636e\u7c7b\u578b:" + o.getClass().getName());
                }
                ++j;
            }
            ++i;
        }
        this.dos.flush();
        return this.dos.size();
    }

    public void close() throws Exception {
        this.dos.close();
    }
}

