/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.base.util.LongArrayList;
import com.runqian.base.util.ReportError;
import com.runqian.report.dataset.BlockInputStream;
import com.runqian.report.dataset.BlockOutputStream;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.dataset.DataSetSaver;
import com.runqian.report.dataset.Group;
import com.runqian.report.dataset.Row;
import com.runqian.report.dataset.TmpFile;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

public class CachedDataSet
extends DataSet {
    static final int BLOCKSIZE = 100;
    Object lock1 = new Object();
    ArrayList queue;
    private LongArrayList indexList;
    private Object[][] block;
    private File dataFile;
    private ReferenceQueue rq;
    private BlockOutputStream bos;
    private BlockInputStream bis;
    private DataSetSaver saver;
    private volatile boolean finished = false;

    public CachedDataSet(int initRowCap, int initColCap) throws Exception {
        this.colNameList = new ArrayList(initColCap);
        this.colNameList.add("__row");
        this.dataList = new ArrayList(initRowCap / 100 + 1);
        this.indexList = new LongArrayList(initRowCap / 100 + 1);
        this.indexList.addLong(0L);
        this.queue = new ArrayList();
        this.rootGroup = new Group(this, initRowCap, true);
        this.dataFile = TmpFile.make();
        this.rq = new ReferenceQueue();
        this.saver = new DataSetSaver(this);
        this.saver.start();
    }

    public CachedDataSet() throws Exception {
        this(100, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (!this.finished) {
            this.finished = true;
            Object object = this.lock1;
            synchronized (object) {
                this.lock1.notify();
            }
            if (this.bos != null) {
                this.bos.close();
            }
        }
        if (this.bis != null) {
            this.bis.close();
        }
    }

    public Row addRow() {
        ++this.allRowCount;
        Row row = new Row(this, this.allRowCount);
        if (this.allRowCount % 100 == 1) {
            if (this.allRowCount > 100) {
                this.addBlockToQueue();
            }
            while (this.queue.size() > 500) {
                try {
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.block = new Object[100][this.getColumnCount()];
        }
        this.rootGroup.addRow(row);
        return row;
    }

    public void setData(int rowNo, int colNo, Object value) {
        throw new ReportError("\u7f13\u5b58\u6570\u636e\u96c6\u4e0d\u80fd\u91cd\u65b0\u8bbe\u7f6e\u6570\u636e");
    }

    public final Object[] getRowData(int rowNo) {
        int blockIndex = (rowNo - 1) / 100;
        if (this.finished) {
            SoftReference sr = (SoftReference)this.dataList.get(blockIndex);
            Object[][] tmp = (Object[][])sr.get();
            if (tmp == null) {
                try {
                    if (this.bis == null) {
                        this.bis = new BlockInputStream(this, this.dataFile);
                    }
                    long offset = this.indexList.getLong(blockIndex);
                    tmp = this.bis.read(offset);
                    System.err.println("read block " + blockIndex);
                }
                catch (Exception e) {
                    throw new ReportError("\u4ece\u7f13\u5b58\u4e2d\u53d6\u6570\u636e\u65f6\u51fa\u9519", e);
                }
                this.dataList.set(blockIndex, new SoftReference<Object[][]>(tmp));
            }
            return tmp[(rowNo - 1) % 100];
        }
        return this.block[(rowNo - 1) % 100];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBlockToQueue() {
        Object object = this.lock1;
        synchronized (object) {
            this.queue.add(this.block);
            this.lock1.notify();
            this.block = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finish() {
        if (this.finished) {
            return;
        }
        if (this.block != null) {
            this.addBlockToQueue();
        }
        try {
            Object object = this.lock1;
            synchronized (object) {
                this.lock1.notify();
            }
            this.finished = true;
            this.saver.join();
            this.bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.queue = null;
        this.bos = null;
        this.saver = null;
        if (this.dataIndex != null) {
            this.dataIndex.create();
        }
    }

    final boolean finished() {
        return this.finished;
    }

    public final void writeBlock(Object[][] tmp) {
        try {
            if (this.bos == null) {
                this.bos = new BlockOutputStream(this, this.dataFile);
            }
            this.indexList.addLong(this.bos.write(tmp));
        }
        catch (Exception e) {
            throw new ReportError("\u5199\u6570\u636e\u96c6\u7f13\u5b58\u65f6\u51fa\u9519", e);
        }
        this.dataList.add(new SoftReference<Object[][]>(tmp));
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            CachedDataSet ds = new CachedDataSet();
            ds.addColumn("int");
            ds.addColumn("name");
            ds.addColumn("date");
            ds.addColumn("dec1");
            ds.addColumn("dec2");
            int i = 0;
            while (i < 1000000) {
                Row row = ds.addRow();
                row.setData(1, (Object)new Integer(i));
                row.setData(2, (Object)new String("abc"));
                row.setData(3, (Object)new Date());
                row.setData(4, (Object)new BigDecimal(100.4 * (double)i));
                row.setData(5, (Object)new BigDecimal(2313.4 * (double)i));
                ++i;
            }
            ds.finish();
            long t2 = System.currentTimeMillis();
            System.out.println("time1 = " + (double)(t2 - t1) / 1000.0);
            int[] xx = new int[]{1000, 3599, 34322, 52422, 32, 993433, 33293, 423901, 394933};
            int i2 = 0;
            while (i2 < xx.length) {
                Object[] o = ds.getRowData(xx[i2]);
                System.err.println(o[0] + "\t" + o[1] + "\t" + o[2] + "\t" + o[3]);
                ++i2;
            }
            System.out.println("time2 = " + (double)(System.currentTimeMillis() - t2) / 1000.0);
            ds = null;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

