/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.report.dataset.BlockIndex;
import com.runqian.report.dataset.Group;
import com.runqian.report.dataset.NullRow;
import com.runqian.report.dataset.Row;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Date;

public class DataSet {
    protected ArrayList colNameList;
    protected ArrayList dataList;
    protected Group rootGroup;
    protected Group curGroup;
    protected Row curRow;
    protected volatile int allRowCount = 0;
    private int[] rowNos;
    protected NullRow nullRow = null;
    protected BlockIndex dataIndex = null;
    public static final boolean DEBUG = Boolean.getBoolean("com.runqian.report.dataset.debug");

    public DataSet(int initRowCap, int initColCap) {
        this.colNameList = new ArrayList(initColCap);
        this.colNameList.add("$$rowno");
        this.dataList = new ArrayList(initRowCap);
        this.rootGroup = new Group(this, initRowCap, true);
    }

    public DataSet() {
        this(100, 10);
    }

    public NullRow getNullRow() {
        if (this.nullRow == null) {
            this.nullRow = new NullRow(this);
        }
        return this.nullRow;
    }

    public final int getColumnCount() {
        return this.colNameList.size() - 1;
    }

    public final void insertColumn(int colNo, String colName) {
        this.colNameList.add(colNo, colName);
    }

    public final void addColumn(String colName) {
        this.colNameList.add(colName);
    }

    public final int getColumnNo(String colName) {
        int i = 0;
        while (i < this.colNameList.size()) {
            if (colName.equalsIgnoreCase((String)this.colNameList.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final String getColumnName(int colNo) {
        if (colNo < 0 || colNo >= this.colNameList.size()) {
            return null;
        }
        return (String)this.colNameList.get(colNo);
    }

    public final boolean isColumnName(String id) {
        return this.getColumnNo(id) >= 0;
    }

    public final int getAllRowCount() {
        return this.allRowCount;
    }

    public Row addRow() {
        ++this.allRowCount;
        Row row = new Row(this, this.allRowCount);
        this.dataList.add(new Object[this.getColumnCount()]);
        this.rootGroup.addRow(row);
        return row;
    }

    public final Group getRootGroup() {
        return this.rootGroup;
    }

    public final Group newRootGroup() {
        Group group = new Group(this, this.allRowCount, true);
        int i = 1;
        while (i <= this.allRowCount) {
            group.addRow(new Row(this, i));
            ++i;
        }
        return group;
    }

    public void setData(int rowNo, int colNo, Object value) {
        Object[] rowData = this.getRowData(rowNo);
        rowData[colNo - 1] = value;
    }

    public Object getData(int rowNo, int colNo) {
        Object[] rowData = this.getRowData(rowNo);
        return rowData[colNo - 1];
    }

    Object[] getRowData(int rowNo) {
        return (Object[])this.dataList.get(rowNo - 1);
    }

    public void finish() {
        if (this.dataIndex != null) {
            this.dataIndex.create();
        }
    }

    public void createIndex(String[] colNames) {
        this.dataIndex = new BlockIndex(this, colNames, false);
    }

    public void createIndex(String[] colNames, boolean sorted) {
        this.dataIndex = new BlockIndex(this, colNames, sorted);
    }

    public void createIndex(int[] cols) {
        this.dataIndex = new BlockIndex(this, cols, false);
    }

    public void createIndex(int[] cols, boolean sorted) {
        this.dataIndex = new BlockIndex(this, cols, sorted);
    }

    public BlockIndex getIndex() {
        return this.dataIndex;
    }

    final int[] applyEmptyRowsArray() {
        if (this.rowNos == null) {
            this.rowNos = new int[this.allRowCount + 1];
        }
        int i = 0;
        while (i < this.rowNos.length) {
            this.rowNos[i] = -1;
            ++i;
        }
        return this.rowNos;
    }

    public final void setCurrentGroup(Group group) {
        this.curGroup = group;
    }

    public final Group getCurrentGroup() {
        return this.curGroup;
    }

    public final void setCurrentRow(Row row) {
        this.curRow = row;
    }

    public final Row getCurrentRow() {
        return this.curRow;
    }

    public static void main(String[] args) {
        try {
            DataSet ds = new DataSet();
            Class.forName("com.sybase.jdbc2.jdbc.SybDriver");
            Connection cn = DriverManager.getConnection("jdbc:sybase:Tds:yanjing:2048/xu", "sa", "");
            PreparedStatement pst = cn.prepareStatement("select * from RMBC");
            ResultSet rs = pst.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int i = 1;
            while (i <= rsmd.getColumnCount()) {
                ds.addColumn(rsmd.getColumnName(i));
                ++i;
            }
            System.out.print("column count:");
            System.out.print(ds.getColumnCount());
            int n = 0;
            Date date = new Date();
            System.out.print("start time:");
            System.out.print(date);
            while (rs.next()) {
                ++n;
            }
            System.out.print("row count:");
            System.out.print(n);
            date = new Date();
            System.out.print("end time:");
            System.out.print(date);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

