/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.base.util.ReportError;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.dataset.DataSetFactory;
import com.runqian.report.dataset.ProcDataSetFactory;
import com.runqian.report.dataset.SQLDataSetFactory;
import com.runqian.report.dataset.TextDataSetFactory;
import com.runqian.report.dataset.XMLDataSetFactory;
import com.runqian.report.usermodel.Env;
import java.util.Properties;

public class DataSetCreator {
    public DataSet getDataSet(Env env, Properties config) {
        if (config == null) {
            throw new ReportError("config is null");
        }
        String type = config.getProperty("type");
        try {
            DataSetFactory dsf = null;
            if ("normal".equalsIgnoreCase(type)) {
                dsf = new SQLDataSetFactory();
            } else if ("complex".equalsIgnoreCase(type)) {
                dsf = new SQLDataSetFactory();
            } else if ("proc".equalsIgnoreCase(type)) {
                dsf = new ProcDataSetFactory();
            } else if ("text".equalsIgnoreCase(type)) {
                dsf = new TextDataSetFactory();
            } else if ("xml".equalsIgnoreCase(type)) {
                dsf = new XMLDataSetFactory();
            } else if ("self".equalsIgnoreCase(type)) {
                String className = config.getProperty("className");
                dsf = (DataSetFactory)Class.forName(className).newInstance();
            } else {
                throw new ReportError("\u6570\u636e\u96c6" + config.getProperty("name") + "\u5177\u6709\u65e0\u6cd5\u8bc6\u522b\u7684\u7c7b\u578b" + type);
            }
            dsf.setProperties(config);
            return dsf.getDataSet(env);
        }
        catch (Exception e) {
            throw new ReportError("\u4e0d\u80fd\u4ea7\u751f\u6570\u636e\u96c6" + config.getProperty("name"), e);
        }
    }
}

