/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.report.dataset.BlockIndex;
import com.runqian.report.dataset.Filter;
import com.runqian.report.engine.Constant;
import com.runqian.report.engine.DSVariable;
import com.runqian.report.engine.Expression;
import com.runqian.report.engine.Node;
import com.runqian.report.engine.operator.And;
import com.runqian.report.engine.operator.Equals;
import com.runqian.report.engine.operator.Greater;
import com.runqian.report.engine.operator.In;
import com.runqian.report.engine.operator.NotGreater;
import com.runqian.report.engine.operator.NotSmaller;
import com.runqian.report.engine.operator.Smaller;

public class Filters {
    public static final int EQ = 0;
    public static final int IN = 1;
    public static final int GT = 2;
    public static final int GE = 3;
    public static final int LT = 4;
    public static final int LE = 5;
    private BlockIndex dataIndex = null;
    private int groupLevel = -1;
    private Expression filterExp;
    private Filter[][] filters = null;
    private int count = 0;
    private boolean includeAllFilter = true;

    public Filters(BlockIndex dataIndex, int groupLevel, Expression filterExp) {
        this.dataIndex = dataIndex;
        this.groupLevel = groupLevel;
        this.filterExp = filterExp;
        this.checkFilters();
        this.validate();
    }

    public Expression getFilterExp() {
        return this.filterExp;
    }

    private void validate() {
        int start;
        int level = start = this.groupLevel + 1;
        while (level < this.dataIndex.cols.length) {
            if (this.filters[level][0] == null && this.filters[level][1] == null) {
                int i = level + 1;
                while (i < this.dataIndex.cols.length) {
                    if (this.filters[i][0] != null || this.filters[i][1] != null) {
                        this.includeAllFilter = false;
                    }
                    this.filters[i][0] = null;
                    this.filters[i][1] = null;
                    ++i;
                }
                break;
            }
            ++this.count;
            ++level;
        }
        if (this.count == 0) {
            this.filters = null;
        }
    }

    public int getIndexColCount() {
        return this.count;
    }

    public boolean includeAllFilter() {
        return this.includeAllFilter;
    }

    public Filter[] getFilter(int i) {
        return this.filters[i];
    }

    private boolean addFilter(int col, int op, Object value) {
        int level = this.dataIndex.getLevelFrom(this.groupLevel, col);
        if (level < 0) {
            return false;
        }
        if (this.filters == null) {
            this.filters = new Filter[this.dataIndex.cols.length][2];
            if (op == 4 || op == 5) {
                this.filters[level][1] = new Filter(op, value);
            } else {
                this.filters[level][0] = new Filter(op, value);
            }
            return true;
        }
        Filter f0 = this.filters[level][0];
        Filter f1 = this.filters[level][1];
        switch (op) {
            case 0: {
                if (f0 == null) {
                    this.filters[level][0] = new Filter(op, value);
                    this.filters[level][1] = null;
                    return true;
                }
                if (f0.op == 0) break;
                this.filters[level][0].op = op;
                this.filters[level][0].value = value;
                this.filters[level][1] = null;
                break;
            }
            case 1: {
                if (f0 == null) {
                    this.filters[level][0] = new Filter(op, value);
                    this.filters[level][1] = null;
                    return true;
                }
                if (f0.op != 2 && f0.op != 3) break;
                this.filters[level][0].op = op;
                this.filters[level][0].value = value;
                this.filters[level][1] = null;
                break;
            }
            case 2: 
            case 3: {
                if (f0 != null) break;
                this.filters[level][0] = new Filter(op, value);
                return true;
            }
            case 4: 
            case 5: {
                if (f1 != null) break;
                this.filters[level][1] = new Filter(op, value);
                return true;
            }
        }
        return false;
    }

    private void checkFilters() {
        if (this.filterExp == null) {
            return;
        }
        this.checkFilters(this.filterExp.getHome());
    }

    private void checkFilters(Node node) {
        if (node instanceof And) {
            this.checkFilters(node.getLeft());
            this.checkFilters(node.getRight());
            return;
        }
        if (node instanceof Equals) {
            if (!this.check(0, node.getLeft(), node.getRight())) {
                this.includeAllFilter = false;
            }
        } else if (node instanceof Greater) {
            if (!this.check(2, node.getLeft(), node.getRight())) {
                this.includeAllFilter = false;
            }
        } else if (node instanceof Smaller) {
            if (!this.check(4, node.getLeft(), node.getRight())) {
                this.includeAllFilter = false;
            }
        } else if (node instanceof NotSmaller) {
            if (!this.check(3, node.getLeft(), node.getRight())) {
                this.includeAllFilter = false;
            }
        } else if (node instanceof NotGreater) {
            if (!this.check(5, node.getLeft(), node.getRight())) {
                this.includeAllFilter = false;
            }
        } else if (node instanceof In) {
            if (!this.check(1, node.getLeft(), node.getRight())) {
                this.includeAllFilter = false;
            }
        } else {
            this.includeAllFilter = false;
        }
    }

    private boolean check(int op, Node left, Node right) {
        int col;
        DSVariable var;
        if (left instanceof DSVariable) {
            int col2;
            DSVariable var2 = (DSVariable)left;
            if (var2.getDS() == this.dataIndex.getDS() && this.dataIndex.getLevelFrom(this.groupLevel, col2 = var2.getColNo()) >= 0 && right instanceof Constant) {
                return this.addFilter(col2, op, ((Constant)right).getValue(false));
            }
        } else if (right instanceof DSVariable && (var = (DSVariable)right).getDS() == this.dataIndex.getDS() && this.dataIndex.getLevelFrom(this.groupLevel, col = var.getColNo()) >= 0 && left instanceof Constant) {
            return this.addFilter(col, op, ((Constant)left).getValue(false));
        }
        return false;
    }
}

