/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.base.util.Logger;
import com.runqian.base.util.ObjectCache;
import com.runqian.base.util.ReportError;
import com.runqian.report.dataset.BINode;
import com.runqian.report.dataset.BlockIndex;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.dataset.Filters;
import com.runqian.report.dataset.Row;
import com.runqian.report.engine.DSVariable;
import com.runqian.report.engine.Expression;
import com.runqian.report.engine.ExtCellSet;
import com.runqian.report.engine.Node;
import com.runqian.report.engine.RowComparator;
import com.runqian.report.engine.Variable;
import com.runqian.report.engine.Variant2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Group
implements Variable,
Cloneable {
    private DataSet ds;
    private ArrayList rowList;
    private Object value;
    private boolean isRootGroup = false;
    private BINode iNode = null;

    public Group(DataSet ds, int initCap, boolean isRootGroup) {
        this.ds = ds;
        this.rowList = new ArrayList(initCap);
        this.isRootGroup = isRootGroup;
    }

    public Group(DataSet ds, boolean isRootGroup) {
        this(ds, 20, isRootGroup);
    }

    public Group(DataSet ds) {
        this(ds, 20, false);
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public boolean isRootGroup() {
        return this.isRootGroup;
    }

    public Object clone() {
        try {
            Group newGroup = (Group)super.clone();
            newGroup.rowList = (ArrayList)this.rowList.clone();
            return newGroup;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public final int getRowCount() {
        return this.rowList.size();
    }

    public final void addRow(Row row) {
        this.rowList.add(row);
    }

    public final void addRows(List rows) {
        this.rowList.addAll(rows);
    }

    public final List getRows() {
        return this.rowList;
    }

    public final Row getRow(int index) {
        return (Row)this.rowList.get(index);
    }

    public final void setValue(Object value) {
        this.value = value;
    }

    public final Object getValue(boolean dispValue) {
        return this.value;
    }

    public final void trimToSize() {
        this.rowList.trimToSize();
    }

    void setIndexNode(BINode iNode) {
        this.iNode = iNode;
    }

    BINode getIndexNode() {
        return this.iNode;
    }

    public final void evaulateRows(Expression exp) {
        int i = 0;
        while (i < this.rowList.size()) {
            Row row = (Row)this.rowList.get(i);
            row.setValue(row.evaluate(exp));
            ++i;
        }
    }

    public Filters getFilters(Expression filterExp) {
        BlockIndex bi = this.ds.getIndex();
        if (bi == null) {
            return null;
        }
        if (this.iNode == null) {
            return null;
        }
        Filters f = new Filters(bi, this.iNode.getLevel(), filterExp);
        if (f.getIndexColCount() == 0) {
            return null;
        }
        return f;
    }

    public final Row select1(Expression filterExp) {
        if (filterExp == null) {
            if (this.rowList.size() == 0) {
                return this.ds.getNullRow();
            }
            return (Row)this.rowList.get(0);
        }
        Filters f = filterExp.getFilters(this);
        if (f == null) {
            int i = 0;
            while (i < this.rowList.size()) {
                Row row = (Row)this.rowList.get(i);
                if (row.test(filterExp)) {
                    return row;
                }
                ++i;
            }
        } else {
            Row row;
            if (DataSet.DEBUG) {
                ExtCellSet cs = filterExp.getCS();
                if (cs != null && cs.getCurrent() != null) {
                    if (cs.getCurrent().getSource() == cs.getCurrent()) {
                        Logger.info(String.valueOf(cs.getCurrent().getSourceId()) + "\u5355\u9009\u5b8c\u5168\u4f7f\u7528\u7d22\u5f15");
                    }
                } else {
                    Logger.info("\u5355\u9009\u5b8c\u5168\u4f7f\u7528\u7d22\u5f15");
                }
            }
            if ((row = this.ds.getIndex().getRow(this.iNode, f)) != null) {
                return row;
            }
        }
        return this.ds.getNullRow();
    }

    private final void filterWithoutIndex(Expression exp) {
        int size = this.rowList.size();
        ArrayList<Row> list = new ArrayList<Row>(size > 1000 ? size / 100 : 10);
        int i = 0;
        while (i < size) {
            Row row = (Row)this.rowList.get(i);
            if (row.test(exp)) {
                list.add(row);
            }
            ++i;
        }
        list.trimToSize();
        this.rowList = list;
    }

    private final void filterWithIndex(Expression exp) {
        Filters f = exp.getFilters(this);
        if (DataSet.DEBUG) {
            boolean b = f.includeAllFilter();
            ExtCellSet cs = exp.getCS();
            if (cs != null && cs.getCurrent() != null) {
                if (cs.getCurrent().getSource() == cs.getCurrent()) {
                    if (b) {
                        Logger.info(String.valueOf(cs.getCurrent().getSourceId()) + "\u8fc7\u6ee4\u5b8c\u5168\u4f7f\u7528\u7d22\u5f15");
                    } else {
                        Logger.info(String.valueOf(cs.getCurrent().getSourceId()) + "\u8fc7\u6ee4\u65f6\u4f7f\u7528\u7d22\u5f15\u4e2d\u904d\u5386");
                    }
                }
            } else if (b) {
                Logger.info("\u8fc7\u6ee4\u5b8c\u5168\u4f7f\u7528\u7d22\u5f15");
            } else {
                Logger.info("\u8fc7\u6ee4\u4f7f\u7528\u7d22\u5f15\u4e2d\u904d\u5386");
            }
        }
        BlockIndex dataIndex = this.ds.getIndex();
        this.rowList = dataIndex.getRows(this.iNode, f);
        this.rowList.trimToSize();
    }

    public final Group filter(Expression exp) {
        Object val;
        if (exp == null) {
            return this;
        }
        if (exp.isConstantExpression() && (val = exp.calculate()) instanceof Boolean && ((Boolean)val).booleanValue()) {
            return this;
        }
        Group group = (Group)this.clone();
        group.isRootGroup = false;
        Filters f = exp.getFilters(group);
        if (f == null) {
            group.filterWithoutIndex(exp);
        } else {
            group.filterWithIndex(exp);
        }
        group.iNode = null;
        return group;
    }

    private final void onlySort(Expression sort, Boolean dsc) {
        Collections.sort(this.rowList, new RowComparator(sort, dsc));
    }

    public final Group sort(Expression sort, Expression desc) {
        if (sort == null || sort.isConstantExpression()) {
            return this;
        }
        Boolean dsc = null;
        if (desc != null) {
            Object value = Variant2.getValue(desc.calculate());
            if (value instanceof Boolean) {
                dsc = (Boolean)value;
            } else {
                throw new ReportError("group\u51fd\u6570\u7b2c2\u4e2a\u53c2\u6570\u5e94\u8be5\u4e3a\u7a7a\u6216null\u6216\u5e03\u5c14\u578b\u503c");
            }
        }
        Group group = (Group)this.clone();
        group.onlySort(sort, dsc);
        return group;
    }

    private List groupWithoutIndex(Expression select, Expression desc, Expression filter, Expression sort) {
        Group group = this;
        if (filter != null) {
            group = group.filter(filter);
        }
        if (sort != null || desc != null) {
            if (sort == null) {
                sort = select;
            }
            group = group.sort(sort, desc);
        }
        return group.groupByOrder(select);
    }

    private List groupWithIndex(Expression select, Expression desc) {
        if (DataSet.DEBUG) {
            ExtCellSet cs = select.getCS();
            if (cs != null && cs.getCurrent() != null) {
                if (cs.getCurrent().getSource() == cs.getCurrent()) {
                    Logger.info(String.valueOf(cs.getCurrent().getSourceId()) + "\u5206\u7ec4\u4f7f\u7528\u7d22\u5f15");
                }
            } else {
                Logger.info("\u5206\u7ec4\u4f7f\u7528\u7d22\u5f15");
            }
        }
        boolean dsc = false;
        if (desc != null) {
            Object value = Variant2.getValue(desc.calculate());
            if (value instanceof Boolean) {
                dsc = (Boolean)value;
            } else {
                throw new ReportError("group\u51fd\u6570\u7b2c2\u4e2a\u53c2\u6570\u5e94\u8be5\u4e3a\u7a7a\u6216null\u6216\u5e03\u5c14\u578b\u503c");
            }
        }
        return this.ds.getIndex().getGroups(this.iNode, !dsc);
    }

    private boolean canOptForGroup(Expression select) {
        BlockIndex bIndex = this.ds.getIndex();
        if (bIndex == null) {
            return false;
        }
        if (this.iNode == null) {
            return false;
        }
        if (select == null) {
            return false;
        }
        Node home = select.getHome();
        if (!(home instanceof DSVariable)) {
            return false;
        }
        DSVariable var = (DSVariable)home;
        if (var.getDS() != this.ds) {
            return false;
        }
        int col = var.getColNo();
        return col >= 0 && bIndex.getLevelFrom(this.iNode, col) >= 0;
    }

    public final List group(Expression select, Expression desc, Expression filter, Expression sort) {
        Object v;
        if (filter != null && filter.isConstantExpression() && (v = filter.calculate()) instanceof Boolean && ((Boolean)v).booleanValue()) {
            filter = null;
        }
        if (sort == null && filter == null && this.canOptForGroup(select)) {
            return this.groupWithIndex(select, desc);
        }
        return this.groupWithoutIndex(select, desc, filter, sort);
    }

    private final List groupByOrder(Expression exp) {
        ArrayList<Group> subList = new ArrayList<Group>();
        Group sub = null;
        Object value1 = null;
        Object value2 = null;
        Row row = null;
        int i = 0;
        while (i < this.rowList.size()) {
            row = (Row)this.rowList.get(i);
            value1 = row.evaluate(exp);
            if (i == 0) {
                sub = new Group(this.ds, false);
                sub.setValue(value1);
                subList.add(sub);
            } else if (!Variant2.equals(value1, value2)) {
                sub.trimToSize();
                sub = new Group(this.ds, false);
                sub.setValue(value1);
                subList.add(sub);
            }
            sub.addRow(row);
            value2 = value1;
            ++i;
        }
        return subList;
    }

    public final List group(Expression exp, List extents, boolean eq, boolean asc) {
        Row row;
        ArrayList<Group> subList = new ArrayList<Group>();
        int l = extents.size();
        int i = 0;
        while (i <= l) {
            Group g = new Group(this.ds, false);
            g.setValue(ObjectCache.getInteger(i));
            subList.add(g);
            ++i;
        }
        if (asc) {
            i = 0;
            while (i < this.rowList.size()) {
                row = (Row)this.rowList.get(i);
                Object v = row.evaluate(exp);
                int pos = 0;
                while (pos < l) {
                    int c = Variant2.compare(v, extents.get(pos));
                    if (eq && c <= 0 || !eq && c < 0) break;
                    ++pos;
                }
                Group g = (Group)subList.get(pos);
                g.addRow(row);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.rowList.size()) {
                row = (Row)this.rowList.get(i);
                Object v = row.evaluate(exp);
                int pos = 0;
                while (pos < l) {
                    int c = Variant2.compare(v, extents.get(pos));
                    if (eq && c >= 0 || !eq && c > 0) break;
                    ++pos;
                }
                Group g = (Group)subList.get(pos);
                g.addRow(row);
                ++i;
            }
        }
        return subList;
    }

    protected final boolean contains(Group other) {
        int i = 0;
        while (i < other.rowList.size()) {
            if (!this.rowList.contains(other.rowList.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final Group cross(Group other) {
        int[] rowNos = this.ds.applyEmptyRowsArray();
        int i = 0;
        while (i < this.rowList.size()) {
            Row row = (Row)this.rowList.get(i);
            rowNos[row.getRowNo()] = row.getRowNo();
            ++i;
        }
        Group newGroup = new Group(this.ds, false);
        int i2 = 0;
        while (i2 < other.rowList.size()) {
            Row row = (Row)other.rowList.get(i2);
            if (rowNos[row.getRowNo()] > 0) {
                newGroup.addRow(row);
            }
            ++i2;
        }
        newGroup.trimToSize();
        return newGroup;
    }
}

